/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.trace.format.api;

import com.ibm.jvm.trace.format.api.ByteStream;
import com.ibm.jvm.trace.format.api.DataHeader;
import com.ibm.jvm.trace.format.api.TraceContext;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class TraceSection {
    BigInteger startPlatform;
    BigInteger startSystem;
    int type;
    int generations;
    int pointerSize = 4;
    TraceContext context;
    String textSummary;

    public TraceSection(TraceContext traceContext, ByteBuffer byteBuffer) throws IllegalArgumentException {
        this.context = traceContext;
        DataHeader dataHeader = new DataHeader(traceContext, byteBuffer, "UTTS");
        byte[] byArray = new byte[16];
        byteBuffer.get(byArray);
        ByteStream byteStream = traceContext.createByteStream(byArray);
        this.startPlatform = byteStream.getBigInteger(8);
        this.startSystem = byteStream.getBigInteger(8);
        this.type = byteBuffer.getInt();
        this.generations = byteBuffer.getInt();
        this.pointerSize = byteBuffer.getInt();
        if (traceContext.debugStream != null) {
            traceContext.debug(this, 1, this.summary());
        }
    }

    public String toString() {
        return "Trace file header";
    }

    public String summary() {
        if (this.textSummary == null) {
            StringBuilder stringBuilder = new StringBuilder(this.toString() + ":" + System.getProperty("line.separator"));
            stringBuilder.append("        JVM start time: " + this.context.getFormattedTime(this.startPlatform)).append(System.getProperty("line.separator"));
            stringBuilder.append("        Generations:    " + this.generations).append(System.getProperty("line.separator"));
            stringBuilder.append("        Pointer size:   " + this.pointerSize).append(System.getProperty("line.separator"));
            this.textSummary = stringBuilder.toString();
        }
        return this.textSummary;
    }
}

