/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMClassHelper;
import com.ibm.j9ddr.vm29.structure.J9ConstantPool;
import java.io.PrintStream;

public class CPDescriptionCommand
extends Command {
    public CPDescriptionCommand() {
        this.addCommand("cpdescription", "<address>", "Dump the cpdescription for the J9ROMClass");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            long l = CommandUtils.parsePointer(stringArray[0], J9BuildFlags.env_data64);
            J9ROMClassPointer j9ROMClassPointer = J9ROMClassPointer.cast(l);
            U32Pointer u32Pointer = J9ROMClassHelper.cpShapeDescription(j9ROMClassPointer);
            long l2 = j9ROMClassPointer.romConstantPoolCount().longValue();
            long l3 = (l2 + J9ConstantPool.J9_CP_DESCRIPTIONS_PER_U32 - 1L) / J9ConstantPool.J9_CP_DESCRIPTIONS_PER_U32;
            printStream.append("CP Shape Description:" + nl);
            long l4 = 0L;
            for (long i = 0L; i < l3; ++i) {
                long l5 = u32Pointer.at(i).longValue();
                for (long j = 0L; j < J9ConstantPool.J9_CP_DESCRIPTIONS_PER_U32 && l4 != l2; ++j, ++l4) {
                    printStream.append("[" + l4 + "] = " + (int)(l5 & J9ConstantPool.J9_CP_DESCRIPTION_MASK) + nl);
                    l5 >>= (int)J9ConstantPool.J9_CP_BITS_PER_DESCRIPTION;
                }
            }
            printStream.append(nl);
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }
}

