/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.pointer.I16Pointer;
import com.ibm.j9ddr.vm29.pointer.I32Pointer;
import com.ibm.j9ddr.vm29.pointer.I64Pointer;
import com.ibm.j9ddr.vm29.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm29.pointer.U16Pointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ArrayClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9IndexableObjectContiguousPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9IndexableObjectDiscontiguousPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ArrayClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.StringWriter;

public class J9IndexableObjectHelper
extends J9ObjectHelper {
    public static U32 flags(J9IndexableObjectPointer j9IndexableObjectPointer) throws CorruptDataException {
        return J9ObjectHelper.flags(J9ObjectPointer.cast(j9IndexableObjectPointer));
    }

    public static J9ArrayClassPointer clazz(J9IndexableObjectPointer j9IndexableObjectPointer) throws CorruptDataException {
        return J9ArrayClassPointer.cast(J9ObjectHelper.clazz(J9ObjectPointer.cast(j9IndexableObjectPointer)));
    }

    public static UDATA monitor(J9IndexableObjectPointer j9IndexableObjectPointer) throws CorruptDataException {
        return J9ObjectHelper.monitor(J9ObjectPointer.cast(j9IndexableObjectPointer));
    }

    public static String getClassName(J9IndexableObjectPointer j9IndexableObjectPointer) throws CorruptDataException {
        return J9ArrayClassHelper.getName(J9IndexableObjectHelper.clazz(j9IndexableObjectPointer));
    }

    public static U32 size(J9IndexableObjectPointer j9IndexableObjectPointer) throws CorruptDataException {
        UDATA uDATA = J9IndexableObjectContiguousPointer.cast(j9IndexableObjectPointer).size();
        if (uDATA.eq(0L)) {
            uDATA = J9IndexableObjectDiscontiguousPointer.cast(j9IndexableObjectPointer).size();
        }
        if (uDATA.anyBitsIn(Integer.MIN_VALUE)) {
            throw new CorruptDataException("java array size with sign bit set");
        }
        return new U32(uDATA);
    }

    public static U32 size(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return J9IndexableObjectHelper.size(J9IndexableObjectPointer.cast(j9ObjectPointer));
    }

    public static VoidPointer getElementEA(J9IndexableObjectPointer j9IndexableObjectPointer, int n, int n2) throws CorruptDataException {
        return ObjectModel.getElementAddress(j9IndexableObjectPointer, n, n2);
    }

    public static void getData(J9IndexableObjectPointer j9IndexableObjectPointer, Object object, int n, int n2, int n3) throws CorruptDataException {
        String string = J9IndexableObjectHelper.getClassName(j9IndexableObjectPointer);
        int n4 = (int)J9IndexableObjectHelper.size(j9IndexableObjectPointer).longValue();
        if (n + n2 > n4) {
            throw new ArrayIndexOutOfBoundsException("Requested range " + n + " to " + (n + n2) + " overflows array of length " + n4);
        }
        switch (string.charAt(1)) {
            case 'B': {
                if (!(object instanceof byte[])) {
                    throw new IllegalArgumentException("Destination array of type " + object.getClass().getName() + " incompatible with byte array (expects byte[])");
                }
                J9IndexableObjectHelper.getByteData(j9IndexableObjectPointer, (byte[])object, n, n2, n3);
                break;
            }
            case 'C': {
                if (!(object instanceof char[])) {
                    throw new IllegalArgumentException("Destination array of type " + object.getClass().getName() + " incompatible with char array (expects char[])");
                }
                J9IndexableObjectHelper.getCharData(j9IndexableObjectPointer, (char[])object, n, n2, n3);
                break;
            }
            case 'D': {
                if (!(object instanceof double[])) {
                    throw new IllegalArgumentException("Destination array of type " + object.getClass().getName() + " incompatible with double array (expects double[])");
                }
                J9IndexableObjectHelper.getDoubleData(j9IndexableObjectPointer, (double[])object, n, n2, n3);
                break;
            }
            case 'F': {
                if (!(object instanceof float[])) {
                    throw new IllegalArgumentException("Destination array of type " + object.getClass().getName() + " incompatible with float array (expects float[])");
                }
                J9IndexableObjectHelper.getFloatData(j9IndexableObjectPointer, (float[])object, n, n2, n3);
                break;
            }
            case 'I': {
                if (!(object instanceof int[])) {
                    throw new IllegalArgumentException("Destination array of type " + object.getClass().getName() + " incompatible with int array (expects int[])");
                }
                J9IndexableObjectHelper.getIntData(j9IndexableObjectPointer, (int[])object, n, n2, n3);
                break;
            }
            case 'J': {
                if (!(object instanceof long[])) {
                    throw new IllegalArgumentException("Destination array of type " + object.getClass().getName() + " incompatible with long array (expects long[])");
                }
                J9IndexableObjectHelper.getLongData(j9IndexableObjectPointer, (long[])object, n, n2, n3);
                break;
            }
            case 'S': {
                if (!(object instanceof short[])) {
                    throw new IllegalArgumentException("Destination array of type " + object.getClass().getName() + " incompatible with short array (expects short[])");
                }
                J9IndexableObjectHelper.getShortData(j9IndexableObjectPointer, (short[])object, n, n2, n3);
                break;
            }
            case 'Z': {
                if (!(object instanceof boolean[])) {
                    throw new IllegalArgumentException("Destination array of type " + object.getClass().getName() + " incompatible with boolean array (expects boolean[])");
                }
                J9IndexableObjectHelper.getBooleanData(j9IndexableObjectPointer, (boolean[])object, n, n2, n3);
                break;
            }
            case 'L': 
            case '[': {
                if (!(object instanceof J9ObjectPointer[])) {
                    throw new IllegalArgumentException("Destination array of type " + object.getClass().getName() + " incompatible with Object array (expects J9ObjectPointer[])");
                }
                J9IndexableObjectHelper.getObjectData(j9IndexableObjectPointer, (J9ObjectPointer[])object, n, n2, n3);
                break;
            }
            default: {
                throw new CorruptDataException("The data identifier : " + string.charAt(1) + " was not recognised");
            }
        }
    }

    public static void getByteData(J9IndexableObjectPointer j9IndexableObjectPointer, byte[] byArray, int n, int n2, int n3) throws CorruptDataException {
        if (n3 + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException("Supplied destination array too small. Requires: " + n3 + n2 + ", was " + byArray.length);
        }
        for (int i = 0; i < n2; ++i) {
            byArray[n3 + i] = U8Pointer.cast(ObjectModel.getElementAddress(j9IndexableObjectPointer, n + i, 1)).at(0L).byteValue();
        }
    }

    public static void getCharData(J9IndexableObjectPointer j9IndexableObjectPointer, char[] cArray, int n, int n2, int n3) throws CorruptDataException {
        if (n3 + n2 > cArray.length) {
            throw new ArrayIndexOutOfBoundsException("Supplied destination array too small. Requires: " + n3 + n2 + ", was " + cArray.length);
        }
        for (int i = 0; i < n2; ++i) {
            cArray[n3 + i] = (char)U16Pointer.cast(ObjectModel.getElementAddress(j9IndexableObjectPointer, n + i, 2)).at(0L).intValue();
        }
    }

    public static void getDoubleData(J9IndexableObjectPointer j9IndexableObjectPointer, double[] dArray, int n, int n2, int n3) throws CorruptDataException {
        if (n3 + n2 > dArray.length) {
            throw new ArrayIndexOutOfBoundsException("Supplied destination array too small. Requires: " + n3 + n2 + ", was " + dArray.length);
        }
        for (int i = 0; i < n2; ++i) {
            long l = I64Pointer.cast(ObjectModel.getElementAddress(j9IndexableObjectPointer, n + i, 8)).at(0L).longValue();
            dArray[n3 + i] = Double.longBitsToDouble(l);
        }
    }

    public static void getFloatData(J9IndexableObjectPointer j9IndexableObjectPointer, float[] fArray, int n, int n2, int n3) throws CorruptDataException {
        if (n3 + n2 > fArray.length) {
            throw new ArrayIndexOutOfBoundsException("Supplied destination array too small. Requires: " + n3 + n2 + ", was " + fArray.length);
        }
        for (int i = 0; i < n2; ++i) {
            int n4 = I32Pointer.cast(ObjectModel.getElementAddress(j9IndexableObjectPointer, n + i, 4)).at(0L).intValue();
            fArray[n3 + i] = Float.intBitsToFloat(n4);
        }
    }

    public static void getIntData(J9IndexableObjectPointer j9IndexableObjectPointer, int[] nArray, int n, int n2, int n3) throws CorruptDataException {
        if (n3 + n2 > nArray.length) {
            throw new ArrayIndexOutOfBoundsException("Supplied destination array too small. Requires: " + n3 + n2 + ", was " + nArray.length);
        }
        for (int i = 0; i < n2; ++i) {
            nArray[n3 + i] = I32Pointer.cast(ObjectModel.getElementAddress(j9IndexableObjectPointer, n + i, 4)).at(0L).intValue();
        }
    }

    public static void getLongData(J9IndexableObjectPointer j9IndexableObjectPointer, long[] lArray, int n, int n2, int n3) throws CorruptDataException {
        if (n3 + n2 > lArray.length) {
            throw new ArrayIndexOutOfBoundsException("Supplied destination array too small. Requires: " + n3 + n2 + ", was " + lArray.length);
        }
        for (int i = 0; i < n2; ++i) {
            lArray[n3 + i] = I64Pointer.cast(ObjectModel.getElementAddress(j9IndexableObjectPointer, n + i, 8)).at(0L).longValue();
        }
    }

    public static void getShortData(J9IndexableObjectPointer j9IndexableObjectPointer, short[] sArray, int n, int n2, int n3) throws CorruptDataException {
        if (n3 + n2 > sArray.length) {
            throw new ArrayIndexOutOfBoundsException("Supplied destination array too small. Requires: " + n3 + n2 + ", was " + sArray.length);
        }
        for (int i = 0; i < n2; ++i) {
            sArray[n3 + i] = I16Pointer.cast(ObjectModel.getElementAddress(j9IndexableObjectPointer, n + i, 2)).at(0L).shortValue();
        }
    }

    public static void getBooleanData(J9IndexableObjectPointer j9IndexableObjectPointer, boolean[] blArray, int n, int n2, int n3) throws CorruptDataException {
        if (n3 + n2 > blArray.length) {
            throw new ArrayIndexOutOfBoundsException("Supplied destination array too small. Requires: " + n3 + n2 + ", was " + blArray.length);
        }
        for (int i = 0; i < n2; ++i) {
            blArray[n3 + i] = 0 != U8Pointer.cast(ObjectModel.getElementAddress(j9IndexableObjectPointer, n + i, 1)).at(0L).intValue();
        }
    }

    public static void getObjectData(J9IndexableObjectPointer j9IndexableObjectPointer, J9ObjectPointer[] j9ObjectPointerArray, int n, int n2, int n3) throws CorruptDataException {
        if (n3 + n2 > j9ObjectPointerArray.length) {
            throw new ArrayIndexOutOfBoundsException("Supplied destination array too small. Requires: " + n3 + n2 + ", was " + j9ObjectPointerArray.length);
        }
        for (int i = 0; i < n2; ++i) {
            j9ObjectPointerArray[n3 + i] = ObjectReferencePointer.cast(ObjectModel.getElementAddress(j9IndexableObjectPointer, n + i, (int)ObjectReferencePointer.SIZEOF)).at(0L);
        }
    }

    public static Object getData(J9IndexableObjectPointer j9IndexableObjectPointer) throws CorruptDataException {
        String string = J9IndexableObjectHelper.getClassName(j9IndexableObjectPointer);
        int n = (int)J9IndexableObjectHelper.size(j9IndexableObjectPointer).longValue();
        switch (string.charAt(1)) {
            case 'B': {
                byte[] byArray = new byte[n];
                J9IndexableObjectHelper.getByteData(j9IndexableObjectPointer, byArray, 0, n, 0);
                return byArray;
            }
            case 'C': {
                char[] cArray = new char[n];
                J9IndexableObjectHelper.getCharData(j9IndexableObjectPointer, cArray, 0, n, 0);
                return cArray;
            }
            case 'D': {
                double[] dArray = new double[n];
                J9IndexableObjectHelper.getDoubleData(j9IndexableObjectPointer, dArray, 0, n, 0);
                return dArray;
            }
            case 'F': {
                float[] fArray = new float[n];
                J9IndexableObjectHelper.getFloatData(j9IndexableObjectPointer, fArray, 0, n, 0);
                return fArray;
            }
            case 'I': {
                int[] nArray = new int[n];
                J9IndexableObjectHelper.getIntData(j9IndexableObjectPointer, nArray, 0, n, 0);
                return nArray;
            }
            case 'J': {
                long[] lArray = new long[n];
                J9IndexableObjectHelper.getLongData(j9IndexableObjectPointer, lArray, 0, n, 0);
                return lArray;
            }
            case 'S': {
                short[] sArray = new short[n];
                J9IndexableObjectHelper.getShortData(j9IndexableObjectPointer, sArray, 0, n, 0);
                return sArray;
            }
            case 'Z': {
                boolean[] blArray = new boolean[n];
                J9IndexableObjectHelper.getBooleanData(j9IndexableObjectPointer, blArray, 0, n, 0);
                return blArray;
            }
            case 'L': 
            case '[': {
                J9ObjectPointer[] j9ObjectPointerArray = new J9ObjectPointer[n];
                J9IndexableObjectHelper.getObjectData(j9IndexableObjectPointer, j9ObjectPointerArray, 0, n, 0);
                return j9ObjectPointerArray;
            }
        }
        throw new CorruptDataException("The data identifier : " + string.charAt(1) + " was not recognised");
    }

    public static String getDataAsString(J9IndexableObjectPointer j9IndexableObjectPointer) throws CorruptDataException {
        return J9IndexableObjectHelper.getDataAsString(j9IndexableObjectPointer, 10, 80);
    }

    public static String getDataAsString(J9IndexableObjectPointer j9IndexableObjectPointer, int n, int n2) throws CorruptDataException {
        int n3;
        StringWriter stringWriter = new StringWriter();
        J9ClassPointer j9ClassPointer = J9ObjectHelper.clazz(J9ObjectPointer.cast(j9IndexableObjectPointer));
        char c = J9ClassHelper.getName(j9ClassPointer).charAt(1);
        int n4 = J9IndexableObjectHelper.size(j9IndexableObjectPointer).intValue();
        int n5 = 0;
        n5 = c != 'C' ? n : n2;
        stringWriter.write("{ ");
        for (n3 = 0; n3 < Math.min(n4, n5); ++n3) {
            Object object = J9IndexableObjectHelper.getData(j9IndexableObjectPointer);
            switch (c) {
                case 'B': {
                    stringWriter.write("0x");
                    stringWriter.write(Integer.toHexString(((byte[])object)[n3]));
                    break;
                }
                case 'C': {
                    char c2 = ((char[])object)[n3];
                    if (c2 > '\u001f' && c2 < '\u007f') {
                        stringWriter.write(c2);
                        break;
                    }
                    stringWriter.write(63);
                    break;
                }
                case 'D': {
                    stringWriter.write(Double.toString(((double[])object)[n3]));
                    break;
                }
                case 'F': {
                    stringWriter.write(Float.toString(((float[])object)[n3]));
                    break;
                }
                case 'I': {
                    stringWriter.write("0x");
                    stringWriter.write(Integer.toHexString(((int[])object)[n3]));
                    break;
                }
                case 'J': {
                    stringWriter.write("0x");
                    stringWriter.write(Long.toHexString(((long[])object)[n3]));
                    break;
                }
                case 'S': {
                    stringWriter.write("0x");
                    stringWriter.write(Integer.toHexString(((short[])object)[n3]));
                    break;
                }
                case 'Z': {
                    stringWriter.write(((boolean[])object)[n3] ? "true" : "false");
                    break;
                }
                case 'L': 
                case '[': {
                    J9ObjectPointer j9ObjectPointer = ((J9ObjectPointer[])object)[n3];
                    if (null == j9ObjectPointer) {
                        stringWriter.write("null");
                        break;
                    }
                    stringWriter.write("0x");
                    stringWriter.write(Long.toHexString(j9ObjectPointer.longValue()));
                    break;
                }
                default: {
                    stringWriter.write("?");
                }
            }
            if (c == 'C' || n3 == n4 - 1) continue;
            stringWriter.write(", ");
        }
        if (n3 != n4) {
            stringWriter.write("... ");
        }
        stringWriter.write(" }");
        return stringWriter.toString();
    }
}

