/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public final class J9ConfigFlags {
    public static final boolean arch_arm;
    public static final boolean arch_aarch64;
    public static final boolean arch_power;
    public static final boolean arch_riscv;
    public static final boolean arch_s390;
    public static final boolean arch_x86;

    private static boolean getFlag(Class<?> clazz, String ... stringArray) {
        Boolean bl = null;
        for (String string : stringArray) {
            try {
                Field field = clazz.getField(string);
                int n = field.getModifiers();
                if (!Modifier.isPublic(n) || !Modifier.isStatic(n) || !Modifier.isFinal(n) || field.getType() != Boolean.TYPE) continue;
                if (bl != null) {
                    throw new InternalError("ambiguous flag");
                }
                bl = field.getBoolean(null);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                throw new InternalError("unexpected exception", exception);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (SecurityException securityException) {
                throw new InternalError("unexpected exception", securityException);
            }
        }
        if (bl == null) {
            throw new InternalError("missing flag");
        }
        return bl;
    }

    static {
        Class<J9BuildFlags> clazz = J9BuildFlags.class;
        arch_arm = J9ConfigFlags.getFlag(clazz, "arch_arm", "J9VM_ARCH_ARM");
        arch_aarch64 = J9ConfigFlags.getFlag(clazz, "arch_aarch64", "J9VM_ARCH_AARCH64");
        arch_power = J9ConfigFlags.getFlag(clazz, "arch_power", "J9VM_ARCH_POWER");
        arch_riscv = J9ConfigFlags.getFlag(clazz, "arch_riscv", "J9VM_ARCH_RISCV");
        arch_s390 = J9ConfigFlags.getFlag(clazz, "arch_s390", "J9VM_ARCH_S390");
        arch_x86 = J9ConfigFlags.getFlag(clazz, "arch_x86", "J9VM_ARCH_X86");
    }
}

