/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.corereaders.ResourceReleaser;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;

public class ClosingFileReader
extends ImageInputStreamImpl
implements ResourceReleaser {
    private static final int PAGE_SIZE = 4096;
    private static final int BUFFER_PAGES = 4;
    private static final int BUFFER_SIZE = 16384;
    private IRandomAccessFile _file;
    private File _fileRef;
    private byte[] _buffer = new byte[16384];
    private long _bufferBase = -1L;
    private long _bufferEnd = -1L;
    private boolean deleteOnClose = false;
    private int _page_size = 4096;

    public ClosingFileReader(File file) throws IOException {
        this._fileRef = file;
        this._file = new BaseRandomAccessFile(this._fileRef, "r");
    }

    public ClosingFileReader(ImageInputStream imageInputStream) throws IOException {
        this._file = new StreamRandomAccessFile(imageInputStream);
    }

    public ClosingFileReader(File file, boolean bl) throws IOException {
        this(file);
        if (bl) {
            this.deleteOnClose = true;
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        ClosingFileReader.this.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public byte[] readBytes(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        return byArray;
    }

    @Override
    public int readInt() throws IOException {
        byte[] byArray = new byte[4];
        this.readFully(byArray);
        return (int)(((long)byArray[0] & 0xFFL) << 24 | ((long)byArray[1] & 0xFFL) << 16 | ((long)byArray[2] & 0xFFL) << 8 | (long)byArray[3] & 0xFFL);
    }

    @Override
    public void seek(long l) throws IOException {
        this.streamPos = l;
    }

    @Override
    public long readLong() throws IOException {
        byte[] byArray = new byte[8];
        this.readFully(byArray);
        return ((long)byArray[0] & 0xFFL) << 56 | ((long)byArray[1] & 0xFFL) << 48 | ((long)byArray[2] & 0xFFL) << 40 | ((long)byArray[3] & 0xFFL) << 32 | ((long)byArray[4] & 0xFFL) << 24 | ((long)byArray[5] & 0xFFL) << 16 | ((long)byArray[6] & 0xFFL) << 8 | (long)byArray[7] & 0xFFL;
    }

    @Override
    public short readShort() throws IOException {
        byte[] byArray = new byte[2];
        this.readFully(byArray);
        return (short)((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
    }

    @Override
    public byte readByte() throws IOException {
        byte[] byArray = new byte[1];
        this.readFully(byArray);
        return byArray[0];
    }

    @Override
    public void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        int n;
        for (int i = 0; i < byArray.length; i += n) {
            int n2 = Math.min(this._buffer.length, byArray.length - i);
            n = this.read(byArray, i, n2);
            if (n > 0) continue;
            throw new EOFException("Read " + i + " bytes ");
        }
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        try {
            if (-1L == this._bufferBase) {
                this._recache();
            }
            long l = this._bufferBase;
            long l2 = this._bufferEnd;
            long l3 = this.streamPos;
            long l4 = this.streamPos + (long)n2;
            long l5 = Math.max(l, l3);
            long l6 = Math.min(l2, l4);
            if (l6 <= l5 || this.streamPos < this._bufferBase) {
                this._recache();
                l = this._bufferBase;
                l2 = this._bufferEnd;
                l5 = Math.max(l, l3);
                l6 = Math.min(l2, l4);
            }
            int n4 = (int)(l5 - this._bufferBase);
            n3 = (int)(l6 - l5);
            try {
                System.arraycopy(this._buffer, n4, byArray, n, n3);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2 = new ArrayIndexOutOfBoundsException("System.arraycopy(" + this._buffer + " length=" + this._buffer.length + "," + n4 + "," + byArray + " length=" + byArray.length + "," + n + "," + n3 + ")");
                arrayIndexOutOfBoundsException2.initCause(arrayIndexOutOfBoundsException);
                throw arrayIndexOutOfBoundsException2;
            }
            this.streamPos += (long)n3;
            if (n3 == 0 && n2 > 0) {
                n3 = -1;
            }
        }
        catch (EOFException eOFException) {
            n3 = -1;
        }
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _recache() throws IOException {
        long l;
        long l2 = this._file.length();
        if (l2 != -1L && l2 <= this.streamPos) throw new EOFException("trying to cache beyond end of file");
        long l3 = this.streamPos % (long)this._page_size;
        this._bufferBase = l = this.streamPos - l3;
        this._bufferEnd = l;
        try {
            this._file.seek(l);
            this._file.readFully(this._buffer);
            this._bufferEnd = l + (long)this._buffer.length;
            return;
        }
        catch (EORFException eORFException) {
            this._file.seek(l);
            this._file.readFully(this._buffer, 0, eORFException.bytesRead);
            this._bufferEnd = l + (long)eORFException.bytesRead;
            return;
        }
        catch (EOFException eOFException) {
            int n;
            if (l2 != -1L) {
                this._bufferEnd = l2;
                this._file.seek(l);
                this._file.readFully(this._buffer, 0, (int)(this._bufferEnd - l));
                return;
            }
            this._file.seek(l);
            this._bufferEnd = l;
            for (int i = 0; i < this._buffer.length && (n = this._file.read()) != -1; ++i) {
                this._buffer[i] = (byte)n;
                ++this._bufferEnd;
            }
            if (this._bufferEnd != l) return;
            throw new EOFException("trying to cache beyond end of file");
        }
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray);
        if (n < 0) {
            return n;
        }
        return byArray[0] & 0xFF;
    }

    @Override
    public long length() {
        try {
            return this._file.length();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    @Override
    public void close() throws IOException {
        this._file.close();
        if (this.deleteOnClose) {
            this._fileRef.delete();
        }
    }

    public InputStream streamFromFile() throws FileNotFoundException {
        return new FileInputStream(this._fileRef);
    }

    public URI getURIOfFile() {
        return this._fileRef.toURI();
    }

    public String getAbsolutePath() {
        if (this._fileRef == null) {
            return null;
        }
        return this._fileRef.getAbsolutePath();
    }

    public boolean isMVSFile() {
        return false;
    }

    @Override
    public void releaseResources() throws IOException {
        this.close();
    }

    private static class StreamRandomAccessFile
    implements IRandomAccessFile {
        private ImageInputStream _file;

        public StreamRandomAccessFile(ImageInputStream imageInputStream) {
            this._file = imageInputStream;
        }

        @Override
        public void close() throws IOException {
            this._file.close();
        }

        @Override
        public long length() throws IOException {
            return this._file.length();
        }

        @Override
        public int read() throws IOException {
            return this._file.read();
        }

        @Override
        public void readFully(byte[] byArray) throws IOException {
            this.readFully(byArray, 0, byArray.length);
        }

        @Override
        public void readFully(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            int n4 = 0;
            do {
                if ((n3 = this._file.read(byArray, n + n4, n2 - n4)) > 0) continue;
                throw new EOFException();
            } while ((n4 += n3) < n2);
        }

        @Override
        public void seek(long l) throws IOException {
            this._file.seek(l);
        }
    }

    private static class BaseRandomAccessFile
    implements IRandomAccessFile {
        private RandomAccessFile _file;

        public BaseRandomAccessFile(File file, String string) throws FileNotFoundException {
            this._file = new RandomAccessFile(file, string);
        }

        @Override
        public void close() throws IOException {
            this._file.close();
        }

        @Override
        public long length() throws IOException {
            return this._file.length();
        }

        @Override
        public int read() throws IOException {
            return this._file.read();
        }

        @Override
        public void readFully(byte[] byArray) throws IOException {
            this._file.readFully(byArray);
        }

        @Override
        public void readFully(byte[] byArray, int n, int n2) throws IOException {
            this._file.readFully(byArray, n, n2);
        }

        @Override
        public void seek(long l) throws IOException {
            this._file.seek(l);
        }
    }

    private static class EORFException
    extends EOFException {
        private static final long serialVersionUID = 1L;
        public int bytesRead;

        public EORFException(int n) {
            this.bytesRead = n;
        }
    }

    private static interface IRandomAccessFile {
        public void close() throws IOException;

        public long length() throws IOException;

        public int read() throws IOException;

        public void readFully(byte[] var1) throws IOException;

        public void readFully(byte[] var1, int var2, int var3) throws IOException;

        public void seek(long var1) throws IOException;
    }
}

