/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Conditional;
import java.awt.Container;
import java.awt.EventDispatchThread;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.IllegalComponentStateException;
import java.awt.KeyboardFocusManager;
import java.awt.ModalEventFilter;
import java.awt.SecondaryLoop;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.InvocationEvent;
import java.awt.peer.DialogPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.ref.WeakReference;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.awt.util.IdentityArrayList;
import sun.awt.util.IdentityLinkedList;
import sun.security.util.SecurityConstants;

public class Dialog
extends Window {
    boolean resizable = true;
    boolean undecorated = false;
    private transient boolean initialized = false;
    public static final ModalityType DEFAULT_MODALITY_TYPE;
    boolean modal;
    ModalityType modalityType;
    static transient IdentityArrayList<Dialog> modalDialogs;
    transient IdentityArrayList<Window> blockedWindows = new IdentityArrayList();
    String title;
    private transient ModalEventFilter modalFilter;
    private volatile transient SecondaryLoop secondaryLoop;
    volatile transient boolean isInHide = false;
    volatile transient boolean isInDispose = false;
    private static final String base = "dialog";
    private static int nameCounter;
    private static final long serialVersionUID = 5920926903803293709L;

    public Dialog(Frame frame) {
        this(frame, "", false);
    }

    public Dialog(Frame frame, boolean bl) {
        this(frame, "", bl);
    }

    public Dialog(Frame frame, String string) {
        this(frame, string, false);
    }

    public Dialog(Frame frame, String string, boolean bl) {
        this((Window)frame, string, bl ? DEFAULT_MODALITY_TYPE : ModalityType.MODELESS);
    }

    public Dialog(Frame frame, String string, boolean bl, GraphicsConfiguration graphicsConfiguration) {
        this((Window)frame, string, bl ? DEFAULT_MODALITY_TYPE : ModalityType.MODELESS, graphicsConfiguration);
    }

    public Dialog(Dialog dialog) {
        this(dialog, "", false);
    }

    public Dialog(Dialog dialog, String string) {
        this(dialog, string, false);
    }

    public Dialog(Dialog dialog, String string, boolean bl) {
        this((Window)dialog, string, bl ? DEFAULT_MODALITY_TYPE : ModalityType.MODELESS);
    }

    public Dialog(Dialog dialog, String string, boolean bl, GraphicsConfiguration graphicsConfiguration) {
        this((Window)dialog, string, bl ? DEFAULT_MODALITY_TYPE : ModalityType.MODELESS, graphicsConfiguration);
    }

    public Dialog(Window window) {
        this(window, "", ModalityType.MODELESS);
    }

    public Dialog(Window window, String string) {
        this(window, string, ModalityType.MODELESS);
    }

    public Dialog(Window window, ModalityType modalityType) {
        this(window, "", modalityType);
    }

    public Dialog(Window window, String string, ModalityType modalityType) {
        super(window);
        if (window != null && !(window instanceof Frame) && !(window instanceof Dialog)) {
            throw new IllegalArgumentException("Wrong parent window");
        }
        this.title = string;
        this.setModalityType(modalityType);
        SunToolkit.checkAndSetPolicy(this);
        this.initialized = true;
    }

    public Dialog(Window window, String string, ModalityType modalityType, GraphicsConfiguration graphicsConfiguration) {
        super(window, graphicsConfiguration);
        if (window != null && !(window instanceof Frame) && !(window instanceof Dialog)) {
            throw new IllegalArgumentException("wrong owner window");
        }
        this.title = string;
        this.setModalityType(modalityType);
        SunToolkit.checkAndSetPolicy(this);
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String constructComponentName() {
        Class<Dialog> clazz = Dialog.class;
        synchronized (Dialog.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return base + nameCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.parent != null && this.parent.getPeer() == null) {
                this.parent.addNotify();
            }
            if (this.peer == null) {
                this.peer = this.getToolkit().createDialog(this);
            }
            super.addNotify();
        }
    }

    public boolean isModal() {
        return this.isModal_NoClientCode();
    }

    final boolean isModal_NoClientCode() {
        return this.modalityType != ModalityType.MODELESS;
    }

    public void setModal(boolean bl) {
        this.modal = bl;
        this.setModalityType(bl ? DEFAULT_MODALITY_TYPE : ModalityType.MODELESS);
    }

    public ModalityType getModalityType() {
        return this.modalityType;
    }

    public void setModalityType(ModalityType modalityType) {
        if (modalityType == null) {
            modalityType = ModalityType.MODELESS;
        }
        if (!Toolkit.getDefaultToolkit().isModalityTypeSupported(modalityType)) {
            modalityType = ModalityType.MODELESS;
        }
        if (this.modalityType == modalityType) {
            return;
        }
        this.checkModalityPermission(modalityType);
        this.modalityType = modalityType;
        this.modal = this.modalityType != ModalityType.MODELESS;
    }

    public String getTitle() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTitle(String string) {
        String string2 = this.title;
        Dialog dialog = this;
        synchronized (dialog) {
            this.title = string;
            DialogPeer dialogPeer = (DialogPeer)this.peer;
            if (dialogPeer != null) {
                dialogPeer.setTitle(string);
            }
        }
        this.firePropertyChange("title", string2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean conditionalShow(Component component, AtomicLong atomicLong) {
        boolean bl;
        this.closeSplashScreen();
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.addNotify();
            }
            this.validateUnconditionally();
            if (this.visible) {
                this.toFront();
                bl = false;
            } else {
                bl = true;
                this.visible = true;
                if (!this.isModal()) {
                    Dialog.checkShouldBeBlocked(this);
                } else {
                    modalDialogs.add(this);
                    this.modalShow();
                }
                if (component != null && atomicLong != null && this.isFocusable() && this.isEnabled() && !this.isModalBlocked()) {
                    atomicLong.set(Toolkit.getEventQueue().getMostRecentKeyEventTime());
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().enqueueKeyEvents(atomicLong.get(), component);
                }
                this.mixOnShowing();
                this.peer.setVisible(true);
                if (this.isModalBlocked()) {
                    this.modalBlocker.toFront();
                }
                this.setLocationByPlatform(false);
                for (int i = 0; i < this.ownedWindowList.size(); ++i) {
                    Window window = (Window)((WeakReference)this.ownedWindowList.elementAt(i)).get();
                    if (window == null || !window.showWithParent) continue;
                    window.show();
                    window.showWithParent = false;
                }
                Window.updateChildFocusableWindowState(this);
                this.createHierarchyEvents(1400, this, this.parent, 4L, Toolkit.enabledOnToolkit(32768L));
                if (this.componentListener != null || (this.eventMask & 1L) != 0L || Toolkit.enabledOnToolkit(1L)) {
                    ComponentEvent componentEvent = new ComponentEvent(this, 102);
                    Toolkit.getEventQueue().postEvent(componentEvent);
                }
            }
        }
        if (bl && (this.state & 1) == 0) {
            this.postWindowEvent(200);
            this.state |= 1;
        }
        return bl;
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void show() {
        block16: {
            if (!this.initialized) {
                throw new IllegalStateException("The dialog component has not been initialized properly");
            }
            this.beforeFirstShow = false;
            if (!this.isModal()) {
                this.conditionalShow(null, null);
            } else {
                AppContext appContext = AppContext.getAppContext();
                AtomicLong atomicLong = new AtomicLong();
                Component component = null;
                try {
                    Runnable runnable;
                    EventQueue eventQueue;
                    component = this.getMostRecentFocusOwner();
                    if (!this.conditionalShow(component, atomicLong)) break block16;
                    this.modalFilter = ModalEventFilter.createFilterForDialog(this);
                    Conditional conditional = new Conditional(){

                        @Override
                        public boolean evaluate() {
                            return Dialog.this.windowClosingException == null;
                        }
                    };
                    if (this.modalityType == ModalityType.TOOLKIT_MODAL) {
                        for (AppContext appContext2 : AppContext.getAppContexts()) {
                            if (appContext2 == appContext) continue;
                            eventQueue = (EventQueue)appContext2.get(AppContext.EVENT_QUEUE_KEY);
                            runnable = new Runnable(){

                                @Override
                                public void run() {
                                }
                            };
                            eventQueue.postEvent(new InvocationEvent((Object)this, runnable));
                            EventDispatchThread eventDispatchThread = eventQueue.getDispatchThread();
                            eventDispatchThread.addEventFilter(this.modalFilter);
                        }
                    }
                    this.modalityPushed();
                    try {
                        Iterator<AppContext> iterator = AccessController.doPrivileged(new PrivilegedAction<EventQueue>(){

                            @Override
                            public EventQueue run() {
                                return Toolkit.getDefaultToolkit().getSystemEventQueue();
                            }
                        });
                        this.secondaryLoop = ((EventQueue)((Object)iterator)).createSecondaryLoop(conditional, this.modalFilter, 0L);
                        if (!this.secondaryLoop.enter()) {
                            this.secondaryLoop = null;
                        }
                    }
                    finally {
                        this.modalityPopped();
                    }
                    if (this.modalityType == ModalityType.TOOLKIT_MODAL) {
                        for (AppContext appContext2 : AppContext.getAppContexts()) {
                            if (appContext2 == appContext) continue;
                            eventQueue = (EventQueue)appContext2.get(AppContext.EVENT_QUEUE_KEY);
                            runnable = eventQueue.getDispatchThread();
                            ((EventDispatchThread)runnable).removeEventFilter(this.modalFilter);
                        }
                    }
                    if (this.windowClosingException != null) {
                        this.windowClosingException.fillInStackTrace();
                        throw this.windowClosingException;
                    }
                }
                finally {
                    if (component != null) {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().dequeueKeyEvents(atomicLong.get(), component);
                    }
                }
            }
        }
    }

    final void modalityPushed() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit instanceof SunToolkit) {
            SunToolkit sunToolkit = (SunToolkit)toolkit;
            sunToolkit.notifyModalityPushed(this);
        }
    }

    final void modalityPopped() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit instanceof SunToolkit) {
            SunToolkit sunToolkit = (SunToolkit)toolkit;
            sunToolkit.notifyModalityPopped(this);
        }
    }

    void interruptBlocking() {
        if (this.isModal()) {
            this.disposeImpl();
        } else if (this.windowClosingException != null) {
            this.windowClosingException.fillInStackTrace();
            this.windowClosingException.printStackTrace();
            this.windowClosingException = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hideAndDisposePreHandler() {
        this.isInHide = true;
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.secondaryLoop != null) {
                this.modalHide();
                if (this.modalFilter != null) {
                    this.modalFilter.disable();
                }
                modalDialogs.remove(this);
            }
        }
    }

    private void hideAndDisposeHandler() {
        if (this.secondaryLoop != null) {
            this.secondaryLoop.exit();
            this.secondaryLoop = null;
        }
        this.isInHide = false;
    }

    @Override
    @Deprecated
    public void hide() {
        this.hideAndDisposePreHandler();
        super.hide();
        if (!this.isInDispose) {
            this.hideAndDisposeHandler();
        }
    }

    @Override
    void doDispose() {
        this.isInDispose = true;
        super.doDispose();
        this.hideAndDisposeHandler();
        this.isInDispose = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toBack() {
        super.toBack();
        if (this.visible) {
            Object object = this.getTreeLock();
            synchronized (object) {
                for (Window window : this.blockedWindows) {
                    window.toBack_NoClientCode();
                }
            }
        }
    }

    public boolean isResizable() {
        return this.resizable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResizable(boolean bl) {
        boolean bl2 = false;
        Dialog dialog = this;
        synchronized (dialog) {
            this.resizable = bl;
            DialogPeer dialogPeer = (DialogPeer)this.peer;
            if (dialogPeer != null) {
                dialogPeer.setResizable(bl);
                bl2 = true;
            }
        }
        if (bl2) {
            this.invalidateIfValid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUndecorated(boolean bl) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.isDisplayable()) {
                throw new IllegalComponentStateException("The dialog is displayable.");
            }
            if (!bl) {
                if (this.getOpacity() < 1.0f) {
                    throw new IllegalComponentStateException("The dialog is not opaque");
                }
                if (this.getShape() != null) {
                    throw new IllegalComponentStateException("The dialog does not have a default shape");
                }
                Color color = this.getBackground();
                if (color != null && color.getAlpha() < 255) {
                    throw new IllegalComponentStateException("The dialog background color is not opaque");
                }
            }
            this.undecorated = bl;
        }
    }

    public boolean isUndecorated() {
        return this.undecorated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOpacity(float f) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (f < 1.0f && !this.isUndecorated()) {
                throw new IllegalComponentStateException("The dialog is decorated");
            }
            super.setOpacity(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setShape(Shape shape) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (shape != null && !this.isUndecorated()) {
                throw new IllegalComponentStateException("The dialog is decorated");
            }
            super.setShape(shape);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBackground(Color color) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (color != null && color.getAlpha() < 255 && !this.isUndecorated()) {
                throw new IllegalComponentStateException("The dialog is decorated");
            }
            super.setBackground(color);
        }
    }

    @Override
    protected String paramString() {
        String string = super.paramString() + "," + (Object)((Object)this.modalityType);
        if (this.title != null) {
            string = string + ",title=" + this.title;
        }
        return string;
    }

    private static native void initIDs();

    void modalShow() {
        Window[] windowArray;
        Object object;
        IdentityArrayList<Object> identityArrayList = new IdentityArrayList<Object>();
        for (Dialog dialog : modalDialogs) {
            if (!dialog.shouldBlock(this)) continue;
            for (object = dialog; object != null && object != this; object = ((Window)object).getOwner_NoClientCode()) {
            }
            if (object != this && this.shouldBlock(dialog) && this.modalityType.compareTo(dialog.getModalityType()) >= 0) continue;
            identityArrayList.add(dialog);
        }
        for (int i = 0; i < identityArrayList.size(); ++i) {
            Dialog dialog;
            dialog = (Dialog)identityArrayList.get(i);
            if (!dialog.isModalBlocked() || identityArrayList.contains(object = dialog.getModalBlocker())) continue;
            identityArrayList.add(i + 1, object);
        }
        if (identityArrayList.size() > 0) {
            ((Dialog)identityArrayList.get(0)).blockWindow(this);
        }
        IdentityArrayList<Window> identityArrayList2 = new IdentityArrayList<Window>(identityArrayList);
        for (int i = 0; i < identityArrayList2.size(); ++i) {
            object = (Window)identityArrayList2.get(i);
            for (Window window : windowArray = ((Window)object).getOwnedWindows_NoClientCode()) {
                identityArrayList2.add(window);
            }
        }
        object = new IdentityLinkedList();
        windowArray = Window.getAllUnblockedWindows();
        for (Window window : windowArray) {
            Dialog dialog;
            if (!this.shouldBlock(window) || identityArrayList2.contains(window) || window instanceof Dialog && ((Dialog)window).isModal_NoClientCode() && (dialog = (Dialog)window).shouldBlock(this) && modalDialogs.indexOf(dialog) > modalDialogs.indexOf(this)) continue;
            object.add(window);
        }
        this.blockWindows((List<Window>)object);
        if (!this.isModalBlocked()) {
            this.updateChildrenBlocking();
        }
    }

    void modalHide() {
        Window window;
        int n;
        IdentityArrayList<Window> identityArrayList = new IdentityArrayList<Window>();
        int n2 = this.blockedWindows.size();
        for (n = 0; n < n2; ++n) {
            window = this.blockedWindows.get(0);
            identityArrayList.add(window);
            this.unblockWindow(window);
        }
        for (n = 0; n < n2; ++n) {
            window = (Window)identityArrayList.get(n);
            if (window instanceof Dialog && ((Dialog)window).isModal_NoClientCode()) {
                Dialog dialog = (Dialog)window;
                dialog.modalShow();
                continue;
            }
            Dialog.checkShouldBeBlocked(window);
        }
    }

    boolean shouldBlock(Window window) {
        Container container;
        if (!this.isVisible_NoClientCode() || !window.isVisible_NoClientCode() && !window.isInShow || this.isInHide || window == this || !this.isModal_NoClientCode()) {
            return false;
        }
        if (window instanceof Dialog && ((Dialog)window).isInHide) {
            return false;
        }
        for (Dialog dialog = this; dialog != null; dialog = dialog.getModalBlocker()) {
            for (container = window; container != null && container != dialog; container = container.getParent_NoClientCode()) {
            }
            if (container != dialog) continue;
            return false;
        }
        switch (this.modalityType) {
            case MODELESS: {
                return false;
            }
            case DOCUMENT_MODAL: {
                if (window.isModalExcluded(ModalExclusionType.APPLICATION_EXCLUDE)) {
                    for (container = this; container != null && container != window; container = container.getParent_NoClientCode()) {
                    }
                    return container == window;
                }
                return this.getDocumentRoot() == window.getDocumentRoot();
            }
            case APPLICATION_MODAL: {
                return !window.isModalExcluded(ModalExclusionType.APPLICATION_EXCLUDE) && this.appContext == window.appContext;
            }
            case TOOLKIT_MODAL: {
                return !window.isModalExcluded(ModalExclusionType.TOOLKIT_EXCLUDE);
            }
        }
        return false;
    }

    void blockWindow(Window window) {
        if (!window.isModalBlocked()) {
            window.setModalBlocked(this, true, true);
            this.blockedWindows.add(window);
        }
    }

    void blockWindows(List<Window> list) {
        DialogPeer dialogPeer = (DialogPeer)this.peer;
        if (dialogPeer == null) {
            return;
        }
        Iterator<Window> iterator = list.iterator();
        while (iterator.hasNext()) {
            Window window = iterator.next();
            if (!window.isModalBlocked()) {
                window.setModalBlocked(this, true, false);
                continue;
            }
            iterator.remove();
        }
        dialogPeer.blockWindows(list);
        this.blockedWindows.addAll(list);
    }

    void unblockWindow(Window window) {
        if (window.isModalBlocked() && this.blockedWindows.contains(window)) {
            this.blockedWindows.remove(window);
            window.setModalBlocked(this, false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkShouldBeBlocked(Window window) {
        Object object = window.getTreeLock();
        synchronized (object) {
            for (int i = 0; i < modalDialogs.size(); ++i) {
                Dialog dialog = modalDialogs.get(i);
                if (!dialog.shouldBlock(window)) continue;
                dialog.blockWindow(window);
                break;
            }
        }
    }

    private void checkModalityPermission(ModalityType modalityType) {
        SecurityManager securityManager;
        if (modalityType == ModalityType.TOOLKIT_MODAL && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(SecurityConstants.AWT.TOOLKIT_MODALITY_PERMISSION);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, HeadlessException {
        GraphicsEnvironment.checkHeadless();
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        ModalityType modalityType = (ModalityType)((Object)getField.get("modalityType", null));
        try {
            this.checkModalityPermission(modalityType);
        }
        catch (AccessControlException accessControlException) {
            modalityType = DEFAULT_MODALITY_TYPE;
        }
        if (modalityType == null) {
            this.modal = getField.get("modal", false);
            this.setModal(this.modal);
        } else {
            this.modalityType = modalityType;
        }
        this.resizable = getField.get("resizable", true);
        this.undecorated = getField.get("undecorated", false);
        this.title = (String)getField.get("title", "");
        this.blockedWindows = new IdentityArrayList();
        SunToolkit.checkAndSetPolicy(this);
        this.initialized = true;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTDialog();
        }
        return this.accessibleContext;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Dialog.initIDs();
        }
        DEFAULT_MODALITY_TYPE = ModalityType.APPLICATION_MODAL;
        modalDialogs = new IdentityArrayList();
        nameCounter = 0;
    }

    protected class AccessibleAWTDialog
    extends Window.AccessibleAWTWindow {
        private static final long serialVersionUID = 4837230331833941201L;

        protected AccessibleAWTDialog() {
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.DIALOG;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (Dialog.this.getFocusOwner() != null) {
                accessibleStateSet.add(AccessibleState.ACTIVE);
            }
            if (Dialog.this.isModal()) {
                accessibleStateSet.add(AccessibleState.MODAL);
            }
            if (Dialog.this.isResizable()) {
                accessibleStateSet.add(AccessibleState.RESIZABLE);
            }
            return accessibleStateSet;
        }
    }

    public static enum ModalExclusionType {
        NO_EXCLUDE,
        APPLICATION_EXCLUDE,
        TOOLKIT_EXCLUDE;

    }

    public static enum ModalityType {
        MODELESS,
        DOCUMENT_MODAL,
        APPLICATION_MODAL,
        TOOLKIT_MODAL;

    }
}

