/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.structure.J9MemorySegment;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.commands.SegmentsUtil;
import java.io.PrintStream;

public class FindOverlappingSegmentsCommand
extends Command {
    private static final String nl = System.getProperty("line.separator");

    private static void printHelp(PrintStream printStream) {
        printStream.append("!findoverlappingsegments         -- Search for overlaps between all J9MemorySegments except the SHARED_META segment.");
        printStream.append(nl);
        printStream.append("!findoverlappingsegments all     -- Search for overlaps between all J9MemorySegments.");
        printStream.append(nl);
        printStream.append("!findoverlappingsegments virtual -- Search for overlaps between virtual J9MemorySegments.");
        printStream.append(nl);
        printStream.append("!findoverlappingsegments help    -- Print this help message.");
        printStream.append(nl);
    }

    public FindOverlappingSegmentsCommand() {
        this.addCommand("findoverlappingsegments", "[all|virtual|help]", "find overlapping J9MemorySegments");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        Object object;
        int n = 0xFFFFFFFF & ~((int)J9MemorySegment.MEMORY_TYPE_SHARED_META);
        if (stringArray.length != 0) {
            object = stringArray[0];
            if (((String)object).equalsIgnoreCase("help")) {
                FindOverlappingSegmentsCommand.printHelp(printStream);
                return;
            }
            if (((String)object).equalsIgnoreCase("all")) {
                n = -1;
            } else if (((String)object).equalsIgnoreCase("virtual")) {
                n = (int)J9MemorySegment.MEMORY_TYPE_VIRTUAL;
            }
        }
        try {
            object = J9RASHelper.getVM(DataType.getJ9RASPointer());
            SegmentsUtil.checkSegmentsForOverlap(printStream, (J9JavaVMPointer)object, n);
            printStream.append(nl);
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }
}

