/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.I32Pointer;
import com.ibm.j9ddr.vm29.pointer.Pointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;

public class SelfRelativePointer
extends Pointer {
    public static final SelfRelativePointer NULL = new SelfRelativePointer(0L);
    public static final long SIZEOF = 4L;

    protected SelfRelativePointer(long l) {
        super(l);
    }

    public static SelfRelativePointer cast(long l) {
        if (l == 0L) {
            return NULL;
        }
        return new SelfRelativePointer(l);
    }

    public static SelfRelativePointer cast(UDATA uDATA) {
        return SelfRelativePointer.cast(uDATA.longValue());
    }

    public static SelfRelativePointer cast(AbstractPointer abstractPointer) {
        return SelfRelativePointer.cast(abstractPointer.address);
    }

    @Override
    public SelfRelativePointer add(long l) {
        return new SelfRelativePointer(this.address + l * 4L);
    }

    @Override
    public SelfRelativePointer add(Scalar scalar) {
        return this.add(scalar.longValue());
    }

    @Override
    public SelfRelativePointer addOffset(long l) {
        return new SelfRelativePointer(this.address + l);
    }

    @Override
    public SelfRelativePointer addOffset(Scalar scalar) {
        return this.addOffset(scalar.longValue());
    }

    @Override
    public DataType at(long l) throws CorruptDataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataType at(Scalar scalar) throws CorruptDataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SelfRelativePointer untag() {
        return this.untag(3L);
    }

    @Override
    public SelfRelativePointer untag(long l) {
        return new SelfRelativePointer(this.address & (l ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public SelfRelativePointer sub(long l) {
        return new SelfRelativePointer(this.address - l * 4L);
    }

    @Override
    public SelfRelativePointer sub(Scalar scalar) {
        return this.sub(scalar.longValue());
    }

    @Override
    public SelfRelativePointer subOffset(long l) {
        return new SelfRelativePointer(this.address - l);
    }

    @Override
    public SelfRelativePointer subOffset(Scalar scalar) {
        return this.subOffset(scalar.longValue());
    }

    public VoidPointer get() throws CorruptDataException {
        I32 i32 = I32Pointer.cast(this).at(0L);
        if (i32.eq(0L)) {
            return VoidPointer.NULL;
        }
        return VoidPointer.cast(this.addOffset(i32));
    }

    @Override
    protected long sizeOfBaseType() {
        return 4L;
    }
}

