/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.le;

import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpace;
import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpaceImageInputStream;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Caa32Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Caa32_11Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Caa64Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Caa64_11Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CaaNotFound;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CaaTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeedsaTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeelcaTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexdsaf;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Ceexhcom32Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeexlaaTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeexsancTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeexstkhTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.CeextvbTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.DsaStackFrame;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.Edb;
import com.ibm.j9ddr.corereaders.tdump.zebedee.le.SmcbTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.Ihartm2aTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.IhastcbTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.Lse;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.RegisterSet;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.Tcb;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.ProgressMeter;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Caa {
    private long address;
    private Tcb tcb;
    private AddressSpace space;
    private AddressSpaceImageInputStream inputStream;
    private Edb edb;
    private DsaStackFrame currentFrame;
    private int stackdirection;
    private CaaTemplate caaTemplate;
    private long laa;
    private boolean is64bit;
    private static int hcomLength = new Ceexhcom32Template().length();
    private String whereFound;
    private RegisterSet failingRegisters;
    private RegisterSet registers;
    static final int CEECAASTACK_UP = 0;
    static final int CEECAASTACK_DOWN = 1;
    private static final int WARNING = 4;
    private static final int ERROR = 8;
    private static final long F1SA = -420355391L;
    private static final long F4SA = -420158783L;
    private static final long F5SA = -420093247L;
    private static Logger log = Logger.getLogger("j9ddr.core_readers");
    private static int whereSkip = 0;

    public static Caa[] getCaas(AddressSpace addressSpace) {
        return Caa.getCaas(addressSpace, null);
    }

    public static Caa[] getCaas(AddressSpace addressSpace, Edb edb) {
        Tcb[] tcbArray = Tcb.getTcbs(addressSpace);
        if (tcbArray == null) {
            log.fine("no tcbs found in address space " + addressSpace);
            return new Caa[0];
        }
        log.fine("found " + tcbArray.length + " tcbs for address space " + addressSpace);
        Vector<Caa> vector = new Vector<Caa>();
        for (int i = 0; i < tcbArray.length; ++i) {
            ProgressMeter.set("getting caas", i * 100 / tcbArray.length);
            try {
                Caa caa = new Caa(tcbArray[i]);
                if (edb != null && !caa.getEdb().equals(edb)) continue;
                vector.add(caa);
                continue;
            }
            catch (CaaNotFound caaNotFound) {
                // empty catch block
            }
        }
        return vector.toArray(new Caa[0]);
    }

    public Caa(Tcb tcb) throws CaaNotFound {
        log.finer("creating Caa for Tcb at address " + Caa.hex(tcb.address()));
        this.tcb = tcb;
        this.space = tcb.space();
        this.inputStream = this.space.getImageInputStream();
        if (this.is32bitCaa()) {
            int n;
            this.caaTemplate = new Caa32Template();
            String string = this.space.getDump().getProductRelease();
            if (string != null && (n = new Integer(string).intValue()) >= 11) {
                this.caaTemplate = new Caa32_11Template();
                log.fine("switched to new caa format");
            }
            log.fine("created 32-bit Caa " + Caa.hex(this.address) + " for Tcb at address " + Caa.hex(tcb.address()));
        } else if (this.is64bitCaa()) {
            int n;
            this.is64bit = true;
            this.space.setIs64bit(true);
            this.caaTemplate = new Caa64Template();
            String string = this.space.getDump().getProductRelease();
            if (string != null && (n = new Integer(string).intValue()) >= 11) {
                this.caaTemplate = new Caa64_11Template();
                log.fine("switched to new caa format");
            }
            log.fine("created 64-bit Caa " + Caa.hex(this.address) + " for Tcb at address " + Caa.hex(tcb.address()));
        } else if (this.is32bitCaaLastDitch()) {
            int n;
            this.caaTemplate = new Caa32Template();
            String string = this.space.getDump().getProductRelease();
            if (string != null && (n = new Integer(string).intValue()) >= 11) {
                this.caaTemplate = new Caa32_11Template();
                log.fine("switched to new caa format");
            }
            log.fine("created 32-bit Caa " + Caa.hex(this.address) + " for Tcb at address " + Caa.hex(tcb.address()) + " (last ditch)");
        } else {
            throw new CaaNotFound();
        }
    }

    private boolean is32bitCaa() {
        try {
            long l = this.tcb.tcbcelap();
            log.finer("celap = 0x" + Caa.hex(l));
            int n = this.space.readInt(l);
            log.finer("celap0 = 0x" + Caa.hex(n));
            if (n == 0) {
                return false;
            }
            this.address = this.space.readInt(n + 32);
            int n2 = this.space.readInt(n + 8);
            log.finer("caa address = " + Caa.hex(this.address));
            return this.validate();
        }
        catch (IOException iOException) {
            log.finer("caught exception: " + iOException);
            return false;
        }
    }

    private boolean is64bitCaa() {
        try {
            long l = this.tcb.tcbstcb();
            log.finer("stcb = 0x" + Caa.hex(l));
            this.laa = IhastcbTemplate.getStcblaa(this.inputStream, l);
            log.finer("laa = 0x" + Caa.hex(this.laa));
            long l2 = CeexlaaTemplate.getCeelaa_lca64(this.inputStream, this.laa);
            log.finer("lca = 0x" + Caa.hex(l2));
            this.address = CeelcaTemplate.getCeelca_caa(this.inputStream, l2);
            log.finer("caa address = " + Caa.hex(this.address));
            return this.validate();
        }
        catch (IOException iOException) {
            log.finer("caught exception: " + iOException);
            return false;
        }
    }

    private boolean is32bitCaaLastDitch() {
        try {
            this.address = this.space.readInt(this.tcb.address() + 96L);
            log.finer("tcb caa address = " + Caa.hex(this.address));
            if (this.address == 0L) {
                throw new IOException("oh");
            }
            return this.validate();
        }
        catch (IOException iOException) {
            log.finer("caught exception: " + iOException);
            return false;
        }
    }

    public boolean is64bit() {
        return this.is64bit;
    }

    public String whereFound() {
        return this.whereFound;
    }

    public RegisterSet getFailingRegisters() {
        this.getCurrentFrame();
        return this.failingRegisters;
    }

    public RegisterSet getRegisters() {
        this.getCurrentFrame();
        return this.registers;
    }

    private boolean validate() {
        try {
            int n = this.space.readInt(this.address - 24L);
            int n2 = this.space.readInt(this.address - 20L) & 0xFFFF0000;
            if (n == -1010448957 && n2 == -1044316160) {
                log.fine("found valid caa at " + Caa.hex(this.address));
                return true;
            }
        }
        catch (IOException iOException) {
            log.finer("caught exception: " + iOException);
        }
        return false;
    }

    public DsaStackFrame getCurrentFrame() {
        if (this.currentFrame == null) {
            log.finer("about to get top dsa for caa " + Caa.hex(this.address));
            Cel4rreg cel4rreg = new Cel4rreg();
            assert (cel4rreg.p_dsafmt != -1);
            RegisterSet registerSet = cel4rreg.regs;
            boolean bl = cel4rreg.p_dsafmt == 1;
            long l = cel4rreg.p_dsaptr;
            if (l == 0L) {
                log.finer("dsa is zero for caa " + Caa.hex(this.address));
                return null;
            }
            try {
                this.currentFrame = new DsaStackFrame(l, bl, registerSet, this.space, this);
            }
            catch (IOException iOException) {
                log.finer("exception getting top dsa: " + iOException);
            }
        }
        return this.currentFrame;
    }

    public long getPthreadId() throws IOException {
        return this.caaTemplate.getCeecaathdid(this.inputStream, this.address);
    }

    public boolean hasFailed() {
        throw new Error("tbc");
    }

    public RegisterSet getRegisterSet() {
        throw new Error("tbc");
    }

    public Edb getEdb() {
        if (this.edb == null) {
            try {
                Long l = new Long(this.ceecaaedb());
                this.edb = (Edb)this.space.getUserMap().get(l);
                if (this.edb == null) {
                    this.edb = new Edb(this.ceecaaedb(), this.space, this.is64bit);
                    this.space.getUserMap().put(l, this.edb);
                }
            }
            catch (Exception exception) {
                log.logp(Level.WARNING, "com.ibm.j9ddr.corereaders.tdump.zebedee.le.Caa", "getEdb", "Unexepected exception", exception);
                throw new Error("Unexpected Exception: " + exception);
            }
        }
        return this.edb;
    }

    public long address() {
        return this.address;
    }

    public AddressSpace space() {
        return this.space;
    }

    public Tcb getTcb() {
        return this.tcb;
    }

    public int ceecaalevel() throws IOException {
        return (int)this.caaTemplate.getCeecaalevel(this.inputStream, this.address);
    }

    public int ceecaa_stackdirection() throws IOException {
        if (this.ceecaalevel() < 13) {
            throw new Error("ceecaa_stackdirection is not available in this level of LE! " + this.ceecaalevel());
        }
        return (int)this.caaTemplate.getCeecaa_stackdirection(this.inputStream, this.address);
    }

    public long ceecaasmcb() throws IOException {
        if (this.caaTemplate instanceof Caa32Template) {
            return ((Caa32Template)this.caaTemplate).getCeecaasmcb(this.inputStream, this.address);
        }
        return ((Caa64Template)this.caaTemplate).getCeecaasmcb(this.inputStream, this.address);
    }

    public long ceecaarcb() throws IOException {
        return this.caaTemplate.getCeecaarcb(this.inputStream, this.address);
    }

    public long ceecaa_stackfloor() throws IOException {
        throw new Error("tbc");
    }

    public long ceecaavba() throws IOException {
        return this.caaTemplate.getCeecaavba(this.inputStream, this.address);
    }

    public long ceecaatcs() throws IOException {
        return this.caaTemplate.getCeecaatcs(this.inputStream, this.address);
    }

    public long pthread_getspecific_d8_np(long l) throws IOException {
        long l2 = this.ceecaavba();
        if (l2 == 0L) {
            log.finer("ceecaavba is zero in caa " + Caa.hex(this.address));
            return 0L;
        }
        long l3 = 0L;
        try {
            l3 = this.space.readInt(l2);
        }
        catch (IOException iOException) {
            log.fine("bad ceecaavba: " + Caa.hex(l2));
            return 0L;
        }
        if (l3 == -471481792L) {
            long l4 = this.getEdb().ceeedbdba();
            log.finer("ceeedbdba = " + Caa.hex(l4));
            assert (this.space.readInt(l4) == -758857152);
            long l5 = this.space.readWord(l4 + 8L, this.is64bit);
            long l6 = (l - l5) / 16L;
            int n = (int)l6 / 32;
            int n2 = (int)l6 % 32;
            log.fine("keyIndex = " + l6 + " bucketNumber = " + n + " bucketIndex = " + n2);
            if (n < 0 || n > 31) {
                return 0L;
            }
            assert (n < 32);
            int n3 = this.is64bit ? 8 : 4;
            long l7 = this.space.readWord(l2 + (long)n3 + (long)(n * n3), this.is64bit);
            if (l7 == 0L) {
                return 0L;
            }
            log.finer("bucket = " + Caa.hex(l7));
            long l8 = this.space.readWord(l7 + (long)n3 + (long)(n2 * n3), this.is64bit);
            log.finer("value = " + Caa.hex(l8));
            return l8;
        }
        long l9 = CeextvbTemplate.getCeetvbcount(this.inputStream, l2);
        log.finer("eye = " + Caa.hex(this.space.readInt(l2)));
        long l10 = l2 + (long)(this.is64bit ? 16 : 12);
        int n = 0;
        while ((long)n < l9) {
            long l11 = this.space.readWord(l10);
            log.finer("key = " + Caa.hex(l) + " ceetvbekey = " + Caa.hex(l11));
            if (l == l11) {
                return this.space.readWord(l10 + (long)(this.is64bit ? 8 : 4));
            }
            l10 += (long)(this.is64bit ? 16 : 8);
            ++n;
        }
        return 0L;
    }

    public long ceecaaddsa() {
        try {
            return this.caaTemplate.getCeecaaddsa(this.inputStream, this.address);
        }
        catch (IOException iOException) {
            throw new Error("oops");
        }
    }

    public long ceecaaedb() throws IOException {
        return this.caaTemplate.getCeecaaedb(this.inputStream, this.address);
    }

    public long ceecaaerrcm() throws IOException {
        return this.caaTemplate.getCeecaaerrcm(this.inputStream, this.address);
    }

    private static String hex(int n) {
        return Integer.toHexString(n);
    }

    private static String hex(long l) {
        return Long.toHexString(l);
    }

    public String toString() {
        return Caa.hex(this.address);
    }

    static {
        String string = System.getProperty("zebedee.where.skip");
        if (string != null) {
            whereSkip = new Integer(string);
        }
    }

    class Cel4rreg {
        long seghigh;
        long seglow;
        int p_dsafmt = -1;
        long p_dsaptr;
        RegisterSet regs;

        Cel4rreg() {
            String string = System.getProperty("zebedee.use.svcdump");
            if (string != null && string.equals("true")) {
                this.getRegistersFromSvcdump();
                return;
            }
            int n = 0;
            try {
                this.regs = this.getRegistersFromRTM2();
                if (this.regs != null && n++ >= whereSkip) {
                    Caa.this.whereFound = "RTM2";
                    Caa.this.failingRegisters = this.regs;
                    Caa.this.registers = this.regs;
                    return;
                }
            }
            catch (IOException iOException) {
                throw new Error("oops: " + iOException);
            }
            try {
                this.regs = this.getRegistersFromBPXGMSTA();
                if (this.regs != null && n++ >= whereSkip) {
                    Caa.this.whereFound = this.regs.whereFound();
                    if (Caa.this.whereFound == null) {
                        Caa.this.whereFound = "BPXGMSTA";
                    }
                    if (Caa.this.tcb.tcbcmp() != 0L) {
                        Caa.this.failingRegisters = this.regs;
                    }
                    Caa.this.registers = this.regs;
                    return;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.regs = this.getRegistersFromLinkageStack();
                if (this.regs != null && n++ >= whereSkip) {
                    Caa.this.whereFound = "Linkage";
                    if (Caa.this.tcb.tcbcmp() != 0L) {
                        Caa.this.failingRegisters = this.regs;
                    }
                    Caa.this.registers = this.regs;
                    return;
                }
            }
            catch (IOException iOException) {
                log.logp(Level.WARNING, "com.ibm.j9ddr.corereaders.tdump.zebedee.le.Caa.Cel4rreg", "Cel4rreg", "Unexepected exception", iOException);
                throw new Error("Unexpected IOException: " + iOException);
            }
            try {
                this.regs = this.getRegistersFromTCB();
                if (this.regs != null && n++ >= whereSkip) {
                    Caa.this.whereFound = "TCB";
                    if (Caa.this.tcb.tcbcmp() != 0L) {
                        Caa.this.failingRegisters = this.regs;
                    }
                    Caa.this.registers = this.regs;
                    return;
                }
            }
            catch (IOException iOException) {
                throw new Error("oops: " + iOException);
            }
            try {
                if (Caa.this.is64bit) {
                    long l = CeexlaaTemplate.getCeelaa_lca64(Caa.this.inputStream, Caa.this.laa);
                    this.p_dsaptr = CeelcaTemplate.getCeelca_savstack(Caa.this.inputStream, l);
                    log.fine("p_dsaptr from lca = " + Caa.hex(this.p_dsaptr));
                    this.p_dsafmt = Caa.this.stackdirection = 1;
                    if (this.validateDSA() == 0 && n++ >= whereSkip) {
                        Caa.this.whereFound = "LCA";
                        return;
                    }
                }
            }
            catch (IOException iOException) {
                throw new Error("oops: " + iOException);
            }
            try {
                this.regs = this.getRegistersFromUsta();
                if (this.regs != null && n++ >= whereSkip) {
                    Caa.this.whereFound = this.regs.whereFound();
                    if (Caa.this.tcb.tcbcmp() != 0L) {
                        Caa.this.failingRegisters = this.regs;
                    }
                    Caa.this.registers = this.regs;
                    return;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Caa.this.whereFound = "not found";
        }

        private RegisterSet getRegistersFromRTM2() throws IOException {
            long l;
            int n = Caa.this.ceecaalevel();
            log.finer("caa level is " + n);
            if (Caa.this.is64bit) {
                Caa.this.stackdirection = 1;
                log.finer("stack direction is down");
            } else if (n >= 13) {
                Caa.this.stackdirection = Caa.this.ceecaa_stackdirection();
                log.finer("stack direction is " + (Caa.this.stackdirection == 0 ? "up" : "down"));
            } else {
                Caa.this.stackdirection = 0;
                log.finer("stack direction is up");
            }
            if (Caa.this.stackdirection == 1 && !Caa.this.is64bit) {
                try {
                    l = Caa.this.ceecaasmcb();
                    this.seghigh = SmcbTemplate.getSmcb_dsbos(Caa.this.inputStream, l);
                    this.seglow = CeexstkhTemplate.getStkh_stackfloor(Caa.this.inputStream, this.seghigh);
                }
                catch (Exception exception) {
                    return null;
                }
            }
            if ((l = Caa.this.tcb.tcbrtwa()) != 0L) {
                try {
                    log.finer("found some rtm2 registers");
                    RegisterSet registerSet = new RegisterSet();
                    long l2 = l + (long)Ihartm2aTemplate.getRtm2ereg$offset();
                    long l3 = l + (long)Ihartm2aTemplate.getRtm2g64h$offset();
                    for (int i = 0; i < 16; ++i) {
                        long l4 = Caa.this.space.readUnsignedInt(l2 + (long)(i * 4));
                        long l5 = Caa.this.is64bit ? Caa.this.space.readUnsignedInt(l3 + (long)(i * 4)) : 0L;
                        registerSet.setRegister(i, l5 << 32 | l4);
                    }
                    long l6 = l + (long)Ihartm2aTemplate.getRtm2apsw$offset();
                    registerSet.setPSW(Caa.this.space.readLong(l6));
                    if (this.registersValid(registerSet)) {
                        log.finer("found good dsa in rtm2");
                    } else {
                        log.finer("bad dsa in rtm2");
                        registerSet = null;
                    }
                    return registerSet;
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (Exception exception) {
                    throw new Error("oops: " + exception);
                }
            }
            log.finer("failed to get registers from rtm2");
            return null;
        }

        private boolean registersValid(RegisterSet registerSet) throws IOException {
            if (registerSet == null) {
                return false;
            }
            this.p_dsafmt = Caa.this.stackdirection;
            if (this.p_dsafmt == 1) {
                this.p_dsaptr = registerSet.getRegisterAsAddress(4);
                log.finer("p_dsaptr from reg 4 = " + Caa.hex(this.p_dsaptr));
            } else {
                this.p_dsaptr = registerSet.getRegisterAsAddress(13);
                log.finer("p_dsaptr from reg 13 = " + Caa.hex(this.p_dsaptr));
            }
            int n = this.validateDSA();
            if (n == 0) {
                log.finer("found valid dsa");
                return true;
            }
            if (Caa.this.stackdirection == 1) {
                this.p_dsaptr = registerSet.getRegisterAsAddress(13);
                log.finer("p_dsaptr from reg 13 (again) = " + Caa.hex(this.p_dsaptr));
                this.p_dsafmt = 0;
                n = this.validateDSA();
                if (n == 4 && (n = this.validateDSA()) == 0) {
                    log.finer("found valid dsa");
                    return true;
                }
            }
            log.finer("p_dsaptr invalid so reset: " + Caa.hex(this.p_dsaptr));
            this.p_dsaptr = 0L;
            return false;
        }

        private RegisterSet getRegistersFromBPXGMSTA() throws IOException {
            RegisterSet registerSet = Caa.this.tcb.getRegistersFromBPXGMSTA();
            if (Caa.this.is64bit) {
                Caa.this.stackdirection = 1;
            }
            if (this.registersValid(registerSet)) {
                log.finer("found good dsa in BPXGMSTA");
                return registerSet;
            }
            log.finer("BPX registers are invalid so keep looking");
            return null;
        }

        private RegisterSet getRegistersFromLinkageStack() throws IOException {
            log.finer("enter getRegistersFromLinkageStack");
            try {
                Lse[] lseArray = Caa.this.tcb.getLinkageStack();
                if (lseArray.length == 0) {
                    log.finer("empty linkage stack");
                    return null;
                }
                for (int i = 0; i < lseArray.length; ++i) {
                    Lse lse = lseArray[i];
                    if (lse.lses1pasn() == Caa.this.space.getAsid()) {
                        int n;
                        RegisterSet registerSet = new RegisterSet();
                        if (lse.isZArchitecture() && (lse.lses1typ7() == 13 || lse.lses1typ7() == 12)) {
                            log.finer("found some z arch registers");
                            registerSet.setPSW(lse.lses1pswh());
                            for (n = 0; n < 16; ++n) {
                                registerSet.setRegister(n, lse.lses1grs(n));
                            }
                        } else {
                            log.finer("found some non z arch registers");
                            registerSet.setPSW(lse.lsespsw());
                            for (n = 0; n < 16; ++n) {
                                registerSet.setRegister(n, lse.lsesgrs(n));
                            }
                        }
                        if (!this.registersValid(registerSet)) continue;
                        log.finer("found good dsa in linkage stack");
                        return registerSet;
                    }
                    log.finer("different asid: " + Caa.hex(lse.lses1pasn()));
                }
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new Error("oops: " + exception);
            }
            log.finer("could not find registers in linkage stack");
            return null;
        }

        private RegisterSet getRegistersFromTCB() throws IOException {
            log.finer("getRegistersFromTCB");
            RegisterSet registerSet = Caa.this.tcb.getRegisters();
            if (this.registersValid(registerSet)) {
                log.finer("found good dsa in TCB");
                return registerSet;
            }
            return null;
        }

        private RegisterSet getRegistersFromUsta() throws IOException {
            long l;
            boolean bl;
            log.fine("enter getRegistersFromUsta");
            RegisterSet registerSet = Caa.this.tcb.getRegistersFromUsta();
            if (this.registersValid(registerSet)) {
                log.finer("found good dsa in Usta");
                return registerSet;
            }
            boolean bl2 = bl = Caa.this.stackdirection == 1;
            if (bl) {
                l = registerSet.getRegister(4);
                log.finer("p_dsaptr from reg 4 = " + Caa.hex(this.p_dsaptr));
            } else {
                l = registerSet.getRegister(13);
                log.finer("p_dsaptr from reg 13 = " + Caa.hex(this.p_dsaptr));
            }
            try {
                int n = 0;
                for (DsaStackFrame dsaStackFrame = new DsaStackFrame(l, bl, registerSet, Caa.this.space, Caa.this); dsaStackFrame != null; dsaStackFrame = dsaStackFrame.getParentFrame()) {
                    if (++n <= 3) continue;
                    this.p_dsaptr = l;
                    this.p_dsafmt = Caa.this.stackdirection;
                    return registerSet;
                }
            }
            catch (IOException iOException) {
            }
            catch (AssertionError assertionError) {
                // empty catch block
            }
            return null;
        }

        private void getRegistersFromSvcdump() {
        }

        private int validateDSA() {
            log.finer("attempt to validate " + Caa.hex(this.p_dsaptr) + " on " + (this.p_dsafmt == 1 ? "down" : "up") + " stack");
            try {
                long l;
                if (Caa.this.is64bit) {
                    long l2;
                    assert (Caa.this.laa != 0L);
                    long l3 = CeexlaaTemplate.getCeelaa_sanc64(Caa.this.inputStream, Caa.this.laa);
                    assert (l3 != 0L);
                    long l4 = CeexsancTemplate.getSanc_bos(Caa.this.inputStream, l3);
                    long l5 = 0L;
                    long l6 = CeexsancTemplate.getSanc_stack(Caa.this.inputStream, l3);
                    l5 = l6 == (l2 = CeexsancTemplate.getSanc_user_stack(Caa.this.inputStream, l3)) ? CeexsancTemplate.getSanc_user_floor(Caa.this.inputStream, l3) : CeexlaaTemplate.getCeelaa_stackfloor64(Caa.this.inputStream, Caa.this.laa);
                    if (this.p_dsaptr < l4 && this.p_dsaptr + 2048L >= l5 && (this.p_dsaptr & 0xFL) == 0L) {
                        log.finer("dsa " + Caa.hex(this.p_dsaptr) + " is within seglow = " + Caa.hex(l5) + " seghigh = " + Caa.hex(l4));
                        return 0;
                    }
                    log.finer("dsa " + Caa.hex(this.p_dsaptr) + " is NOT within seglow = " + Caa.hex(l5) + " seghigh = " + Caa.hex(l4));
                    return 8;
                }
                if (this.p_dsafmt != 1) {
                    if (Caa.this.is64bit) {
                        return 8;
                    }
                    l = Caa.this.ceecaaerrcm();
                    if (this.p_dsaptr < l + (long)hcomLength && this.p_dsaptr >= l && (this.p_dsaptr & 7L) == 0L) {
                        log.finer("upstack dsa " + Caa.hex(this.p_dsaptr) + " is inside hcom");
                        return 0;
                    }
                }
                l = Caa.this.ceecaaddsa();
                long l7 = this.p_dsaptr;
                int n = this.p_dsafmt;
                long l8 = this.p_dsaptr;
                int n2 = this.p_dsafmt;
                boolean bl = false;
                while (true) {
                    long l9;
                    Ceexdsaf ceexdsaf = new Ceexdsaf(Caa.this.space, l7, n, Caa.this.is64bit);
                    log.finer("looping with dsa = " + Caa.hex(l7));
                    if (Caa.this.stackdirection == 1 && this.p_dsafmt == 0 && l7 < this.seghigh && l7 >= this.seglow) {
                        this.p_dsaptr = CeedsaTemplate.getCeedsar4(Caa.this.inputStream, l7);
                        this.p_dsafmt = 1;
                        log.finer("warning, try switching to down stack");
                        return 4;
                    }
                    long l10 = ceexdsaf.DSA_Prev;
                    n = ceexdsaf.DSA_Format;
                    if (l10 == 0L || l10 == -420355391L) {
                        log.finer("cannot backchain futher because " + (l10 == 0L ? "zero" : "linkage stack") + " found");
                        return 8;
                    }
                    if (l10 == l) {
                        log.finer("dummy dsa reached");
                        return 0;
                    }
                    if (n != this.p_dsafmt) {
                        log.finer("backchained across a stack transition");
                        return 0;
                    }
                    if (n == 0 && (l9 = CeedsaTemplate.getCeedsanab(Caa.this.inputStream, l10)) == l7) {
                        log.finer("upstack DSA is good");
                        return 0;
                    }
                    l7 = l10;
                    if (bl) {
                        ceexdsaf = new Ceexdsaf(Caa.this.space, l8, n2, Caa.this.is64bit);
                        l8 = ceexdsaf.DSA_Prev;
                        n2 = ceexdsaf.DSA_Format;
                    }
                    if (l7 == l8) {
                        log.finer("loop detected in DSA chain");
                        return 8;
                    }
                    bl = !bl;
                }
            }
            catch (IOException iOException) {
                log.logp(Level.FINER, "com.ibm.j9ddr.corereaders.tdump.zebedee.le.Caa.Cel4rreg", "validateDSA", "Bad read", iOException);
                return 8;
            }
            catch (Exception exception) {
                log.logp(Level.WARNING, "com.ibm.j9ddr.corereaders.tdump.zebedee.le.Caa.Cel4rreg", "validateDSA", "Unexepected exception", exception);
                throw new Error("Unexpected Exception:: " + exception);
            }
        }
    }
}

