/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.corereaders.osthread.IOSStackFrame;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class NativeStacksCommand
extends Command {
    public NativeStacksCommand() {
        this.addCommand("nativestacks", "[tid] [tid] ...", "Display the native stacks for all or the specified thread ids.");
        this.addCommand("nstack", "[tid] [tid] ...", "Display the native stacks for all or the specified thread ids.");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run(String cmd, String[] args, Context ctx, PrintStream out) throws DDRInteractiveCommandException {
        void var8_11;
        HashSet<Long> threadIds = null;
        String[] stringArray = args;
        int n = stringArray.length;
        boolean bl = false;
        while (var8_11 < n) {
            String arg = stringArray[var8_11];
            if (threadIds == null) {
                threadIds = new HashSet<Long>();
            }
            Long tid = CommandUtils.parseNumber(arg).longValue();
            threadIds.add(tid);
            ++var8_11;
        }
        try {
            Collection<? extends IOSThread> threads = ctx.process.getThreads();
            for (IOSThread iOSThread : threads) {
                if (threadIds != null && !threadIds.contains(iOSThread.getThreadId())) continue;
                try {
                    out.printf("Thread id: %d (0x%X)\n", iOSThread.getThreadId(), iOSThread.getThreadId());
                    int frameId = 0;
                    if (threadIds != null) {
                        threadIds.remove(iOSThread.getThreadId());
                    }
                    for (IOSStackFrame iOSStackFrame : iOSThread.getStackFrames()) {
                        String symbol = ctx.process.getProcedureNameForAddress(iOSStackFrame.getInstructionPointer());
                        if (ctx.process.bytesPerPointer() == 8) {
                            out.printf("#%d bp:0x%016X ip:0x%016X %s\n", frameId++, iOSStackFrame.getBasePointer(), iOSStackFrame.getInstructionPointer(), symbol);
                            continue;
                        }
                        out.printf("#%d bp:0x%08X ip:0x%08X %s\n", frameId++, iOSStackFrame.getBasePointer(), iOSStackFrame.getInstructionPointer(), symbol);
                    }
                }
                catch (DataUnavailableException e) {
                    out.printf("DataUnavailableException reading stack for thread %d\n", iOSThread.getThreadId());
                }
                catch (CorruptDataException e) {
                    out.printf("CorruptDataException reading stack for thread %d\n", iOSThread.getThreadId());
                }
                out.println("----------");
            }
            if (threadIds != null && !threadIds.isEmpty()) {
                out.print("Unable to find native thread for id(s): ");
                Iterator<IOSThread> iterator = threadIds.iterator();
                while (iterator.hasNext()) {
                    long l = (Long)((Object)iterator.next());
                    out.print(l);
                }
                out.println();
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

