/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AttributeValue;

public final class JobAttributes
implements Cloneable {
    private int copies;
    private DefaultSelectionType defaultSelection;
    private DestinationType destination;
    private DialogType dialog;
    private String fileName;
    private int fromPage;
    private int maxPage;
    private int minPage;
    private MultipleDocumentHandlingType multipleDocumentHandling;
    private int[][] pageRanges;
    private int prFirst;
    private int prLast;
    private String printer;
    private SidesType sides;
    private int toPage;

    public JobAttributes() {
        this.setCopiesToDefault();
        this.setDefaultSelection(DefaultSelectionType.ALL);
        this.setDestination(DestinationType.PRINTER);
        this.setDialog(DialogType.NATIVE);
        this.setMaxPage(Integer.MAX_VALUE);
        this.setMinPage(1);
        this.setMultipleDocumentHandlingToDefault();
        this.setSidesToDefault();
    }

    public JobAttributes(JobAttributes jobAttributes) {
        this.set(jobAttributes);
    }

    public JobAttributes(int n, DefaultSelectionType defaultSelectionType, DestinationType destinationType, DialogType dialogType, String string, int n2, int n3, MultipleDocumentHandlingType multipleDocumentHandlingType, int[][] nArray, String string2, SidesType sidesType) {
        this.setCopies(n);
        this.setDefaultSelection(defaultSelectionType);
        this.setDestination(destinationType);
        this.setDialog(dialogType);
        this.setFileName(string);
        this.setMaxPage(n2);
        this.setMinPage(n3);
        this.setMultipleDocumentHandling(multipleDocumentHandlingType);
        this.setPageRanges(nArray);
        this.setPrinter(string2);
        this.setSides(sidesType);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void set(JobAttributes jobAttributes) {
        this.copies = jobAttributes.copies;
        this.defaultSelection = jobAttributes.defaultSelection;
        this.destination = jobAttributes.destination;
        this.dialog = jobAttributes.dialog;
        this.fileName = jobAttributes.fileName;
        this.fromPage = jobAttributes.fromPage;
        this.maxPage = jobAttributes.maxPage;
        this.minPage = jobAttributes.minPage;
        this.multipleDocumentHandling = jobAttributes.multipleDocumentHandling;
        this.pageRanges = jobAttributes.pageRanges;
        this.prFirst = jobAttributes.prFirst;
        this.prLast = jobAttributes.prLast;
        this.printer = jobAttributes.printer;
        this.sides = jobAttributes.sides;
        this.toPage = jobAttributes.toPage;
    }

    public int getCopies() {
        return this.copies;
    }

    public void setCopies(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid value for attribute copies");
        }
        this.copies = n;
    }

    public void setCopiesToDefault() {
        this.setCopies(1);
    }

    public DefaultSelectionType getDefaultSelection() {
        return this.defaultSelection;
    }

    public void setDefaultSelection(DefaultSelectionType defaultSelectionType) {
        if (defaultSelectionType == null) {
            throw new IllegalArgumentException("Invalid value for attribute defaultSelection");
        }
        this.defaultSelection = defaultSelectionType;
    }

    public DestinationType getDestination() {
        return this.destination;
    }

    public void setDestination(DestinationType destinationType) {
        if (destinationType == null) {
            throw new IllegalArgumentException("Invalid value for attribute destination");
        }
        this.destination = destinationType;
    }

    public DialogType getDialog() {
        return this.dialog;
    }

    public void setDialog(DialogType dialogType) {
        if (dialogType == null) {
            throw new IllegalArgumentException("Invalid value for attribute dialog");
        }
        this.dialog = dialogType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public int getFromPage() {
        if (this.fromPage != 0) {
            return this.fromPage;
        }
        if (this.toPage != 0) {
            return this.getMinPage();
        }
        if (this.pageRanges != null) {
            return this.prFirst;
        }
        return this.getMinPage();
    }

    public void setFromPage(int n) {
        if (n <= 0 || this.toPage != 0 && n > this.toPage || n < this.minPage || n > this.maxPage) {
            throw new IllegalArgumentException("Invalid value for attribute fromPage");
        }
        this.fromPage = n;
    }

    public int getMaxPage() {
        return this.maxPage;
    }

    public void setMaxPage(int n) {
        if (n <= 0 || n < this.minPage) {
            throw new IllegalArgumentException("Invalid value for attribute maxPage");
        }
        this.maxPage = n;
    }

    public int getMinPage() {
        return this.minPage;
    }

    public void setMinPage(int n) {
        if (n <= 0 || n > this.maxPage) {
            throw new IllegalArgumentException("Invalid value for attribute minPage");
        }
        this.minPage = n;
    }

    public MultipleDocumentHandlingType getMultipleDocumentHandling() {
        return this.multipleDocumentHandling;
    }

    public void setMultipleDocumentHandling(MultipleDocumentHandlingType multipleDocumentHandlingType) {
        if (multipleDocumentHandlingType == null) {
            throw new IllegalArgumentException("Invalid value for attribute multipleDocumentHandling");
        }
        this.multipleDocumentHandling = multipleDocumentHandlingType;
    }

    public void setMultipleDocumentHandlingToDefault() {
        this.setMultipleDocumentHandling(MultipleDocumentHandlingType.SEPARATE_DOCUMENTS_UNCOLLATED_COPIES);
    }

    public int[][] getPageRanges() {
        if (this.pageRanges != null) {
            int[][] nArray = new int[this.pageRanges.length][2];
            for (int i = 0; i < this.pageRanges.length; ++i) {
                nArray[i][0] = this.pageRanges[i][0];
                nArray[i][1] = this.pageRanges[i][1];
            }
            return nArray;
        }
        if (this.fromPage != 0 || this.toPage != 0) {
            int n = this.getFromPage();
            int n2 = this.getToPage();
            return new int[][]{{n, n2}};
        }
        int n = this.getMinPage();
        return new int[][]{{n, n}};
    }

    public void setPageRanges(int[][] nArray) {
        String string = "Invalid value for attribute pageRanges";
        int n = 0;
        int n2 = 0;
        if (nArray == null) {
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == null || nArray[i].length != 2 || nArray[i][0] <= n2 || nArray[i][1] < nArray[i][0]) {
                throw new IllegalArgumentException(string);
            }
            n2 = nArray[i][1];
            if (n != 0) continue;
            n = nArray[i][0];
        }
        if (n < this.minPage || n2 > this.maxPage) {
            throw new IllegalArgumentException(string);
        }
        int[][] nArray2 = new int[nArray.length][2];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i][0] = nArray[i][0];
            nArray2[i][1] = nArray[i][1];
        }
        this.pageRanges = nArray2;
        this.prFirst = n;
        this.prLast = n2;
    }

    public String getPrinter() {
        return this.printer;
    }

    public void setPrinter(String string) {
        this.printer = string;
    }

    public SidesType getSides() {
        return this.sides;
    }

    public void setSides(SidesType sidesType) {
        if (sidesType == null) {
            throw new IllegalArgumentException("Invalid value for attribute sides");
        }
        this.sides = sidesType;
    }

    public void setSidesToDefault() {
        this.setSides(SidesType.ONE_SIDED);
    }

    public int getToPage() {
        if (this.toPage != 0) {
            return this.toPage;
        }
        if (this.fromPage != 0) {
            return this.fromPage;
        }
        if (this.pageRanges != null) {
            return this.prLast;
        }
        return this.getMinPage();
    }

    public void setToPage(int n) {
        if (n <= 0 || this.fromPage != 0 && n < this.fromPage || n < this.minPage || n > this.maxPage) {
            throw new IllegalArgumentException("Invalid value for attribute toPage");
        }
        this.toPage = n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JobAttributes)) {
            return false;
        }
        JobAttributes jobAttributes = (JobAttributes)object;
        if (this.fileName == null ? jobAttributes.fileName != null : !this.fileName.equals(jobAttributes.fileName)) {
            return false;
        }
        if (this.pageRanges == null) {
            if (jobAttributes.pageRanges != null) {
                return false;
            }
        } else {
            if (jobAttributes.pageRanges == null || this.pageRanges.length != jobAttributes.pageRanges.length) {
                return false;
            }
            for (int i = 0; i < this.pageRanges.length; ++i) {
                if (this.pageRanges[i][0] == jobAttributes.pageRanges[i][0] && this.pageRanges[i][1] == jobAttributes.pageRanges[i][1]) continue;
                return false;
            }
        }
        if (this.printer == null ? jobAttributes.printer != null : !this.printer.equals(jobAttributes.printer)) {
            return false;
        }
        return this.copies == jobAttributes.copies && this.defaultSelection == jobAttributes.defaultSelection && this.destination == jobAttributes.destination && this.dialog == jobAttributes.dialog && this.fromPage == jobAttributes.fromPage && this.maxPage == jobAttributes.maxPage && this.minPage == jobAttributes.minPage && this.multipleDocumentHandling == jobAttributes.multipleDocumentHandling && this.prFirst == jobAttributes.prFirst && this.prLast == jobAttributes.prLast && this.sides == jobAttributes.sides && this.toPage == jobAttributes.toPage;
    }

    public int hashCode() {
        int n = (this.copies + this.fromPage + this.maxPage + this.minPage + this.prFirst + this.prLast + this.toPage) * 31 << 21;
        if (this.pageRanges != null) {
            int n2 = 0;
            for (int i = 0; i < this.pageRanges.length; ++i) {
                n2 += this.pageRanges[i][0] + this.pageRanges[i][1];
            }
            n ^= n2 * 31 << 11;
        }
        if (this.fileName != null) {
            n ^= this.fileName.hashCode();
        }
        if (this.printer != null) {
            n ^= this.printer.hashCode();
        }
        return this.defaultSelection.hashCode() << 6 ^ this.destination.hashCode() << 5 ^ this.dialog.hashCode() << 3 ^ this.multipleDocumentHandling.hashCode() << 2 ^ this.sides.hashCode() ^ n;
    }

    public String toString() {
        int[][] nArray = this.getPageRanges();
        String string = "[";
        boolean bl = true;
        for (int i = 0; i < nArray.length; ++i) {
            if (bl) {
                bl = false;
            } else {
                string = string + ",";
            }
            string = string + nArray[i][0] + ":" + nArray[i][1];
        }
        string = string + "]";
        return "copies=" + this.getCopies() + ",defaultSelection=" + this.getDefaultSelection() + ",destination=" + this.getDestination() + ",dialog=" + this.getDialog() + ",fileName=" + this.getFileName() + ",fromPage=" + this.getFromPage() + ",maxPage=" + this.getMaxPage() + ",minPage=" + this.getMinPage() + ",multiple-document-handling=" + this.getMultipleDocumentHandling() + ",page-ranges=" + string + ",printer=" + this.getPrinter() + ",sides=" + this.getSides() + ",toPage=" + this.getToPage();
    }

    public static final class SidesType
    extends AttributeValue {
        private static final int I_ONE_SIDED = 0;
        private static final int I_TWO_SIDED_LONG_EDGE = 1;
        private static final int I_TWO_SIDED_SHORT_EDGE = 2;
        private static final String[] NAMES = new String[]{"one-sided", "two-sided-long-edge", "two-sided-short-edge"};
        public static final SidesType ONE_SIDED = new SidesType(0);
        public static final SidesType TWO_SIDED_LONG_EDGE = new SidesType(1);
        public static final SidesType TWO_SIDED_SHORT_EDGE = new SidesType(2);

        private SidesType(int n) {
            super(n, NAMES);
        }
    }

    public static final class MultipleDocumentHandlingType
    extends AttributeValue {
        private static final int I_SEPARATE_DOCUMENTS_COLLATED_COPIES = 0;
        private static final int I_SEPARATE_DOCUMENTS_UNCOLLATED_COPIES = 1;
        private static final String[] NAMES = new String[]{"separate-documents-collated-copies", "separate-documents-uncollated-copies"};
        public static final MultipleDocumentHandlingType SEPARATE_DOCUMENTS_COLLATED_COPIES = new MultipleDocumentHandlingType(0);
        public static final MultipleDocumentHandlingType SEPARATE_DOCUMENTS_UNCOLLATED_COPIES = new MultipleDocumentHandlingType(1);

        private MultipleDocumentHandlingType(int n) {
            super(n, NAMES);
        }
    }

    public static final class DialogType
    extends AttributeValue {
        private static final int I_COMMON = 0;
        private static final int I_NATIVE = 1;
        private static final int I_NONE = 2;
        private static final String[] NAMES = new String[]{"common", "native", "none"};
        public static final DialogType COMMON = new DialogType(0);
        public static final DialogType NATIVE = new DialogType(1);
        public static final DialogType NONE = new DialogType(2);

        private DialogType(int n) {
            super(n, NAMES);
        }
    }

    public static final class DestinationType
    extends AttributeValue {
        private static final int I_FILE = 0;
        private static final int I_PRINTER = 1;
        private static final String[] NAMES = new String[]{"file", "printer"};
        public static final DestinationType FILE = new DestinationType(0);
        public static final DestinationType PRINTER = new DestinationType(1);

        private DestinationType(int n) {
            super(n, NAMES);
        }
    }

    public static final class DefaultSelectionType
    extends AttributeValue {
        private static final int I_ALL = 0;
        private static final int I_RANGE = 1;
        private static final int I_SELECTION = 2;
        private static final String[] NAMES = new String[]{"all", "range", "selection"};
        public static final DefaultSelectionType ALL = new DefaultSelectionType(0);
        public static final DefaultSelectionType RANGE = new DefaultSelectionType(1);
        public static final DefaultSelectionType SELECTION = new DefaultSelectionType(2);

        private DefaultSelectionType(int n) {
            super(n, NAMES);
        }
    }
}

