/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.CacheKey;
import java.lang.invoke.MethodType;

final class MethodCacheKey
extends CacheKey {
    private final MethodType type;
    private final Class<?> specialCaller;

    public MethodCacheKey(String string, MethodType methodType, Class<?> clazz) {
        super(string, MethodCacheKey.calculateHashcode(string, methodType, clazz));
        this.type = methodType;
        this.specialCaller = clazz;
    }

    private static int calculateHashcode(String string, MethodType methodType, Class<?> clazz) {
        int n = 31 + methodType.hashCode();
        n = 31 * n + string.hashCode();
        if (clazz != null) {
            n = 31 * n + clazz.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof MethodCacheKey)) {
            return false;
        }
        MethodCacheKey methodCacheKey = (MethodCacheKey)object;
        return methodCacheKey.type == this.type && methodCacheKey.name.equals(this.name) && methodCacheKey.specialCaller == this.specialCaller;
    }
}

