/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.Comparator;
import java.lang.invoke.ComputedCalls;
import java.lang.invoke.IndirectHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleResolver;
import java.lang.invoke.MethodType;
import java.lang.invoke.ThunkTable;
import java.lang.reflect.Method;

final class InterfaceHandle
extends IndirectHandle {
    private static final ThunkTable _thunkTable;

    static native void registerNatives();

    InterfaceHandle(Class<?> clazz, String string, MethodType methodType) throws NoSuchMethodException, IllegalAccessException {
        super(InterfaceHandle.indirectMethodType(methodType, clazz), clazz, string, (byte)9);
        assert (clazz.isInterface());
        this.defc = this.finishMethodInitialization(null, methodType);
    }

    InterfaceHandle(Method method) throws IllegalAccessException {
        super(InterfaceHandle.indirectMethodType(method), method.getDeclaringClass(), method.getName(), (byte)9, method.getModifiers());
        if (!this.referenceClass.isInterface()) {
            throw new IllegalArgumentException();
        }
        boolean bl = InterfaceHandle.setVMSlotAndRawModifiersFromMethod(this, this.referenceClass, method, this.kind, this.specialCaller);
        if (!bl) {
            throw new IllegalAccessException();
        }
    }

    public InterfaceHandle(InterfaceHandle interfaceHandle, MethodType methodType) {
        super(interfaceHandle, methodType);
    }

    @Override
    protected final long vtableOffset(Object object) {
        Class clazz = this.referenceClass;
        if (clazz.isInstance(object)) {
            long l = MethodHandleResolver.getJ9ClassFromClass(clazz);
            long l2 = MethodHandleResolver.getJ9ClassFromClass(object.getClass());
            return InterfaceHandle.convertITableIndexToVTableIndex(l, (int)this.vmSlot, l2) << VTABLE_ENTRY_SHIFT;
        }
        throw new IncompatibleClassChangeError();
    }

    protected static native int convertITableIndexToVTableIndex(long var0, int var2, long var3);

    @Override
    protected final ThunkTable thunkTable() {
        return _thunkTable;
    }

    protected static native void interfaceCall_V(Object var0, int var1);

    protected static native int interfaceCall_I(Object var0, int var1);

    protected static native long interfaceCall_J(Object var0, int var1);

    protected static native float interfaceCall_F(Object var0, int var1);

    protected static native double interfaceCall_D(Object var0, int var1);

    protected static native Object interfaceCall_L(Object var0, int var1);

    @MethodHandle.FrameIteratorSkip
    private final void invokeExact_thunkArchetype_V(Object object, int n) {
        ComputedCalls.dispatchVirtual_V(this.jittedMethodAddress(object), this.vtableIndexArgument(object), object, n);
    }

    @MethodHandle.FrameIteratorSkip
    private final int invokeExact_thunkArchetype_I(Object object, int n) {
        return ComputedCalls.dispatchVirtual_I(this.jittedMethodAddress(object), this.vtableIndexArgument(object), object, n);
    }

    @MethodHandle.FrameIteratorSkip
    private final long invokeExact_thunkArchetype_J(Object object, int n) {
        return ComputedCalls.dispatchVirtual_J(this.jittedMethodAddress(object), this.vtableIndexArgument(object), object, n);
    }

    @MethodHandle.FrameIteratorSkip
    private final float invokeExact_thunkArchetype_F(Object object, int n) {
        return ComputedCalls.dispatchVirtual_F(this.jittedMethodAddress(object), this.vtableIndexArgument(object), object, n);
    }

    @MethodHandle.FrameIteratorSkip
    private final double invokeExact_thunkArchetype_D(Object object, int n) {
        return ComputedCalls.dispatchVirtual_D(this.jittedMethodAddress(object), this.vtableIndexArgument(object), object, n);
    }

    @MethodHandle.FrameIteratorSkip
    private final Object invokeExact_thunkArchetype_L(Object object, int n) {
        return ComputedCalls.dispatchVirtual_L(this.jittedMethodAddress(object), this.vtableIndexArgument(object), object, n);
    }

    @Override
    MethodHandle cloneWithNewType(MethodType methodType) {
        return new InterfaceHandle(this, methodType);
    }

    @Override
    final void compareWith(MethodHandle methodHandle, Comparator comparator) {
        if (methodHandle instanceof InterfaceHandle) {
            ((InterfaceHandle)methodHandle).compareWithInterface(this, comparator);
        } else {
            comparator.fail();
        }
    }

    final void compareWithInterface(InterfaceHandle interfaceHandle, Comparator comparator) {
        super.compareWithIndirect(interfaceHandle, comparator);
    }

    static {
        InterfaceHandle.registerNatives();
        _thunkTable = new ThunkTable();
    }
}

