/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management.internal;

import com.ibm.java.lang.management.internal.MemoryMXBeanImpl;
import com.ibm.lang.management.MemoryMXBean;
import com.ibm.lang.management.internal.ExtendedGarbageCollectorMXBeanImpl;
import com.ibm.lang.management.internal.ExtendedOperatingSystemMXBeanImpl;
import com.ibm.lang.management.internal.MemoryNotificationThread;
import com.ibm.lang.management.internal.MemoryPoolMXBeanImpl;
import com.ibm.oti.vm.VM;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public final class ExtendedMemoryMXBeanImpl
extends MemoryMXBeanImpl
implements MemoryMXBean {
    private static final ExtendedMemoryMXBeanImpl instance = new ExtendedMemoryMXBeanImpl();
    private static final ExtendedOperatingSystemMXBeanImpl osinstance = ExtendedOperatingSystemMXBeanImpl.getInstance();
    private final AtomicBoolean notificationThreadStarted = new AtomicBoolean();

    public static ExtendedMemoryMXBeanImpl getInstance() {
        return instance;
    }

    private ExtendedMemoryMXBeanImpl() {
    }

    @Override
    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        this.startNotificationThread();
        super.addNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    protected void startNotificationThread() {
        if (!this.notificationThreadStarted.getAndSet(true)) {
            PrivilegedAction<Thread> privilegedAction = () -> {
                Thread thread = VM.getVMLangAccess().createThread(new MemoryNotificationThread(this), "MemoryMXBean notification dispatcher", true, false, true, ClassLoader.getSystemClassLoader());
                thread.setPriority(6);
                return thread;
            };
            Thread thread = AccessController.doPrivileged(privilegedAction);
            thread.start();
        }
    }

    @Deprecated
    public long getTotalPhysicalMemory() {
        return osinstance.getTotalPhysicalMemorySize();
    }

    public long getTotalPhysicalMemorySize() {
        return osinstance.getTotalPhysicalMemorySize();
    }

    public long getUsedPhysicalMemory() {
        return osinstance.getTotalPhysicalMemorySize() - osinstance.getFreePhysicalMemorySize();
    }

    @Override
    protected GarbageCollectorMXBean makeGCBean(String string, String string2, int n) {
        return new ExtendedGarbageCollectorMXBeanImpl(string, string2, n, this);
    }

    @Override
    protected MemoryPoolMXBean makeMemoryPoolBean(String string, MemoryType memoryType, int n) {
        return new MemoryPoolMXBeanImpl(string, memoryType, n, this);
    }
}

