/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffsetIterator;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.I32Pointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.pointer.U64Pointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ArrayClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.pointer.helper.ValueTypeHelper;
import com.ibm.j9ddr.vm29.structure.J9FieldFlags;
import com.ibm.j9ddr.vm29.structure.J9ROMFieldOffsetWalkState;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Pattern;

public class PrintObjectFieldsHelper {
    private static ValueTypeHelper valueTypeHelper = ValueTypeHelper.getValueTypeHelper();
    private static final String PADDING = "\t";

    public static void printJ9ObjectFields(PrintStream printStream, int n, J9ClassPointer j9ClassPointer, U8Pointer u8Pointer, J9ObjectPointer j9ObjectPointer, long l) throws CorruptDataException {
        PrintObjectFieldsHelper.printJ9ObjectFields(printStream, n, j9ClassPointer, u8Pointer, j9ObjectPointer, l, null, false);
    }

    public static void printJ9ObjectFields(PrintStream printStream, int n, J9ClassPointer j9ClassPointer, U8Pointer u8Pointer, J9ObjectPointer j9ObjectPointer, long l, String[] stringArray, boolean bl) throws CorruptDataException {
        long l2;
        int n2;
        int n3;
        long l3;
        U32 u32;
        StructurePointer structurePointer;
        boolean bl2;
        StructurePointer structurePointer2 = J9ClassPointer.NULL;
        boolean bl3 = false;
        UDATA uDATA = new UDATA(0L);
        boolean bl4 = false;
        J9ClassPointer[] j9ClassPointerArray = null;
        boolean bl5 = bl2 = n <= 1;
        if (null != stringArray && stringArray.length > 0) {
            bl4 = true;
        }
        if (bl4) {
            j9ClassPointerArray = valueTypeHelper.findNestedClassHierarchy(j9ClassPointer, stringArray);
            structurePointer = null;
            u32 = new U32(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_INSTANCE | J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_HIDDEN);
            for (int i = 0; i < j9ClassPointerArray.length - 1; ++i) {
                structurePointer = j9ClassPointerArray[i];
                if (i > 0 && valueTypeHelper.classRequires4BytePrePadding((J9ClassPointer)structurePointer)) {
                    uDATA = uDATA.sub(4L);
                }
                l3 = J9ClassHelper.classDepth((J9ClassPointer)structurePointer).longValue();
                boolean bl6 = false;
                if (J9ClassHelper.isArrayClass((J9ClassPointer)structurePointer)) {
                    n3 = Integer.parseInt(stringArray[0].substring(1, stringArray[0].length() - 1));
                    n2 = J9ArrayClassPointer.cast(structurePointer).flattenedElementSize().intValue();
                    u8Pointer = u8Pointer.add(n3 * n2);
                    continue;
                }
                for (l2 = 0L; l2 <= l3 && !bl6; ++l2) {
                    StructurePointer structurePointer3 = l2 == l3 ? structurePointer : J9ClassPointer.cast(((J9ClassPointer)structurePointer).superclasses().at(l2));
                    Iterator<J9ObjectFieldOffset> iterator = J9ObjectFieldOffsetIterator.J9ObjectFieldOffsetIteratorFor(((J9ClassPointer)structurePointer3).romClass(), (J9ClassPointer)structurePointer, structurePointer2, u32);
                    while (iterator.hasNext()) {
                        J9ObjectFieldOffset j9ObjectFieldOffset = iterator.next();
                        if (!j9ObjectFieldOffset.getName().equals(stringArray[i])) continue;
                        uDATA = uDATA.add(j9ObjectFieldOffset.getOffsetOrAddress());
                        bl6 = true;
                        break;
                    }
                    structurePointer2 = structurePointer3;
                }
            }
            j9ClassPointer = j9ClassPointerArray[j9ClassPointerArray.length - 1];
            u8Pointer = u8Pointer.add(uDATA);
            structurePointer2 = J9ClassPointer.NULL;
        }
        if (bl2) {
            if (bl4) {
                PrintObjectFieldsHelper.padding(printStream, n);
                printStream.format("// EA = %s, offset in top level container = %d;%n", u8Pointer.getHexAddress(), u8Pointer.sub(l).getAddress());
            }
            structurePointer = j9ClassPointer.romClass().className();
            PrintObjectFieldsHelper.padding(printStream, n);
            printStream.format("struct J9Class* clazz = !j9class 0x%X // %s%n", j9ClassPointer.getAddress(), J9UTF8Helper.stringValue((J9UTF8Pointer)structurePointer));
            PrintObjectFieldsHelper.padding(printStream, n);
            printStream.format("Object flags = %s;%n", J9ObjectHelper.flags(j9ObjectPointer).getHexValue());
        }
        l3 = J9ClassHelper.classDepth(j9ClassPointer).longValue();
        for (l2 = 0L; l2 <= l3; ++l2) {
            structurePointer = l2 == l3 ? j9ClassPointer : J9ClassPointer.cast(j9ClassPointer.superclasses().at(l2));
            u32 = new U32(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_INSTANCE | J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_HIDDEN);
            Iterator<J9ObjectFieldOffset> iterator = J9ObjectFieldOffsetIterator.J9ObjectFieldOffsetIteratorFor(((J9ClassPointer)structurePointer).romClass(), j9ClassPointer, structurePointer2, u32);
            while (iterator.hasNext()) {
                boolean bl7;
                J9ObjectFieldOffset j9ObjectFieldOffset = iterator.next();
                n3 = 1;
                n2 = j9ObjectFieldOffset.isHidden();
                boolean bl8 = bl7 = n2 != 0 && j9ObjectFieldOffset.getOffsetOrAddress().add(J9ObjectHelper.headerSize()).eq(((J9ClassPointer)structurePointer).lockOffset());
                if (bl7) {
                    int n4 = n3 = !bl3 && j9ClassPointer.lockOffset().eq(((J9ClassPointer)structurePointer).lockOffset()) ? 1 : 0;
                    if (n3 != 0) {
                        bl3 = true;
                    }
                }
                if (n3 == 0) continue;
                if (bl) {
                    J9ClassPointer j9ClassPointer2 = null;
                    if (null == j9ClassPointerArray) {
                        j9ClassPointer2 = j9ClassPointer;
                    } else {
                        int n5 = Pattern.matches("\\[\\d+\\]", stringArray[0]) ? 1 : 0;
                        j9ClassPointer2 = j9ClassPointerArray[n5];
                    }
                    PrintObjectFieldsHelper.printNestedObjectField(printStream, n, j9ClassPointer, u8Pointer, (J9ClassPointer)structurePointer, j9ObjectFieldOffset, l, stringArray, j9ClassPointer2);
                } else {
                    PrintObjectFieldsHelper.printObjectField(printStream, n, j9ClassPointer, u8Pointer, (J9ClassPointer)structurePointer, j9ObjectFieldOffset, l, stringArray);
                }
                printStream.println();
            }
            structurePointer2 = structurePointer;
        }
    }

    private static void printObjectField(PrintStream printStream, int n, J9ClassPointer j9ClassPointer, U8Pointer u8Pointer, J9ClassPointer j9ClassPointer2, J9ObjectFieldOffset j9ObjectFieldOffset, long l, String[] stringArray) throws CorruptDataException {
        J9ROMFieldShapePointer j9ROMFieldShapePointer = j9ObjectFieldOffset.getField();
        UDATA uDATA = j9ObjectFieldOffset.getOffsetOrAddress();
        boolean bl = j9ObjectFieldOffset.isHidden();
        boolean bl2 = stringArray != null && stringArray.length > 0;
        String string = J9ClassHelper.getName(j9ClassPointer2);
        String string2 = J9UTF8Helper.stringValue(j9ROMFieldShapePointer.nameAndSignature().name());
        String string3 = J9UTF8Helper.stringValue(j9ROMFieldShapePointer.nameAndSignature().signature());
        boolean bl3 = valueTypeHelper.isFieldInClassFlattened(j9ClassPointer, string2);
        if (bl2 && valueTypeHelper.classRequires4BytePrePadding(j9ClassPointer)) {
            uDATA = uDATA.sub(4L);
        }
        PrintObjectFieldsHelper.padding(printStream, n);
        printStream.format("%s %s = ", string3, string2);
        U8Pointer u8Pointer2 = u8Pointer.add(uDATA);
        if (j9ROMFieldShapePointer.modifiers().anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
            printStream.print(U64Pointer.cast(u8Pointer2).at(0L).getHexValue());
        } else if (j9ROMFieldShapePointer.modifiers().anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
            if (bl3) {
                J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(l);
                StringBuilder stringBuilder = new StringBuilder("");
                if (bl2) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringBuilder.append(stringArray[i]);
                        stringBuilder.append(".");
                    }
                }
                stringBuilder.append(string2);
                printStream.format("!j9object 0x%x %s", j9ObjectPointer.getAddress(), stringBuilder);
            } else {
                UDATAPointer uDATAPointer = J9ObjectHelper.compressObjectReferences ? U32Pointer.cast(u8Pointer2) : UDATAPointer.cast(u8Pointer2);
                printStream.format("!fj9object 0x%x", ((AbstractPointer)uDATAPointer).at(0L).longValue());
            }
        } else {
            printStream.print(I32Pointer.cast(u8Pointer2).at(0L).getHexValue());
        }
        if (bl3) {
            printStream.format(" (offset = %d) (%s)", uDATA.longValue(), string3.substring(1, string3.length() - 1));
        } else {
            printStream.format(" (offset = %d) (%s)", uDATA.longValue(), string);
        }
        if (bl) {
            printStream.print(" <hidden>");
        }
    }

    private static void printNestedObjectField(PrintStream printStream, int n, J9ClassPointer j9ClassPointer, U8Pointer u8Pointer, J9ClassPointer j9ClassPointer2, J9ObjectFieldOffset j9ObjectFieldOffset, long l, String[] stringArray, J9ClassPointer j9ClassPointer3) throws CorruptDataException {
        J9ROMFieldShapePointer j9ROMFieldShapePointer = j9ObjectFieldOffset.getField();
        UDATA uDATA = j9ObjectFieldOffset.getOffsetOrAddress();
        boolean bl = stringArray != null && stringArray.length > 0;
        boolean bl2 = j9ObjectFieldOffset.isHidden();
        String string = J9UTF8Helper.stringValue(j9ROMFieldShapePointer.nameAndSignature().name());
        String string2 = J9UTF8Helper.stringValue(j9ROMFieldShapePointer.nameAndSignature().signature());
        boolean bl3 = valueTypeHelper.isFieldInClassFlattened(j9ClassPointer, string);
        PrintObjectFieldsHelper.padding(printStream, n);
        if (bl && valueTypeHelper.classRequires4BytePrePadding(j9ClassPointer)) {
            uDATA = uDATA.sub(4L);
        }
        U8Pointer u8Pointer2 = u8Pointer.add(uDATA);
        if (bl3) {
            printStream.format("%s %s { // EA = %s (offset = %d)%n", string2.substring(1, string2.length() - 1), string, u8Pointer2.getHexAddress(), uDATA.longValue());
        } else {
            printStream.format("%s %s = ", string2, string);
        }
        if (j9ROMFieldShapePointer.modifiers().anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
            printStream.print(U64Pointer.cast(u8Pointer2).at(0L).getHexValue());
        } else if (j9ROMFieldShapePointer.modifiers().anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
            if (bl3) {
                String[] stringArray2 = null;
                if (stringArray == null) {
                    stringArray2 = new String[]{string};
                } else {
                    stringArray2 = Arrays.copyOf(stringArray, stringArray.length + 1);
                    stringArray2[stringArray.length] = string;
                }
                J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(l);
                u8Pointer = U8Pointer.cast(j9ObjectPointer).add(ObjectModel.getHeaderSize(j9ObjectPointer));
                PrintObjectFieldsHelper.printJ9ObjectFields(printStream, n + 1, j9ClassPointer3, u8Pointer, null, l, stringArray2, true);
            } else {
                UDATAPointer uDATAPointer = J9ObjectHelper.compressObjectReferences ? U32Pointer.cast(u8Pointer2) : UDATAPointer.cast(u8Pointer2);
                printStream.format("!fj9object 0x%x%n", ((AbstractPointer)uDATAPointer).at(0L).longValue());
            }
        } else {
            printStream.print(I32Pointer.cast(u8Pointer2).at(0L).getHexValue());
        }
        if (bl3) {
            PrintObjectFieldsHelper.padding(printStream, n);
            printStream.print("}");
        }
        if (bl2) {
            printStream.print(" <hidden>");
        }
    }

    public static void padding(PrintStream printStream, int n) {
        for (int i = 0; i < n; ++i) {
            printStream.print(PADDING);
        }
    }
}

