/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.mvs;

import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpace;
import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpaceImageInputStream;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.BpxzotcbTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.BpxzustaTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.CeexcvtTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.IhaascbTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.IhaasxbTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.IhapsaTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.IharbTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.IhastcbTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.IhawebTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.IhaxsbTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.IkjrbTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.IkjrbprefixTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.IkjtcbTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.Lse;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.LsedTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.Lsestate1Template;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.LsestateTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.OtcbcopyonforkTemplate;
import com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.RegisterSet;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.ProgressMeter;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Tcb {
    private AddressSpace space;
    private AddressSpaceImageInputStream inputStream;
    private long address;
    private Lse[] linkageStack;
    private static final int RBFTPRB = 0;
    private static final int FastPathPCLow = 4871;
    private static final int OmvsPcLow = 4864;
    private static Logger log = Logger.getLogger("j9ddr.core_readers");
    private boolean assertionsEnabled = false;
    private int release = 0;

    public static Tcb[] getTcbs(AddressSpace addressSpace) {
        ProgressMeter.set("getting tcbs", 50);
        AddressSpaceImageInputStream addressSpaceImageInputStream = addressSpace.getImageInputStream();
        AddressSpaceImageInputStream addressSpaceImageInputStream2 = addressSpace.getRootAddressSpace().getImageInputStream();
        Tcb[] tcbArray = (Tcb[])addressSpace.getUserMap().get("tcbmap");
        if (tcbArray != null) {
            return tcbArray;
        }
        log.fine("creating Tcb array for asid " + addressSpace);
        Vector<Tcb> vector = new Vector<Tcb>();
        try {
            long l;
            long l2 = IhapsaTemplate.getPsaaold(addressSpaceImageInputStream2, 0L);
            if (l2 == 0L) {
                log.fine("psaaold is zero so no tcbs in asid " + addressSpace);
                return null;
            }
            long l3 = IhaascbTemplate.getAscbasxb(addressSpaceImageInputStream2, l2);
            long l4 = IhaasxbTemplate.getAsxbftcb(addressSpaceImageInputStream, l3);
            if (l4 == (l = IhaasxbTemplate.getAsxbltcb(addressSpaceImageInputStream, l3))) {
                log.fine("first and last tcb pointers are equal so no tcbs in asid " + addressSpace);
                return null;
            }
            Tcb tcb = new Tcb(addressSpace, l4);
            while (true) {
                ProgressMeter.set("getting tcb " + Tcb.hex(tcb.address()), 50);
                vector.add(tcb);
                if (tcb.address() != l && tcb.tcbtcb() != 0L) {
                    tcb = new Tcb(addressSpace, tcb.tcbtcb());
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            log.logp(Level.FINE, "com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.Tcb", "getTcbs", "Caught Exception", exception);
            return null;
        }
        tcbArray = vector.toArray(new Tcb[0]);
        addressSpace.getUserMap().put("tcbmap", tcbArray);
        ProgressMeter.set("finished getting tcbs", 50);
        return tcbArray;
    }

    public long address() {
        return this.address;
    }

    public AddressSpace space() {
        return this.space;
    }

    public Tcb(AddressSpace addressSpace, long l) {
        log.fine("creating Tcb at address " + Tcb.hex(l));
        this.space = addressSpace;
        this.address = l;
        this.inputStream = addressSpace.getImageInputStream();
        String string = addressSpace.getDump().getProductRelease();
        if (string != null) {
            this.release = Integer.parseInt(string);
        }
    }

    public long tcbcelap() throws IOException {
        return IkjtcbTemplate.getTcbcelap(this.inputStream, this.address);
    }

    public long tcbrtwa() throws IOException {
        return IkjtcbTemplate.getTcbrtwa(this.inputStream, this.address);
    }

    public long tcbcmp() throws IOException {
        return IkjtcbTemplate.getTcbcmp(this.inputStream, this.address) & 0xFFFFFFFFL;
    }

    public long tcbrbp() throws IOException {
        return IkjtcbTemplate.getTcbrbp(this.inputStream, this.address);
    }

    public long tcbstcb() throws IOException {
        return IkjtcbTemplate.getTcbstcb(this.inputStream, this.address);
    }

    public long tcbtcb() throws IOException {
        return IkjtcbTemplate.getTcbtcb(this.inputStream, this.address);
    }

    public long tcbotcb() throws IOException {
        return IhastcbTemplate.getStcbotcb(this.inputStream, this.tcbstcb());
    }

    public long tcbthli() throws IOException {
        return BpxzotcbTemplate.getOtcbthli(this.inputStream, this.tcbotcb());
    }

    public RegisterSet getRegisters() throws IOException {
        log.fine("getRegisters");
        RegisterSet registerSet = new RegisterSet();
        try {
            long l = this.address + (long)IkjtcbTemplate.getTcbgrs$offset();
            for (int i = 0; i < 16; ++i) {
                registerSet.setRegister(i, this.space.readUnsignedInt(l + (long)(i * 4)));
            }
            registerSet.setPSW(IharbTemplate.getRbopsw(this.inputStream, this.tcbrbp()));
            if (this.space.is64bit()) {
                long l2 = this.tcbstcb() + (long)IhastcbTemplate.getStcbg64h$offset();
                for (int i = 0; i < 16; ++i) {
                    long l3 = this.space.readUnsignedInt(l2 + (long)(i * 4));
                    registerSet.setRegister(i, registerSet.getRegister(i) | l3 << 32);
                }
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new Error("oops: " + exception);
        }
        return registerSet;
    }

    public RegisterSet getRegistersFromBPXGMSTA() throws IOException {
        RegisterSet registerSet;
        block20: {
            registerSet = new RegisterSet();
            try {
                long l = this.tcbrbp();
                long l2 = 0L;
                long l3 = 0L;
                long l4 = 0L;
                long l5 = 0L;
                log.fine("for tcb " + Tcb.hex(this.address) + ", rbp = " + Tcb.hex(l));
                int n = 0;
                do {
                    log.fine("currently looking at rbp 0x" + Tcb.hex(l));
                    l3 = l2;
                    l4 = l5;
                    l5 = IkjrbprefixTemplate.getRbxsb(this.inputStream, l - 64L);
                    l2 = l;
                    l = IharbTemplate.getRblinkXrblnkRblinkb(this.inputStream, l);
                    ++n;
                } while (l != this.address);
                log.fine("found " + n + " rbs");
                if (n == 1) {
                    this.getLinkageStack();
                    if (this.linkageStack.length == 0) {
                        log.fine("empty linkage stack, get registers from TCB");
                        registerSet = this.getRegisters();
                        registerSet.setWhereFound("BPXGMSTA/TCB");
                        break block20;
                    }
                    log.fine("linkageStack.length = " + this.linkageStack.length);
                    long l6 = this.tcbotcb();
                    boolean bl = false;
                    if (l6 != 0L) {
                        boolean bl2 = bl = BpxzotcbTemplate.getOtcbptregsinusta(this.inputStream, l6) != 0L;
                    }
                    if (bl && l6 != 0L) {
                        long l7 = BpxzotcbTemplate.getOtcbcofptr(this.inputStream, l6);
                        throw new Error("tbc");
                    }
                    log.fine("try first linkage stack entry");
                    Lse lse = this.linkageStack[this.linkageStack.length - 1];
                    assert (l6 != 0L);
                    long l8 = BpxzotcbTemplate.getOtcbcofptr(this.inputStream, l6);
                    long l9 = OtcbcopyonforkTemplate.getOtcbustaptr(this.inputStream, l8);
                    log.fine("lse type " + lse.lses1typ7());
                    if ((lse.lsestyp7() == 5 || lse.lses1typ7() == 13) && lse.lsestarg() < 4871L && lse.lsestarg() >= 4864L && l9 != 0L) {
                        registerSet = null;
                        break block20;
                    }
                    log.fine("try last linkage stack entry");
                    lse = this.linkageStack[0];
                    if (lse.lses1typ7() == 13 || lse.lses1typ7() == 12) {
                        registerSet.setPSW(lse.lses1pswh());
                        for (int i = 0; i < 16; ++i) {
                            registerSet.setRegister(i, lse.lses1grs(i));
                        }
                    } else {
                        registerSet.setPSW(lse.lsespsw());
                        for (int i = 0; i < 16; ++i) {
                            registerSet.setRegister(i, lse.lsesgrs(i));
                        }
                    }
                    registerSet.setWhereFound("BPXGMSTA/Linkage");
                    break block20;
                }
                long l10 = IkjrbTemplate.getRbftp(this.inputStream, l2);
                if (l10 == 0L) {
                    log.fine("BPXGMSTA/RBFTPRB");
                    registerSet.setPSW(IharbTemplate.getRbopsw(this.inputStream, l2));
                    long l11 = IharbTemplate.getRbgrsave$offset();
                    long l12 = IhaxsbTemplate.getXsbg64h$offset();
                    if (this.space.is64bit() || this.release >= 12) {
                        for (int i = 0; i < 16; ++i) {
                            long l13 = this.space.readUnsignedInt(l3 + l11 + (long)(i * 4));
                            long l14 = this.space.readUnsignedInt(l4 + l12 + (long)(i * 4));
                            registerSet.setRegister(i, l14 << 32 | l13);
                        }
                    } else {
                        for (int i = 0; i < 16; ++i) {
                            long l15 = this.space.readUnsignedInt(l3 + l11 + (long)(i * 4));
                            registerSet.setRegister(i, l15);
                        }
                    }
                    registerSet.setWhereFound("BPXGMSTA/RBFTPRB");
                    break block20;
                }
                throw new Error("tbc");
            }
            catch (IOException iOException) {
                if (!$assertionsDisabled) {
                    this.assertionsEnabled = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                log.logp(Level.FINE, "com.ibm.j9ddr.corereaders.tdump.zebedee.mvs.Tcb", "getRegistersFromBPXGMSTA", "Caught and rethrew exception", iOException);
                throw iOException;
            }
        }
        return registerSet;
    }

    public RegisterSet getRegistersFromUsta() throws IOException {
        RegisterSet registerSet = new RegisterSet();
        long l = this.tcbotcb();
        long l2 = BpxzotcbTemplate.getOtcbcofptr(this.inputStream, l);
        long l3 = OtcbcopyonforkTemplate.getOtcbustaptr(this.inputStream, l2);
        long l4 = l3 + (long)BpxzustaTemplate.getUstagrs$offset();
        long l5 = IhapsaTemplate.getFlccvt(this.inputStream, 0L);
        long l6 = CeexcvtTemplate.getCvtoslv3(this.inputStream, l5);
        if ((l6 & 2L) != 0L) {
            log.fine("new level of OS (0x" + Tcb.hex(l6) + ")");
        } else {
            log.fine("old level of OS (0x" + Tcb.hex(l6) + ") so adjust usta pointer");
            l4 -= 8L;
        }
        for (int i = 0; i < 16; ++i) {
            registerSet.setRegister(i, this.space.readUnsignedInt(l4 + (long)(i * 4)));
        }
        long l7 = l3 + (long)BpxzustaTemplate.getUstapswg$offset();
        registerSet.setPSW(this.space.readLong(l7));
        registerSet.setWhereFound("BPXGMSTA/USTA");
        return registerSet;
    }

    public Lse[] getLinkageStack() throws IOException {
        if (this.linkageStack != null) {
            return this.linkageStack;
        }
        try {
            long l = this.tcbstcb();
            long l2 = IhastcbTemplate.getStcbestk(this.inputStream, l);
            long l3 = IhastcbTemplate.getStcblsdp(this.inputStream, l);
            if (l2 == l3) {
                log.fine("linkage stack empty");
                this.linkageStack = new Lse[0];
                return this.linkageStack;
            }
            long l4 = LsedTemplate.getLsednes(this.inputStream, l2);
            if (l4 <= 0L) {
                log.fine("linkage stack empty");
                this.linkageStack = new Lse[0];
                return this.linkageStack;
            }
            assert (l4 == (long)LsestateTemplate.length() || l4 == (long)Lsestate1Template.length()) : l4;
            assert ((l3 - l2) % l4 == 0L) : (l3 - l2) % l4;
            int n = (int)((l3 - l2) / l4);
            assert (n >= 0 && n < 100) : n;
            this.linkageStack = new Lse[n];
            long l5 = l3 - l4;
            for (int i = 0; i < n; ++i) {
                this.linkageStack[i] = new Lse(this.space, l5);
                l5 -= l4;
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new Error("oops: " + exception);
        }
        return this.linkageStack;
    }

    public boolean isIFAEnabled() throws IOException {
        byte by = this.getIFAFlags();
        return (by & 0x80) == 128 || (by & 0x10) == 16;
    }

    public byte getIFAFlags() throws IOException {
        long l = this.tcbstcb();
        long l2 = IhastcbTemplate.getStcbweb(this.inputStream, l);
        return IhawebTemplate.getWebflag2(this.inputStream, l2);
    }

    public boolean equals(Object object) {
        Tcb tcb = (Tcb)object;
        return tcb.space == this.space && tcb.address == this.address;
    }

    public int hashCode() {
        return (int)this.address;
    }

    private static String hex(long l) {
        return Long.toHexString(l);
    }
}

