/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader;

import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpace;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.ProgressMeter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class SystemTrace {
    private AddressSpace space;
    private ArrayList entries = new ArrayList();
    private HashMap contextMap = new HashMap();
    private int cachedAddress;
    private Map cachedMap;
    private Properties pcDescriptions;
    private Properties svcDescriptions;
    private Properties ssrvDescriptions;
    private static int debugIndex;
    private static Logger log;
    public static final int UNKNOWN = 0;
    public static final int SSCH = 1;
    public static final int EXT = 3;
    public static final int SVC = 5;
    public static final int PGM = 7;
    public static final int SPER = 9;
    public static final int IO = 11;
    public static final int DSP = 15;
    public static final int MCH = 19;
    public static final int RST = 21;
    public static final int ACR = 23;
    public static final int SUSP = 25;
    public static final int ALTR = 27;
    public static final int RCVY = 29;
    public static final int TIME = 31;
    public static final int MSCH = 257;
    public static final int EMS = 259;
    public static final int SVCR = 261;
    public static final int SRB = 271;
    public static final int HSCH = 513;
    public static final int SS = 515;
    public static final int SSRV = 517;
    public static final int SSRB = 527;
    public static final int CSCH = 769;
    public static final int CALL = 771;
    public static final int RSCH = 1025;
    public static final int CLKC = 1027;
    public static final int SIGA = 1281;
    public static final int XSCH = 1537;
    public static final int SVCE = 3845;
    public static final int WAIT = 3855;
    public static final int USR0 = 127;
    public static final int SSAR = 16;
    public static final int PC = 33;
    public static final int PC64 = 34;
    public static final int PT = 49;
    public static final int PR = 50;
    public static final int BSG = 65;
    private static final int[] log2bytes;

    public SystemTrace(AddressSpace addressSpace) throws IOException {
        this.space = addressSpace;
        InputStream inputStream = this.getClass().getResourceAsStream("pcnumbers.properties");
        this.pcDescriptions = new Properties();
        this.pcDescriptions.load(inputStream);
        inputStream.close();
        inputStream = this.getClass().getResourceAsStream("svcnumbers.properties");
        this.svcDescriptions = new Properties();
        this.svcDescriptions.load(inputStream);
        inputStream.close();
        inputStream = this.getClass().getResourceAsStream("ssrvnumbers.properties");
        this.ssrvDescriptions = new Properties();
        this.ssrvDescriptions.load(inputStream);
        inputStream.close();
        this.readTrace();
        ProgressMeter.set("sorting trace entries", 0);
        final int n = this.entries.size() * SystemTrace.log2(this.entries.size());
        Collections.sort(this.entries, new Comparator(){
            int n;

            public int compare(Object object, Object object2) {
                if (this.n < n) {
                    ProgressMeter.set(this.n++ * 100 / n);
                }
                Entry entry = (Entry)object;
                Entry entry2 = (Entry)object2;
                if (entry.getRawTime() == entry2.getRawTime()) {
                    return entry.address - entry2.address;
                }
                return entry.getRawTime() < entry2.getRawTime() ? -1 : 1;
            }

            @Override
            public boolean equals(Object object) {
                throw new Error("oops");
            }
        });
    }

    public List getEntries() {
        return this.entries;
    }

    private boolean inDebugRange(int n) {
        return false;
    }

    private void readTrace() throws IOException {
        long l = this.space.getLowestAddress();
        int n = 0;
        try {
            n = Integer.parseInt(this.space.getDump().getProductRelease());
        }
        catch (NumberFormatException numberFormatException) {
            throw new Error("oops: " + numberFormatException);
        }
        boolean bl = n >= 9;
        int n2 = this.space.readUnsignedShort(l + 28L);
        int n3 = this.space.readInt(l + 32L);
        long l2 = n3 >> 16;
        long l3 = l2 <<= 48;
        Object var11_9 = null;
        ProgressMeter.set("reading trace entries", 0);
        for (int i = 0; i < n2; ++i) {
            if (this.inDebugRange(debugIndex)) {
                System.out.println("index " + debugIndex + " :go to proc " + i);
            }
            long l4 = l + 56L + (long)(i * (bl ? 16 : 8));
            int n4 = bl ? this.space.readInt(l4 + 8L) : this.space.readUnsignedShort(l4);
            int n5 = this.space.readUnsignedShort(l4 + 2L);
            int n6 = this.space.readInt(l4 + 4L);
            boolean bl2 = false;
            for (int j = 0; j < n4; ++j) {
                if (this.inDebugRange(debugIndex)) {
                    System.out.println("index " + debugIndex + " :go to buffer " + j);
                }
                ProgressMeter.set(i * 100 / n2 + j * (100 / n2) / n4);
                int n7 = this.space.readUnsignedShort(n6 + j * 40 + 8);
                int n8 = this.space.readInt(n6 + j * 40);
                int n9 = this.space.readInt(n6 + j * 40 + 4);
                Entry entry = null;
                Entry entry2 = null;
                ArrayList<TimelessEntry> arrayList = null;
                for (int k = n8; k < n8 + n9; k += entry.length()) {
                    Context context;
                    int n10 = this.space.readUnsignedByte(k);
                    if (this.inDebugRange(debugIndex)) {
                        System.out.println("index " + debugIndex + " :go to id " + n10);
                    }
                    if (n10 < 112 || n10 >= 128) {
                        context = this.getContext(l2, n5, 0);
                        entry = this.getTimelessEntry(context, k, entry2);
                        if (entry2 != null) {
                            this.entries.add(entry);
                            if (!this.inDebugRange(debugIndex)) continue;
                            System.out.println("index " + debugIndex + " :add to entry " + entry2.index);
                            continue;
                        }
                        if (arrayList == null) {
                            arrayList = new ArrayList<TimelessEntry>();
                        }
                        arrayList.add((TimelessEntry)entry);
                        if (!this.inDebugRange(debugIndex)) continue;
                        System.out.println("index " + debugIndex + " :orphan");
                        continue;
                    }
                    context = this.getContext(l2, n5, this.space.readUnsignedShort(k + 8));
                    entry = this.getEntry(context, k);
                    if (arrayList != null) {
                        if (this.inDebugRange(debugIndex)) {
                            System.out.println("index " + debugIndex + " :adding orphans to " + entry.index);
                        }
                        for (TimelessEntry timelessEntry : arrayList) {
                            timelessEntry.lastTimedEntry = entry;
                            this.entries.add(timelessEntry);
                        }
                        arrayList = null;
                    }
                    this.entries.add(entry);
                    entry2 = entry;
                }
            }
        }
    }

    private Entry getEntry(Context context, int n) throws IOException {
        int n2 = this.space.readUnsignedShort(n + 10);
        switch (n2) {
            case 1: {
                return new SSCH(context, n);
            }
            case 3: {
                return new EXT(context, n);
            }
            case 5: {
                return new SVC(context, n);
            }
            case 7: {
                return new PGM(context, n);
            }
            case 9: {
                return new SPER(context, n);
            }
            case 11: {
                return new IO(context, n);
            }
            case 15: {
                return new DSP(context, n);
            }
            case 19: {
                return new MCH(context, n);
            }
            case 21: {
                return new RST(context, n);
            }
            case 23: {
                return new ACR(context, n);
            }
            case 25: {
                return new SUSP(context, n);
            }
            case 27: {
                return new ALTR(context, n);
            }
            case 29: {
                return new RCVY(context, n);
            }
            case 31: {
                return new TIME(context, n);
            }
            case 257: {
                return new MSCH(context, n);
            }
            case 259: {
                return new EMS(context, n);
            }
            case 261: {
                return new SVCR(context, n);
            }
            case 271: {
                return new SRB(context, n);
            }
            case 513: {
                return new HSCH(context, n);
            }
            case 515: {
                return new SS(context, n);
            }
            case 517: {
                return new SSRV(context, n);
            }
            case 527: {
                return new SSRB(context, n);
            }
            case 769: {
                return new CSCH(context, n);
            }
            case 771: {
                return new CALL(context, n);
            }
            case 1025: {
                return new RSCH(context, n);
            }
            case 1027: {
                return new CLKC(context, n);
            }
            case 1281: {
                return new SIGA(context, n);
            }
            case 1537: {
                return new XSCH(context, n);
            }
            case 3845: {
                return new SVCE(context, n);
            }
            case 3855: {
                return new WAIT(context, n);
            }
            case 127: {
                return new USR0(context, n);
            }
        }
        log.info("Unknown entry type: " + n2);
        return new UNKNOWN(context, n);
    }

    private TimelessEntry getTimelessEntry(Context context, int n, Entry entry) throws IOException {
        switch (this.space.readUnsignedByte(n)) {
            case 16: {
                return new SSAR(context, n, entry);
            }
            case 33: {
                return new PC(context, n, entry);
            }
            case 34: {
                return new PC64(context, n, entry);
            }
            case 49: {
                return new PT(context, n, entry);
            }
            case 50: {
                return new PR(context, n, entry);
            }
            case 65: {
                return new BSG(context, n, entry);
            }
        }
        log.info("Unknown timeless entry type: " + this.space.readUnsignedByte(n));
        return new UNKNOWNT(context, n, entry);
    }

    private Context getContext(long l, int n, int n2) {
        Integer n3 = n << 16 | n2;
        Context context = (Context)this.contextMap.get(n3);
        if (context == null) {
            context = new Context(l, n, n2);
            this.contextMap.put(n3, context);
        }
        return context;
    }

    private static String hex(long l) {
        return Long.toHexString(l);
    }

    private static String hex(int n) {
        return Integer.toHexString(n);
    }

    private static String hexpad(int n) {
        return SystemTrace.hexpad(n, 8);
    }

    private static String hexpad(int n, int n2) {
        String string = Integer.toHexString(n);
        for (int i = string.length(); i < n2; ++i) {
            string = "0" + string;
        }
        return string;
    }

    private static String spacepad(String string, int n) {
        for (int i = string.length(); i < n; ++i) {
            string = " " + string;
        }
        return string;
    }

    private static String rspacepad(String string, int n) {
        for (int i = string.length(); i < n; ++i) {
            string = string + " ";
        }
        return string;
    }

    private static String hexpad(long l) {
        String string = Long.toHexString(l);
        for (int i = string.length(); i < 8; ++i) {
            string = "0" + string;
        }
        return string;
    }

    private static int log2(int n) {
        int n2 = 0;
        while ((n & 0xFFFFFF00) != 0) {
            n2 += 8;
            n >>>= 8;
        }
        return n2 + log2bytes[n];
    }

    static {
        log = Logger.getLogger("j9ddr.core_readers");
        log2bytes = new int[]{-1, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    }

    private class PT
    extends TimelessEntry {
        PT(Context context, int n, Entry entry) {
            super(context, n, entry);
        }

        @Override
        public String getIdentString() {
            return "PT";
        }

        @Override
        public int getIdent() {
            return 49;
        }

        @Override
        public String getPswString() throws IOException {
            return "  " + (SystemTrace.this.space.readUnsignedByte(this.address + 1) >> 4) + "     ";
        }

        @Override
        int addressOffset() {
            return 4;
        }

        @Override
        public String getUnique2String() throws IOException {
            return SystemTrace.hexpad(SystemTrace.this.space.readUnsignedShort(this.address + 2), 4) + "    ";
        }
    }

    private class PR
    extends TimelessEntry {
        PR(Context context, int n, Entry entry) {
            super(context, n, entry);
        }

        @Override
        public String getIdentString() {
            return "PR";
        }

        @Override
        public int getIdent() {
            return 50;
        }

        @Override
        public String getPswString() throws IOException {
            return "  " + (SystemTrace.this.space.readUnsignedByte(this.address + 1) >> 4) + "     ";
        }

        @Override
        int addressOffset() {
            return 4;
        }

        @Override
        int pasdOffset() {
            return 2;
        }

        @Override
        public String getUnique2String() throws IOException {
            if ((SystemTrace.this.space.readUnsignedByte(this.address + 1) & 2) == 2) {
                return "00_" + SystemTrace.hexpad(SystemTrace.this.space.readInt(this.address + 8));
            }
            return SystemTrace.hexpad(SystemTrace.this.space.readInt(this.address + 8) & Integer.MAX_VALUE);
        }
    }

    private class PC64
    extends TimelessEntry {
        PC64(Context context, int n, Entry entry) {
            super(context, n, entry);
        }

        @Override
        public String getIdentString() {
            return "PC";
        }

        @Override
        public int getIdent() {
            return 34;
        }

        @Override
        public String getPswString() throws IOException {
            return "  " + (SystemTrace.this.space.readUnsignedByte(this.address + 1) >> 4) + "   0 ";
        }

        @Override
        int addressOffset() {
            return 4;
        }

        @Override
        int u2Offset() {
            return 8;
        }
    }

    private class PC
    extends TimelessEntry {
        PC(Context context, int n, Entry entry) {
            super(context, n, entry);
        }

        @Override
        public String getIdentString() {
            return "PC";
        }

        @Override
        public int getIdent() {
            return 33;
        }

        @Override
        public String getPswString() throws IOException {
            return "  " + (SystemTrace.this.space.readUnsignedByte(this.address + 1) >> 4) + "     ";
        }

        @Override
        int u2Offset() {
            return 2;
        }

        @Override
        int u2Length() {
            return 2;
        }

        @Override
        int addressOffset() {
            return 4;
        }

        String pcnumber() throws IOException {
            return SystemTrace.hexpad(SystemTrace.this.space.readInt(this.address) & 0xFFFFF, 5);
        }

        @Override
        public String getUnique2String() throws IOException {
            return SystemTrace.spacepad(this.pcnumber(), 8);
        }

        @Override
        public String getDescription() throws IOException {
            return SystemTrace.this.pcDescriptions.getProperty(this.pcnumber().toUpperCase());
        }
    }

    private class BSG
    extends TimelessEntry {
        BSG(Context context, int n, Entry entry) {
            super(context, n, entry);
        }

        @Override
        public String getIdentString() {
            return "BSG";
        }

        @Override
        public int getIdent() {
            return 65;
        }

        @Override
        public String getPswString() throws IOException {
            return SystemTrace.spacepad(SystemTrace.hexpad(SystemTrace.this.space.readInt(this.address) & 0xFFFFFF, 4), 8);
        }

        @Override
        int addressOffset() {
            return 4;
        }
    }

    private class SSAR
    extends TimelessEntry {
        SSAR(Context context, int n, Entry entry) {
            super(context, n, entry);
        }

        @Override
        public String getIdentString() {
            return "SSAR";
        }

        @Override
        public int getIdent() {
            return 16;
        }

        @Override
        public String getPswString() throws IOException {
            return SystemTrace.spacepad(SystemTrace.hexpad(SystemTrace.this.space.readUnsignedShort(this.address + 2), 4), 8);
        }

        @Override
        int sasdOffset() {
            return 2;
        }
    }

    private class UNKNOWNT
    extends TimelessEntry {
        UNKNOWNT(Context context, int n, Entry entry) {
            super(context, n, entry);
        }

        @Override
        public String getIdentString() {
            return "UNKNOWN";
        }

        @Override
        public int getIdent() {
            return 0;
        }
    }

    private class SPER
    extends Entry {
        SPER(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "SPER";
        }

        @Override
        public int getIdent() {
            return 9;
        }
    }

    private class MSCH
    extends Entry {
        MSCH(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "MSCH";
        }

        @Override
        public int getIdent() {
            return 257;
        }
    }

    private class TIME
    extends Entry {
        TIME(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "TIME";
        }

        @Override
        public int getIdent() {
            return 31;
        }
    }

    private class RCVY
    extends Entry {
        RCVY(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "RCVY";
        }

        @Override
        public int getIdent() {
            return 29;
        }
    }

    private class ALTR
    extends Entry {
        ALTR(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "ALTR";
        }

        @Override
        public int getIdent() {
            return 27;
        }
    }

    private class ACR
    extends Entry {
        ACR(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "ACR";
        }

        @Override
        public int getIdent() {
            return 23;
        }
    }

    private class RST
    extends Entry {
        RST(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "RST";
        }

        @Override
        public int getIdent() {
            return 21;
        }
    }

    private class MCH
    extends Entry {
        MCH(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "MCH";
        }

        @Override
        public int getIdent() {
            return 19;
        }
    }

    private class USR0
    extends Entry {
        USR0(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "USR0";
        }

        @Override
        public int getIdent() {
            return 127;
        }
    }

    private class SVCE
    extends Entry {
        SVCE(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "SVCE";
        }

        @Override
        public int getIdent() {
            return 3845;
        }
    }

    private class XSCH
    extends Entry {
        XSCH(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "XSCH";
        }

        @Override
        public int getIdent() {
            return 1537;
        }
    }

    private class CLKC
    extends Entry {
        CLKC(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "CLKC";
        }

        @Override
        public int getIdent() {
            return 1027;
        }

        @Override
        int pswOffset() {
            return 24;
        }

        @Override
        int addressOffset() {
            return 28;
        }

        @Override
        int u1Offset() {
            return 32;
        }

        @Override
        int u2Offset() {
            return 36;
        }

        @Override
        int u3Offset() {
            return 42;
        }

        @Override
        int u3Length() {
            return 2;
        }

        @Override
        public String getUnique3String() throws IOException {
            return "    " + SystemTrace.hexpad(SystemTrace.this.space.readUnsignedShort(this.address + 42), 4);
        }

        @Override
        int clhsOffset() {
            return 44;
        }

        @Override
        int localOffset() {
            return 48;
        }

        @Override
        int clhseOffset() {
            return 52;
        }

        @Override
        int pasdOffset() {
            return 20;
        }

        @Override
        int sasdOffset() {
            return 22;
        }
    }

    private class CSCH
    extends Entry {
        CSCH(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "CSCH";
        }

        @Override
        public int getIdent() {
            return 769;
        }
    }

    private class SS
    extends Entry {
        SS(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "SS";
        }

        @Override
        public int getIdent() {
            return 515;
        }
    }

    private class HSCH
    extends Entry {
        HSCH(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "HSCH";
        }

        @Override
        public int getIdent() {
            return 513;
        }
    }

    private class WAIT
    extends Entry {
        WAIT(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "WAIT";
        }

        @Override
        public int getIdent() {
            return 3855;
        }
    }

    private class UNKNOWN
    extends Entry {
        UNKNOWN(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "UNKNOWN";
        }

        @Override
        public int getIdent() {
            return 0;
        }
    }

    private class SIGA
    extends Entry {
        SIGA(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "SIGA";
        }

        @Override
        public int getIdent() {
            return 1281;
        }

        @Override
        int codeOffset() {
            return 22;
        }

        @Override
        int pswOffset() {
            return 20;
        }

        @Override
        int pswLength() {
            return 2;
        }

        @Override
        public String getPswString() throws IOException {
            return SystemTrace.hexpad(SystemTrace.this.space.readUnsignedByte(this.address + 20) & 3, 2) + "  " + SystemTrace.hexpad(SystemTrace.this.space.readUnsignedByte(this.address + 21), 2) + "  ";
        }

        @Override
        int addressOffset() {
            return 36;
        }

        @Override
        int u1Offset() {
            return 24;
        }

        @Override
        int u2Offset() {
            return 28;
        }

        @Override
        int u3Offset() {
            return 32;
        }

        @Override
        int u4Offset() {
            return 40;
        }
    }

    private class RSCH
    extends Entry {
        RSCH(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "RSCH";
        }

        @Override
        public int getIdent() {
            return 1025;
        }

        @Override
        int codeOffset() {
            return 22;
        }

        @Override
        public String getCodeString() throws IOException {
            return SystemTrace.hexpad(SystemTrace.this.space.readUnsignedShort(this.address + 22), 5);
        }

        @Override
        int pswOffset() {
            return 20;
        }

        @Override
        int pswLength() {
            return 2;
        }

        @Override
        public String getPswString() throws IOException {
            return SystemTrace.hexpad(SystemTrace.this.space.readUnsignedByte(this.address + 20) & 3, 2) + "  " + SystemTrace.hexpad(SystemTrace.this.space.readUnsignedByte(this.address + 21), 2) + "  ";
        }

        @Override
        int addressOffset() {
            return 28;
        }

        @Override
        int u1Offset() {
            return 24;
        }
    }

    private class CALL
    extends Entry {
        CALL(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "CALL";
        }

        @Override
        public int getIdent() {
            return 771;
        }

        @Override
        int pswOffset() {
            return 24;
        }

        @Override
        int addressOffset() {
            return 28;
        }

        @Override
        int u1Offset() {
            return 32;
        }

        @Override
        int u2Offset() {
            return 36;
        }

        @Override
        int clhsOffset() {
            return 40;
        }

        @Override
        int localOffset() {
            return 44;
        }

        @Override
        int clhseOffset() {
            return 48;
        }

        @Override
        int pasdOffset() {
            return 20;
        }

        @Override
        int sasdOffset() {
            return 22;
        }
    }

    private class SSRB
    extends Entry {
        SSRB(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "SSRB";
        }

        @Override
        public int getIdent() {
            return 527;
        }

        @Override
        int pswOffset() {
            return 24;
        }

        @Override
        int addressOffset() {
            return 28;
        }

        @Override
        int u1Offset() {
            return 40;
        }

        @Override
        int u3Offset() {
            return 36;
        }

        @Override
        int u4Offset() {
            return 32;
        }

        @Override
        int clhsOffset() {
            return 17;
        }

        @Override
        int clhsLength() {
            return 1;
        }

        @Override
        public String getPsaclhsString() throws IOException {
            return SystemTrace.spacepad(SystemTrace.hexpad(SystemTrace.this.space.readUnsignedByte(this.address + 17), 2), 8);
        }

        @Override
        int localOffset() {
            return 44;
        }

        @Override
        int pasdOffset() {
            return 20;
        }

        @Override
        int sasdOffset() {
            return 22;
        }
    }

    private class SSRV
    extends Entry {
        SSRV(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "SSRV";
        }

        @Override
        public int getIdent() {
            return 517;
        }

        @Override
        int codeOffset() {
            return 16;
        }

        @Override
        int addressOffset() {
            return 20;
        }

        @Override
        int u1Offset() {
            return 24;
        }

        @Override
        int u2Offset() {
            return 28;
        }

        @Override
        int u3Offset() {
            return 32;
        }

        @Override
        int u4Offset() {
            return 36;
        }

        @Override
        public String getDescription() throws IOException {
            int n = SystemTrace.this.space.readUnsignedShort(this.address + 16);
            switch (n) {
                case 95: {
                    int n2 = SystemTrace.this.space.readInt(this.address + 28);
                    switch (n2 & 0xFF) {
                        case 3: {
                            return "Sysevent NIOWait";
                        }
                        case 4: {
                            return "Sysevent UserRdy";
                        }
                        case 12: {
                            return "Sysevent QsceSt";
                        }
                        case 13: {
                            return "Sysevent QsceCmp";
                        }
                        case 20: {
                            return "Sysevent EnqHold";
                        }
                        case 21: {
                            return "Sysevent EnqRlse";
                        }
                        case 41: {
                            return "Sysevent DontSwap";
                        }
                        case 42: {
                            return "Sysevent OkSwap";
                        }
                        case 82: {
                            return "Sysevent ReqASD";
                        }
                        case 87: {
                            return "Sysevent EncCreat";
                        }
                        case 88: {
                            return "Sysevent EncDelet";
                        }
                        case 105: {
                            return "Sysevent WlmQueue";
                        }
                        case 106: {
                            return "Sysevent EncAssoc";
                        }
                    }
                    return "Unknown r0: " + SystemTrace.hex(n2);
                }
                case 120: {
                    int n3 = SystemTrace.this.space.readInt(this.address + 24);
                    return (n3 & 1) == 1 ? "Freemain" : "Getmain";
                }
            }
            return SystemTrace.this.ssrvDescriptions.getProperty(SystemTrace.hex(n).toUpperCase());
        }
    }

    private class SVCR
    extends Entry {
        SVCR(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "SVCR";
        }

        @Override
        public int getIdent() {
            return 261;
        }

        @Override
        int codeOffset() {
            return 16;
        }

        @Override
        int pswOffset() {
            return 20;
        }

        @Override
        int addressOffset() {
            return 24;
        }

        @Override
        int u1Offset() {
            return 28;
        }

        @Override
        int u2Offset() {
            return 32;
        }

        @Override
        int u3Offset() {
            return 36;
        }
    }

    private class SRB
    extends Entry {
        SRB(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "SRB";
        }

        @Override
        public int getIdent() {
            return 271;
        }

        @Override
        int pswOffset() {
            return 20;
        }

        @Override
        int addressOffset() {
            return 24;
        }

        @Override
        int u1Offset() {
            return 28;
        }

        @Override
        int u2Offset() {
            return 32;
        }

        @Override
        int u3Offset() {
            return 36;
        }

        @Override
        int u4Offset() {
            return 40;
        }

        @Override
        int u5Offset() {
            return 16;
        }

        @Override
        int u5Length() {
            return 1;
        }

        @Override
        public String getUnique5String() throws IOException {
            return SystemTrace.rspacepad(SystemTrace.hexpad(SystemTrace.this.space.readUnsignedByte(this.address + 16), 2), 8);
        }

        @Override
        int clhsOffset() {
            return 17;
        }

        @Override
        int clhsLength() {
            return 1;
        }

        @Override
        public String getPsaclhsString() throws IOException {
            return SystemTrace.spacepad(SystemTrace.hexpad(SystemTrace.this.space.readUnsignedByte(this.address + 17), 2), 8);
        }

        @Override
        int pasdOffset() {
            return 18;
        }

        @Override
        int sasdOffset() {
            return 18;
        }
    }

    private class EMS
    extends Entry {
        EMS(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "EMS";
        }

        @Override
        public int getIdent() {
            return 259;
        }

        @Override
        int pswOffset() {
            return 24;
        }

        @Override
        int addressOffset() {
            return 28;
        }

        @Override
        int u1Offset() {
            return 32;
        }

        @Override
        int u2Offset() {
            return 36;
        }

        @Override
        int u3Offset() {
            return 40;
        }

        @Override
        int u4Offset() {
            return 44;
        }

        @Override
        int clhsOffset() {
            return 48;
        }

        @Override
        int localOffset() {
            return 52;
        }

        @Override
        int clhseOffset() {
            return 56;
        }

        @Override
        int pasdOffset() {
            return 20;
        }

        @Override
        int sasdOffset() {
            return 22;
        }
    }

    private class SUSP
    extends Entry {
        SUSP(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "SUSP";
        }

        @Override
        public int getIdent() {
            return 25;
        }

        @Override
        int addressOffset() {
            return 20;
        }

        @Override
        int u1Offset() {
            return 24;
        }

        @Override
        int u2Offset() {
            return 32;
        }

        @Override
        int u3Offset() {
            return 36;
        }

        @Override
        int u4Offset() {
            return 28;
        }

        @Override
        int clhsOffset() {
            return 40;
        }

        @Override
        int localOffset() {
            return 44;
        }

        @Override
        int clhseOffset() {
            return 48;
        }

        @Override
        public String getUnique2String() throws IOException {
            return SystemTrace.this.space.readEbcdicString(this.address + 32, 4) + "    ";
        }
    }

    private class DSP
    extends Entry {
        DSP(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "DSP";
        }

        @Override
        public int getIdent() {
            return 15;
        }

        @Override
        int pswOffset() {
            return 24;
        }

        @Override
        int addressOffset() {
            return 28;
        }

        @Override
        int u1Offset() {
            return 40;
        }

        @Override
        int u2Offset() {
            return 32;
        }

        @Override
        int u3Offset() {
            return 36;
        }

        @Override
        int clhsOffset() {
            return 44;
        }

        @Override
        int localOffset() {
            return 48;
        }

        @Override
        int pasdOffset() {
            return 20;
        }

        @Override
        int sasdOffset() {
            return 22;
        }
    }

    private class IO
    extends Entry {
        IO(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "I/O";
        }

        @Override
        public int getIdent() {
            return 11;
        }

        @Override
        int codeOffset() {
            return 16;
        }

        @Override
        public String getCodeString() throws IOException {
            int n = SystemTrace.this.space.readUnsignedShort(this.address + 16);
            int n2 = SystemTrace.this.space.readInt(this.address + 64);
            if ((n2 & 0x20000) != 0) {
                n |= 0x10000;
            }
            return SystemTrace.hexpad(n, 5);
        }

        @Override
        int pswOffset() {
            return 24;
        }

        @Override
        int addressOffset() {
            return 28;
        }

        @Override
        int u1Offset() {
            return 32;
        }

        @Override
        int u2Offset() {
            return 36;
        }

        @Override
        int u3Offset() {
            return 40;
        }

        @Override
        int u4Offset() {
            return 64;
        }

        @Override
        public String getUnique4String() throws IOException {
            int n = SystemTrace.this.space.readInt(this.address + 64);
            if ((n & 0x20000) != 0) {
                return SystemTrace.spacepad(SystemTrace.hexpad(n & 0xFFFF, 4), 8);
            }
            return null;
        }

        @Override
        int u5Offset() {
            return 48;
        }

        @Override
        int u6Offset() {
            return 44;
        }

        @Override
        int clhsOffset() {
            return 52;
        }

        @Override
        int localOffset() {
            return 56;
        }

        @Override
        int clhseOffset() {
            return 60;
        }

        @Override
        int pasdOffset() {
            return 20;
        }

        @Override
        int sasdOffset() {
            return 22;
        }
    }

    private class PGM
    extends Entry {
        PGM(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "PGM";
        }

        @Override
        public int getIdent() {
            return 7;
        }

        @Override
        int codeOffset() {
            return 46;
        }

        @Override
        public String getCodeString() throws IOException {
            return SystemTrace.hexpad(SystemTrace.this.space.readUnsignedShort(this.address + 46), 3);
        }

        @Override
        int pswOffset() {
            return 36;
        }

        @Override
        int addressOffset() {
            return 40;
        }

        @Override
        int u1Offset() {
            return 44;
        }

        @Override
        int u2Offset() {
            return 48;
        }

        @Override
        int u5Offset() {
            return 52;
        }

        @Override
        int clhsOffset() {
            return 24;
        }

        @Override
        int localOffset() {
            return 28;
        }

        @Override
        int clhseOffset() {
            return 32;
        }

        @Override
        int pasdOffset() {
            return 20;
        }

        @Override
        int sasdOffset() {
            return 22;
        }
    }

    private class SVC
    extends Entry {
        SVC(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "SVC";
        }

        @Override
        public int getIdent() {
            return 5;
        }

        @Override
        int codeOffset() {
            return 16;
        }

        @Override
        int pswOffset() {
            return 20;
        }

        @Override
        int addressOffset() {
            return 24;
        }

        @Override
        int u1Offset() {
            return 28;
        }

        @Override
        int u2Offset() {
            return 32;
        }

        @Override
        int u3Offset() {
            return 36;
        }

        @Override
        public String getDescription() throws IOException {
            int n = SystemTrace.this.space.readUnsignedShort(this.address + 16);
            int n2 = SystemTrace.this.space.readInt(this.address + 28);
            int n3 = SystemTrace.this.space.readInt(this.address + 32);
            int n4 = SystemTrace.this.space.readInt(this.address + 36);
            switch (n) {
                case 10: {
                    return n4 < 0 ? "Getmain" : "Freemain";
                }
                case 120: {
                    return (n2 & 1) == 1 ? "Freemain" : "Getmain";
                }
                case 46: {
                    if ((n4 & 8) == 0) {
                        if ((n4 & 1) == 1) {
                            return "TTimer Cancel";
                        }
                        return "TTimer Set";
                    }
                    if ((n4 & 1) == 1) {
                        return "STimerM Cancel";
                    }
                    return "STimerM";
                }
                case 47: {
                    if ((n3 & 0x4000000) == 0) {
                        return "STimer   Set";
                    }
                    return "STimerM  Set";
                }
                case 79: {
                    switch (n3 & 0xFFFF) {
                        case 1: {
                            return "MCStep Set";
                        }
                        case 3: {
                            return "NDStep Set";
                        }
                        case 4: {
                            return "NDSys Set";
                        }
                        case 5: {
                            return "NDTcb Set";
                        }
                        case 6: {
                            return "Stop  SRBs/TCBs";
                        }
                    }
                    return "Uknown";
                }
            }
            return SystemTrace.this.svcDescriptions.getProperty(SystemTrace.hex(n).toUpperCase());
        }
    }

    private class EXT
    extends Entry {
        EXT(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "EXT";
        }

        @Override
        public int getIdent() {
            return 3;
        }

        @Override
        int codeOffset() {
            return 32;
        }

        @Override
        int codeLength() {
            return 4;
        }

        @Override
        int pswOffset() {
            return 24;
        }

        @Override
        int addressOffset() {
            return 28;
        }

        @Override
        int u1Offset() {
            return 32;
        }

        @Override
        int clhsOffset() {
            return 36;
        }

        @Override
        int localOffset() {
            return 40;
        }

        @Override
        int clhseOffset() {
            return 44;
        }

        @Override
        int pasdOffset() {
            return 20;
        }

        @Override
        int sasdOffset() {
            return 22;
        }
    }

    private class SSCH
    extends Entry {
        SSCH(Context context, int n) {
            super(context, n);
        }

        @Override
        public String getIdentString() {
            return "SSCH";
        }

        @Override
        public int getIdent() {
            return 1;
        }

        @Override
        int codeOffset() {
            return 22;
        }

        @Override
        public String getCodeString() throws IOException {
            int n;
            int n2 = SystemTrace.this.space.readUnsignedShort(this.address + 22);
            if (n2 != (n = SystemTrace.this.space.readUnsignedShort(this.address + 46))) {
                n2 |= 0x10000;
            }
            return SystemTrace.hexpad(n2, 5);
        }

        @Override
        int pswOffset() {
            return 20;
        }

        @Override
        int pswLength() {
            return 2;
        }

        @Override
        public String getPswString() throws IOException {
            return SystemTrace.hexpad(SystemTrace.this.space.readUnsignedByte(this.address + 20) & 3, 2) + "  " + SystemTrace.hexpad(SystemTrace.this.space.readUnsignedByte(this.address + 21), 2) + "  ";
        }

        @Override
        int addressOffset() {
            return 40;
        }

        @Override
        int u1Offset() {
            return 24;
        }

        @Override
        int u2Offset() {
            return 28;
        }

        @Override
        int u3Offset() {
            return 32;
        }

        @Override
        int u4Offset() {
            return 46;
        }

        @Override
        int u4Length() {
            return 2;
        }

        @Override
        public String getUnique4String() throws IOException {
            int n;
            int n2 = SystemTrace.this.space.readUnsignedShort(this.address + 22);
            if (n2 != (n = SystemTrace.this.space.readUnsignedShort(this.address + 46))) {
                return SystemTrace.spacepad(SystemTrace.hexpad(n, 4), 8);
            }
            return null;
        }
    }

    private class Context {
        long tod;
        String processorId;
        String physicalProcessorId;

        Context(long l, int n, int n2) {
            this.tod = l;
            this.processorId = SystemTrace.hexpad(n, 2);
            this.physicalProcessorId = SystemTrace.hexpad(n2, 2);
        }

        String getProcessorId() {
            return this.processorId;
        }

        String getPhysicalProcessorId() {
            return this.physicalProcessorId;
        }
    }

    private abstract class TimelessEntry
    extends Entry {
        Entry lastTimedEntry;

        TimelessEntry(Context context, int n, Entry entry) {
            super(context, n);
            this.lastTimedEntry = entry;
        }

        @Override
        public int length() throws IOException {
            return ((this.getId() & 0xF) + 1) * 4;
        }

        @Override
        long getRawTime() {
            return this.lastTimedEntry.getRawTime();
        }

        @Override
        public String getTimestamp() {
            return this.lastTimedEntry.getTimestamp();
        }

        @Override
        public boolean hasTimestamp() {
            return false;
        }

        @Override
        public int getAsid() throws IOException {
            return this.lastTimedEntry.getHomeAsid();
        }

        @Override
        public String getTcbAddress() throws IOException {
            return this.lastTimedEntry.getTcbAddress();
        }

        @Override
        public String getCodeString() throws IOException {
            return " ...";
        }

        @Override
        public String getAddressString() throws IOException {
            if (this.addressOffset() == 0) {
                return null;
            }
            return SystemTrace.hex(SystemTrace.this.space.readInt(this.address + this.addressOffset()) & Integer.MAX_VALUE);
        }
    }

    public abstract class Entry {
        int address;
        Context context;
        public int index;

        Entry(Context context, int n) {
            this.address = n;
            this.context = context;
            this.index = debugIndex++;
        }

        public int getEntryAddress() {
            return this.address;
        }

        int getId() throws IOException {
            return SystemTrace.this.space.readUnsignedByte(this.address);
        }

        public int length() throws IOException {
            return 16 + (this.getId() & 0xF) * 4;
        }

        public String getProcessorId() {
            return this.context.getProcessorId();
        }

        public String getPhysicalProcessorId() {
            return this.context.getPhysicalProcessorId();
        }

        long getRawTime() {
            try {
                return SystemTrace.this.space.readLong(this.address) & 0xFFFFFFFFFFFFFFL;
            }
            catch (IOException iOException) {
                assert (false);
                return 0L;
            }
        }

        public String getTimestamp() {
            return SystemTrace.hex(this.getRawTime() | this.context.tod);
        }

        public boolean hasTimestamp() {
            return true;
        }

        int getHomeAsid() throws IOException {
            return SystemTrace.this.space.readUnsignedShort(this.address + 18);
        }

        public String getAsidString() throws IOException {
            return SystemTrace.hex(this.getAsid());
        }

        public int getAsid() throws IOException {
            int n = SystemTrace.this.space.readUnsignedShort(this.address + 10);
            if (n == 1025 || n == 1) {
                return SystemTrace.this.space.readUnsignedShort(this.address + 16);
            }
            return this.getHomeAsid();
        }

        public String getTcbAddress() throws IOException {
            return SystemTrace.hex(this.getTcb());
        }

        public int getTcb() throws IOException {
            return SystemTrace.this.space.readInt(this.address + 12);
        }

        public abstract String getIdentString();

        public abstract int getIdent();

        int codeLength() {
            return 2;
        }

        int pswLength() {
            return 4;
        }

        int u2Length() {
            return 4;
        }

        int u3Length() {
            return 4;
        }

        int u4Length() {
            return 4;
        }

        int u5Length() {
            return 4;
        }

        int clhsLength() {
            return 4;
        }

        int codeOffset() {
            return 0;
        }

        int pswOffset() {
            return 0;
        }

        int addressOffset() {
            return 0;
        }

        int u1Offset() {
            return 0;
        }

        int u2Offset() {
            return 0;
        }

        int u3Offset() {
            return 0;
        }

        int u4Offset() {
            return 0;
        }

        int u5Offset() {
            return 0;
        }

        int u6Offset() {
            return 0;
        }

        int clhsOffset() {
            return 0;
        }

        int localOffset() {
            return 0;
        }

        int clhseOffset() {
            return 0;
        }

        int pasdOffset() {
            return 0;
        }

        int sasdOffset() {
            return 0;
        }

        Integer getField(int n, int n2) throws IOException {
            if (n != 0) {
                if (n2 == 1) {
                    return SystemTrace.this.space.readUnsignedByte(this.address + n);
                }
                if (n2 == 2) {
                    return SystemTrace.this.space.readUnsignedShort(this.address + n);
                }
                return SystemTrace.this.space.readInt(this.address + n);
            }
            return null;
        }

        public int readInt(int n) throws IOException {
            return SystemTrace.this.space.readInt(this.address + n);
        }

        String getFieldString(Integer n) throws IOException {
            return n == null ? null : SystemTrace.hex(n);
        }

        public Integer getCode() throws IOException {
            return this.getField(this.codeOffset(), this.codeLength());
        }

        public String getCodeString() throws IOException {
            return this.getFieldString(this.getCode());
        }

        public Integer getPsw() throws IOException {
            return this.getField(this.pswOffset(), this.pswLength());
        }

        public String getPswString() throws IOException {
            return this.getFieldString(this.getPsw());
        }

        public Integer getAddress() throws IOException {
            return this.getField(this.addressOffset(), 4);
        }

        public String getAddressString() throws IOException {
            return this.getFieldString(this.getAddress());
        }

        public Integer getUnique1() throws IOException {
            return this.getField(this.u1Offset(), 4);
        }

        public String getUnique1String() throws IOException {
            return this.getFieldString(this.getUnique1());
        }

        public Integer getUnique2() throws IOException {
            return this.getField(this.u2Offset(), this.u2Length());
        }

        public String getUnique2String() throws IOException {
            return this.getFieldString(this.getUnique2());
        }

        public Integer getUnique3() throws IOException {
            return this.getField(this.u3Offset(), this.u3Length());
        }

        public String getUnique3String() throws IOException {
            return this.getFieldString(this.getUnique3());
        }

        public Integer getUnique4() throws IOException {
            return this.getField(this.u4Offset(), this.u4Length());
        }

        public String getUnique4String() throws IOException {
            return this.getFieldString(this.getUnique4());
        }

        public Integer getUnique5() throws IOException {
            return this.getField(this.u5Offset(), this.u5Length());
        }

        public String getUnique5String() throws IOException {
            return this.getFieldString(this.getUnique5());
        }

        public Integer getUnique6() throws IOException {
            return this.getField(this.u6Offset(), 4);
        }

        public String getUnique6String() throws IOException {
            return this.getFieldString(this.getUnique6());
        }

        public Integer getPsaclhs() throws IOException {
            return this.getField(this.clhsOffset(), this.clhsLength());
        }

        public String getPsaclhsString() throws IOException {
            return this.getFieldString(this.getPsaclhs());
        }

        public Integer getPsalocal() throws IOException {
            return this.getField(this.localOffset(), 4);
        }

        public String getPsalocalString() throws IOException {
            return this.getFieldString(this.getPsalocal());
        }

        public Integer getPsaclhse() throws IOException {
            return this.getField(this.clhseOffset(), 4);
        }

        public String getPsaclhseString() throws IOException {
            return this.getFieldString(this.getPsaclhse());
        }

        public Integer getPasd() throws IOException {
            return this.getField(this.pasdOffset(), 2);
        }

        public String getPasdString() throws IOException {
            return this.getFieldString(this.getPasd());
        }

        public Integer getSasd() throws IOException {
            return this.getField(this.sasdOffset(), 2);
        }

        public String getSasdString() throws IOException {
            return this.getFieldString(this.getSasd());
        }

        public String getDescription() throws IOException {
            return null;
        }
    }
}

