/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.macho;

import com.ibm.j9ddr.corereaders.macho.LoadCommand;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.stream.ImageInputStream;

public class SegmentCommand64
extends LoadCommand {
    public static final int VM_PROT_READ = 1;
    public static final int VM_PROT_WRITE = 2;
    public static final int VM_PROT_EXECUTE = 4;
    byte[] segmentName = new byte[16];
    long vmaddr;
    long vmsize;
    long fileOffset;
    long fileSize;
    int maxProt;
    int initialProt;
    int numSections;
    int flags;
    List<Section64> sections;

    @Override
    public SegmentCommand64 readCommand(ImageInputStream imageInputStream, long l) throws IOException {
        super.readCommand(imageInputStream, l);
        imageInputStream.readFully(this.segmentName);
        this.vmaddr = imageInputStream.readLong();
        this.vmsize = imageInputStream.readLong();
        this.fileOffset = imageInputStream.readLong();
        this.fileSize = imageInputStream.readLong();
        this.maxProt = imageInputStream.readInt();
        this.initialProt = imageInputStream.readInt();
        this.numSections = imageInputStream.readInt();
        this.flags = imageInputStream.readInt();
        this.sections = new ArrayList<Section64>(this.numSections);
        for (int i = 0; i < this.numSections; ++i) {
            Section64 section64 = new Section64();
            imageInputStream.readFully(section64.sectionName);
            imageInputStream.readFully(section64.segmentName);
            section64.address = imageInputStream.readLong();
            section64.size = imageInputStream.readLong();
            section64.fileOffset = imageInputStream.readInt();
            section64.alignment = imageInputStream.readInt();
            section64.relocOffset = imageInputStream.readInt();
            section64.numReloc = imageInputStream.readInt();
            section64.flags = imageInputStream.readInt();
            section64.reserved1 = imageInputStream.readInt();
            section64.reserved2 = imageInputStream.readInt();
            section64.reserved3 = imageInputStream.readInt();
            this.sections.add(section64);
        }
        return this;
    }

    public String getName() throws UnsupportedEncodingException {
        return SegmentCommand64.getStringFromAsciiChars(this.segmentName);
    }

    public static class Section64 {
        public static final int SECTION_TYPE = 255;
        public static final int SECTION_ATTRIBUTES = -256;
        public static final int S_REGULAR = 0;
        public static final int S_ZEROFILL = 1;
        public static final int S_CSTRING_LITERALS = 2;
        public static final int S_4BYTE_LITERALS = 3;
        public static final int S_8BYTE_LITERALS = 4;
        public static final int S_LITERAL_POINTERS = 5;
        public static final int S_NON_LAZY_SYMBOL_POINTERS = 6;
        public static final int S_LAZY_SYMBOL_POINTERS = 7;
        public static final int S_SYMBOL_STUBS = 8;
        public static final int S_MOD_INIT_FUNC_POINTERS = 9;
        public static final int S_MOD_TERM_FUNC_POINTERS = 10;
        public static final int S_COALESCED = 11;
        public static final int S_GB_ZEROFILL = 12;
        public static final int S_INTERPOSING = 13;
        public static final int S_16BYTE_LITERALS = 14;
        public static final int S_DTRACE_DOF = 15;
        public static final int S_LAZY_DYLIB_SYMBOL_POINTERS = 16;
        public static final int S_THREAD_LOCAL_REGULAR = 17;
        public static final int S_THREAD_LOCAL_ZEROFILL = 18;
        public static final int S_THREAD_LOCAL_VARIABLES = 19;
        public static final int S_THREAD_LOCAL_VARIABLE_POINTERS = 20;
        public static final int S_THREAD_LOCAL_INIT_FUNCTION_POINTERS = 21;
        public static final int SECTION_ATTRIBUTES_USR = -16777216;
        public static final int S_ATTR_PURE_INSTRUCTIONS = Integer.MIN_VALUE;
        public static final int S_ATTR_NO_TOC = 0x40000000;
        public static final int S_ATTR_STRIP_STATIC_SYMS = 0x20000000;
        public static final int S_ATTR_NO_DEAD_STRIP = 0x10000000;
        public static final int S_ATTR_LIVE_SUPPORT = 0x8000000;
        public static final int S_ATTR_SELF_MODIFYING_CODE = 0x4000000;
        public static final int S_ATTR_DEBUG = 0x2000000;
        public static final int SECTION_ATTRIBUTES_SYS = 0xFFFF00;
        public static final int S_ATTR_SOME_INSTRUCTIONS = 1024;
        public static final int S_ATTR_EXT_RELOC = 512;
        public static final int S_ATTR_LOC_RELOC = 256;
        public byte[] sectionName = new byte[16];
        public byte[] segmentName = new byte[16];
        public long address;
        public long size;
        public int fileOffset;
        public int alignment;
        public int relocOffset;
        public int numReloc;
        public int flags;
        public int reserved1;
        public int reserved2;
        public int reserved3;

        public String getSectionName() throws UnsupportedEncodingException {
            return LoadCommand.getStringFromAsciiChars(this.sectionName);
        }

        public String getSegmentName() throws UnsupportedEncodingException {
            return LoadCommand.getStringFromAsciiChars(this.segmentName);
        }
    }
}

