/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf;

import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.elf.Address;
import com.ibm.j9ddr.corereaders.elf.Address32;
import com.ibm.j9ddr.corereaders.elf.ELFFileReader;
import com.ibm.j9ddr.corereaders.elf.ELFSymbol;
import com.ibm.j9ddr.corereaders.elf.ProgramHeaderEntry;
import com.ibm.j9ddr.corereaders.elf.SectionHeaderEntry;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.stream.ImageInputStream;

public class ELF32FileReader
extends ELFFileReader {
    public ELF32FileReader(File file, ByteOrder byteOrder) throws IOException, InvalidDumpFormatException {
        super(file, byteOrder);
    }

    public ELF32FileReader(ImageInputStream imageInputStream, long l, long l2) throws IOException, InvalidDumpFormatException {
        super(imageInputStream, l, l2);
    }

    public boolean validDump(byte[] byArray, long l) {
        return 127 == byArray[0] && 69 == byArray[1] && 76 == byArray[2] && 70 == byArray[3] && 1 == byArray[4];
    }

    @Override
    protected ProgramHeaderEntry readProgramHeaderEntry() throws IOException {
        int n = this.is.readInt();
        long l = ELF32FileReader.unsigned(this.is.readInt());
        long l2 = ELF32FileReader.unsigned(this.is.readInt());
        long l3 = ELF32FileReader.unsigned(this.is.readInt());
        long l4 = ELF32FileReader.unsigned(this.is.readInt());
        long l5 = ELF32FileReader.unsigned(this.is.readInt());
        int n2 = this.is.readInt();
        long l6 = ELF32FileReader.unsigned(this.is.readInt());
        return new ProgramHeaderEntry(n, l, l4, l2, l3, l5, n2, l6, this);
    }

    private static long unsigned(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    @Override
    protected long padToWordBoundary(long l) {
        return l + 3L & 0xFFFFFFFFFFFFFFFCL;
    }

    @Override
    protected long readElfWord() throws IOException {
        return (long)this.is.readInt() & 0xFFFFFFFFL;
    }

    @Override
    protected Address readElfWordAsAddress() throws IOException {
        return new Address32(this.is.readInt());
    }

    @Override
    protected int addressSizeBits() {
        return 32;
    }

    @Override
    protected List<ELFSymbol> readSymbolsAt(SectionHeaderEntry sectionHeaderEntry) throws IOException {
        if (0L != sectionHeaderEntry.size % 16L) {
            return Collections.emptyList();
        }
        this.seek(sectionHeaderEntry.offset);
        int n = (int)Math.min(Math.abs(sectionHeaderEntry.size / 16L), 8096L);
        ArrayList<ELFSymbol> arrayList = new ArrayList<ELFSymbol>(n);
        for (long i = 0L; i < (long)n; ++i) {
            long l = (long)this.is.readInt() & 0xFFFFFFFFL;
            long l2 = (long)this.is.readInt() & 0xFFFFFFFFL;
            long l3 = (long)this.is.readInt() & 0xFFFFFFFFL;
            byte by = this.is.readByte();
            byte by2 = this.is.readByte();
            int n2 = this.is.readShort() & 0xFFFF;
            arrayList.add(new ELFSymbol(l, l2, l3, by, by2, n2));
        }
        return arrayList;
    }
}

