/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: ZipsupConstants
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class ZipsupConstants {

	// VM Constants

	public static final long SIZEOF;
	public static final long ZIP_CM_Deflated;
	public static final long ZIP_CM_Imploded;
	public static final long ZIP_CM_Reduced1;
	public static final long ZIP_CM_Reduced2;
	public static final long ZIP_CM_Reduced3;
	public static final long ZIP_CM_Reduced4;
	public static final long ZIP_CM_Shrunk;
	public static final long ZIP_CM_Stored;
	public static final long ZIP_CM_Tokenized;
	public static final long ZIP_CentralEnd;
	public static final long ZIP_CentralHeader;
	public static final long ZIP_DataDescriptor;
	public static final long ZIP_ERR_BUFFER_TOO_SMALL;
	public static final long ZIP_ERR_ENTRY_NOT_FOUND;
	public static final long ZIP_ERR_FILE_CLOSE_ERROR;
	public static final long ZIP_ERR_FILE_CORRUPT;
	public static final long ZIP_ERR_FILE_OPEN_ERROR;
	public static final long ZIP_ERR_FILE_READ_ERROR;
	public static final long ZIP_ERR_INTERNAL_ERROR;
	public static final long ZIP_ERR_NO_MORE_ENTRIES;
	public static final long ZIP_ERR_OUT_OF_MEMORY;
	public static final long ZIP_ERR_UNKNOWN_FILE_TYPE;
	public static final long ZIP_ERR_UNSUPPORTED_FILE_TYPE;
	public static final long ZIP_GZIP;
	public static final long ZIP_INTERNAL_MAX;
	public static final long ZIP_LocalHeader;
	public static final long ZIP_PKZIP;
	public static final long ZIP_Unknown;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		ZIP_CM_Deflated = 0;
		ZIP_CM_Imploded = 0;
		ZIP_CM_Reduced1 = 0;
		ZIP_CM_Reduced2 = 0;
		ZIP_CM_Reduced3 = 0;
		ZIP_CM_Reduced4 = 0;
		ZIP_CM_Shrunk = 0;
		ZIP_CM_Stored = 0;
		ZIP_CM_Tokenized = 0;
		ZIP_CentralEnd = 0;
		ZIP_CentralHeader = 0;
		ZIP_DataDescriptor = 0;
		ZIP_ERR_BUFFER_TOO_SMALL = 0;
		ZIP_ERR_ENTRY_NOT_FOUND = 0;
		ZIP_ERR_FILE_CLOSE_ERROR = 0;
		ZIP_ERR_FILE_CORRUPT = 0;
		ZIP_ERR_FILE_OPEN_ERROR = 0;
		ZIP_ERR_FILE_READ_ERROR = 0;
		ZIP_ERR_INTERNAL_ERROR = 0;
		ZIP_ERR_NO_MORE_ENTRIES = 0;
		ZIP_ERR_OUT_OF_MEMORY = 0;
		ZIP_ERR_UNKNOWN_FILE_TYPE = 0;
		ZIP_ERR_UNSUPPORTED_FILE_TYPE = 0;
		ZIP_GZIP = 0;
		ZIP_INTERNAL_MAX = 0;
		ZIP_LocalHeader = 0;
		ZIP_PKZIP = 0;
		ZIP_Unknown = 0;
	}

}
