/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: VMIZipEntry
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class VMIZipEntry {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _compressedSizeOffset_;
	public static final int _compressionMethodOffset_;
	public static final int _crc32Offset_;
	public static final int _dataOffset_;
	public static final int _dataPointerOffset_;
	public static final int _extraFieldOffset_;
	public static final int _extraFieldLengthOffset_;
	public static final int _extraFieldPointerOffset_;
	public static final int _fileCommentOffset_;
	public static final int _fileCommentLengthOffset_;
	public static final int _fileCommentPointerOffset_;
	public static final int _filenameOffset_;
	public static final int _filenameLengthOffset_;
	public static final int _filenamePointerOffset_;
	public static final int _flagsOffset_;
	public static final int _internalAttributesOffset_;
	public static final int _internalFilenameOffset_;
	public static final int _lastModDateOffset_;
	public static final int _lastModTimeOffset_;
	public static final int _uncompressedSizeOffset_;
	public static final int _versionCreatedOffset_;
	public static final int _versionNeededOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_compressedSizeOffset_ = 0;
		_compressionMethodOffset_ = 0;
		_crc32Offset_ = 0;
		_dataOffset_ = 0;
		_dataPointerOffset_ = 0;
		_extraFieldOffset_ = 0;
		_extraFieldLengthOffset_ = 0;
		_extraFieldPointerOffset_ = 0;
		_fileCommentOffset_ = 0;
		_fileCommentLengthOffset_ = 0;
		_fileCommentPointerOffset_ = 0;
		_filenameOffset_ = 0;
		_filenameLengthOffset_ = 0;
		_filenamePointerOffset_ = 0;
		_flagsOffset_ = 0;
		_internalAttributesOffset_ = 0;
		_internalFilenameOffset_ = 0;
		_lastModDateOffset_ = 0;
		_lastModTimeOffset_ = 0;
		_uncompressedSizeOffset_ = 0;
		_versionCreatedOffset_ = 0;
		_versionNeededOffset_ = 0;
	}

}
