/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: UtGlobalData
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class UtGlobalData {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _allocatedTraceBuffersOffset_;
	public static final int _bufferSizeOffset_;
	public static final int _componentListOffset_;
	public static final int _configOffset_;
	public static final int _dynamicBuffersOffset_;
	public static final int _exceptFilenameOffset_;
	public static final int _exceptTraceWrapOffset_;
	public static final int _exceptionContextOffset_;
	public static final int _exceptionTrcBufOffset_;
	public static final int _extExceptTraceOffset_;
	public static final int _externalTraceOffset_;
	public static final int _fatalassertOffset_;
	public static final int _freeQueueOffset_;
	public static final int _freeQueueLockOffset_;
	public static final int _generationCharOffset_;
	public static final int _headerOffset_;
	public static final int _ignoreOffset_;
	public static final int _indentPrintOffset_;
	public static final int _initialSuspendResumeOffset_;
	public static final int _languageIntfOffset_;
	public static final int _lastPrintOffset_;
	public static final int _lostRecordsOffset_;
	public static final int _nextGenerationOffset_;
	public static final int _outputQueueOffset_;
	public static final int _platformTraceStartedOffset_;
	public static final int _portLibraryOffset_;
	public static final int _propertiesOffset_;
	public static final int _propertyFilePathOffset_;
	public static final int _serviceInfoOffset_;
	public static final int _sleepTimeMillisOffset_;
	public static final int _snapFileOffset_;
	public static final int _snapSequenceOffset_;
	public static final int _startPlatformOffset_;
	public static final int _startSystemOffset_;
	public static final int _subscribersOffset_;
	public static final int _subscribersLockOffset_;
	public static final int _threadCountOffset_;
	public static final int _threadLockOffset_;
	public static final int _traceActiveOffset_;
	public static final int _traceCountOffset_;
	public static final int _traceDebugOffset_;
	public static final int _traceDestsOffset_;
	public static final int _traceDisableOffset_;
	public static final int _traceEnabledOffset_;
	public static final int _traceFilenameOffset_;
	public static final int _traceFinalizedOffset_;
	public static final int _traceFormatSpecOffset_;
	public static final int _traceGenerationsOffset_;
	public static final int _traceGlobalOffset_;
	public static final int _traceHeaderOffset_;
	public static final int _traceInCoreOffset_;
	public static final int _traceInitializedOffset_;
	public static final int _traceListenersOffset_;
	public static final int _traceLockOffset_;
	public static final int _tracePointSubscribersOffset_;
	public static final int _traceSnapOffset_;
	public static final int _traceSuspendOffset_;
	public static final int _traceWrapOffset_;
	public static final int _traceWriteStartedOffset_;
	public static final int _triggerOnGroupsOffset_;
	public static final int _triggerOnGroupsReferenceCountOffset_;
	public static final int _triggerOnGroupsWriteMutexOffset_;
	public static final int _triggerOnTpidsOffset_;
	public static final int _triggerOnTpidsReferenceCountOffset_;
	public static final int _triggerOnTpidsWriteMutexOffset_;
	public static final int _unloadedComponentListOffset_;
	public static final int _vmOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_allocatedTraceBuffersOffset_ = 0;
		_bufferSizeOffset_ = 0;
		_componentListOffset_ = 0;
		_configOffset_ = 0;
		_dynamicBuffersOffset_ = 0;
		_exceptFilenameOffset_ = 0;
		_exceptTraceWrapOffset_ = 0;
		_exceptionContextOffset_ = 0;
		_exceptionTrcBufOffset_ = 0;
		_extExceptTraceOffset_ = 0;
		_externalTraceOffset_ = 0;
		_fatalassertOffset_ = 0;
		_freeQueueOffset_ = 0;
		_freeQueueLockOffset_ = 0;
		_generationCharOffset_ = 0;
		_headerOffset_ = 0;
		_ignoreOffset_ = 0;
		_indentPrintOffset_ = 0;
		_initialSuspendResumeOffset_ = 0;
		_languageIntfOffset_ = 0;
		_lastPrintOffset_ = 0;
		_lostRecordsOffset_ = 0;
		_nextGenerationOffset_ = 0;
		_outputQueueOffset_ = 0;
		_platformTraceStartedOffset_ = 0;
		_portLibraryOffset_ = 0;
		_propertiesOffset_ = 0;
		_propertyFilePathOffset_ = 0;
		_serviceInfoOffset_ = 0;
		_sleepTimeMillisOffset_ = 0;
		_snapFileOffset_ = 0;
		_snapSequenceOffset_ = 0;
		_startPlatformOffset_ = 0;
		_startSystemOffset_ = 0;
		_subscribersOffset_ = 0;
		_subscribersLockOffset_ = 0;
		_threadCountOffset_ = 0;
		_threadLockOffset_ = 0;
		_traceActiveOffset_ = 0;
		_traceCountOffset_ = 0;
		_traceDebugOffset_ = 0;
		_traceDestsOffset_ = 0;
		_traceDisableOffset_ = 0;
		_traceEnabledOffset_ = 0;
		_traceFilenameOffset_ = 0;
		_traceFinalizedOffset_ = 0;
		_traceFormatSpecOffset_ = 0;
		_traceGenerationsOffset_ = 0;
		_traceGlobalOffset_ = 0;
		_traceHeaderOffset_ = 0;
		_traceInCoreOffset_ = 0;
		_traceInitializedOffset_ = 0;
		_traceListenersOffset_ = 0;
		_traceLockOffset_ = 0;
		_tracePointSubscribersOffset_ = 0;
		_traceSnapOffset_ = 0;
		_traceSuspendOffset_ = 0;
		_traceWrapOffset_ = 0;
		_traceWriteStartedOffset_ = 0;
		_triggerOnGroupsOffset_ = 0;
		_triggerOnGroupsReferenceCountOffset_ = 0;
		_triggerOnGroupsWriteMutexOffset_ = 0;
		_triggerOnTpidsOffset_ = 0;
		_triggerOnTpidsReferenceCountOffset_ = 0;
		_triggerOnTpidsWriteMutexOffset_ = 0;
		_unloadedComponentListOffset_ = 0;
		_vmOffset_ = 0;
	}

}
