/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: ThreadApiConstants
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class ThreadApiConstants {

	// VM Constants

	public static final long SIZEOF;
	public static final long GET_PROCESS_TIMES_IN_NANO;
	public static final long J9THREAD_LIB_CONTROL_USE_REALTIME_SCHEDULING_DISABLED;
	public static final long J9THREAD_LIB_CONTROL_USE_REALTIME_SCHEDULING_ENABLED;
	public static final long J9THREAD_NUMA_ERR;
	public static final long J9THREAD_NUMA_ERR_AFFINITY_NOT_SUPPORTED;
	public static final long J9THREAD_NUMA_ERR_NO_CPUS_FOR_NODE;
	public static final long J9THREAD_NUMA_OK;
	public static final long J9THREAD_NUMA_OVERRIDE_DEFAULT_AFFINITY;
	public static final long J9THREAD_RWMUTEX_FAIL;
	public static final long J9THREAD_RWMUTEX_OK;
	public static final long J9THREAD_RWMUTEX_WOULDBLOCK;
	public static final long MICRO_TO_NANO_CONVERSION_CONSTANT;
	public static final long SEC_TO_NANO_CONVERSION_CONSTANT;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		GET_PROCESS_TIMES_IN_NANO = 0;
		J9THREAD_LIB_CONTROL_USE_REALTIME_SCHEDULING_DISABLED = 0;
		J9THREAD_LIB_CONTROL_USE_REALTIME_SCHEDULING_ENABLED = 0;
		J9THREAD_NUMA_ERR = 0;
		J9THREAD_NUMA_ERR_AFFINITY_NOT_SUPPORTED = 0;
		J9THREAD_NUMA_ERR_NO_CPUS_FOR_NODE = 0;
		J9THREAD_NUMA_OK = 0;
		J9THREAD_NUMA_OVERRIDE_DEFAULT_AFFINITY = 0;
		J9THREAD_RWMUTEX_FAIL = 0;
		J9THREAD_RWMUTEX_OK = 0;
		J9THREAD_RWMUTEX_WOULDBLOCK = 0;
		MICRO_TO_NANO_CONVERSION_CONSTANT = 0;
		SEC_TO_NANO_CONVERSION_CONSTANT = 0;
	}

}
