/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: SH_Manager
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class SH_Manager {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __cacheOffset_;
	public static final int __dataTypesRepresentedOffset_;
	public static final int __hashTableOffset_;
	public static final int __hashTableGetNumItemsDoFnOffset_;
	public static final int __htEntriesOffset_;
	public static final int __htMutexOffset_;
	public static final int __htMutexNameOffset_;
	public static final int __isRunningNestedOffset_;
	public static final int __managerTypeOffset_;
	public static final int __portlibOffset_;
	public static final int __runtimeFlagsPtrOffset_;
	public static final int __stateOffset_;
	public static final int __verboseFlagsOffset_;
	public static final int __vptr$SH_ManagerOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__cacheOffset_ = 0;
		__dataTypesRepresentedOffset_ = 0;
		__hashTableOffset_ = 0;
		__hashTableGetNumItemsDoFnOffset_ = 0;
		__htEntriesOffset_ = 0;
		__htMutexOffset_ = 0;
		__htMutexNameOffset_ = 0;
		__isRunningNestedOffset_ = 0;
		__managerTypeOffset_ = 0;
		__portlibOffset_ = 0;
		__runtimeFlagsPtrOffset_ = 0;
		__stateOffset_ = 0;
		__verboseFlagsOffset_ = 0;
		__vptr$SH_ManagerOffset_ = 0;
	}

}
