/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: RastraceInternalConstants
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class RastraceInternalConstants {

	// VM Constants

	public static final long SIZEOF;
	public static final long J9RAS_APPLICATION_TRACE_BUFFER;
	public static final long UT_CONTEXT_CLASS;
	public static final long UT_CONTEXT_COMPONENT;
	public static final long UT_CONTEXT_FINAL;
	public static final long UT_CONTEXT_INITIAL;
	public static final long UT_CONTEXT_PROCESS;
	public static final long UT_COUNT;
	public static final long UT_DEBUG_EXCPT_TYPE;
	public static final long UT_DEBUG_TYPE;
	public static final long UT_ENTRY_EXCPT_TYPE;
	public static final long UT_ENTRY_TYPE;
	public static final long UT_EVENT_TYPE;
	public static final long UT_EXCEPTION;
	public static final long UT_EXCEPTION_BUFFER;
	public static final long UT_EXCEPTION_TYPE;
	public static final long UT_EXIT_EXCPT_TYPE;
	public static final long UT_EXIT_TYPE;
	public static final long UT_EXTERNAL;
	public static final long UT_FASTPATH;
	public static final long UT_LEVELMASK;
	public static final long UT_MAXIMAL;
	public static final long UT_MAX_OPTS;
	public static final long UT_MAX_TIMERS;
	public static final long UT_MAX_TYPES;
	public static final long UT_MEM_EXCPT_TYPE;
	public static final long UT_MEM_TYPE;
	public static final long UT_MINIMAL;
	public static final long UT_NONE;
	public static final long UT_NORMAL_BUFFER;
	public static final long UT_PERF_EXCPT_TYPE;
	public static final long UT_PERF_TYPE;
	public static final long UT_PLATFORM;
	public static final long UT_PRINT;
	public static final long UT_PURGE_BUFFER_TIMEOUT;
	public static final long UT_SEM_POSTED;
	public static final long UT_SEM_WAITING;
	public static final long UT_STACK_SIZE;
	public static final long UT_STRING_VALUE;
	public static final long UT_STRUCT_ALIGN;
	public static final long UT_SUBSCRIPTION_ALIVE;
	public static final long UT_SUBSCRIPTION_DEAD;
	public static final long UT_SUBSCRIPTION_KILLED;
	public static final long UT_SUSPEND_INITIALIZE;
	public static final long UT_SUSPEND_LOCKED;
	public static final long UT_SUSPEND_SNAP;
	public static final long UT_SUSPEND_TERMINATE;
	public static final long UT_SUSPEND_USER;
	public static final long UT_TCFS;
	public static final long UT_TRACE_EXTERNAL;
	public static final long UT_TRACE_INTERNAL;
	public static final long UT_TRACE_WRITE_PRIORITY;
	public static final long UT_TRC_BUFFER_ACTIVE;
	public static final long UT_TRC_BUFFER_EXTERNAL;
	public static final long UT_TRC_BUFFER_FLUSH;
	public static final long UT_TRC_BUFFER_FULL;
	public static final long UT_TRC_BUFFER_NEW;
	public static final long UT_TRC_BUFFER_PURGE;
	public static final long UT_TRC_BUFFER_SNAP;
	public static final long UT_TRC_BUFFER_WRITE;
	public static final long UT_TRC_BUFFER_WRITTEN;
	public static final long UT_TRC_SPECIAL_MASK;
	public static final long UT_TRIGGER;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		J9RAS_APPLICATION_TRACE_BUFFER = 0;
		UT_CONTEXT_CLASS = 0;
		UT_CONTEXT_COMPONENT = 0;
		UT_CONTEXT_FINAL = 0;
		UT_CONTEXT_INITIAL = 0;
		UT_CONTEXT_PROCESS = 0;
		UT_COUNT = 0;
		UT_DEBUG_EXCPT_TYPE = 0;
		UT_DEBUG_TYPE = 0;
		UT_ENTRY_EXCPT_TYPE = 0;
		UT_ENTRY_TYPE = 0;
		UT_EVENT_TYPE = 0;
		UT_EXCEPTION = 0;
		UT_EXCEPTION_BUFFER = 0;
		UT_EXCEPTION_TYPE = 0;
		UT_EXIT_EXCPT_TYPE = 0;
		UT_EXIT_TYPE = 0;
		UT_EXTERNAL = 0;
		UT_FASTPATH = 0;
		UT_LEVELMASK = 0;
		UT_MAXIMAL = 0;
		UT_MAX_OPTS = 0;
		UT_MAX_TIMERS = 0;
		UT_MAX_TYPES = 0;
		UT_MEM_EXCPT_TYPE = 0;
		UT_MEM_TYPE = 0;
		UT_MINIMAL = 0;
		UT_NONE = 0;
		UT_NORMAL_BUFFER = 0;
		UT_PERF_EXCPT_TYPE = 0;
		UT_PERF_TYPE = 0;
		UT_PLATFORM = 0;
		UT_PRINT = 0;
		UT_PURGE_BUFFER_TIMEOUT = 0;
		UT_SEM_POSTED = 0;
		UT_SEM_WAITING = 0;
		UT_STACK_SIZE = 0;
		UT_STRING_VALUE = 0;
		UT_STRUCT_ALIGN = 0;
		UT_SUBSCRIPTION_ALIVE = 0;
		UT_SUBSCRIPTION_DEAD = 0;
		UT_SUBSCRIPTION_KILLED = 0;
		UT_SUSPEND_INITIALIZE = 0;
		UT_SUSPEND_LOCKED = 0;
		UT_SUSPEND_SNAP = 0;
		UT_SUSPEND_TERMINATE = 0;
		UT_SUSPEND_USER = 0;
		UT_TCFS = 0;
		UT_TRACE_EXTERNAL = 0;
		UT_TRACE_INTERNAL = 0;
		UT_TRACE_WRITE_PRIORITY = 0;
		UT_TRC_BUFFER_ACTIVE = 0;
		UT_TRC_BUFFER_EXTERNAL = 0;
		UT_TRC_BUFFER_FLUSH = 0;
		UT_TRC_BUFFER_FULL = 0;
		UT_TRC_BUFFER_NEW = 0;
		UT_TRC_BUFFER_PURGE = 0;
		UT_TRC_BUFFER_SNAP = 0;
		UT_TRC_BUFFER_WRITE = 0;
		UT_TRC_BUFFER_WRITTEN = 0;
		UT_TRC_SPECIAL_MASK = 0;
		UT_TRIGGER = 0;
	}

}
