/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: OMR_VM
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class OMR_VM {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __arrayletLeafLogSizeOffset_;
	public static final int __arrayletLeafSizeOffset_;
	public static final int __compressObjectReferencesOffset_;
	public static final int __compressedPointersShiftOffset_;
	public static final int __configurationOffset_;
	public static final int __gcCycleOnOffset_;
	public static final int __gcCycleOnMonitorOffset_;
	public static final int __gcOmrVMExtensionsOffset_;
	public static final int __hcAgentOffset_;
	public static final int __internalThreadCountOffset_;
	public static final int __languageThreadCountOffset_;
	public static final int __language_vmOffset_;
	public static final int __linkNextOffset_;
	public static final int __linkPreviousOffset_;
	public static final int __methodDictionaryOffset_;
	public static final int __objectAlignmentInBytesOffset_;
	public static final int __objectAlignmentShiftOffset_;
	public static final int __omrTIAccessMutexOffset_;
	public static final int __runtimeOffset_;
	public static final int __sizeClassesOffset_;
	public static final int __trcEngineOffset_;
	public static final int __vmThreadKeyOffset_;
	public static final int __vmThreadListOffset_;
	public static final int __vmThreadListMutexOffset_;
	public static final int _exclusiveVMAccessStatsOffset_;
	public static final int _gcPolicyOffset_;
	public static final int _sysInfoOffset_;
	public static final int _utIntfOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__arrayletLeafLogSizeOffset_ = 0;
		__arrayletLeafSizeOffset_ = 0;
		__compressObjectReferencesOffset_ = 0;
		__compressedPointersShiftOffset_ = 0;
		__configurationOffset_ = 0;
		__gcCycleOnOffset_ = 0;
		__gcCycleOnMonitorOffset_ = 0;
		__gcOmrVMExtensionsOffset_ = 0;
		__hcAgentOffset_ = 0;
		__internalThreadCountOffset_ = 0;
		__languageThreadCountOffset_ = 0;
		__language_vmOffset_ = 0;
		__linkNextOffset_ = 0;
		__linkPreviousOffset_ = 0;
		__methodDictionaryOffset_ = 0;
		__objectAlignmentInBytesOffset_ = 0;
		__objectAlignmentShiftOffset_ = 0;
		__omrTIAccessMutexOffset_ = 0;
		__runtimeOffset_ = 0;
		__sizeClassesOffset_ = 0;
		__trcEngineOffset_ = 0;
		__vmThreadKeyOffset_ = 0;
		__vmThreadListOffset_ = 0;
		__vmThreadListMutexOffset_ = 0;
		_exclusiveVMAccessStatsOffset_ = 0;
		_gcPolicyOffset_ = 0;
		_sysInfoOffset_ = 0;
		_utIntfOffset_ = 0;
	}

}
