/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: OMRProcessorArchitecture
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class OMRProcessorArchitecture {

	// VM Constants

	public static final long SIZEOF;
	public static final long OMR_PROCESOR_RISCV32_UNKNOWN;
	public static final long OMR_PROCESOR_RISCV64_UNKNOWN;
	public static final long OMR_PROCESSOR_ARM64_FISRT;
	public static final long OMR_PROCESSOR_ARM64_LAST;
	public static final long OMR_PROCESSOR_ARM64_UNKNOWN;
	public static final long OMR_PROCESSOR_ARM64_V8_A;
	public static final long OMR_PROCESSOR_ARM_FIRST;
	public static final long OMR_PROCESSOR_ARM_LAST;
	public static final long OMR_PROCESSOR_ARM_UNKNOWN;
	public static final long OMR_PROCESSOR_ARM_V6;
	public static final long OMR_PROCESSOR_ARM_V7;
	public static final long OMR_PROCESSOR_DUMMY;
	public static final long OMR_PROCESSOR_PPC_64BIT_FIRST;
	public static final long OMR_PROCESSOR_PPC_7XX;
	public static final long OMR_PROCESSOR_PPC_82XX;
	public static final long OMR_PROCESSOR_PPC_AS_FIRST;
	public static final long OMR_PROCESSOR_PPC_ATLAS;
	public static final long OMR_PROCESSOR_PPC_BALANCED;
	public static final long OMR_PROCESSOR_PPC_CELLPX;
	public static final long OMR_PROCESSOR_PPC_FIRST;
	public static final long OMR_PROCESSOR_PPC_GP;
	public static final long OMR_PROCESSOR_PPC_GPUL;
	public static final long OMR_PROCESSOR_PPC_GR;
	public static final long OMR_PROCESSOR_PPC_HW_COPY_SIGN_FIRST;
	public static final long OMR_PROCESSOR_PPC_HW_ROUND_FIRST;
	public static final long OMR_PROCESSOR_PPC_HW_SQRT_FIRST;
	public static final long OMR_PROCESSOR_PPC_LAST;
	public static final long OMR_PROCESSOR_PPC_NSTAR;
	public static final long OMR_PROCESSOR_PPC_P10;
	public static final long OMR_PROCESSOR_PPC_P6;
	public static final long OMR_PROCESSOR_PPC_P7;
	public static final long OMR_PROCESSOR_PPC_P8;
	public static final long OMR_PROCESSOR_PPC_P9;
	public static final long OMR_PROCESSOR_PPC_PULSAR;
	public static final long OMR_PROCESSOR_PPC_PWR2S;
	public static final long OMR_PROCESSOR_PPC_PWR403;
	public static final long OMR_PROCESSOR_PPC_PWR405;
	public static final long OMR_PROCESSOR_PPC_PWR440;
	public static final long OMR_PROCESSOR_PPC_PWR601;
	public static final long OMR_PROCESSOR_PPC_PWR602;
	public static final long OMR_PROCESSOR_PPC_PWR603;
	public static final long OMR_PROCESSOR_PPC_PWR604;
	public static final long OMR_PROCESSOR_PPC_PWR620;
	public static final long OMR_PROCESSOR_PPC_PWR630;
	public static final long OMR_PROCESSOR_PPC_RIOS1;
	public static final long OMR_PROCESSOR_PPC_RIOS2;
	public static final long OMR_PROCESSOR_PPC_UNKNOWN;
	public static final long OMR_PROCESSOR_PPC_VMX_FIRST;
	public static final long OMR_PROCESSOR_PPC_VSX_FIRST;
	public static final long OMR_PROCESSOR_S390_FIRST;
	public static final long OMR_PROCESSOR_S390_LAST;
	public static final long OMR_PROCESSOR_S390_UNKNOWN;
	public static final long OMR_PROCESSOR_S390_Z10;
	public static final long OMR_PROCESSOR_S390_Z13;
	public static final long OMR_PROCESSOR_S390_Z14;
	public static final long OMR_PROCESSOR_S390_Z15;
	public static final long OMR_PROCESSOR_S390_Z196;
	public static final long OMR_PROCESSOR_S390_Z9;
	public static final long OMR_PROCESSOR_S390_Z900;
	public static final long OMR_PROCESSOR_S390_Z990;
	public static final long OMR_PROCESSOR_S390_ZEC12;
	public static final long OMR_PROCESSOR_S390_ZNEXT;
	public static final long OMR_PROCESSOR_UNDEFINED;
	public static final long OMR_PROCESSOR_X86_AMDATHLONDURON;
	public static final long OMR_PROCESSOR_X86_AMDFAMILY15H;
	public static final long OMR_PROCESSOR_X86_AMDK5;
	public static final long OMR_PROCESSOR_X86_AMDK6;
	public static final long OMR_PROCESSOR_X86_AMDOPTERON;
	public static final long OMR_PROCESSOR_X86_AMD_FIRST;
	public static final long OMR_PROCESSOR_X86_AMD_LAST;
	public static final long OMR_PROCESSOR_X86_FIRST;
	public static final long OMR_PROCESSOR_X86_INTELBROADWELL;
	public static final long OMR_PROCESSOR_X86_INTELCORE2;
	public static final long OMR_PROCESSOR_X86_INTELHASWELL;
	public static final long OMR_PROCESSOR_X86_INTELIVYBRIDGE;
	public static final long OMR_PROCESSOR_X86_INTELNEHALEM;
	public static final long OMR_PROCESSOR_X86_INTELP6;
	public static final long OMR_PROCESSOR_X86_INTELPENTIUM;
	public static final long OMR_PROCESSOR_X86_INTELPENTIUM4;
	public static final long OMR_PROCESSOR_X86_INTELSANDYBRIDGE;
	public static final long OMR_PROCESSOR_X86_INTELSKYLAKE;
	public static final long OMR_PROCESSOR_X86_INTELTULSA;
	public static final long OMR_PROCESSOR_X86_INTELWESTMERE;
	public static final long OMR_PROCESSOR_X86_INTEL_FIRST;
	public static final long OMR_PROCESSOR_X86_INTEL_LAST;
	public static final long OMR_PROCESSOR_X86_LAST;
	public static final long OMR_PROCESSOR_X86_UNKNOWN;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		OMR_PROCESOR_RISCV32_UNKNOWN = 0;
		OMR_PROCESOR_RISCV64_UNKNOWN = 0;
		OMR_PROCESSOR_ARM64_FISRT = 0;
		OMR_PROCESSOR_ARM64_LAST = 0;
		OMR_PROCESSOR_ARM64_UNKNOWN = 0;
		OMR_PROCESSOR_ARM64_V8_A = 0;
		OMR_PROCESSOR_ARM_FIRST = 0;
		OMR_PROCESSOR_ARM_LAST = 0;
		OMR_PROCESSOR_ARM_UNKNOWN = 0;
		OMR_PROCESSOR_ARM_V6 = 0;
		OMR_PROCESSOR_ARM_V7 = 0;
		OMR_PROCESSOR_DUMMY = 0;
		OMR_PROCESSOR_PPC_64BIT_FIRST = 0;
		OMR_PROCESSOR_PPC_7XX = 0;
		OMR_PROCESSOR_PPC_82XX = 0;
		OMR_PROCESSOR_PPC_AS_FIRST = 0;
		OMR_PROCESSOR_PPC_ATLAS = 0;
		OMR_PROCESSOR_PPC_BALANCED = 0;
		OMR_PROCESSOR_PPC_CELLPX = 0;
		OMR_PROCESSOR_PPC_FIRST = 0;
		OMR_PROCESSOR_PPC_GP = 0;
		OMR_PROCESSOR_PPC_GPUL = 0;
		OMR_PROCESSOR_PPC_GR = 0;
		OMR_PROCESSOR_PPC_HW_COPY_SIGN_FIRST = 0;
		OMR_PROCESSOR_PPC_HW_ROUND_FIRST = 0;
		OMR_PROCESSOR_PPC_HW_SQRT_FIRST = 0;
		OMR_PROCESSOR_PPC_LAST = 0;
		OMR_PROCESSOR_PPC_NSTAR = 0;
		OMR_PROCESSOR_PPC_P10 = 0;
		OMR_PROCESSOR_PPC_P6 = 0;
		OMR_PROCESSOR_PPC_P7 = 0;
		OMR_PROCESSOR_PPC_P8 = 0;
		OMR_PROCESSOR_PPC_P9 = 0;
		OMR_PROCESSOR_PPC_PULSAR = 0;
		OMR_PROCESSOR_PPC_PWR2S = 0;
		OMR_PROCESSOR_PPC_PWR403 = 0;
		OMR_PROCESSOR_PPC_PWR405 = 0;
		OMR_PROCESSOR_PPC_PWR440 = 0;
		OMR_PROCESSOR_PPC_PWR601 = 0;
		OMR_PROCESSOR_PPC_PWR602 = 0;
		OMR_PROCESSOR_PPC_PWR603 = 0;
		OMR_PROCESSOR_PPC_PWR604 = 0;
		OMR_PROCESSOR_PPC_PWR620 = 0;
		OMR_PROCESSOR_PPC_PWR630 = 0;
		OMR_PROCESSOR_PPC_RIOS1 = 0;
		OMR_PROCESSOR_PPC_RIOS2 = 0;
		OMR_PROCESSOR_PPC_UNKNOWN = 0;
		OMR_PROCESSOR_PPC_VMX_FIRST = 0;
		OMR_PROCESSOR_PPC_VSX_FIRST = 0;
		OMR_PROCESSOR_S390_FIRST = 0;
		OMR_PROCESSOR_S390_LAST = 0;
		OMR_PROCESSOR_S390_UNKNOWN = 0;
		OMR_PROCESSOR_S390_Z10 = 0;
		OMR_PROCESSOR_S390_Z13 = 0;
		OMR_PROCESSOR_S390_Z14 = 0;
		OMR_PROCESSOR_S390_Z15 = 0;
		OMR_PROCESSOR_S390_Z196 = 0;
		OMR_PROCESSOR_S390_Z9 = 0;
		OMR_PROCESSOR_S390_Z900 = 0;
		OMR_PROCESSOR_S390_Z990 = 0;
		OMR_PROCESSOR_S390_ZEC12 = 0;
		OMR_PROCESSOR_S390_ZNEXT = 0;
		OMR_PROCESSOR_UNDEFINED = 0;
		OMR_PROCESSOR_X86_AMDATHLONDURON = 0;
		OMR_PROCESSOR_X86_AMDFAMILY15H = 0;
		OMR_PROCESSOR_X86_AMDK5 = 0;
		OMR_PROCESSOR_X86_AMDK6 = 0;
		OMR_PROCESSOR_X86_AMDOPTERON = 0;
		OMR_PROCESSOR_X86_AMD_FIRST = 0;
		OMR_PROCESSOR_X86_AMD_LAST = 0;
		OMR_PROCESSOR_X86_FIRST = 0;
		OMR_PROCESSOR_X86_INTELBROADWELL = 0;
		OMR_PROCESSOR_X86_INTELCORE2 = 0;
		OMR_PROCESSOR_X86_INTELHASWELL = 0;
		OMR_PROCESSOR_X86_INTELIVYBRIDGE = 0;
		OMR_PROCESSOR_X86_INTELNEHALEM = 0;
		OMR_PROCESSOR_X86_INTELP6 = 0;
		OMR_PROCESSOR_X86_INTELPENTIUM = 0;
		OMR_PROCESSOR_X86_INTELPENTIUM4 = 0;
		OMR_PROCESSOR_X86_INTELSANDYBRIDGE = 0;
		OMR_PROCESSOR_X86_INTELSKYLAKE = 0;
		OMR_PROCESSOR_X86_INTELTULSA = 0;
		OMR_PROCESSOR_X86_INTELWESTMERE = 0;
		OMR_PROCESSOR_X86_INTEL_FIRST = 0;
		OMR_PROCESSOR_X86_INTEL_LAST = 0;
		OMR_PROCESSOR_X86_LAST = 0;
		OMR_PROCESSOR_X86_UNKNOWN = 0;
	}

}
