/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_HeapRegionDescriptor
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_HeapRegionDescriptor {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __headOfSpanOffset_;
	public static final int __heapRegionDescriptorExtensionOffset_;
	public static final int __highAddressOffset_;
	public static final int __isAllocatedOffset_;
	public static final int __lowAddressOffset_;
	public static final int __memoryPoolOffset_;
	public static final int __memorySubSpaceOffset_;
	public static final int __nextInSetOffset_;
	public static final int __nextRegionOffset_;
	public static final int __nextRegionInSubSpaceOffset_;
	public static final int __numaNodeOffset_;
	public static final int __previousRegionOffset_;
	public static final int __previousRegionInSubSpaceOffset_;
	public static final int __regionPropertiesOffset_;
	public static final int __regionTypeOffset_;
	public static final int __regionsInSpanOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__headOfSpanOffset_ = 0;
		__heapRegionDescriptorExtensionOffset_ = 0;
		__highAddressOffset_ = 0;
		__isAllocatedOffset_ = 0;
		__lowAddressOffset_ = 0;
		__memoryPoolOffset_ = 0;
		__memorySubSpaceOffset_ = 0;
		__nextInSetOffset_ = 0;
		__nextRegionOffset_ = 0;
		__nextRegionInSubSpaceOffset_ = 0;
		__numaNodeOffset_ = 0;
		__previousRegionOffset_ = 0;
		__previousRegionInSubSpaceOffset_ = 0;
		__regionPropertiesOffset_ = 0;
		__regionTypeOffset_ = 0;
		__regionsInSpanOffset_ = 0;
	}

}
