/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_ForwardedHeader
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_ForwardedHeader {

	// VM Constants

	public static final long SIZEOF;
	public static final long COPY_PROGRESS_INFO_MASK;
	public static final long MAX_OUTSTANDING_COPIES;
	public static final long OMR_BEING_COPIED_HINT;
	public static final long OMR_BEING_COPIED_TAG;
	public static final long OMR_FORWARDED_TAG;
	public static final long OMR_FORWARDED_TAG_MASK;
	public static final long OMR_SELF_FORWARDED_TAG;
	public static final long OUTSTANDING_COPIES_MASK;
	public static final long OUTSTANDING_COPIES_MASK_BASE;
	public static final long OUTSTANDING_COPIES_SHIFT;
	public static final long PRIMARY_BUCKET;
	public static final long REMAINING_SIZE_MASK;
	public static final long SIZE_ALIGNMENT;
	public static final long SKIP_AVAILABLE_REGION_FOR_ALLOCATION;

	// Offsets

	public static final int __compressObjectReferencesOffset_;
	public static final int __objectPtrOffset_;
	public static final int __preservedOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		COPY_PROGRESS_INFO_MASK = 0;
		MAX_OUTSTANDING_COPIES = 0;
		OMR_BEING_COPIED_HINT = 0;
		OMR_BEING_COPIED_TAG = 0;
		OMR_FORWARDED_TAG = 0;
		OMR_FORWARDED_TAG_MASK = 0;
		OMR_SELF_FORWARDED_TAG = 0;
		OUTSTANDING_COPIES_MASK = 0;
		OUTSTANDING_COPIES_MASK_BASE = 0;
		OUTSTANDING_COPIES_SHIFT = 0;
		PRIMARY_BUCKET = 0;
		REMAINING_SIZE_MASK = 0;
		SIZE_ALIGNMENT = 0;
		SKIP_AVAILABLE_REGION_FOR_ALLOCATION = 0;
		__compressObjectReferencesOffset_ = 0;
		__objectPtrOffset_ = 0;
		__preservedOffset_ = 0;
	}

}
