/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_CopyForwardScheme
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_CopyForwardScheme {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __abortFlagOffset_;
	public static final int __abortInProgressOffset_;
	public static final int __arraySplitSizeOffset_;
	public static final int __cacheFreeListOffset_;
	public static final int __cacheLineAlignmentOffset_;
	public static final int __cacheScanListsOffset_;
	public static final int __cacheTracingEnabledOffset_;
	public static final int __clearableProcessingStartedOffset_;
	public static final int __collectStringConstantsEnabledOffset_;
	public static final int __commonContextOffset_;
	public static final int __compactGroupBlockOffset_;
	public static final int __compactGroupMaxCountOffset_;
	public static final int __dispatcherOffset_;
	public static final int __doneIndexOffset_;
	public static final int __dynamicClassUnloadingEnabledOffset_;
	public static final int __extensionsOffset_;
	public static final int __failedToExpandOffset_;
	public static final int __heapBaseOffset_;
	public static final int __heapTopOffset_;
	public static final int __interRegionRememberedSetOffset_;
	public static final int __javaVMOffset_;
	public static final int __markMapOffset_;
	public static final int __maxCacheSizeOffset_;
	public static final int __minCacheSizeOffset_;
	public static final int __objectAlignmentInBytesOffset_;
	public static final int __phantomReferenceRegionsToProcessOffset_;
	public static final int __regionCountCannotBeEvacuatedOffset_;
	public static final int __regionCountReservedNonEvacuatedOffset_;
	public static final int __regionManagerOffset_;
	public static final int __regionSublistContentionThresholdOffset_;
	public static final int __reservedRegionListOffset_;
	public static final int __scanCacheListSizeOffset_;
	public static final int __scanCacheMonitorOffset_;
	public static final int __scanCacheWaitCountOffset_;
	public static final int __shouldScanFinalizableObjectsOffset_;
	public static final int __tracingEnabledOffset_;
	public static final int __workQueueMonitorPtrOffset_;
	public static final int __workQueueWaitCountPtrOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__abortFlagOffset_ = 0;
		__abortInProgressOffset_ = 0;
		__arraySplitSizeOffset_ = 0;
		__cacheFreeListOffset_ = 0;
		__cacheLineAlignmentOffset_ = 0;
		__cacheScanListsOffset_ = 0;
		__cacheTracingEnabledOffset_ = 0;
		__clearableProcessingStartedOffset_ = 0;
		__collectStringConstantsEnabledOffset_ = 0;
		__commonContextOffset_ = 0;
		__compactGroupBlockOffset_ = 0;
		__compactGroupMaxCountOffset_ = 0;
		__dispatcherOffset_ = 0;
		__doneIndexOffset_ = 0;
		__dynamicClassUnloadingEnabledOffset_ = 0;
		__extensionsOffset_ = 0;
		__failedToExpandOffset_ = 0;
		__heapBaseOffset_ = 0;
		__heapTopOffset_ = 0;
		__interRegionRememberedSetOffset_ = 0;
		__javaVMOffset_ = 0;
		__markMapOffset_ = 0;
		__maxCacheSizeOffset_ = 0;
		__minCacheSizeOffset_ = 0;
		__objectAlignmentInBytesOffset_ = 0;
		__phantomReferenceRegionsToProcessOffset_ = 0;
		__regionCountCannotBeEvacuatedOffset_ = 0;
		__regionCountReservedNonEvacuatedOffset_ = 0;
		__regionManagerOffset_ = 0;
		__regionSublistContentionThresholdOffset_ = 0;
		__reservedRegionListOffset_ = 0;
		__scanCacheListSizeOffset_ = 0;
		__scanCacheMonitorOffset_ = 0;
		__scanCacheWaitCountOffset_ = 0;
		__shouldScanFinalizableObjectsOffset_ = 0;
		__tracingEnabledOffset_ = 0;
		__workQueueMonitorPtrOffset_ = 0;
		__workQueueWaitCountPtrOffset_ = 0;
	}

}
