/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_ConcurrentGCStats
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_ConcurrentGCStats {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __RSObjectsFoundOffset_;
	public static final int __RSScanTraceCountOffset_;
	public static final int __allocationsTaxedOffset_;
	public static final int __allocationsTaxedAt0Offset_;
	public static final int __allocationsTaxedAt100Offset_;
	public static final int __allocationsTaxedAt25Offset_;
	public static final int __allocationsTaxedAt50Offset_;
	public static final int __allocationsTaxedAt75Offset_;
	public static final int __cardCleanCountOffset_;
	public static final int __cardCleaningReasonOffset_;
	public static final int __cardCleaningThresholdOffset_;
	public static final int __completeTracingCountOffset_;
	public static final int __completedModesOffset_;
	public static final int __conHelperCardCleanCountOffset_;
	public static final int __conHelperTraceSizeCountOffset_;
	public static final int __concurrentWorkStackOverflowCountOffset_;
	public static final int __concurrentWorkStackOverflowOcurredOffset_;
	public static final int __executionModeOffset_;
	public static final int __executionModeAtGCOffset_;
	public static final int __finalCardCleanCountOffset_;
	public static final int __finalTraceCountOffset_;
	public static final int __initWorkRequiredOffset_;
	public static final int __kickoffReasonOffset_;
	public static final int __kickoffThresholdOffset_;
	public static final int __remainingFreeOffset_;
	public static final int __threadsScannedCountOffset_;
	public static final int __threadsToScanCountOffset_;
	public static final int __traceSizeCountOffset_;
	public static final int __traceSizeTargetOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__RSObjectsFoundOffset_ = 0;
		__RSScanTraceCountOffset_ = 0;
		__allocationsTaxedOffset_ = 0;
		__allocationsTaxedAt0Offset_ = 0;
		__allocationsTaxedAt100Offset_ = 0;
		__allocationsTaxedAt25Offset_ = 0;
		__allocationsTaxedAt50Offset_ = 0;
		__allocationsTaxedAt75Offset_ = 0;
		__cardCleanCountOffset_ = 0;
		__cardCleaningReasonOffset_ = 0;
		__cardCleaningThresholdOffset_ = 0;
		__completeTracingCountOffset_ = 0;
		__completedModesOffset_ = 0;
		__conHelperCardCleanCountOffset_ = 0;
		__conHelperTraceSizeCountOffset_ = 0;
		__concurrentWorkStackOverflowCountOffset_ = 0;
		__concurrentWorkStackOverflowOcurredOffset_ = 0;
		__executionModeOffset_ = 0;
		__executionModeAtGCOffset_ = 0;
		__finalCardCleanCountOffset_ = 0;
		__finalTraceCountOffset_ = 0;
		__initWorkRequiredOffset_ = 0;
		__kickoffReasonOffset_ = 0;
		__kickoffThresholdOffset_ = 0;
		__remainingFreeOffset_ = 0;
		__threadsScannedCountOffset_ = 0;
		__threadsToScanCountOffset_ = 0;
		__traceSizeCountOffset_ = 0;
		__traceSizeTargetOffset_ = 0;
	}

}
