/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_CompactVLHGCStats
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_CompactVLHGCStats {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __clearMarkMapEndTimeOffset_;
	public static final int __clearMarkMapStartTimeOffset_;
	public static final int __compactPreventedReasonOffset_;
	public static final int __compactReasonOffset_;
	public static final int __endTimeOffset_;
	public static final int __finalClearNextMarkMapEndTimeOffset_;
	public static final int __finalClearNextMarkMapStartTimeOffset_;
	public static final int __fixupArrayletLeafEndTimeOffset_;
	public static final int __fixupArrayletLeafStartTimeOffset_;
	public static final int __fixupEndTimeOffset_;
	public static final int __fixupExternalPacketsEndTimeOffset_;
	public static final int __fixupExternalPacketsStartTimeOffset_;
	public static final int __fixupObjectsOffset_;
	public static final int __fixupStartTimeOffset_;
	public static final int __flushEndTimeOffset_;
	public static final int __flushStartTimeOffset_;
	public static final int __leafTaggingEndTimeOffset_;
	public static final int __leafTaggingStartTimeOffset_;
	public static final int __moveEndTimeOffset_;
	public static final int __moveStallTimeOffset_;
	public static final int __moveStartTimeOffset_;
	public static final int __movedBytesOffset_;
	public static final int __movedObjectsOffset_;
	public static final int __planningEndTimeOffset_;
	public static final int __planningStartTimeOffset_;
	public static final int __rebuildMarkBitsEndTimeOffset_;
	public static final int __rebuildMarkBitsStartTimeOffset_;
	public static final int __rebuildNextMarkMapEndTimeOffset_;
	public static final int __rebuildNextMarkMapStartTimeOffset_;
	public static final int __rebuildStallTimeOffset_;
	public static final int __recycleEndTimeOffset_;
	public static final int __recycleStartTimeOffset_;
	public static final int __regionCompactDataInitEndTimeOffset_;
	public static final int __regionCompactDataInitStartTimeOffset_;
	public static final int __rememberedSetClearingEndTimeOffset_;
	public static final int __rememberedSetClearingStartTimeOffset_;
	public static final int __reportMoveEventsEndTimeOffset_;
	public static final int __reportMoveEventsStartTimeOffset_;
	public static final int __rootFixupEndTimeOffset_;
	public static final int __rootFixupStartTimeOffset_;
	public static final int __setupEndTimeOffset_;
	public static final int __setupStartTimeOffset_;
	public static final int __startTimeOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__clearMarkMapEndTimeOffset_ = 0;
		__clearMarkMapStartTimeOffset_ = 0;
		__compactPreventedReasonOffset_ = 0;
		__compactReasonOffset_ = 0;
		__endTimeOffset_ = 0;
		__finalClearNextMarkMapEndTimeOffset_ = 0;
		__finalClearNextMarkMapStartTimeOffset_ = 0;
		__fixupArrayletLeafEndTimeOffset_ = 0;
		__fixupArrayletLeafStartTimeOffset_ = 0;
		__fixupEndTimeOffset_ = 0;
		__fixupExternalPacketsEndTimeOffset_ = 0;
		__fixupExternalPacketsStartTimeOffset_ = 0;
		__fixupObjectsOffset_ = 0;
		__fixupStartTimeOffset_ = 0;
		__flushEndTimeOffset_ = 0;
		__flushStartTimeOffset_ = 0;
		__leafTaggingEndTimeOffset_ = 0;
		__leafTaggingStartTimeOffset_ = 0;
		__moveEndTimeOffset_ = 0;
		__moveStallTimeOffset_ = 0;
		__moveStartTimeOffset_ = 0;
		__movedBytesOffset_ = 0;
		__movedObjectsOffset_ = 0;
		__planningEndTimeOffset_ = 0;
		__planningStartTimeOffset_ = 0;
		__rebuildMarkBitsEndTimeOffset_ = 0;
		__rebuildMarkBitsStartTimeOffset_ = 0;
		__rebuildNextMarkMapEndTimeOffset_ = 0;
		__rebuildNextMarkMapStartTimeOffset_ = 0;
		__rebuildStallTimeOffset_ = 0;
		__recycleEndTimeOffset_ = 0;
		__recycleStartTimeOffset_ = 0;
		__regionCompactDataInitEndTimeOffset_ = 0;
		__regionCompactDataInitStartTimeOffset_ = 0;
		__rememberedSetClearingEndTimeOffset_ = 0;
		__rememberedSetClearingStartTimeOffset_ = 0;
		__reportMoveEventsEndTimeOffset_ = 0;
		__reportMoveEventsStartTimeOffset_ = 0;
		__rootFixupEndTimeOffset_ = 0;
		__rootFixupStartTimeOffset_ = 0;
		__setupEndTimeOffset_ = 0;
		__setupStartTimeOffset_ = 0;
		__startTimeOffset_ = 0;
	}

}
