/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9SharedDataDescriptor
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9SharedDataDescriptor {

	// VM Constants

	public static final long SIZEOF;
	public static final long J9SHRDATA_ALLOCATE_ZEROD_MEMORY;
	public static final long J9SHRDATA_IS_PRIVATE;
	public static final long J9SHRDATA_NOT_INDEXED;
	public static final long J9SHRDATA_PRIVATE_TO_DIFFERENT_JVM;
	public static final long J9SHRDATA_SINGLE_STORE_FOR_KEY_TYPE;
	public static final long J9SHRDATA_SINGLE_STORE_FOR_KEY_TYPE_OVERWRITE;
	public static final long J9SHRDATA_USE_READWRITE;
	public static final long USER_SPECIFIED_CACHE_NAME_MAXLEN;

	// Offsets

	public static final int _addressOffset_;
	public static final int _flagsOffset_;
	public static final int _lengthOffset_;
	public static final int _typeOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		J9SHRDATA_ALLOCATE_ZEROD_MEMORY = 0;
		J9SHRDATA_IS_PRIVATE = 0;
		J9SHRDATA_NOT_INDEXED = 0;
		J9SHRDATA_PRIVATE_TO_DIFFERENT_JVM = 0;
		J9SHRDATA_SINGLE_STORE_FOR_KEY_TYPE = 0;
		J9SHRDATA_SINGLE_STORE_FOR_KEY_TYPE_OVERWRITE = 0;
		J9SHRDATA_USE_READWRITE = 0;
		USER_SPECIFIED_CACHE_NAME_MAXLEN = 0;
		_addressOffset_ = 0;
		_flagsOffset_ = 0;
		_lengthOffset_ = 0;
		_typeOffset_ = 0;
	}

}
