/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9ROMImageHeader
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9ROMImageHeader {

	// VM Constants

	public static final long SIZEOF;
	public static final long J9ROMIMAGEHEADER_FLAGS_BIG_ENDIAN;
	public static final long J9ROMIMAGEHEADER_FLAGS_INTERPRETABLE;
	public static final long J9ROMIMAGEHEADER_FLAGS_POSITION_INDEPENDENT;
	public static final long J9ROMIMAGEHEADER_FLAGS_REQUIRES_JCLS;
	public static final long J9ROMIMAGEHEADER_FLAGS_REQUIRES_TOOLS_EXT_DIR;

	// Offsets

	public static final int _aotPointerOffset_;
	public static final int _classCountOffset_;
	public static final int _firstClassOffset_;
	public static final int _flagsAndVersionOffset_;
	public static final int _idTagOffset_;
	public static final int _jxePointerOffset_;
	public static final int _romSizeOffset_;
	public static final int _symbolFileIDOffset_;
	public static final int _tableOfContentsOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		J9ROMIMAGEHEADER_FLAGS_BIG_ENDIAN = 0;
		J9ROMIMAGEHEADER_FLAGS_INTERPRETABLE = 0;
		J9ROMIMAGEHEADER_FLAGS_POSITION_INDEPENDENT = 0;
		J9ROMIMAGEHEADER_FLAGS_REQUIRES_JCLS = 0;
		J9ROMIMAGEHEADER_FLAGS_REQUIRES_TOOLS_EXT_DIR = 0;
		_aotPointerOffset_ = 0;
		_classCountOffset_ = 0;
		_firstClassOffset_ = 0;
		_flagsAndVersionOffset_ = 0;
		_idTagOffset_ = 0;
		_jxePointerOffset_ = 0;
		_romSizeOffset_ = 0;
		_symbolFileIDOffset_ = 0;
		_tableOfContentsOffset_ = 0;
	}

}
