/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9PortLibrary
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9PortLibrary {

	// VM Constants

	public static final long SIZEOF;
	public static final long EsIsDir;
	public static final long EsIsFile;
	public static final long EsMaxPath;
	public static final long EsOpenAppend;
	public static final long EsOpenAsynchronous;
	public static final long EsOpenCreate;
	public static final long EsOpenCreateAlways;
	public static final long EsOpenCreateNew;
	public static final long EsOpenCreateNoTag;
	public static final long EsOpenForInherit;
	public static final long EsOpenForMapping;
	public static final long EsOpenRead;
	public static final long EsOpenShareDelete;
	public static final long EsOpenSync;
	public static final long EsOpenText;
	public static final long EsOpenTruncate;
	public static final long EsOpenWrite;
	public static final long EsSeekCur;
	public static final long EsSeekEnd;
	public static final long EsSeekSet;
	public static final long FLG_ACQUIRE_LOCK_NOWAIT;
	public static final long FLG_ACQUIRE_LOCK_WAIT;
	public static final long J9GP_CONTROL;
	public static final long J9GP_CONTROL_PC;
	public static final long J9GP_FPR;
	public static final long J9GP_GPR;
	public static final long J9GP_MODULE;
	public static final long J9GP_MODULE_NAME;
	public static final long J9GP_NUM_CATEGORIES;
	public static final long J9GP_OTHER;
	public static final long J9GP_SIGNAL;
	public static final long J9GP_VALUE_16;
	public static final long J9GP_VALUE_32;
	public static final long J9GP_VALUE_64;
	public static final long J9GP_VALUE_ADDRESS;
	public static final long J9GP_VALUE_FLOAT_64;
	public static final long J9GP_VALUE_STRING;
	public static final long J9GP_VALUE_UNDEFINED;
	public static final long J9MEMTAG_EYECATCHER_ALLOC_FOOTER;
	public static final long J9MEMTAG_EYECATCHER_ALLOC_HEADER;
	public static final long J9MEMTAG_EYECATCHER_FREED_FOOTER;
	public static final long J9MEMTAG_EYECATCHER_FREED_HEADER;
	public static final long J9MEMTAG_PADDING_BYTE;
	public static final long J9MEMTAG_TAG_CORRUPTION;
	public static final long J9MEMTAG_VERSION;
	public static final long J9MEM_CATEGORIES_KEEP_ITERATING;
	public static final long J9MEM_CATEGORIES_STOP_ITERATING;
	public static final long J9NLS_BEGIN_MULTI_LINE;
	public static final long J9NLS_CONFIG;
	public static final long J9NLS_DO_NOT_APPEND_NEWLINE;
	public static final long J9NLS_DO_NOT_PRINT_MESSAGE_TAG;
	public static final long J9NLS_END_MULTI_LINE;
	public static final long J9NLS_ERROR;
	public static final long J9NLS_INFO;
	public static final long J9NLS_MULTI_LINE;
	public static final long J9NLS_STDERR;
	public static final long J9NLS_STDOUT;
	public static final long J9NLS_VITAL;
	public static final long J9NLS_WARNING;
	public static final long J9OSDUMP_EYECATCHER;
	public static final long J9OSDUMP_SIZE;
	public static final long J9PORT_CACHEINFO_DCACHE;
	public static final long J9PORT_CACHEINFO_ICACHE;
	public static final long J9PORT_CACHEINFO_TCACHE;
	public static final long J9PORT_CACHEINFO_UCACHE;
	public static final long J9PORT_CAPABILITY_ALLOCATE_TOP_DOWN;
	public static final long J9PORT_CAPABILITY_BASE;
	public static final long J9PORT_CAPABILITY_CAN_RESERVE_SPECIFIC_ADDRESS;
	public static final long J9PORT_CAPABILITY_MASK_TOP_DOWN;
	public static final long J9PORT_CAPABILITY_STANDARD;
	public static final long J9PORT_CPU_BOUND;
	public static final long J9PORT_CPU_ONLINE;
	public static final long J9PORT_CPU_PHYSICAL;
	public static final long J9PORT_CPU_TARGET;
	public static final long J9PORT_DISABLE_ENSURE_CAP32;
	public static final long J9PORT_ERROR_BADF;
	public static final long J9PORT_ERROR_FILE_EXIST;
	public static final long J9PORT_ERROR_FILE_FSTAT_FAILED;
	public static final long J9PORT_ERROR_FILE_LOCK_BADLOCK;
	public static final long J9PORT_ERROR_FILE_LOCK_EDEADLK;
	public static final long J9PORT_ERROR_FILE_NAMETOOLONG;
	public static final long J9PORT_ERROR_FILE_NOENT;
	public static final long J9PORT_ERROR_FILE_NOPERMISSION;
	public static final long J9PORT_ERROR_FILE_NOTFOUND;
	public static final long J9PORT_ERROR_FILE_OPFAILED;
	public static final long J9PORT_ERROR_FILE_SYSTEMFULL;
	public static final long J9PORT_ERROR_INVALID_ARGUMENTS;
	public static final long J9PORT_ERROR_INVALID_HANDLE;
	public static final long J9PORT_ERROR_NOTFOUND;
	public static final long J9PORT_ERROR_NOT_SUPPORTED_ON_THIS_PLATFORM;
	public static final long J9PORT_ERROR_OPFAILED;
	public static final long J9PORT_ERROR_STARTUP_MEM;
	public static final long J9PORT_ERROR_STARTUP_TLS_ALLOC;
	public static final long J9PORT_ERROR_STRING_BUFFER_TOO_SMALL;
	public static final long J9PORT_ERROR_STRING_ICONV_OPEN_FAILED;
	public static final long J9PORT_ERROR_STRING_ILLEGAL_STRING;
	public static final long J9PORT_ERROR_STRING_MEM_ALLOCATE_FAILED;
	public static final long J9PORT_ERROR_STRING_UNSUPPORTED_ENCODING;
	public static final long J9PORT_ERROR_SYSINFO_ENV_INIT_CRASHED_COPYING_BUFFER;
	public static final long J9PORT_ERROR_SYSINFO_INSUFFICIENT_PRIVILEGE;
	public static final long J9PORT_ERROR_SYSINFO_MEMORY_ALLOC_FAILED;
	public static final long J9PORT_ERROR_SYSINFO_NOT_SUPPORTED;
	public static final long J9PORT_ERROR_SYSINFO_OPFAILED;
	public static final long J9PORT_ERROR_SYSTEM_CALL_CODE_SHIFT;
	public static final long J9PORT_ERROR_SYSTEM_CALL_ERRNO_MASK;
	public static final long J9PORT_ERROR_VMEM_INSUFFICENT_RESOURCES;
	public static final long J9PORT_FILE_IGNORE_ID;
	public static final long J9PORT_FILE_NOWAIT_FOR_LOCK;
	public static final long J9PORT_FILE_READ_LOCK;
	public static final long J9PORT_FILE_WAIT_FOR_LOCK;
	public static final long J9PORT_FILE_WRITE_LOCK;
	public static final long J9PORT_HWCAP_S390_DFP;
	public static final long J9PORT_HWCAP_S390_EIMM;
	public static final long J9PORT_HWCAP_S390_ESAN3;
	public static final long J9PORT_HWCAP_S390_ETF3EH;
	public static final long J9PORT_HWCAP_S390_GS;
	public static final long J9PORT_HWCAP_S390_HIGH_GPRS;
	public static final long J9PORT_HWCAP_S390_HPAGE;
	public static final long J9PORT_HWCAP_S390_LDISP;
	public static final long J9PORT_HWCAP_S390_MSA;
	public static final long J9PORT_HWCAP_S390_STFLE;
	public static final long J9PORT_HWCAP_S390_TE;
	public static final long J9PORT_HWCAP_S390_VXRS;
	public static final long J9PORT_HWCAP_S390_VXRS_BCD;
	public static final long J9PORT_HWCAP_S390_VXRS_EXT;
	public static final long J9PORT_HWCAP_S390_ZARCH;
	public static final long J9PORT_INFO_CONTROL_FILE_NOT_UNLINKED;
	public static final long J9PORT_INFO_CONTROL_FILE_UNLINKED;
	public static final long J9PORT_INFO_CONTROL_FILE_UNLINK_FAILED;
	public static final long J9PORT_INFO_SHMEM_BASE;
	public static final long J9PORT_INFO_SHMEM_CREATED;
	public static final long J9PORT_INFO_SHMEM_OPENED;
	public static final long J9PORT_INFO_SHMEM_OPENED_STALE;
	public static final long J9PORT_INFO_SHMEM_OPEN_UNLINKED;
	public static final long J9PORT_INFO_SHMEM_PARTIAL;
	public static final long J9PORT_INFO_SHMEM_STAT_PASSED;
	public static final long J9PORT_INFO_SHSEM_BASE;
	public static final long J9PORT_INFO_SHSEM_CREATED;
	public static final long J9PORT_INFO_SHSEM_OPENED;
	public static final long J9PORT_INFO_SHSEM_OPENED_STALE;
	public static final long J9PORT_INFO_SHSEM_OPEN_UNLINKED;
	public static final long J9PORT_INFO_SHSEM_PARTIAL;
	public static final long J9PORT_INFO_SHSEM_STAT_PASSED;
	public static final long J9PORT_INVALID_FD;
	public static final long J9PORT_LIMIT_HARD;
	public static final long J9PORT_LIMIT_LIMITED;
	public static final long J9PORT_LIMIT_UNLIMITED;
	public static final long J9PORT_MAJOR_VERSION_NUMBER;
	public static final long J9PORT_MEMINFO_NOT_AVAILABLE;
	public static final long J9PORT_MINOR_VERSION_NUMBER;
	public static final long J9PORT_MMAP_CAPABILITY_COPYONWRITE;
	public static final long J9PORT_MMAP_CAPABILITY_MSYNC;
	public static final long J9PORT_MMAP_CAPABILITY_PROTECT;
	public static final long J9PORT_MMAP_CAPABILITY_READ;
	public static final long J9PORT_MMAP_CAPABILITY_WRITE;
	public static final long J9PORT_MMAP_FLAG_COPYONWRITE;
	public static final long J9PORT_MMAP_FLAG_READ;
	public static final long J9PORT_MMAP_FLAG_SHARED;
	public static final long J9PORT_MMAP_FLAG_WRITE;
	public static final long J9PORT_MMAP_SYNC_WAIT;
	public static final long J9PORT_PAGE_PROTECT_NOT_SUPPORTED;
	public static final long J9PORT_PAGE_PROTECT_READ;
	public static final long J9PORT_PAGE_PROTECT_WRITE;
	public static final long J9PORT_PPC_FEATURE_32;
	public static final long J9PORT_PPC_FEATURE_601_INSTR;
	public static final long J9PORT_PPC_FEATURE_64;
	public static final long J9PORT_PPC_FEATURE_ARCH_2_05;
	public static final long J9PORT_PPC_FEATURE_ARCH_2_06;
	public static final long J9PORT_PPC_FEATURE_ARCH_2_07;
	public static final long J9PORT_PPC_FEATURE_BOOKE;
	public static final long J9PORT_PPC_FEATURE_CELL_BE;
	public static final long J9PORT_PPC_FEATURE_DSCR;
	public static final long J9PORT_PPC_FEATURE_EBB;
	public static final long J9PORT_PPC_FEATURE_HAS_4xxMAC;
	public static final long J9PORT_PPC_FEATURE_HAS_ALTIVEC;
	public static final long J9PORT_PPC_FEATURE_HAS_DFP;
	public static final long J9PORT_PPC_FEATURE_HAS_EFP_DOUBLE;
	public static final long J9PORT_PPC_FEATURE_HAS_EFP_SINGLE;
	public static final long J9PORT_PPC_FEATURE_HAS_FPU;
	public static final long J9PORT_PPC_FEATURE_HAS_MMU;
	public static final long J9PORT_PPC_FEATURE_HAS_SPE;
	public static final long J9PORT_PPC_FEATURE_HAS_VSX;
	public static final long J9PORT_PPC_FEATURE_HTM;
	public static final long J9PORT_PPC_FEATURE_ICACHE_SNOOP;
	public static final long J9PORT_PPC_FEATURE_ISEL;
	public static final long J9PORT_PPC_FEATURE_NO_TB;
	public static final long J9PORT_PPC_FEATURE_PA6T;
	public static final long J9PORT_PPC_FEATURE_POWER4;
	public static final long J9PORT_PPC_FEATURE_POWER5;
	public static final long J9PORT_PPC_FEATURE_POWER5_PLUS;
	public static final long J9PORT_PPC_FEATURE_POWER6_EXT;
	public static final long J9PORT_PPC_FEATURE_PPC_LE;
	public static final long J9PORT_PPC_FEATURE_PSERIES_PERFMON_COMPAT;
	public static final long J9PORT_PPC_FEATURE_SMT;
	public static final long J9PORT_PPC_FEATURE_TAR;
	public static final long J9PORT_PPC_FEATURE_TRUE_LE;
	public static final long J9PORT_PPC_FEATURE_UNIFIED_CACHE;
	public static final long J9PORT_PROCESS_CREATE_NEW_PROCESS_GROUP;
	public static final long J9PORT_PROCESS_DO_NOT_CLOSE_STREAMS;
	public static final long J9PORT_PROCESS_IGNORE_OUTPUT;
	public static final long J9PORT_PROCESS_INHERIT_STDERR;
	public static final long J9PORT_PROCESS_INHERIT_STDIN;
	public static final long J9PORT_PROCESS_INHERIT_STDOUT;
	public static final long J9PORT_PROCESS_NONBLOCKING_IO;
	public static final long J9PORT_PROCESS_PIPE_TO_PARENT;
	public static final long J9PORT_PROCESS_REDIRECT_STDERR_TO_STDOUT;
	public static final long J9PORT_PROCESS_STDERR;
	public static final long J9PORT_PROCESS_STDIN;
	public static final long J9PORT_PROCESS_STDOUT;
	public static final long J9PORT_PROCINFO_NOT_AVAILABLE;
	public static final long J9PORT_PROCINFO_PROC_ONLINE;
	public static final long J9PORT_RESOURCE_ADDRESS_SPACE;
	public static final long J9PORT_RESOURCE_CORE_FILE;
	public static final long J9PORT_RESOURCE_CORE_FLAGS;
	public static final long J9PORT_RESOURCE_FILE_DESCRIPTORS;
	public static final long J9PORT_RESOURCE_SHARED_MEMORY;
	public static final long J9PORT_S390_FEATURE_COMPARE_AND_SWAP_AND_STORE;
	public static final long J9PORT_S390_FEATURE_COMPARE_AND_SWAP_AND_STORE2;
	public static final long J9PORT_S390_FEATURE_DFP;
	public static final long J9PORT_S390_FEATURE_ESAN3;
	public static final long J9PORT_S390_FEATURE_ETF3_ENHANCEMENT;
	public static final long J9PORT_S390_FEATURE_EXECUTE_EXTENSIONS;
	public static final long J9PORT_S390_FEATURE_EXTENDED_IMMEDIATE;
	public static final long J9PORT_S390_FEATURE_EXTENDED_TRANSLATION_3;
	public static final long J9PORT_S390_FEATURE_FPE;
	public static final long J9PORT_S390_FEATURE_GENERAL_INSTRUCTIONS_EXTENSIONS;
	public static final long J9PORT_S390_FEATURE_GUARDED_STORAGE;
	public static final long J9PORT_S390_FEATURE_HIGH_WORD;
	public static final long J9PORT_S390_FEATURE_HPAGE;
	public static final long J9PORT_S390_FEATURE_LOAD_AND_ZERO_RIGHTMOST_BYTE;
	public static final long J9PORT_S390_FEATURE_LOAD_STORE_ON_CONDITION_1;
	public static final long J9PORT_S390_FEATURE_LOAD_STORE_ON_CONDITION_2;
	public static final long J9PORT_S390_FEATURE_LONG_DISPLACEMENT;
	public static final long J9PORT_S390_FEATURE_MISCELLANEOUS_INSTRUCTION_EXTENSION;
	public static final long J9PORT_S390_FEATURE_MISCELLANEOUS_INSTRUCTION_EXTENSION_2;
	public static final long J9PORT_S390_FEATURE_MISCELLANEOUS_INSTRUCTION_EXTENSION_3;
	public static final long J9PORT_S390_FEATURE_MSA;
	public static final long J9PORT_S390_FEATURE_MSA_EXTENSION3;
	public static final long J9PORT_S390_FEATURE_MSA_EXTENSION4;
	public static final long J9PORT_S390_FEATURE_MSA_EXTENSION_5;
	public static final long J9PORT_S390_FEATURE_MSA_EXTENSION_8;
	public static final long J9PORT_S390_FEATURE_RI;
	public static final long J9PORT_S390_FEATURE_SEMAPHORE_ASSIST;
	public static final long J9PORT_S390_FEATURE_SIDE_EFFECT_ACCESS;
	public static final long J9PORT_S390_FEATURE_STFLE;
	public static final long J9PORT_S390_FEATURE_TE;
	public static final long J9PORT_S390_FEATURE_VECTOR_FACILITY;
	public static final long J9PORT_S390_FEATURE_VECTOR_FACILITY_ENHANCEMENT_1;
	public static final long J9PORT_S390_FEATURE_VECTOR_FACILITY_ENHANCEMENT_2;
	public static final long J9PORT_S390_FEATURE_VECTOR_PACKED_DECIMAL;
	public static final long J9PORT_S390_FEATURE_VECTOR_PACKED_DECIMAL_ENHANCEMENT_FACILITY;
	public static final long J9PORT_S390_FEATURE_ZARCH;
	public static final long J9PORT_SHMEM_EYECATCHER_LENGTH;
	public static final long J9PORT_SHSEM_MODE_DEFAULT;
	public static final long J9PORT_SHSEM_MODE_NOWAIT;
	public static final long J9PORT_SHSEM_MODE_UNDO;
	public static final long J9PORT_SIG_CONTROL;
	public static final long J9PORT_SIG_CONTROL_BP;
	public static final long J9PORT_SIG_CONTROL_PC;
	public static final long J9PORT_SIG_CONTROL_POWERPC_CR;
	public static final long J9PORT_SIG_CONTROL_POWERPC_CTR;
	public static final long J9PORT_SIG_CONTROL_POWERPC_DAR;
	public static final long J9PORT_SIG_CONTROL_POWERPC_DSIR;
	public static final long J9PORT_SIG_CONTROL_POWERPC_FPSCR;
	public static final long J9PORT_SIG_CONTROL_POWERPC_LR;
	public static final long J9PORT_SIG_CONTROL_POWERPC_MQ;
	public static final long J9PORT_SIG_CONTROL_POWERPC_MSR;
	public static final long J9PORT_SIG_CONTROL_POWERPC_XER;
	public static final long J9PORT_SIG_CONTROL_S390_BEA;
	public static final long J9PORT_SIG_CONTROL_S390_FPC;
	public static final long J9PORT_SIG_CONTROL_S390_GPR7;
	public static final long J9PORT_SIG_CONTROL_SP;
	public static final long J9PORT_SIG_CONTROL_X86_EFLAGS;
	public static final long J9PORT_SIG_ERROR;
	public static final long J9PORT_SIG_EXCEPTION_CONTINUE_EXECUTION;
	public static final long J9PORT_SIG_EXCEPTION_CONTINUE_SEARCH;
	public static final long J9PORT_SIG_EXCEPTION_COOPERATIVE_SHUTDOWN;
	public static final long J9PORT_SIG_EXCEPTION_OCCURRED;
	public static final long J9PORT_SIG_EXCEPTION_RETURN;
	public static final long J9PORT_SIG_FLAG_MAY_CONTINUE_EXECUTION;
	public static final long J9PORT_SIG_FLAG_MAY_RETURN;
	public static final long J9PORT_SIG_FLAG_SIGABEND;
	public static final long J9PORT_SIG_FLAG_SIGABRT;
	public static final long J9PORT_SIG_FLAG_SIGALLSYNC;
	public static final long J9PORT_SIG_FLAG_SIGBUS;
	public static final long J9PORT_SIG_FLAG_SIGFPE;
	public static final long J9PORT_SIG_FLAG_SIGFPE_DIV_BY_ZERO;
	public static final long J9PORT_SIG_FLAG_SIGFPE_INT_DIV_BY_ZERO;
	public static final long J9PORT_SIG_FLAG_SIGFPE_INT_OVERFLOW;
	public static final long J9PORT_SIG_FLAG_SIGILL;
	public static final long J9PORT_SIG_FLAG_SIGINT;
	public static final long J9PORT_SIG_FLAG_SIGQUIT;
	public static final long J9PORT_SIG_FLAG_SIGRECONFIG;
	public static final long J9PORT_SIG_FLAG_SIGSEGV;
	public static final long J9PORT_SIG_FLAG_SIGTERM;
	public static final long J9PORT_SIG_FLAG_SIGTRAP;
	public static final long J9PORT_SIG_FLAG_SIGXFSZ;
	public static final long J9PORT_SIG_FPR;
	public static final long J9PORT_SIG_GPR;
	public static final long J9PORT_SIG_GPR_AMD64_R10;
	public static final long J9PORT_SIG_GPR_AMD64_R11;
	public static final long J9PORT_SIG_GPR_AMD64_R12;
	public static final long J9PORT_SIG_GPR_AMD64_R13;
	public static final long J9PORT_SIG_GPR_AMD64_R14;
	public static final long J9PORT_SIG_GPR_AMD64_R15;
	public static final long J9PORT_SIG_GPR_AMD64_R8;
	public static final long J9PORT_SIG_GPR_AMD64_R9;
	public static final long J9PORT_SIG_GPR_AMD64_RAX;
	public static final long J9PORT_SIG_GPR_AMD64_RBX;
	public static final long J9PORT_SIG_GPR_AMD64_RCX;
	public static final long J9PORT_SIG_GPR_AMD64_RDI;
	public static final long J9PORT_SIG_GPR_AMD64_RDX;
	public static final long J9PORT_SIG_GPR_AMD64_RSI;
	public static final long J9PORT_SIG_GPR_ARM_R0;
	public static final long J9PORT_SIG_GPR_ARM_R1;
	public static final long J9PORT_SIG_GPR_ARM_R10;
	public static final long J9PORT_SIG_GPR_ARM_R2;
	public static final long J9PORT_SIG_GPR_ARM_R3;
	public static final long J9PORT_SIG_GPR_ARM_R4;
	public static final long J9PORT_SIG_GPR_ARM_R5;
	public static final long J9PORT_SIG_GPR_ARM_R6;
	public static final long J9PORT_SIG_GPR_ARM_R7;
	public static final long J9PORT_SIG_GPR_ARM_R8;
	public static final long J9PORT_SIG_GPR_ARM_R9;
	public static final long J9PORT_SIG_GPR_X86_EAX;
	public static final long J9PORT_SIG_GPR_X86_EBX;
	public static final long J9PORT_SIG_GPR_X86_ECX;
	public static final long J9PORT_SIG_GPR_X86_EDI;
	public static final long J9PORT_SIG_GPR_X86_EDX;
	public static final long J9PORT_SIG_GPR_X86_ESI;
	public static final long J9PORT_SIG_MODULE;
	public static final long J9PORT_SIG_MODULE_NAME;
	public static final long J9PORT_SIG_NO_EXCEPTION;
	public static final long J9PORT_SIG_NUM_CATEGORIES;
	public static final long J9PORT_SIG_OPTIONS_COOPERATIVE_SHUTDOWN;
	public static final long J9PORT_SIG_OPTIONS_OMRSIG_NO_CHAIN;
	public static final long J9PORT_SIG_OPTIONS_REDUCED_SIGNALS_ASYNCHRONOUS;
	public static final long J9PORT_SIG_OPTIONS_REDUCED_SIGNALS_SYNCHRONOUS;
	public static final long J9PORT_SIG_OPTIONS_SIGXFSZ;
	public static final long J9PORT_SIG_OPTIONS_ZOS_USE_CEEHDLR;
	public static final long J9PORT_SIG_OTHER;
	public static final long J9PORT_SIG_SIGNAL;
	public static final long J9PORT_SIG_SIGNAL_ADDRESS;
	public static final long J9PORT_SIG_SIGNAL_CODE;
	public static final long J9PORT_SIG_SIGNAL_ERROR_VALUE;
	public static final long J9PORT_SIG_SIGNAL_HANDLER;
	public static final long J9PORT_SIG_SIGNAL_INACCESSIBLE_ADDRESS;
	public static final long J9PORT_SIG_SIGNAL_PLATFORM_SIGNAL_TYPE;
	public static final long J9PORT_SIG_SIGNAL_TYPE;
	public static final long J9PORT_SIG_SIGNAL_ZOS_CONDITION_FACILITY_ID;
	public static final long J9PORT_SIG_SIGNAL_ZOS_CONDITION_FEEDBACK_TOKEN;
	public static final long J9PORT_SIG_SIGNAL_ZOS_CONDITION_INFORMATION_BLOCK;
	public static final long J9PORT_SIG_SIGNAL_ZOS_CONDITION_MESSAGE_NUMBER;
	public static final long J9PORT_SIG_SIGNAL_ZOS_CONDITION_SEVERITY;
	public static final long J9PORT_SIG_VALUE_128;
	public static final long J9PORT_SIG_VALUE_16;
	public static final long J9PORT_SIG_VALUE_32;
	public static final long J9PORT_SIG_VALUE_64;
	public static final long J9PORT_SIG_VALUE_ADDRESS;
	public static final long J9PORT_SIG_VALUE_FLOAT_64;
	public static final long J9PORT_SIG_VALUE_STRING;
	public static final long J9PORT_SIG_VALUE_UNDEFINED;
	public static final long J9PORT_SIG_VR;
	public static final long J9PORT_SIG_WINDOWS_DEFER_TRY_EXCEPT_HANDLER;
	public static final long J9PORT_SLOPEN_DECORATE;
	public static final long J9PORT_SLOPEN_LAZY;
	public static final long J9PORT_SLOPEN_NO_LOOKUP_MSG_FOR_NOT_FOUND;
	public static final long J9PORT_SLOPEN_OPEN_EXECUTABLE;
	public static final long J9PORT_SL_FOUND;
	public static final long J9PORT_SL_NOT_FOUND;
	public static final long J9PORT_SYSINFO_FEATURES_SIZE;
	public static final long J9PORT_SYSINFO_GET_HW_INFO_ERROR;
	public static final long J9PORT_SYSINFO_GET_HW_INFO_MODEL;
	public static final long J9PORT_SYSINFO_GET_HW_INFO_NOT_AVAILABLE;
	public static final long J9PORT_SYSINFO_GET_HW_INFO_SUCCESS;
	public static final long J9PORT_SYSINFO_HW_INFO_MODEL_BUF_LENGTH;
	public static final long J9PORT_TIME_DELTA_IN_MICROSECONDS;
	public static final long J9PORT_TIME_DELTA_IN_MILLISECONDS;
	public static final long J9PORT_TIME_NS_PER_MS;
	public static final long J9PORT_TIME_US_PER_SEC;
	public static final long J9PORT_TTY_ERR;
	public static final long J9PORT_TTY_OUT;
	public static final long J9PORT_VMEM_ADDRESS_HINT;
	public static final long J9PORT_VMEM_ALLOCATE_TOP_DOWN;
	public static final long J9PORT_VMEM_ALLOC_DIR_BOTTOM_UP;
	public static final long J9PORT_VMEM_ALLOC_DIR_TOP_DOWN;
	public static final long J9PORT_VMEM_ALLOC_QUICK;
	public static final long J9PORT_VMEM_MEMORY_MODE_COMMIT;
	public static final long J9PORT_VMEM_MEMORY_MODE_EXECUTE;
	public static final long J9PORT_VMEM_MEMORY_MODE_READ;
	public static final long J9PORT_VMEM_MEMORY_MODE_VIRTUAL;
	public static final long J9PORT_VMEM_MEMORY_MODE_WRITE;
	public static final long J9PORT_VMEM_NO_AFFINITY;
	public static final long J9PORT_VMEM_PAGE_FLAG_FIXED;
	public static final long J9PORT_VMEM_PAGE_FLAG_NOT_USED;
	public static final long J9PORT_VMEM_PAGE_FLAG_PAGEABLE;
	public static final long J9PORT_VMEM_STRICT_ADDRESS;
	public static final long J9PORT_VMEM_STRICT_PAGE_SIZE;
	public static final long J9PORT_VMEM_ZOS_USE_EXTENDED_PRIVATE_AREA;
	public static final long J9PORT_VMEM_ZTPF_USE_31BIT_MALLOC;
	public static final long J9PORT_X86_FEATURE_10;
	public static final long J9PORT_X86_FEATURE_11;
	public static final long J9PORT_X86_FEATURE_16;
	public static final long J9PORT_X86_FEATURE_20;
	public static final long J9PORT_X86_FEATURE_22;
	public static final long J9PORT_X86_FEATURE_30;
	public static final long J9PORT_X86_FEATURE_ACPI;
	public static final long J9PORT_X86_FEATURE_ADX;
	public static final long J9PORT_X86_FEATURE_AESNI;
	public static final long J9PORT_X86_FEATURE_APIC;
	public static final long J9PORT_X86_FEATURE_AVX;
	public static final long J9PORT_X86_FEATURE_AVX2;
	public static final long J9PORT_X86_FEATURE_AVX512BW;
	public static final long J9PORT_X86_FEATURE_AVX512CD;
	public static final long J9PORT_X86_FEATURE_AVX512DQ;
	public static final long J9PORT_X86_FEATURE_AVX512ER;
	public static final long J9PORT_X86_FEATURE_AVX512F;
	public static final long J9PORT_X86_FEATURE_AVX512PF;
	public static final long J9PORT_X86_FEATURE_AVX512VL;
	public static final long J9PORT_X86_FEATURE_AVX512_IFMA;
	public static final long J9PORT_X86_FEATURE_BMI1;
	public static final long J9PORT_X86_FEATURE_BMI2;
	public static final long J9PORT_X86_FEATURE_CLFLUSHOPT;
	public static final long J9PORT_X86_FEATURE_CLFSH;
	public static final long J9PORT_X86_FEATURE_CLWB;
	public static final long J9PORT_X86_FEATURE_CMOV;
	public static final long J9PORT_X86_FEATURE_CMPXCHG16B;
	public static final long J9PORT_X86_FEATURE_CNXT_ID;
	public static final long J9PORT_X86_FEATURE_CX8;
	public static final long J9PORT_X86_FEATURE_DCA;
	public static final long J9PORT_X86_FEATURE_DE;
	public static final long J9PORT_X86_FEATURE_DEPRECATE_FPUCS;
	public static final long J9PORT_X86_FEATURE_DS;
	public static final long J9PORT_X86_FEATURE_DS_CPL;
	public static final long J9PORT_X86_FEATURE_DTES64;
	public static final long J9PORT_X86_FEATURE_EIST;
	public static final long J9PORT_X86_FEATURE_ERMSB;
	public static final long J9PORT_X86_FEATURE_F16C;
	public static final long J9PORT_X86_FEATURE_FDP_EXCPTN_ONLY;
	public static final long J9PORT_X86_FEATURE_FMA;
	public static final long J9PORT_X86_FEATURE_FPU;
	public static final long J9PORT_X86_FEATURE_FSGSBASE;
	public static final long J9PORT_X86_FEATURE_FXSR;
	public static final long J9PORT_X86_FEATURE_HLE;
	public static final long J9PORT_X86_FEATURE_HTT;
	public static final long J9PORT_X86_FEATURE_IA32_TSC_ADJUST;
	public static final long J9PORT_X86_FEATURE_INVPCID;
	public static final long J9PORT_X86_FEATURE_IPT;
	public static final long J9PORT_X86_FEATURE_MCA;
	public static final long J9PORT_X86_FEATURE_MCE;
	public static final long J9PORT_X86_FEATURE_MMX;
	public static final long J9PORT_X86_FEATURE_MONITOR;
	public static final long J9PORT_X86_FEATURE_MOVBE;
	public static final long J9PORT_X86_FEATURE_MPX;
	public static final long J9PORT_X86_FEATURE_MSR;
	public static final long J9PORT_X86_FEATURE_MTRR;
	public static final long J9PORT_X86_FEATURE_OSXSAVE;
	public static final long J9PORT_X86_FEATURE_PAE;
	public static final long J9PORT_X86_FEATURE_PAT;
	public static final long J9PORT_X86_FEATURE_PBE;
	public static final long J9PORT_X86_FEATURE_PCID;
	public static final long J9PORT_X86_FEATURE_PCLMULQDQ;
	public static final long J9PORT_X86_FEATURE_PDCM;
	public static final long J9PORT_X86_FEATURE_PGE;
	public static final long J9PORT_X86_FEATURE_POPCNT;
	public static final long J9PORT_X86_FEATURE_PSE;
	public static final long J9PORT_X86_FEATURE_PSE_36;
	public static final long J9PORT_X86_FEATURE_PSN;
	public static final long J9PORT_X86_FEATURE_RDRAND;
	public static final long J9PORT_X86_FEATURE_RDSEED;
	public static final long J9PORT_X86_FEATURE_RDT_A;
	public static final long J9PORT_X86_FEATURE_RDT_M;
	public static final long J9PORT_X86_FEATURE_RTM;
	public static final long J9PORT_X86_FEATURE_SEP;
	public static final long J9PORT_X86_FEATURE_SGX;
	public static final long J9PORT_X86_FEATURE_SHA;
	public static final long J9PORT_X86_FEATURE_SMAP;
	public static final long J9PORT_X86_FEATURE_SMEP;
	public static final long J9PORT_X86_FEATURE_SMX;
	public static final long J9PORT_X86_FEATURE_SS;
	public static final long J9PORT_X86_FEATURE_SSE;
	public static final long J9PORT_X86_FEATURE_SSE2;
	public static final long J9PORT_X86_FEATURE_SSE3;
	public static final long J9PORT_X86_FEATURE_SSE4_1;
	public static final long J9PORT_X86_FEATURE_SSE4_2;
	public static final long J9PORT_X86_FEATURE_SSSE3;
	public static final long J9PORT_X86_FEATURE_TM;
	public static final long J9PORT_X86_FEATURE_TM2;
	public static final long J9PORT_X86_FEATURE_TSC;
	public static final long J9PORT_X86_FEATURE_TSC_DEADLINE;
	public static final long J9PORT_X86_FEATURE_VME;
	public static final long J9PORT_X86_FEATURE_VMX;
	public static final long J9PORT_X86_FEATURE_X2APIC;
	public static final long J9PORT_X86_FEATURE_XSAVE;
	public static final long J9PORT_X86_FEATURE_XTPR;
	public static final long J9SHMEM_GETDIR_APPEND_BASEDIR;
	public static final long J9SHMEM_GETDIR_USE_USERHOME;
	public static final long J9SHMEM_NO_FLAGS;
	public static final long J9SHMEM_OPEN_DO_NOT_CREATE;
	public static final long J9SHMEM_OPEN_FOR_DESTROY;
	public static final long J9SHMEM_OPEN_FOR_STATS;
	public static final long J9SHMEM_PRINT_STORAGE_KEY_WARNING;
	public static final long J9SHMEM_STORAGE_KEY_TESTING;
	public static final long J9SHMEM_STORAGE_KEY_TESTING_MASK;
	public static final long J9SHSEM_NO_FLAGS;
	public static final long J9SHSEM_OPEN_DO_NOT_CREATE;
	public static final long J9SHSEM_OPEN_FOR_DESTROY;
	public static final long J9SHSEM_OPEN_FOR_STATS;
	public static final long J9SH_BASEFILEPERM;
	public static final long J9SH_BASEFILEPERM_GROUP_RW_ACCESS;
	public static final long J9SH_DIRPERM;
	public static final long J9SH_DIRPERM_ABSENT;
	public static final long J9SH_DIRPERM_ABSENT_GROUPACCESS;
	public static final long J9SH_DIRPERM_DEFAULT;
	public static final long J9SH_DIRPERM_DEFAULT_TMP;
	public static final long J9SH_DIRPERM_DEFAULT_WITH_STICKYBIT;
	public static final long J9SH_DIRPERM_GROUPACCESS;
	public static final long J9SH_MAXPATH;
	public static final long J9SH_MAX_PROJ_ID;
	public static final long J9SH_PARENTDIRPERM;
	public static final long J9SH_SHMEM_PERM_READ;
	public static final long J9SH_SHMEM_PERM_READ_WRITE;
	public static final long J9SH_SYSV_OLDER_CONTROL_FILE;
	public static final long J9SH_SYSV_OLDER_EMPTY_CONTROL_FILE;
	public static final long J9SH_SYSV_REGULAR_CONTROL_FILE;
	public static final long J9STR_CODE_EBCDIC;
	public static final long J9STR_CODE_LATIN1;
	public static final long J9STR_CODE_MUTF8;
	public static final long J9STR_CODE_PLATFORM_OMR_INTERNAL;
	public static final long J9STR_CODE_PLATFORM_RAW;
	public static final long J9STR_CODE_UTF8;
	public static final long J9STR_CODE_WIDE;
	public static final long J9STR_CODE_WINDEFAULTACP;
	public static final long J9STR_CODE_WINTHREADACP;
	public static final long LS_INITIALIZED;
	public static final long LS_INITIALIZING;
	public static final long LS_LOCKED;
	public static final long LS_UNINITIALIZED;
	public static final long MAX_SIZE_TOTAL_GPINFO;
	public static final long MAX_STRING_TERMINATOR_LENGTH;
	public static final long NANOSECS_PER_USEC;
	public static final long OMRMEM_CATEGORY_PORT_LIBRARY;
	public static final long OMRMEM_CATEGORY_PORT_LIBRARY_UNUSED_ALLOCATE32_REGIONS;
	public static final long OMRMEM_CATEGORY_UNKNOWN;
	public static final long OMRPORT_CPU_BOUND;
	public static final long OMRPORT_CPU_ONLINE;
	public static final long OMRPORT_CPU_PHYSICAL;
	public static final long OMRPORT_CPU_TARGET;
	public static final long OMRPORT_DISABLE_ENSURE_CAP32;
	public static final long OMRPORT_ENABLE_ENSURE_CAP32;
	public static final long OMRPORT_ENSURE_CAPACITY_FAILED;
	public static final long OMRPORT_ENSURE_CAPACITY_NOT_REQUIRED;
	public static final long OMRPORT_ENSURE_CAPACITY_SUCCESS;
	public static final long OMRPORT_FILESTREAM_FULL_BUFFERING;
	public static final long OMRPORT_FILESTREAM_LINE_BUFFERING;
	public static final long OMRPORT_FILESTREAM_NO_BUFFERING;
	public static final long OMRPORT_FILE_IGNORE_ID;
	public static final long OMRPORT_FILE_NOWAIT_FOR_LOCK;
	public static final long OMRPORT_FILE_READ_LOCK;
	public static final long OMRPORT_FILE_WAIT_FOR_LOCK;
	public static final long OMRPORT_FILE_WRITE_LOCK;
	public static final long OMRPORT_INFO_CONTROL_FILE_NOT_UNLINKED;
	public static final long OMRPORT_INFO_CONTROL_FILE_UNLINKED;
	public static final long OMRPORT_INFO_CONTROL_FILE_UNLINK_FAILED;
	public static final long OMRPORT_INFO_SHMEM_BASE;
	public static final long OMRPORT_INFO_SHMEM_CREATED;
	public static final long OMRPORT_INFO_SHMEM_OPENED;
	public static final long OMRPORT_INFO_SHMEM_OPENED_STALE;
	public static final long OMRPORT_INFO_SHMEM_OPEN_UNLINKED;
	public static final long OMRPORT_INFO_SHMEM_PARTIAL;
	public static final long OMRPORT_INFO_SHMEM_STAT_PASSED;
	public static final long OMRPORT_INFO_SHSEM_BASE;
	public static final long OMRPORT_INFO_SHSEM_CREATED;
	public static final long OMRPORT_INFO_SHSEM_OPENED;
	public static final long OMRPORT_INFO_SHSEM_OPENED_STALE;
	public static final long OMRPORT_INFO_SHSEM_OPEN_UNLINKED;
	public static final long OMRPORT_INFO_SHSEM_PARTIAL;
	public static final long OMRPORT_INFO_SHSEM_STAT_PASSED;
	public static final long OMRPORT_INVALID_FD;
	public static final long OMRPORT_LIMIT_BASE;
	public static final long OMRPORT_LIMIT_HARD;
	public static final long OMRPORT_LIMIT_LIMITED;
	public static final long OMRPORT_LIMIT_SOFT;
	public static final long OMRPORT_LIMIT_UNKNOWN;
	public static final long OMRPORT_LIMIT_UNKNOWN_VALUE;
	public static final long OMRPORT_LIMIT_UNLIMITED;
	public static final long OMRPORT_LIMIT_UNLIMITED_VALUE;
	public static final long OMRPORT_MEMINFO_NOT_AVAILABLE;
	public static final long OMRPORT_MMAP_CAPABILITY_COPYONWRITE;
	public static final long OMRPORT_MMAP_CAPABILITY_MSYNC;
	public static final long OMRPORT_MMAP_CAPABILITY_PROTECT;
	public static final long OMRPORT_MMAP_CAPABILITY_READ;
	public static final long OMRPORT_MMAP_CAPABILITY_UMAP_REQUIRES_SIZE;
	public static final long OMRPORT_MMAP_CAPABILITY_WRITE;
	public static final long OMRPORT_MMAP_FLAG_COPYONWRITE;
	public static final long OMRPORT_MMAP_FLAG_CREATE_FILE;
	public static final long OMRPORT_MMAP_FLAG_EXECUTABLE;
	public static final long OMRPORT_MMAP_FLAG_PRIVATE;
	public static final long OMRPORT_MMAP_FLAG_READ;
	public static final long OMRPORT_MMAP_FLAG_SHARED;
	public static final long OMRPORT_MMAP_FLAG_WRITE;
	public static final long OMRPORT_MMAP_SYNC_ASYNC;
	public static final long OMRPORT_MMAP_SYNC_INVALIDATE;
	public static final long OMRPORT_MMAP_SYNC_WAIT;
	public static final long OMRPORT_PAGE_PROTECT_EXEC;
	public static final long OMRPORT_PAGE_PROTECT_NONE;
	public static final long OMRPORT_PAGE_PROTECT_NOT_SUPPORTED;
	public static final long OMRPORT_PAGE_PROTECT_READ;
	public static final long OMRPORT_PAGE_PROTECT_WRITE;
	public static final long OMRPORT_PROCINFO_NOT_AVAILABLE;
	public static final long OMRPORT_PROCINFO_PROC_OFFLINE;
	public static final long OMRPORT_PROCINFO_PROC_ONLINE;
	public static final long OMRPORT_RESOURCE_ADDRESS_SPACE;
	public static final long OMRPORT_RESOURCE_CORE_FILE;
	public static final long OMRPORT_RESOURCE_CORE_FLAGS;
	public static final long OMRPORT_RESOURCE_DATA;
	public static final long OMRPORT_RESOURCE_FILE_DESCRIPTORS;
	public static final long OMRPORT_RESOURCE_SHARED_MEMORY;
	public static final long OMRPORT_SHMEM_EYECATCHER_LENGTH;
	public static final long OMRPORT_SHSEM_MODE_DEFAULT;
	public static final long OMRPORT_SHSEM_MODE_NOWAIT;
	public static final long OMRPORT_SHSEM_MODE_UNDO;
	public static final long OMRPORT_SIG_CONTROL;
	public static final long OMRPORT_SIG_CONTROL_BP;
	public static final long OMRPORT_SIG_CONTROL_PC;
	public static final long OMRPORT_SIG_CONTROL_POWERPC_CR;
	public static final long OMRPORT_SIG_CONTROL_POWERPC_CTR;
	public static final long OMRPORT_SIG_CONTROL_POWERPC_DAR;
	public static final long OMRPORT_SIG_CONTROL_POWERPC_DSIR;
	public static final long OMRPORT_SIG_CONTROL_POWERPC_FPSCR;
	public static final long OMRPORT_SIG_CONTROL_POWERPC_LR;
	public static final long OMRPORT_SIG_CONTROL_POWERPC_MQ;
	public static final long OMRPORT_SIG_CONTROL_POWERPC_MSR;
	public static final long OMRPORT_SIG_CONTROL_POWERPC_XER;
	public static final long OMRPORT_SIG_CONTROL_S390_BEA;
	public static final long OMRPORT_SIG_CONTROL_S390_FPC;
	public static final long OMRPORT_SIG_CONTROL_S390_GPR7;
	public static final long OMRPORT_SIG_CONTROL_SP;
	public static final long OMRPORT_SIG_CONTROL_X86_EFLAGS;
	public static final long OMRPORT_SIG_ERROR;
	public static final long OMRPORT_SIG_EXCEPTION_CONTINUE_EXECUTION;
	public static final long OMRPORT_SIG_EXCEPTION_CONTINUE_SEARCH;
	public static final long OMRPORT_SIG_EXCEPTION_COOPERATIVE_SHUTDOWN;
	public static final long OMRPORT_SIG_EXCEPTION_OCCURRED;
	public static final long OMRPORT_SIG_EXCEPTION_RETURN;
	public static final long OMRPORT_SIG_FLAG_CONTROL_BITS_MASK;
	public static final long OMRPORT_SIG_FLAG_IS_ASYNC;
	public static final long OMRPORT_SIG_FLAG_IS_SYNC;
	public static final long OMRPORT_SIG_FLAG_MAY_CONTINUE_EXECUTION;
	public static final long OMRPORT_SIG_FLAG_MAY_RETURN;
	public static final long OMRPORT_SIG_FLAG_SIGABEND;
	public static final long OMRPORT_SIG_FLAG_SIGABRT;
	public static final long OMRPORT_SIG_FLAG_SIGALLASYNC;
	public static final long OMRPORT_SIG_FLAG_SIGALLSYNC;
	public static final long OMRPORT_SIG_FLAG_SIGALRM;
	public static final long OMRPORT_SIG_FLAG_SIGBUS;
	public static final long OMRPORT_SIG_FLAG_SIGCHLD;
	public static final long OMRPORT_SIG_FLAG_SIGCONT;
	public static final long OMRPORT_SIG_FLAG_SIGFPE;
	public static final long OMRPORT_SIG_FLAG_SIGFPE_DIV_BY_ZERO;
	public static final long OMRPORT_SIG_FLAG_SIGFPE_INT_DIV_BY_ZERO;
	public static final long OMRPORT_SIG_FLAG_SIGFPE_INT_OVERFLOW;
	public static final long OMRPORT_SIG_FLAG_SIGHUP;
	public static final long OMRPORT_SIG_FLAG_SIGILL;
	public static final long OMRPORT_SIG_FLAG_SIGINFO;
	public static final long OMRPORT_SIG_FLAG_SIGINT;
	public static final long OMRPORT_SIG_FLAG_SIGIO;
	public static final long OMRPORT_SIG_FLAG_SIGIOT;
	public static final long OMRPORT_SIG_FLAG_SIGPIPE;
	public static final long OMRPORT_SIG_FLAG_SIGPOLL;
	public static final long OMRPORT_SIG_FLAG_SIGPROF;
	public static final long OMRPORT_SIG_FLAG_SIGQUIT;
	public static final long OMRPORT_SIG_FLAG_SIGRECONFIG;
	public static final long OMRPORT_SIG_FLAG_SIGSEGV;
	public static final long OMRPORT_SIG_FLAG_SIGSYS;
	public static final long OMRPORT_SIG_FLAG_SIGTERM;
	public static final long OMRPORT_SIG_FLAG_SIGTRAP;
	public static final long OMRPORT_SIG_FLAG_SIGTSTP;
	public static final long OMRPORT_SIG_FLAG_SIGTTIN;
	public static final long OMRPORT_SIG_FLAG_SIGTTOU;
	public static final long OMRPORT_SIG_FLAG_SIGURG;
	public static final long OMRPORT_SIG_FLAG_SIGUSR1;
	public static final long OMRPORT_SIG_FLAG_SIGUSR2;
	public static final long OMRPORT_SIG_FLAG_SIGVTALRM;
	public static final long OMRPORT_SIG_FLAG_SIGWINCH;
	public static final long OMRPORT_SIG_FLAG_SIGXCPU;
	public static final long OMRPORT_SIG_FLAG_SIGXFSZ;
	public static final long OMRPORT_SIG_FPR;
	public static final long OMRPORT_SIG_GPR;
	public static final long OMRPORT_SIG_GPR_AMD64_R10;
	public static final long OMRPORT_SIG_GPR_AMD64_R11;
	public static final long OMRPORT_SIG_GPR_AMD64_R12;
	public static final long OMRPORT_SIG_GPR_AMD64_R13;
	public static final long OMRPORT_SIG_GPR_AMD64_R14;
	public static final long OMRPORT_SIG_GPR_AMD64_R15;
	public static final long OMRPORT_SIG_GPR_AMD64_R8;
	public static final long OMRPORT_SIG_GPR_AMD64_R9;
	public static final long OMRPORT_SIG_GPR_AMD64_RAX;
	public static final long OMRPORT_SIG_GPR_AMD64_RBX;
	public static final long OMRPORT_SIG_GPR_AMD64_RCX;
	public static final long OMRPORT_SIG_GPR_AMD64_RDI;
	public static final long OMRPORT_SIG_GPR_AMD64_RDX;
	public static final long OMRPORT_SIG_GPR_AMD64_RSI;
	public static final long OMRPORT_SIG_GPR_ARM_R0;
	public static final long OMRPORT_SIG_GPR_ARM_R1;
	public static final long OMRPORT_SIG_GPR_ARM_R10;
	public static final long OMRPORT_SIG_GPR_ARM_R2;
	public static final long OMRPORT_SIG_GPR_ARM_R3;
	public static final long OMRPORT_SIG_GPR_ARM_R4;
	public static final long OMRPORT_SIG_GPR_ARM_R5;
	public static final long OMRPORT_SIG_GPR_ARM_R6;
	public static final long OMRPORT_SIG_GPR_ARM_R7;
	public static final long OMRPORT_SIG_GPR_ARM_R8;
	public static final long OMRPORT_SIG_GPR_ARM_R9;
	public static final long OMRPORT_SIG_GPR_X86_EAX;
	public static final long OMRPORT_SIG_GPR_X86_EBX;
	public static final long OMRPORT_SIG_GPR_X86_ECX;
	public static final long OMRPORT_SIG_GPR_X86_EDI;
	public static final long OMRPORT_SIG_GPR_X86_EDX;
	public static final long OMRPORT_SIG_GPR_X86_ESI;
	public static final long OMRPORT_SIG_MODULE;
	public static final long OMRPORT_SIG_MODULE_FUNCTION_NAME;
	public static final long OMRPORT_SIG_MODULE_NAME;
	public static final long OMRPORT_SIG_NO_EXCEPTION;
	public static final long OMRPORT_SIG_NUM_CATEGORIES;
	public static final long OMRPORT_SIG_OPTIONS_COOPERATIVE_SHUTDOWN;
	public static final long OMRPORT_SIG_OPTIONS_OMRSIG_NO_CHAIN;
	public static final long OMRPORT_SIG_OPTIONS_REDUCED_SIGNALS_ASYNCHRONOUS;
	public static final long OMRPORT_SIG_OPTIONS_REDUCED_SIGNALS_SYNCHRONOUS;
	public static final long OMRPORT_SIG_OPTIONS_SIGXFSZ;
	public static final long OMRPORT_SIG_OPTIONS_ZOS_USE_CEEHDLR;
	public static final long OMRPORT_SIG_OTHER;
	public static final long OMRPORT_SIG_SIGNAL;
	public static final long OMRPORT_SIG_SIGNAL_ADDRESS;
	public static final long OMRPORT_SIG_SIGNAL_CODE;
	public static final long OMRPORT_SIG_SIGNAL_ERROR_VALUE;
	public static final long OMRPORT_SIG_SIGNAL_HANDLER;
	public static final long OMRPORT_SIG_SIGNAL_INACCESSIBLE_ADDRESS;
	public static final long OMRPORT_SIG_SIGNAL_PLATFORM_SIGNAL_TYPE;
	public static final long OMRPORT_SIG_SIGNAL_TYPE;
	public static final long OMRPORT_SIG_SIGNAL_ZOS_CONDITION_FACILITY_ID;
	public static final long OMRPORT_SIG_SIGNAL_ZOS_CONDITION_FEEDBACK_TOKEN;
	public static final long OMRPORT_SIG_SIGNAL_ZOS_CONDITION_INFORMATION_BLOCK;
	public static final long OMRPORT_SIG_SIGNAL_ZOS_CONDITION_MESSAGE_NUMBER;
	public static final long OMRPORT_SIG_SIGNAL_ZOS_CONDITION_SEVERITY;
	public static final long OMRPORT_SIG_SMALLEST_SIGNAL_FLAG;
	public static final long OMRPORT_SIG_VALUE_128;
	public static final long OMRPORT_SIG_VALUE_16;
	public static final long OMRPORT_SIG_VALUE_32;
	public static final long OMRPORT_SIG_VALUE_64;
	public static final long OMRPORT_SIG_VALUE_ADDRESS;
	public static final long OMRPORT_SIG_VALUE_FLOAT_64;
	public static final long OMRPORT_SIG_VALUE_STRING;
	public static final long OMRPORT_SIG_VALUE_UNDEFINED;
	public static final long OMRPORT_SIG_VR;
	public static final long OMRPORT_SIG_WINDOWS_DEFER_TRY_EXCEPT_HANDLER;
	public static final long OMRPORT_SLOPEN_DECORATE;
	public static final long OMRPORT_SLOPEN_LAZY;
	public static final long OMRPORT_SLOPEN_NO_LOOKUP_MSG_FOR_NOT_FOUND;
	public static final long OMRPORT_SLOPEN_OPEN_EXECUTABLE;
	public static final long OMRPORT_SL_FOUND;
	public static final long OMRPORT_SL_INVALID;
	public static final long OMRPORT_SL_NOT_FOUND;
	public static final long OMRPORT_SL_UNKNOWN;
	public static final long OMRPORT_SL_UNSUPPORTED;
	public static final long OMRPORT_SYSINFO_FEATURES_SIZE;
	public static final long OMRPORT_SYSINFO_OS_FEATURES_SIZE;
	public static final long OMRPORT_TIME_DELTA_IN_MICROSECONDS;
	public static final long OMRPORT_TIME_DELTA_IN_MILLISECONDS;
	public static final long OMRPORT_TIME_DELTA_IN_NANOSECONDS;
	public static final long OMRPORT_TIME_DELTA_IN_SECONDS;
	public static final long OMRPORT_TIME_HIRES_MICROTIME_DIVISOR;
	public static final long OMRPORT_TIME_HIRES_MILLITIME_DIVISOR;
	public static final long OMRPORT_TIME_HIRES_NANOTIME_DENOMINATOR;
	public static final long OMRPORT_TIME_HIRES_NANOTIME_NUMERATOR;
	public static final long OMRPORT_TIME_NS_PER_MS;
	public static final long OMRPORT_TIME_US_PER_SEC;
	public static final long OMRPORT_TTY_ERR;
	public static final long OMRPORT_TTY_IN;
	public static final long OMRPORT_TTY_OUT;
	public static final long OMRPORT_VMEM_ADDRESS_HINT;
	public static final long OMRPORT_VMEM_ALLOCATE_PERSIST;
	public static final long OMRPORT_VMEM_ALLOCATE_TOP_DOWN;
	public static final long OMRPORT_VMEM_ALLOC_DIR_BOTTOM_UP;
	public static final long OMRPORT_VMEM_ALLOC_DIR_TOP_DOWN;
	public static final long OMRPORT_VMEM_ALLOC_QUICK;
	public static final long OMRPORT_VMEM_MEMORY_MODE_COMMIT;
	public static final long OMRPORT_VMEM_MEMORY_MODE_DOUBLE_MAP_AVAILABLE;
	public static final long OMRPORT_VMEM_MEMORY_MODE_EXECUTE;
	public static final long OMRPORT_VMEM_MEMORY_MODE_MMAP_HUGE_PAGES;
	public static final long OMRPORT_VMEM_MEMORY_MODE_READ;
	public static final long OMRPORT_VMEM_MEMORY_MODE_SHARE_FILE_OPEN;
	public static final long OMRPORT_VMEM_MEMORY_MODE_VIRTUAL;
	public static final long OMRPORT_VMEM_MEMORY_MODE_WRITE;
	public static final long OMRPORT_VMEM_NO_AFFINITY;
	public static final long OMRPORT_VMEM_PAGE_FLAG_FIXED;
	public static final long OMRPORT_VMEM_PAGE_FLAG_NOT_USED;
	public static final long OMRPORT_VMEM_PAGE_FLAG_PAGEABLE;
	public static final long OMRPORT_VMEM_PAGE_FLAG_PAGEABLE_PREFERABLE;
	public static final long OMRPORT_VMEM_PAGE_FLAG_SUPERPAGE_ANY;
	public static final long OMRPORT_VMEM_PAGE_FLAG_TYPE_MASK;
	public static final long OMRPORT_VMEM_RESERVE_USED_INVALID;
	public static final long OMRPORT_VMEM_RESERVE_USED_J9ALLOCATE_4K_PAGES_ABOVE_BAR;
	public static final long OMRPORT_VMEM_RESERVE_USED_J9ALLOCATE_4K_PAGES_BELOW_BAR;
	public static final long OMRPORT_VMEM_RESERVE_USED_J9ALLOCATE_4K_PAGES_IN_2TO32G_AREA;
	public static final long OMRPORT_VMEM_RESERVE_USED_J9ALLOCATE_LARGE_FIXED_PAGES_ABOVE_BAR;
	public static final long OMRPORT_VMEM_RESERVE_USED_J9ALLOCATE_LARGE_PAGEABLE_PAGES_ABOVE_BAR;
	public static final long OMRPORT_VMEM_RESERVE_USED_J9ALLOCATE_LARGE_PAGES_BELOW_BAR;
	public static final long OMRPORT_VMEM_RESERVE_USED_J9MEM_ALLOCATE_MEMORY;
	public static final long OMRPORT_VMEM_RESERVE_USED_MALLOC31;
	public static final long OMRPORT_VMEM_RESERVE_USED_MMAP;
	public static final long OMRPORT_VMEM_RESERVE_USED_MMAP_RESTORE_MMAP;
	public static final long OMRPORT_VMEM_RESERVE_USED_MMAP_SHM;
	public static final long OMRPORT_VMEM_RESERVE_USED_MOSERVICES;
	public static final long OMRPORT_VMEM_RESERVE_USED_SHM;
	public static final long OMRPORT_VMEM_STRICT_ADDRESS;
	public static final long OMRPORT_VMEM_STRICT_PAGE_SIZE;
	public static final long OMRPORT_VMEM_ZOS_USE2TO32G_AREA;
	public static final long OMRPORT_VMEM_ZTPF_USE_31BIT_MALLOC;
	public static final long OMRPORT_ZOS_FEATURE_RMODE64;
	public static final long OMRSHMEM_GETDIR_APPEND_BASEDIR;
	public static final long OMRSHMEM_GETDIR_USE_USERHOME;
	public static final long OMRSHMEM_NO_FLAGS;
	public static final long OMRSHMEM_OPEN_DO_NOT_CREATE;
	public static final long OMRSHMEM_OPEN_FOR_DESTROY;
	public static final long OMRSHMEM_OPEN_FOR_STATS;
	public static final long OMRSHMEM_PRINT_STORAGE_KEY_WARNING;
	public static final long OMRSHMEM_STORAGE_KEY_TESTING;
	public static final long OMRSHMEM_STORAGE_KEY_TESTING_MASK;
	public static final long OMRSHSEM_NO_FLAGS;
	public static final long OMRSHSEM_OPEN_DO_NOT_CREATE;
	public static final long OMRSHSEM_OPEN_FOR_DESTROY;
	public static final long OMRSHSEM_OPEN_FOR_STATS;
	public static final long OMRSH_BASEFILEPERM;
	public static final long OMRSH_BASEFILEPERM_GROUP_RW_ACCESS;
	public static final long OMRSH_DIRPERM;
	public static final long OMRSH_DIRPERM_ABSENT;
	public static final long OMRSH_DIRPERM_DEFAULT;
	public static final long OMRSH_DIRPERM_DEFAULT_WITH_STICKYBIT;
	public static final long OMRSH_MAXPATH;
	public static final long OMRSH_PARENTDIRPERM;
	public static final long OMRSH_SHMEM_PERM_READ;
	public static final long OMRSH_SHMEM_PERM_READ_WRITE;
	public static final long OMRSH_SYSV_OLDER_CONTROL_FILE;
	public static final long OMRSH_SYSV_OLDER_EMPTY_CONTROL_FILE;
	public static final long OMRSH_SYSV_REGULAR_CONTROL_FILE;
	public static final long OMR_CGROUP_SUBSYSTEM_ALL;
	public static final long OMR_CGROUP_SUBSYSTEM_CPU;
	public static final long OMR_CGROUP_SUBSYSTEM_CPUSET;
	public static final long OMR_CGROUP_SUBSYSTEM_MEMORY;
	public static final long OMR_CONFIGURABLE_SUSPEND_SIGNAL;
	public static final long OMR_CONFIGURABLE_SUSPEND_SIGNAL_DEFINED;
	public static final long OMR_FEATURE_PPC_32;
	public static final long OMR_FEATURE_PPC_601_INSTR;
	public static final long OMR_FEATURE_PPC_64;
	public static final long OMR_FEATURE_PPC_ARCH_2_05;
	public static final long OMR_FEATURE_PPC_ARCH_2_06;
	public static final long OMR_FEATURE_PPC_ARCH_2_07;
	public static final long OMR_FEATURE_PPC_BOOKE;
	public static final long OMR_FEATURE_PPC_CELL_BE;
	public static final long OMR_FEATURE_PPC_DSCR;
	public static final long OMR_FEATURE_PPC_EBB;
	public static final long OMR_FEATURE_PPC_HAS_4xxMAC;
	public static final long OMR_FEATURE_PPC_HAS_ALTIVEC;
	public static final long OMR_FEATURE_PPC_HAS_DFP;
	public static final long OMR_FEATURE_PPC_HAS_EFP_DOUBLE;
	public static final long OMR_FEATURE_PPC_HAS_EFP_SINGLE;
	public static final long OMR_FEATURE_PPC_HAS_FPU;
	public static final long OMR_FEATURE_PPC_HAS_MMU;
	public static final long OMR_FEATURE_PPC_HAS_SPE;
	public static final long OMR_FEATURE_PPC_HAS_VSX;
	public static final long OMR_FEATURE_PPC_HTM;
	public static final long OMR_FEATURE_PPC_ICACHE_SNOOP;
	public static final long OMR_FEATURE_PPC_ISEL;
	public static final long OMR_FEATURE_PPC_LE;
	public static final long OMR_FEATURE_PPC_NO_TB;
	public static final long OMR_FEATURE_PPC_PA6T;
	public static final long OMR_FEATURE_PPC_POWER4;
	public static final long OMR_FEATURE_PPC_POWER5;
	public static final long OMR_FEATURE_PPC_POWER5_PLUS;
	public static final long OMR_FEATURE_PPC_POWER6_EXT;
	public static final long OMR_FEATURE_PPC_PSERIES_PERFMON_COMPAT;
	public static final long OMR_FEATURE_PPC_SMT;
	public static final long OMR_FEATURE_PPC_TAR;
	public static final long OMR_FEATURE_PPC_TRUE_LE;
	public static final long OMR_FEATURE_PPC_UNIFIED_CACHE;
	public static final long OMR_FEATURE_S390_COMPARE_AND_SWAP_AND_STORE;
	public static final long OMR_FEATURE_S390_COMPARE_AND_SWAP_AND_STORE2;
	public static final long OMR_FEATURE_S390_DFP;
	public static final long OMR_FEATURE_S390_ESAN3;
	public static final long OMR_FEATURE_S390_ETF3_ENHANCEMENT;
	public static final long OMR_FEATURE_S390_EXECUTE_EXTENSIONS;
	public static final long OMR_FEATURE_S390_EXTENDED_IMMEDIATE;
	public static final long OMR_FEATURE_S390_EXTENDED_TRANSLATION_3;
	public static final long OMR_FEATURE_S390_FPE;
	public static final long OMR_FEATURE_S390_GENERAL_INSTRUCTIONS_EXTENSIONS;
	public static final long OMR_FEATURE_S390_GUARDED_STORAGE;
	public static final long OMR_FEATURE_S390_HIGH_WORD;
	public static final long OMR_FEATURE_S390_HPAGE;
	public static final long OMR_FEATURE_S390_LOAD_AND_ZERO_RIGHTMOST_BYTE;
	public static final long OMR_FEATURE_S390_LOAD_STORE_ON_CONDITION_1;
	public static final long OMR_FEATURE_S390_LOAD_STORE_ON_CONDITION_2;
	public static final long OMR_FEATURE_S390_LONG_DISPLACEMENT;
	public static final long OMR_FEATURE_S390_MISCELLANEOUS_INSTRUCTION_EXTENSION;
	public static final long OMR_FEATURE_S390_MISCELLANEOUS_INSTRUCTION_EXTENSION_2;
	public static final long OMR_FEATURE_S390_MISCELLANEOUS_INSTRUCTION_EXTENSION_3;
	public static final long OMR_FEATURE_S390_MSA;
	public static final long OMR_FEATURE_S390_MSA_EXTENSION3;
	public static final long OMR_FEATURE_S390_MSA_EXTENSION4;
	public static final long OMR_FEATURE_S390_MSA_EXTENSION_5;
	public static final long OMR_FEATURE_S390_MSA_EXTENSION_8;
	public static final long OMR_FEATURE_S390_RI;
	public static final long OMR_FEATURE_S390_SEMAPHORE_ASSIST;
	public static final long OMR_FEATURE_S390_SIDE_EFFECT_ACCESS;
	public static final long OMR_FEATURE_S390_STFLE;
	public static final long OMR_FEATURE_S390_TE;
	public static final long OMR_FEATURE_S390_VECTOR_FACILITY;
	public static final long OMR_FEATURE_S390_VECTOR_FACILITY_ENHANCEMENT_1;
	public static final long OMR_FEATURE_S390_VECTOR_FACILITY_ENHANCEMENT_2;
	public static final long OMR_FEATURE_S390_VECTOR_PACKED_DECIMAL;
	public static final long OMR_FEATURE_S390_VECTOR_PACKED_DECIMAL_ENHANCEMENT_FACILITY;
	public static final long OMR_FEATURE_S390_ZARCH;
	public static final long OMR_FEATURE_X86_0_10;
	public static final long OMR_FEATURE_X86_0_20;
	public static final long OMR_FEATURE_X86_0_30;
	public static final long OMR_FEATURE_X86_1_16;
	public static final long OMR_FEATURE_X86_1_31;
	public static final long OMR_FEATURE_X86_3_22;
	public static final long OMR_FEATURE_X86_ACPI;
	public static final long OMR_FEATURE_X86_ADX;
	public static final long OMR_FEATURE_X86_AESNI;
	public static final long OMR_FEATURE_X86_APIC;
	public static final long OMR_FEATURE_X86_AVX;
	public static final long OMR_FEATURE_X86_AVX2;
	public static final long OMR_FEATURE_X86_AVX512BW;
	public static final long OMR_FEATURE_X86_AVX512CD;
	public static final long OMR_FEATURE_X86_AVX512DQ;
	public static final long OMR_FEATURE_X86_AVX512ER;
	public static final long OMR_FEATURE_X86_AVX512F;
	public static final long OMR_FEATURE_X86_AVX512PF;
	public static final long OMR_FEATURE_X86_AVX512VL;
	public static final long OMR_FEATURE_X86_AVX512_IFMA;
	public static final long OMR_FEATURE_X86_BMI1;
	public static final long OMR_FEATURE_X86_BMI2;
	public static final long OMR_FEATURE_X86_CLFLUSHOPT;
	public static final long OMR_FEATURE_X86_CLFSH;
	public static final long OMR_FEATURE_X86_CLWB;
	public static final long OMR_FEATURE_X86_CMOV;
	public static final long OMR_FEATURE_X86_CMPXCHG16B;
	public static final long OMR_FEATURE_X86_CNXT_ID;
	public static final long OMR_FEATURE_X86_CX8;
	public static final long OMR_FEATURE_X86_DCA;
	public static final long OMR_FEATURE_X86_DE;
	public static final long OMR_FEATURE_X86_DEPRECATE_FPUCS;
	public static final long OMR_FEATURE_X86_DS;
	public static final long OMR_FEATURE_X86_DS_CPL;
	public static final long OMR_FEATURE_X86_DTES64;
	public static final long OMR_FEATURE_X86_EIST;
	public static final long OMR_FEATURE_X86_ERMSB;
	public static final long OMR_FEATURE_X86_F16C;
	public static final long OMR_FEATURE_X86_FDP_EXCPTN_ONLY;
	public static final long OMR_FEATURE_X86_FMA;
	public static final long OMR_FEATURE_X86_FPU;
	public static final long OMR_FEATURE_X86_FSGSBASE;
	public static final long OMR_FEATURE_X86_FXSR;
	public static final long OMR_FEATURE_X86_HLE;
	public static final long OMR_FEATURE_X86_HTT;
	public static final long OMR_FEATURE_X86_IA32_TSC_ADJUST;
	public static final long OMR_FEATURE_X86_INVPCID;
	public static final long OMR_FEATURE_X86_IPT;
	public static final long OMR_FEATURE_X86_MCA;
	public static final long OMR_FEATURE_X86_MCE;
	public static final long OMR_FEATURE_X86_MMX;
	public static final long OMR_FEATURE_X86_MONITOR;
	public static final long OMR_FEATURE_X86_MOVBE;
	public static final long OMR_FEATURE_X86_MPX;
	public static final long OMR_FEATURE_X86_MSR;
	public static final long OMR_FEATURE_X86_MTRR;
	public static final long OMR_FEATURE_X86_OSXSAVE;
	public static final long OMR_FEATURE_X86_PAE;
	public static final long OMR_FEATURE_X86_PAT;
	public static final long OMR_FEATURE_X86_PBE;
	public static final long OMR_FEATURE_X86_PCID;
	public static final long OMR_FEATURE_X86_PCLMULQDQ;
	public static final long OMR_FEATURE_X86_PDCM;
	public static final long OMR_FEATURE_X86_PGE;
	public static final long OMR_FEATURE_X86_POPCNT;
	public static final long OMR_FEATURE_X86_PSE;
	public static final long OMR_FEATURE_X86_PSE_36;
	public static final long OMR_FEATURE_X86_PSN;
	public static final long OMR_FEATURE_X86_RDRAND;
	public static final long OMR_FEATURE_X86_RDSEED;
	public static final long OMR_FEATURE_X86_RDT_A;
	public static final long OMR_FEATURE_X86_RDT_M;
	public static final long OMR_FEATURE_X86_RTM;
	public static final long OMR_FEATURE_X86_SDBG;
	public static final long OMR_FEATURE_X86_SEP;
	public static final long OMR_FEATURE_X86_SGX;
	public static final long OMR_FEATURE_X86_SHA;
	public static final long OMR_FEATURE_X86_SMAP;
	public static final long OMR_FEATURE_X86_SMEP;
	public static final long OMR_FEATURE_X86_SMX;
	public static final long OMR_FEATURE_X86_SS;
	public static final long OMR_FEATURE_X86_SSE;
	public static final long OMR_FEATURE_X86_SSE2;
	public static final long OMR_FEATURE_X86_SSE3;
	public static final long OMR_FEATURE_X86_SSE4_1;
	public static final long OMR_FEATURE_X86_SSE4_2;
	public static final long OMR_FEATURE_X86_SSSE3;
	public static final long OMR_FEATURE_X86_TM;
	public static final long OMR_FEATURE_X86_TM2;
	public static final long OMR_FEATURE_X86_TSC;
	public static final long OMR_FEATURE_X86_TSC_DEADLINE;
	public static final long OMR_FEATURE_X86_VME;
	public static final long OMR_FEATURE_X86_VMX;
	public static final long OMR_FEATURE_X86_X2APIC;
	public static final long OMR_FEATURE_X86_XSAVE;
	public static final long OMR_FEATURE_X86_XTPR;
	public static final long OMR_HWCAP_S390_DFP;
	public static final long OMR_HWCAP_S390_EIMM;
	public static final long OMR_HWCAP_S390_ESAN3;
	public static final long OMR_HWCAP_S390_ETF3EH;
	public static final long OMR_HWCAP_S390_GS;
	public static final long OMR_HWCAP_S390_HIGH_GPRS;
	public static final long OMR_HWCAP_S390_HPAGE;
	public static final long OMR_HWCAP_S390_LDISP;
	public static final long OMR_HWCAP_S390_MSA;
	public static final long OMR_HWCAP_S390_STFLE;
	public static final long OMR_HWCAP_S390_TE;
	public static final long OMR_HWCAP_S390_VXRS;
	public static final long OMR_HWCAP_S390_VXRS_BCD;
	public static final long OMR_HWCAP_S390_VXRS_EXT;
	public static final long OMR_HWCAP_S390_ZARCH;
	public static final long UNICODE_REPLACEMENT_CHARACTER;
	public static final long _XOPEN_SOURCE;
	public static final long _XOPEN_SOURCE_DEFINED;

	// Offsets

	public static final int _gp_handler_functionOffset_;
	public static final int _gp_infoOffset_;
	public static final int _gp_info_countOffset_;
	public static final int _gp_protectOffset_;
	public static final int _gp_register_handlerOffset_;
	public static final int _gp_shutdownOffset_;
	public static final int _gp_startupOffset_;
	public static final int _gs_deinitializeOffset_;
	public static final int _gs_disableOffset_;
	public static final int _gs_enableOffset_;
	public static final int _gs_initializeOffset_;
	public static final int _gs_isEnabledOffset_;
	public static final int _gs_params_initOffset_;
	public static final int _hypervisor_get_guest_memory_usageOffset_;
	public static final int _hypervisor_get_guest_processor_usageOffset_;
	public static final int _hypervisor_get_hypervisor_infoOffset_;
	public static final int _hypervisor_hypervisor_presentOffset_;
	public static final int _hypervisor_shutdownOffset_;
	public static final int _hypervisor_startupOffset_;
	public static final int _ipcmutex_acquireOffset_;
	public static final int _ipcmutex_releaseOffset_;
	public static final int _ipcmutex_shutdownOffset_;
	public static final int _ipcmutex_startupOffset_;
	public static final int _omrPortLibraryOffset_;
	public static final int _portGlobalsOffset_;
	public static final int _portVersionOffset_;
	public static final int _port_controlOffset_;
	public static final int _port_create_libraryOffset_;
	public static final int _port_init_libraryOffset_;
	public static final int _port_isFunctionOverriddenOffset_;
	public static final int _port_shutdown_libraryOffset_;
	public static final int _port_startup_libraryOffset_;
	public static final int _process_closeOffset_;
	public static final int _process_createOffset_;
	public static final int _process_getStreamOffset_;
	public static final int _process_get_availableOffset_;
	public static final int _process_get_exitCodeOffset_;
	public static final int _process_isCompleteOffset_;
	public static final int _process_readOffset_;
	public static final int _process_terminateOffset_;
	public static final int _process_waitforOffset_;
	public static final int _process_writeOffset_;
	public static final int _self_handleOffset_;
	public static final int _shmem_attachOffset_;
	public static final int _shmem_closeOffset_;
	public static final int _shmem_createDirOffset_;
	public static final int _shmem_destroyOffset_;
	public static final int _shmem_destroyDeprecatedOffset_;
	public static final int _shmem_detachOffset_;
	public static final int _shmem_findcloseOffset_;
	public static final int _shmem_findfirstOffset_;
	public static final int _shmem_findnextOffset_;
	public static final int _shmem_getDirOffset_;
	public static final int _shmem_getFilepathOffset_;
	public static final int _shmem_get_region_granularityOffset_;
	public static final int _shmem_getidOffset_;
	public static final int _shmem_handle_statOffset_;
	public static final int _shmem_openOffset_;
	public static final int _shmem_openDeprecatedOffset_;
	public static final int _shmem_protectOffset_;
	public static final int _shmem_shutdownOffset_;
	public static final int _shmem_startupOffset_;
	public static final int _shmem_statOffset_;
	public static final int _shmem_statDeprecatedOffset_;
	public static final int _shsem_closeOffset_;
	public static final int _shsem_deprecated_closeOffset_;
	public static final int _shsem_deprecated_destroyOffset_;
	public static final int _shsem_deprecated_destroyDeprecatedOffset_;
	public static final int _shsem_deprecated_getValOffset_;
	public static final int _shsem_deprecated_getidOffset_;
	public static final int _shsem_deprecated_handle_statOffset_;
	public static final int _shsem_deprecated_openOffset_;
	public static final int _shsem_deprecated_openDeprecatedOffset_;
	public static final int _shsem_deprecated_postOffset_;
	public static final int _shsem_deprecated_setValOffset_;
	public static final int _shsem_deprecated_shutdownOffset_;
	public static final int _shsem_deprecated_startupOffset_;
	public static final int _shsem_deprecated_waitOffset_;
	public static final int _shsem_destroyOffset_;
	public static final int _shsem_getValOffset_;
	public static final int _shsem_openOffset_;
	public static final int _shsem_params_initOffset_;
	public static final int _shsem_postOffset_;
	public static final int _shsem_setValOffset_;
	public static final int _shsem_shutdownOffset_;
	public static final int _shsem_startupOffset_;
	public static final int _shsem_waitOffset_;
	public static final int _sock_error_messageOffset_;
	public static final int _sock_freeaddrinfoOffset_;
	public static final int _sock_getaddrinfoOffset_;
	public static final int _sock_getaddrinfo_addressOffset_;
	public static final int _sock_getaddrinfo_create_hintsOffset_;
	public static final int _sock_getaddrinfo_familyOffset_;
	public static final int _sock_getaddrinfo_lengthOffset_;
	public static final int _sock_getaddrinfo_nameOffset_;
	public static final int _sock_gethostbyaddrOffset_;
	public static final int _sock_gethostbynameOffset_;
	public static final int _sock_inetaddrOffset_;
	public static final int _sock_shutdownOffset_;
	public static final int _sock_startupOffset_;
	public static final int _sysinfo_DLPAR_enabledOffset_;
	public static final int _sysinfo_DLPAR_max_CPUsOffset_;
	public static final int _sysinfo_get_cache_infoOffset_;
	public static final int _sysinfo_get_classpathSeparatorOffset_;
	public static final int _sysinfo_get_hw_infoOffset_;
	public static final int _sysinfo_get_processing_capacityOffset_;
	public static final int _sysinfo_get_processor_descriptionOffset_;
	public static final int _sysinfo_processor_has_featureOffset_;
	public static final int _sysinfo_shutdownOffset_;
	public static final int _sysinfo_startupOffset_;
	public static final int _sysinfo_weak_memory_consistencyOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		EsIsDir = 0;
		EsIsFile = 0;
		EsMaxPath = 0;
		EsOpenAppend = 0;
		EsOpenAsynchronous = 0;
		EsOpenCreate = 0;
		EsOpenCreateAlways = 0;
		EsOpenCreateNew = 0;
		EsOpenCreateNoTag = 0;
		EsOpenForInherit = 0;
		EsOpenForMapping = 0;
		EsOpenRead = 0;
		EsOpenShareDelete = 0;
		EsOpenSync = 0;
		EsOpenText = 0;
		EsOpenTruncate = 0;
		EsOpenWrite = 0;
		EsSeekCur = 0;
		EsSeekEnd = 0;
		EsSeekSet = 0;
		FLG_ACQUIRE_LOCK_NOWAIT = 0;
		FLG_ACQUIRE_LOCK_WAIT = 0;
		J9GP_CONTROL = 0;
		J9GP_CONTROL_PC = 0;
		J9GP_FPR = 0;
		J9GP_GPR = 0;
		J9GP_MODULE = 0;
		J9GP_MODULE_NAME = 0;
		J9GP_NUM_CATEGORIES = 0;
		J9GP_OTHER = 0;
		J9GP_SIGNAL = 0;
		J9GP_VALUE_16 = 0;
		J9GP_VALUE_32 = 0;
		J9GP_VALUE_64 = 0;
		J9GP_VALUE_ADDRESS = 0;
		J9GP_VALUE_FLOAT_64 = 0;
		J9GP_VALUE_STRING = 0;
		J9GP_VALUE_UNDEFINED = 0;
		J9MEMTAG_EYECATCHER_ALLOC_FOOTER = 0;
		J9MEMTAG_EYECATCHER_ALLOC_HEADER = 0;
		J9MEMTAG_EYECATCHER_FREED_FOOTER = 0;
		J9MEMTAG_EYECATCHER_FREED_HEADER = 0;
		J9MEMTAG_PADDING_BYTE = 0;
		J9MEMTAG_TAG_CORRUPTION = 0;
		J9MEMTAG_VERSION = 0;
		J9MEM_CATEGORIES_KEEP_ITERATING = 0;
		J9MEM_CATEGORIES_STOP_ITERATING = 0;
		J9NLS_BEGIN_MULTI_LINE = 0;
		J9NLS_CONFIG = 0;
		J9NLS_DO_NOT_APPEND_NEWLINE = 0;
		J9NLS_DO_NOT_PRINT_MESSAGE_TAG = 0;
		J9NLS_END_MULTI_LINE = 0;
		J9NLS_ERROR = 0;
		J9NLS_INFO = 0;
		J9NLS_MULTI_LINE = 0;
		J9NLS_STDERR = 0;
		J9NLS_STDOUT = 0;
		J9NLS_VITAL = 0;
		J9NLS_WARNING = 0;
		J9OSDUMP_EYECATCHER = 0;
		J9OSDUMP_SIZE = 0;
		J9PORT_CACHEINFO_DCACHE = 0;
		J9PORT_CACHEINFO_ICACHE = 0;
		J9PORT_CACHEINFO_TCACHE = 0;
		J9PORT_CACHEINFO_UCACHE = 0;
		J9PORT_CAPABILITY_ALLOCATE_TOP_DOWN = 0;
		J9PORT_CAPABILITY_BASE = 0;
		J9PORT_CAPABILITY_CAN_RESERVE_SPECIFIC_ADDRESS = 0;
		J9PORT_CAPABILITY_MASK_TOP_DOWN = 0;
		J9PORT_CAPABILITY_STANDARD = 0;
		J9PORT_CPU_BOUND = 0;
		J9PORT_CPU_ONLINE = 0;
		J9PORT_CPU_PHYSICAL = 0;
		J9PORT_CPU_TARGET = 0;
		J9PORT_DISABLE_ENSURE_CAP32 = 0;
		J9PORT_ERROR_BADF = 0;
		J9PORT_ERROR_FILE_EXIST = 0;
		J9PORT_ERROR_FILE_FSTAT_FAILED = 0;
		J9PORT_ERROR_FILE_LOCK_BADLOCK = 0;
		J9PORT_ERROR_FILE_LOCK_EDEADLK = 0;
		J9PORT_ERROR_FILE_NAMETOOLONG = 0;
		J9PORT_ERROR_FILE_NOENT = 0;
		J9PORT_ERROR_FILE_NOPERMISSION = 0;
		J9PORT_ERROR_FILE_NOTFOUND = 0;
		J9PORT_ERROR_FILE_OPFAILED = 0;
		J9PORT_ERROR_FILE_SYSTEMFULL = 0;
		J9PORT_ERROR_INVALID_ARGUMENTS = 0;
		J9PORT_ERROR_INVALID_HANDLE = 0;
		J9PORT_ERROR_NOTFOUND = 0;
		J9PORT_ERROR_NOT_SUPPORTED_ON_THIS_PLATFORM = 0;
		J9PORT_ERROR_OPFAILED = 0;
		J9PORT_ERROR_STARTUP_MEM = 0;
		J9PORT_ERROR_STARTUP_TLS_ALLOC = 0;
		J9PORT_ERROR_STRING_BUFFER_TOO_SMALL = 0;
		J9PORT_ERROR_STRING_ICONV_OPEN_FAILED = 0;
		J9PORT_ERROR_STRING_ILLEGAL_STRING = 0;
		J9PORT_ERROR_STRING_MEM_ALLOCATE_FAILED = 0;
		J9PORT_ERROR_STRING_UNSUPPORTED_ENCODING = 0;
		J9PORT_ERROR_SYSINFO_ENV_INIT_CRASHED_COPYING_BUFFER = 0;
		J9PORT_ERROR_SYSINFO_INSUFFICIENT_PRIVILEGE = 0;
		J9PORT_ERROR_SYSINFO_MEMORY_ALLOC_FAILED = 0;
		J9PORT_ERROR_SYSINFO_NOT_SUPPORTED = 0;
		J9PORT_ERROR_SYSINFO_OPFAILED = 0;
		J9PORT_ERROR_SYSTEM_CALL_CODE_SHIFT = 0;
		J9PORT_ERROR_SYSTEM_CALL_ERRNO_MASK = 0;
		J9PORT_ERROR_VMEM_INSUFFICENT_RESOURCES = 0;
		J9PORT_FILE_IGNORE_ID = 0;
		J9PORT_FILE_NOWAIT_FOR_LOCK = 0;
		J9PORT_FILE_READ_LOCK = 0;
		J9PORT_FILE_WAIT_FOR_LOCK = 0;
		J9PORT_FILE_WRITE_LOCK = 0;
		J9PORT_HWCAP_S390_DFP = 0;
		J9PORT_HWCAP_S390_EIMM = 0;
		J9PORT_HWCAP_S390_ESAN3 = 0;
		J9PORT_HWCAP_S390_ETF3EH = 0;
		J9PORT_HWCAP_S390_GS = 0;
		J9PORT_HWCAP_S390_HIGH_GPRS = 0;
		J9PORT_HWCAP_S390_HPAGE = 0;
		J9PORT_HWCAP_S390_LDISP = 0;
		J9PORT_HWCAP_S390_MSA = 0;
		J9PORT_HWCAP_S390_STFLE = 0;
		J9PORT_HWCAP_S390_TE = 0;
		J9PORT_HWCAP_S390_VXRS = 0;
		J9PORT_HWCAP_S390_VXRS_BCD = 0;
		J9PORT_HWCAP_S390_VXRS_EXT = 0;
		J9PORT_HWCAP_S390_ZARCH = 0;
		J9PORT_INFO_CONTROL_FILE_NOT_UNLINKED = 0;
		J9PORT_INFO_CONTROL_FILE_UNLINKED = 0;
		J9PORT_INFO_CONTROL_FILE_UNLINK_FAILED = 0;
		J9PORT_INFO_SHMEM_BASE = 0;
		J9PORT_INFO_SHMEM_CREATED = 0;
		J9PORT_INFO_SHMEM_OPENED = 0;
		J9PORT_INFO_SHMEM_OPENED_STALE = 0;
		J9PORT_INFO_SHMEM_OPEN_UNLINKED = 0;
		J9PORT_INFO_SHMEM_PARTIAL = 0;
		J9PORT_INFO_SHMEM_STAT_PASSED = 0;
		J9PORT_INFO_SHSEM_BASE = 0;
		J9PORT_INFO_SHSEM_CREATED = 0;
		J9PORT_INFO_SHSEM_OPENED = 0;
		J9PORT_INFO_SHSEM_OPENED_STALE = 0;
		J9PORT_INFO_SHSEM_OPEN_UNLINKED = 0;
		J9PORT_INFO_SHSEM_PARTIAL = 0;
		J9PORT_INFO_SHSEM_STAT_PASSED = 0;
		J9PORT_INVALID_FD = 0;
		J9PORT_LIMIT_HARD = 0;
		J9PORT_LIMIT_LIMITED = 0;
		J9PORT_LIMIT_UNLIMITED = 0;
		J9PORT_MAJOR_VERSION_NUMBER = 0;
		J9PORT_MEMINFO_NOT_AVAILABLE = 0;
		J9PORT_MINOR_VERSION_NUMBER = 0;
		J9PORT_MMAP_CAPABILITY_COPYONWRITE = 0;
		J9PORT_MMAP_CAPABILITY_MSYNC = 0;
		J9PORT_MMAP_CAPABILITY_PROTECT = 0;
		J9PORT_MMAP_CAPABILITY_READ = 0;
		J9PORT_MMAP_CAPABILITY_WRITE = 0;
		J9PORT_MMAP_FLAG_COPYONWRITE = 0;
		J9PORT_MMAP_FLAG_READ = 0;
		J9PORT_MMAP_FLAG_SHARED = 0;
		J9PORT_MMAP_FLAG_WRITE = 0;
		J9PORT_MMAP_SYNC_WAIT = 0;
		J9PORT_PAGE_PROTECT_NOT_SUPPORTED = 0;
		J9PORT_PAGE_PROTECT_READ = 0;
		J9PORT_PAGE_PROTECT_WRITE = 0;
		J9PORT_PPC_FEATURE_32 = 0;
		J9PORT_PPC_FEATURE_601_INSTR = 0;
		J9PORT_PPC_FEATURE_64 = 0;
		J9PORT_PPC_FEATURE_ARCH_2_05 = 0;
		J9PORT_PPC_FEATURE_ARCH_2_06 = 0;
		J9PORT_PPC_FEATURE_ARCH_2_07 = 0;
		J9PORT_PPC_FEATURE_BOOKE = 0;
		J9PORT_PPC_FEATURE_CELL_BE = 0;
		J9PORT_PPC_FEATURE_DSCR = 0;
		J9PORT_PPC_FEATURE_EBB = 0;
		J9PORT_PPC_FEATURE_HAS_4xxMAC = 0;
		J9PORT_PPC_FEATURE_HAS_ALTIVEC = 0;
		J9PORT_PPC_FEATURE_HAS_DFP = 0;
		J9PORT_PPC_FEATURE_HAS_EFP_DOUBLE = 0;
		J9PORT_PPC_FEATURE_HAS_EFP_SINGLE = 0;
		J9PORT_PPC_FEATURE_HAS_FPU = 0;
		J9PORT_PPC_FEATURE_HAS_MMU = 0;
		J9PORT_PPC_FEATURE_HAS_SPE = 0;
		J9PORT_PPC_FEATURE_HAS_VSX = 0;
		J9PORT_PPC_FEATURE_HTM = 0;
		J9PORT_PPC_FEATURE_ICACHE_SNOOP = 0;
		J9PORT_PPC_FEATURE_ISEL = 0;
		J9PORT_PPC_FEATURE_NO_TB = 0;
		J9PORT_PPC_FEATURE_PA6T = 0;
		J9PORT_PPC_FEATURE_POWER4 = 0;
		J9PORT_PPC_FEATURE_POWER5 = 0;
		J9PORT_PPC_FEATURE_POWER5_PLUS = 0;
		J9PORT_PPC_FEATURE_POWER6_EXT = 0;
		J9PORT_PPC_FEATURE_PPC_LE = 0;
		J9PORT_PPC_FEATURE_PSERIES_PERFMON_COMPAT = 0;
		J9PORT_PPC_FEATURE_SMT = 0;
		J9PORT_PPC_FEATURE_TAR = 0;
		J9PORT_PPC_FEATURE_TRUE_LE = 0;
		J9PORT_PPC_FEATURE_UNIFIED_CACHE = 0;
		J9PORT_PROCESS_CREATE_NEW_PROCESS_GROUP = 0;
		J9PORT_PROCESS_DO_NOT_CLOSE_STREAMS = 0;
		J9PORT_PROCESS_IGNORE_OUTPUT = 0;
		J9PORT_PROCESS_INHERIT_STDERR = 0;
		J9PORT_PROCESS_INHERIT_STDIN = 0;
		J9PORT_PROCESS_INHERIT_STDOUT = 0;
		J9PORT_PROCESS_NONBLOCKING_IO = 0;
		J9PORT_PROCESS_PIPE_TO_PARENT = 0;
		J9PORT_PROCESS_REDIRECT_STDERR_TO_STDOUT = 0;
		J9PORT_PROCESS_STDERR = 0;
		J9PORT_PROCESS_STDIN = 0;
		J9PORT_PROCESS_STDOUT = 0;
		J9PORT_PROCINFO_NOT_AVAILABLE = 0;
		J9PORT_PROCINFO_PROC_ONLINE = 0;
		J9PORT_RESOURCE_ADDRESS_SPACE = 0;
		J9PORT_RESOURCE_CORE_FILE = 0;
		J9PORT_RESOURCE_CORE_FLAGS = 0;
		J9PORT_RESOURCE_FILE_DESCRIPTORS = 0;
		J9PORT_RESOURCE_SHARED_MEMORY = 0;
		J9PORT_S390_FEATURE_COMPARE_AND_SWAP_AND_STORE = 0;
		J9PORT_S390_FEATURE_COMPARE_AND_SWAP_AND_STORE2 = 0;
		J9PORT_S390_FEATURE_DFP = 0;
		J9PORT_S390_FEATURE_ESAN3 = 0;
		J9PORT_S390_FEATURE_ETF3_ENHANCEMENT = 0;
		J9PORT_S390_FEATURE_EXECUTE_EXTENSIONS = 0;
		J9PORT_S390_FEATURE_EXTENDED_IMMEDIATE = 0;
		J9PORT_S390_FEATURE_EXTENDED_TRANSLATION_3 = 0;
		J9PORT_S390_FEATURE_FPE = 0;
		J9PORT_S390_FEATURE_GENERAL_INSTRUCTIONS_EXTENSIONS = 0;
		J9PORT_S390_FEATURE_GUARDED_STORAGE = 0;
		J9PORT_S390_FEATURE_HIGH_WORD = 0;
		J9PORT_S390_FEATURE_HPAGE = 0;
		J9PORT_S390_FEATURE_LOAD_AND_ZERO_RIGHTMOST_BYTE = 0;
		J9PORT_S390_FEATURE_LOAD_STORE_ON_CONDITION_1 = 0;
		J9PORT_S390_FEATURE_LOAD_STORE_ON_CONDITION_2 = 0;
		J9PORT_S390_FEATURE_LONG_DISPLACEMENT = 0;
		J9PORT_S390_FEATURE_MISCELLANEOUS_INSTRUCTION_EXTENSION = 0;
		J9PORT_S390_FEATURE_MISCELLANEOUS_INSTRUCTION_EXTENSION_2 = 0;
		J9PORT_S390_FEATURE_MISCELLANEOUS_INSTRUCTION_EXTENSION_3 = 0;
		J9PORT_S390_FEATURE_MSA = 0;
		J9PORT_S390_FEATURE_MSA_EXTENSION3 = 0;
		J9PORT_S390_FEATURE_MSA_EXTENSION4 = 0;
		J9PORT_S390_FEATURE_MSA_EXTENSION_5 = 0;
		J9PORT_S390_FEATURE_MSA_EXTENSION_8 = 0;
		J9PORT_S390_FEATURE_RI = 0;
		J9PORT_S390_FEATURE_SEMAPHORE_ASSIST = 0;
		J9PORT_S390_FEATURE_SIDE_EFFECT_ACCESS = 0;
		J9PORT_S390_FEATURE_STFLE = 0;
		J9PORT_S390_FEATURE_TE = 0;
		J9PORT_S390_FEATURE_VECTOR_FACILITY = 0;
		J9PORT_S390_FEATURE_VECTOR_FACILITY_ENHANCEMENT_1 = 0;
		J9PORT_S390_FEATURE_VECTOR_FACILITY_ENHANCEMENT_2 = 0;
		J9PORT_S390_FEATURE_VECTOR_PACKED_DECIMAL = 0;
		J9PORT_S390_FEATURE_VECTOR_PACKED_DECIMAL_ENHANCEMENT_FACILITY = 0;
		J9PORT_S390_FEATURE_ZARCH = 0;
		J9PORT_SHMEM_EYECATCHER_LENGTH = 0;
		J9PORT_SHSEM_MODE_DEFAULT = 0;
		J9PORT_SHSEM_MODE_NOWAIT = 0;
		J9PORT_SHSEM_MODE_UNDO = 0;
		J9PORT_SIG_CONTROL = 0;
		J9PORT_SIG_CONTROL_BP = 0;
		J9PORT_SIG_CONTROL_PC = 0;
		J9PORT_SIG_CONTROL_POWERPC_CR = 0;
		J9PORT_SIG_CONTROL_POWERPC_CTR = 0;
		J9PORT_SIG_CONTROL_POWERPC_DAR = 0;
		J9PORT_SIG_CONTROL_POWERPC_DSIR = 0;
		J9PORT_SIG_CONTROL_POWERPC_FPSCR = 0;
		J9PORT_SIG_CONTROL_POWERPC_LR = 0;
		J9PORT_SIG_CONTROL_POWERPC_MQ = 0;
		J9PORT_SIG_CONTROL_POWERPC_MSR = 0;
		J9PORT_SIG_CONTROL_POWERPC_XER = 0;
		J9PORT_SIG_CONTROL_S390_BEA = 0;
		J9PORT_SIG_CONTROL_S390_FPC = 0;
		J9PORT_SIG_CONTROL_S390_GPR7 = 0;
		J9PORT_SIG_CONTROL_SP = 0;
		J9PORT_SIG_CONTROL_X86_EFLAGS = 0;
		J9PORT_SIG_ERROR = 0;
		J9PORT_SIG_EXCEPTION_CONTINUE_EXECUTION = 0;
		J9PORT_SIG_EXCEPTION_CONTINUE_SEARCH = 0;
		J9PORT_SIG_EXCEPTION_COOPERATIVE_SHUTDOWN = 0;
		J9PORT_SIG_EXCEPTION_OCCURRED = 0;
		J9PORT_SIG_EXCEPTION_RETURN = 0;
		J9PORT_SIG_FLAG_MAY_CONTINUE_EXECUTION = 0;
		J9PORT_SIG_FLAG_MAY_RETURN = 0;
		J9PORT_SIG_FLAG_SIGABEND = 0;
		J9PORT_SIG_FLAG_SIGABRT = 0;
		J9PORT_SIG_FLAG_SIGALLSYNC = 0;
		J9PORT_SIG_FLAG_SIGBUS = 0;
		J9PORT_SIG_FLAG_SIGFPE = 0;
		J9PORT_SIG_FLAG_SIGFPE_DIV_BY_ZERO = 0;
		J9PORT_SIG_FLAG_SIGFPE_INT_DIV_BY_ZERO = 0;
		J9PORT_SIG_FLAG_SIGFPE_INT_OVERFLOW = 0;
		J9PORT_SIG_FLAG_SIGILL = 0;
		J9PORT_SIG_FLAG_SIGINT = 0;
		J9PORT_SIG_FLAG_SIGQUIT = 0;
		J9PORT_SIG_FLAG_SIGRECONFIG = 0;
		J9PORT_SIG_FLAG_SIGSEGV = 0;
		J9PORT_SIG_FLAG_SIGTERM = 0;
		J9PORT_SIG_FLAG_SIGTRAP = 0;
		J9PORT_SIG_FLAG_SIGXFSZ = 0;
		J9PORT_SIG_FPR = 0;
		J9PORT_SIG_GPR = 0;
		J9PORT_SIG_GPR_AMD64_R10 = 0;
		J9PORT_SIG_GPR_AMD64_R11 = 0;
		J9PORT_SIG_GPR_AMD64_R12 = 0;
		J9PORT_SIG_GPR_AMD64_R13 = 0;
		J9PORT_SIG_GPR_AMD64_R14 = 0;
		J9PORT_SIG_GPR_AMD64_R15 = 0;
		J9PORT_SIG_GPR_AMD64_R8 = 0;
		J9PORT_SIG_GPR_AMD64_R9 = 0;
		J9PORT_SIG_GPR_AMD64_RAX = 0;
		J9PORT_SIG_GPR_AMD64_RBX = 0;
		J9PORT_SIG_GPR_AMD64_RCX = 0;
		J9PORT_SIG_GPR_AMD64_RDI = 0;
		J9PORT_SIG_GPR_AMD64_RDX = 0;
		J9PORT_SIG_GPR_AMD64_RSI = 0;
		J9PORT_SIG_GPR_ARM_R0 = 0;
		J9PORT_SIG_GPR_ARM_R1 = 0;
		J9PORT_SIG_GPR_ARM_R10 = 0;
		J9PORT_SIG_GPR_ARM_R2 = 0;
		J9PORT_SIG_GPR_ARM_R3 = 0;
		J9PORT_SIG_GPR_ARM_R4 = 0;
		J9PORT_SIG_GPR_ARM_R5 = 0;
		J9PORT_SIG_GPR_ARM_R6 = 0;
		J9PORT_SIG_GPR_ARM_R7 = 0;
		J9PORT_SIG_GPR_ARM_R8 = 0;
		J9PORT_SIG_GPR_ARM_R9 = 0;
		J9PORT_SIG_GPR_X86_EAX = 0;
		J9PORT_SIG_GPR_X86_EBX = 0;
		J9PORT_SIG_GPR_X86_ECX = 0;
		J9PORT_SIG_GPR_X86_EDI = 0;
		J9PORT_SIG_GPR_X86_EDX = 0;
		J9PORT_SIG_GPR_X86_ESI = 0;
		J9PORT_SIG_MODULE = 0;
		J9PORT_SIG_MODULE_NAME = 0;
		J9PORT_SIG_NO_EXCEPTION = 0;
		J9PORT_SIG_NUM_CATEGORIES = 0;
		J9PORT_SIG_OPTIONS_COOPERATIVE_SHUTDOWN = 0;
		J9PORT_SIG_OPTIONS_OMRSIG_NO_CHAIN = 0;
		J9PORT_SIG_OPTIONS_REDUCED_SIGNALS_ASYNCHRONOUS = 0;
		J9PORT_SIG_OPTIONS_REDUCED_SIGNALS_SYNCHRONOUS = 0;
		J9PORT_SIG_OPTIONS_SIGXFSZ = 0;
		J9PORT_SIG_OPTIONS_ZOS_USE_CEEHDLR = 0;
		J9PORT_SIG_OTHER = 0;
		J9PORT_SIG_SIGNAL = 0;
		J9PORT_SIG_SIGNAL_ADDRESS = 0;
		J9PORT_SIG_SIGNAL_CODE = 0;
		J9PORT_SIG_SIGNAL_ERROR_VALUE = 0;
		J9PORT_SIG_SIGNAL_HANDLER = 0;
		J9PORT_SIG_SIGNAL_INACCESSIBLE_ADDRESS = 0;
		J9PORT_SIG_SIGNAL_PLATFORM_SIGNAL_TYPE = 0;
		J9PORT_SIG_SIGNAL_TYPE = 0;
		J9PORT_SIG_SIGNAL_ZOS_CONDITION_FACILITY_ID = 0;
		J9PORT_SIG_SIGNAL_ZOS_CONDITION_FEEDBACK_TOKEN = 0;
		J9PORT_SIG_SIGNAL_ZOS_CONDITION_INFORMATION_BLOCK = 0;
		J9PORT_SIG_SIGNAL_ZOS_CONDITION_MESSAGE_NUMBER = 0;
		J9PORT_SIG_SIGNAL_ZOS_CONDITION_SEVERITY = 0;
		J9PORT_SIG_VALUE_128 = 0;
		J9PORT_SIG_VALUE_16 = 0;
		J9PORT_SIG_VALUE_32 = 0;
		J9PORT_SIG_VALUE_64 = 0;
		J9PORT_SIG_VALUE_ADDRESS = 0;
		J9PORT_SIG_VALUE_FLOAT_64 = 0;
		J9PORT_SIG_VALUE_STRING = 0;
		J9PORT_SIG_VALUE_UNDEFINED = 0;
		J9PORT_SIG_VR = 0;
		J9PORT_SIG_WINDOWS_DEFER_TRY_EXCEPT_HANDLER = 0;
		J9PORT_SLOPEN_DECORATE = 0;
		J9PORT_SLOPEN_LAZY = 0;
		J9PORT_SLOPEN_NO_LOOKUP_MSG_FOR_NOT_FOUND = 0;
		J9PORT_SLOPEN_OPEN_EXECUTABLE = 0;
		J9PORT_SL_FOUND = 0;
		J9PORT_SL_NOT_FOUND = 0;
		J9PORT_SYSINFO_FEATURES_SIZE = 0;
		J9PORT_SYSINFO_GET_HW_INFO_ERROR = 0;
		J9PORT_SYSINFO_GET_HW_INFO_MODEL = 0;
		J9PORT_SYSINFO_GET_HW_INFO_NOT_AVAILABLE = 0;
		J9PORT_SYSINFO_GET_HW_INFO_SUCCESS = 0;
		J9PORT_SYSINFO_HW_INFO_MODEL_BUF_LENGTH = 0;
		J9PORT_TIME_DELTA_IN_MICROSECONDS = 0;
		J9PORT_TIME_DELTA_IN_MILLISECONDS = 0;
		J9PORT_TIME_NS_PER_MS = 0;
		J9PORT_TIME_US_PER_SEC = 0;
		J9PORT_TTY_ERR = 0;
		J9PORT_TTY_OUT = 0;
		J9PORT_VMEM_ADDRESS_HINT = 0;
		J9PORT_VMEM_ALLOCATE_TOP_DOWN = 0;
		J9PORT_VMEM_ALLOC_DIR_BOTTOM_UP = 0;
		J9PORT_VMEM_ALLOC_DIR_TOP_DOWN = 0;
		J9PORT_VMEM_ALLOC_QUICK = 0;
		J9PORT_VMEM_MEMORY_MODE_COMMIT = 0;
		J9PORT_VMEM_MEMORY_MODE_EXECUTE = 0;
		J9PORT_VMEM_MEMORY_MODE_READ = 0;
		J9PORT_VMEM_MEMORY_MODE_VIRTUAL = 0;
		J9PORT_VMEM_MEMORY_MODE_WRITE = 0;
		J9PORT_VMEM_NO_AFFINITY = 0;
		J9PORT_VMEM_PAGE_FLAG_FIXED = 0;
		J9PORT_VMEM_PAGE_FLAG_NOT_USED = 0;
		J9PORT_VMEM_PAGE_FLAG_PAGEABLE = 0;
		J9PORT_VMEM_STRICT_ADDRESS = 0;
		J9PORT_VMEM_STRICT_PAGE_SIZE = 0;
		J9PORT_VMEM_ZOS_USE_EXTENDED_PRIVATE_AREA = 0;
		J9PORT_VMEM_ZTPF_USE_31BIT_MALLOC = 0;
		J9PORT_X86_FEATURE_10 = 0;
		J9PORT_X86_FEATURE_11 = 0;
		J9PORT_X86_FEATURE_16 = 0;
		J9PORT_X86_FEATURE_20 = 0;
		J9PORT_X86_FEATURE_22 = 0;
		J9PORT_X86_FEATURE_30 = 0;
		J9PORT_X86_FEATURE_ACPI = 0;
		J9PORT_X86_FEATURE_ADX = 0;
		J9PORT_X86_FEATURE_AESNI = 0;
		J9PORT_X86_FEATURE_APIC = 0;
		J9PORT_X86_FEATURE_AVX = 0;
		J9PORT_X86_FEATURE_AVX2 = 0;
		J9PORT_X86_FEATURE_AVX512BW = 0;
		J9PORT_X86_FEATURE_AVX512CD = 0;
		J9PORT_X86_FEATURE_AVX512DQ = 0;
		J9PORT_X86_FEATURE_AVX512ER = 0;
		J9PORT_X86_FEATURE_AVX512F = 0;
		J9PORT_X86_FEATURE_AVX512PF = 0;
		J9PORT_X86_FEATURE_AVX512VL = 0;
		J9PORT_X86_FEATURE_AVX512_IFMA = 0;
		J9PORT_X86_FEATURE_BMI1 = 0;
		J9PORT_X86_FEATURE_BMI2 = 0;
		J9PORT_X86_FEATURE_CLFLUSHOPT = 0;
		J9PORT_X86_FEATURE_CLFSH = 0;
		J9PORT_X86_FEATURE_CLWB = 0;
		J9PORT_X86_FEATURE_CMOV = 0;
		J9PORT_X86_FEATURE_CMPXCHG16B = 0;
		J9PORT_X86_FEATURE_CNXT_ID = 0;
		J9PORT_X86_FEATURE_CX8 = 0;
		J9PORT_X86_FEATURE_DCA = 0;
		J9PORT_X86_FEATURE_DE = 0;
		J9PORT_X86_FEATURE_DEPRECATE_FPUCS = 0;
		J9PORT_X86_FEATURE_DS = 0;
		J9PORT_X86_FEATURE_DS_CPL = 0;
		J9PORT_X86_FEATURE_DTES64 = 0;
		J9PORT_X86_FEATURE_EIST = 0;
		J9PORT_X86_FEATURE_ERMSB = 0;
		J9PORT_X86_FEATURE_F16C = 0;
		J9PORT_X86_FEATURE_FDP_EXCPTN_ONLY = 0;
		J9PORT_X86_FEATURE_FMA = 0;
		J9PORT_X86_FEATURE_FPU = 0;
		J9PORT_X86_FEATURE_FSGSBASE = 0;
		J9PORT_X86_FEATURE_FXSR = 0;
		J9PORT_X86_FEATURE_HLE = 0;
		J9PORT_X86_FEATURE_HTT = 0;
		J9PORT_X86_FEATURE_IA32_TSC_ADJUST = 0;
		J9PORT_X86_FEATURE_INVPCID = 0;
		J9PORT_X86_FEATURE_IPT = 0;
		J9PORT_X86_FEATURE_MCA = 0;
		J9PORT_X86_FEATURE_MCE = 0;
		J9PORT_X86_FEATURE_MMX = 0;
		J9PORT_X86_FEATURE_MONITOR = 0;
		J9PORT_X86_FEATURE_MOVBE = 0;
		J9PORT_X86_FEATURE_MPX = 0;
		J9PORT_X86_FEATURE_MSR = 0;
		J9PORT_X86_FEATURE_MTRR = 0;
		J9PORT_X86_FEATURE_OSXSAVE = 0;
		J9PORT_X86_FEATURE_PAE = 0;
		J9PORT_X86_FEATURE_PAT = 0;
		J9PORT_X86_FEATURE_PBE = 0;
		J9PORT_X86_FEATURE_PCID = 0;
		J9PORT_X86_FEATURE_PCLMULQDQ = 0;
		J9PORT_X86_FEATURE_PDCM = 0;
		J9PORT_X86_FEATURE_PGE = 0;
		J9PORT_X86_FEATURE_POPCNT = 0;
		J9PORT_X86_FEATURE_PSE = 0;
		J9PORT_X86_FEATURE_PSE_36 = 0;
		J9PORT_X86_FEATURE_PSN = 0;
		J9PORT_X86_FEATURE_RDRAND = 0;
		J9PORT_X86_FEATURE_RDSEED = 0;
		J9PORT_X86_FEATURE_RDT_A = 0;
		J9PORT_X86_FEATURE_RDT_M = 0;
		J9PORT_X86_FEATURE_RTM = 0;
		J9PORT_X86_FEATURE_SEP = 0;
		J9PORT_X86_FEATURE_SGX = 0;
		J9PORT_X86_FEATURE_SHA = 0;
		J9PORT_X86_FEATURE_SMAP = 0;
		J9PORT_X86_FEATURE_SMEP = 0;
		J9PORT_X86_FEATURE_SMX = 0;
		J9PORT_X86_FEATURE_SS = 0;
		J9PORT_X86_FEATURE_SSE = 0;
		J9PORT_X86_FEATURE_SSE2 = 0;
		J9PORT_X86_FEATURE_SSE3 = 0;
		J9PORT_X86_FEATURE_SSE4_1 = 0;
		J9PORT_X86_FEATURE_SSE4_2 = 0;
		J9PORT_X86_FEATURE_SSSE3 = 0;
		J9PORT_X86_FEATURE_TM = 0;
		J9PORT_X86_FEATURE_TM2 = 0;
		J9PORT_X86_FEATURE_TSC = 0;
		J9PORT_X86_FEATURE_TSC_DEADLINE = 0;
		J9PORT_X86_FEATURE_VME = 0;
		J9PORT_X86_FEATURE_VMX = 0;
		J9PORT_X86_FEATURE_X2APIC = 0;
		J9PORT_X86_FEATURE_XSAVE = 0;
		J9PORT_X86_FEATURE_XTPR = 0;
		J9SHMEM_GETDIR_APPEND_BASEDIR = 0;
		J9SHMEM_GETDIR_USE_USERHOME = 0;
		J9SHMEM_NO_FLAGS = 0;
		J9SHMEM_OPEN_DO_NOT_CREATE = 0;
		J9SHMEM_OPEN_FOR_DESTROY = 0;
		J9SHMEM_OPEN_FOR_STATS = 0;
		J9SHMEM_PRINT_STORAGE_KEY_WARNING = 0;
		J9SHMEM_STORAGE_KEY_TESTING = 0;
		J9SHMEM_STORAGE_KEY_TESTING_MASK = 0;
		J9SHSEM_NO_FLAGS = 0;
		J9SHSEM_OPEN_DO_NOT_CREATE = 0;
		J9SHSEM_OPEN_FOR_DESTROY = 0;
		J9SHSEM_OPEN_FOR_STATS = 0;
		J9SH_BASEFILEPERM = 0;
		J9SH_BASEFILEPERM_GROUP_RW_ACCESS = 0;
		J9SH_DIRPERM = 0;
		J9SH_DIRPERM_ABSENT = 0;
		J9SH_DIRPERM_ABSENT_GROUPACCESS = 0;
		J9SH_DIRPERM_DEFAULT = 0;
		J9SH_DIRPERM_DEFAULT_TMP = 0;
		J9SH_DIRPERM_DEFAULT_WITH_STICKYBIT = 0;
		J9SH_DIRPERM_GROUPACCESS = 0;
		J9SH_MAXPATH = 0;
		J9SH_MAX_PROJ_ID = 0;
		J9SH_PARENTDIRPERM = 0;
		J9SH_SHMEM_PERM_READ = 0;
		J9SH_SHMEM_PERM_READ_WRITE = 0;
		J9SH_SYSV_OLDER_CONTROL_FILE = 0;
		J9SH_SYSV_OLDER_EMPTY_CONTROL_FILE = 0;
		J9SH_SYSV_REGULAR_CONTROL_FILE = 0;
		J9STR_CODE_EBCDIC = 0;
		J9STR_CODE_LATIN1 = 0;
		J9STR_CODE_MUTF8 = 0;
		J9STR_CODE_PLATFORM_OMR_INTERNAL = 0;
		J9STR_CODE_PLATFORM_RAW = 0;
		J9STR_CODE_UTF8 = 0;
		J9STR_CODE_WIDE = 0;
		J9STR_CODE_WINDEFAULTACP = 0;
		J9STR_CODE_WINTHREADACP = 0;
		LS_INITIALIZED = 0;
		LS_INITIALIZING = 0;
		LS_LOCKED = 0;
		LS_UNINITIALIZED = 0;
		MAX_SIZE_TOTAL_GPINFO = 0;
		MAX_STRING_TERMINATOR_LENGTH = 0;
		NANOSECS_PER_USEC = 0;
		OMRMEM_CATEGORY_PORT_LIBRARY = 0;
		OMRMEM_CATEGORY_PORT_LIBRARY_UNUSED_ALLOCATE32_REGIONS = 0;
		OMRMEM_CATEGORY_UNKNOWN = 0;
		OMRPORT_CPU_BOUND = 0;
		OMRPORT_CPU_ONLINE = 0;
		OMRPORT_CPU_PHYSICAL = 0;
		OMRPORT_CPU_TARGET = 0;
		OMRPORT_DISABLE_ENSURE_CAP32 = 0;
		OMRPORT_ENABLE_ENSURE_CAP32 = 0;
		OMRPORT_ENSURE_CAPACITY_FAILED = 0;
		OMRPORT_ENSURE_CAPACITY_NOT_REQUIRED = 0;
		OMRPORT_ENSURE_CAPACITY_SUCCESS = 0;
		OMRPORT_FILESTREAM_FULL_BUFFERING = 0;
		OMRPORT_FILESTREAM_LINE_BUFFERING = 0;
		OMRPORT_FILESTREAM_NO_BUFFERING = 0;
		OMRPORT_FILE_IGNORE_ID = 0;
		OMRPORT_FILE_NOWAIT_FOR_LOCK = 0;
		OMRPORT_FILE_READ_LOCK = 0;
		OMRPORT_FILE_WAIT_FOR_LOCK = 0;
		OMRPORT_FILE_WRITE_LOCK = 0;
		OMRPORT_INFO_CONTROL_FILE_NOT_UNLINKED = 0;
		OMRPORT_INFO_CONTROL_FILE_UNLINKED = 0;
		OMRPORT_INFO_CONTROL_FILE_UNLINK_FAILED = 0;
		OMRPORT_INFO_SHMEM_BASE = 0;
		OMRPORT_INFO_SHMEM_CREATED = 0;
		OMRPORT_INFO_SHMEM_OPENED = 0;
		OMRPORT_INFO_SHMEM_OPENED_STALE = 0;
		OMRPORT_INFO_SHMEM_OPEN_UNLINKED = 0;
		OMRPORT_INFO_SHMEM_PARTIAL = 0;
		OMRPORT_INFO_SHMEM_STAT_PASSED = 0;
		OMRPORT_INFO_SHSEM_BASE = 0;
		OMRPORT_INFO_SHSEM_CREATED = 0;
		OMRPORT_INFO_SHSEM_OPENED = 0;
		OMRPORT_INFO_SHSEM_OPENED_STALE = 0;
		OMRPORT_INFO_SHSEM_OPEN_UNLINKED = 0;
		OMRPORT_INFO_SHSEM_PARTIAL = 0;
		OMRPORT_INFO_SHSEM_STAT_PASSED = 0;
		OMRPORT_INVALID_FD = 0;
		OMRPORT_LIMIT_BASE = 0;
		OMRPORT_LIMIT_HARD = 0;
		OMRPORT_LIMIT_LIMITED = 0;
		OMRPORT_LIMIT_SOFT = 0;
		OMRPORT_LIMIT_UNKNOWN = 0;
		OMRPORT_LIMIT_UNKNOWN_VALUE = 0;
		OMRPORT_LIMIT_UNLIMITED = 0;
		OMRPORT_LIMIT_UNLIMITED_VALUE = 0;
		OMRPORT_MEMINFO_NOT_AVAILABLE = 0;
		OMRPORT_MMAP_CAPABILITY_COPYONWRITE = 0;
		OMRPORT_MMAP_CAPABILITY_MSYNC = 0;
		OMRPORT_MMAP_CAPABILITY_PROTECT = 0;
		OMRPORT_MMAP_CAPABILITY_READ = 0;
		OMRPORT_MMAP_CAPABILITY_UMAP_REQUIRES_SIZE = 0;
		OMRPORT_MMAP_CAPABILITY_WRITE = 0;
		OMRPORT_MMAP_FLAG_COPYONWRITE = 0;
		OMRPORT_MMAP_FLAG_CREATE_FILE = 0;
		OMRPORT_MMAP_FLAG_EXECUTABLE = 0;
		OMRPORT_MMAP_FLAG_PRIVATE = 0;
		OMRPORT_MMAP_FLAG_READ = 0;
		OMRPORT_MMAP_FLAG_SHARED = 0;
		OMRPORT_MMAP_FLAG_WRITE = 0;
		OMRPORT_MMAP_SYNC_ASYNC = 0;
		OMRPORT_MMAP_SYNC_INVALIDATE = 0;
		OMRPORT_MMAP_SYNC_WAIT = 0;
		OMRPORT_PAGE_PROTECT_EXEC = 0;
		OMRPORT_PAGE_PROTECT_NONE = 0;
		OMRPORT_PAGE_PROTECT_NOT_SUPPORTED = 0;
		OMRPORT_PAGE_PROTECT_READ = 0;
		OMRPORT_PAGE_PROTECT_WRITE = 0;
		OMRPORT_PROCINFO_NOT_AVAILABLE = 0;
		OMRPORT_PROCINFO_PROC_OFFLINE = 0;
		OMRPORT_PROCINFO_PROC_ONLINE = 0;
		OMRPORT_RESOURCE_ADDRESS_SPACE = 0;
		OMRPORT_RESOURCE_CORE_FILE = 0;
		OMRPORT_RESOURCE_CORE_FLAGS = 0;
		OMRPORT_RESOURCE_DATA = 0;
		OMRPORT_RESOURCE_FILE_DESCRIPTORS = 0;
		OMRPORT_RESOURCE_SHARED_MEMORY = 0;
		OMRPORT_SHMEM_EYECATCHER_LENGTH = 0;
		OMRPORT_SHSEM_MODE_DEFAULT = 0;
		OMRPORT_SHSEM_MODE_NOWAIT = 0;
		OMRPORT_SHSEM_MODE_UNDO = 0;
		OMRPORT_SIG_CONTROL = 0;
		OMRPORT_SIG_CONTROL_BP = 0;
		OMRPORT_SIG_CONTROL_PC = 0;
		OMRPORT_SIG_CONTROL_POWERPC_CR = 0;
		OMRPORT_SIG_CONTROL_POWERPC_CTR = 0;
		OMRPORT_SIG_CONTROL_POWERPC_DAR = 0;
		OMRPORT_SIG_CONTROL_POWERPC_DSIR = 0;
		OMRPORT_SIG_CONTROL_POWERPC_FPSCR = 0;
		OMRPORT_SIG_CONTROL_POWERPC_LR = 0;
		OMRPORT_SIG_CONTROL_POWERPC_MQ = 0;
		OMRPORT_SIG_CONTROL_POWERPC_MSR = 0;
		OMRPORT_SIG_CONTROL_POWERPC_XER = 0;
		OMRPORT_SIG_CONTROL_S390_BEA = 0;
		OMRPORT_SIG_CONTROL_S390_FPC = 0;
		OMRPORT_SIG_CONTROL_S390_GPR7 = 0;
		OMRPORT_SIG_CONTROL_SP = 0;
		OMRPORT_SIG_CONTROL_X86_EFLAGS = 0;
		OMRPORT_SIG_ERROR = 0;
		OMRPORT_SIG_EXCEPTION_CONTINUE_EXECUTION = 0;
		OMRPORT_SIG_EXCEPTION_CONTINUE_SEARCH = 0;
		OMRPORT_SIG_EXCEPTION_COOPERATIVE_SHUTDOWN = 0;
		OMRPORT_SIG_EXCEPTION_OCCURRED = 0;
		OMRPORT_SIG_EXCEPTION_RETURN = 0;
		OMRPORT_SIG_FLAG_CONTROL_BITS_MASK = 0;
		OMRPORT_SIG_FLAG_IS_ASYNC = 0;
		OMRPORT_SIG_FLAG_IS_SYNC = 0;
		OMRPORT_SIG_FLAG_MAY_CONTINUE_EXECUTION = 0;
		OMRPORT_SIG_FLAG_MAY_RETURN = 0;
		OMRPORT_SIG_FLAG_SIGABEND = 0;
		OMRPORT_SIG_FLAG_SIGABRT = 0;
		OMRPORT_SIG_FLAG_SIGALLASYNC = 0;
		OMRPORT_SIG_FLAG_SIGALLSYNC = 0;
		OMRPORT_SIG_FLAG_SIGALRM = 0;
		OMRPORT_SIG_FLAG_SIGBUS = 0;
		OMRPORT_SIG_FLAG_SIGCHLD = 0;
		OMRPORT_SIG_FLAG_SIGCONT = 0;
		OMRPORT_SIG_FLAG_SIGFPE = 0;
		OMRPORT_SIG_FLAG_SIGFPE_DIV_BY_ZERO = 0;
		OMRPORT_SIG_FLAG_SIGFPE_INT_DIV_BY_ZERO = 0;
		OMRPORT_SIG_FLAG_SIGFPE_INT_OVERFLOW = 0;
		OMRPORT_SIG_FLAG_SIGHUP = 0;
		OMRPORT_SIG_FLAG_SIGILL = 0;
		OMRPORT_SIG_FLAG_SIGINFO = 0;
		OMRPORT_SIG_FLAG_SIGINT = 0;
		OMRPORT_SIG_FLAG_SIGIO = 0;
		OMRPORT_SIG_FLAG_SIGIOT = 0;
		OMRPORT_SIG_FLAG_SIGPIPE = 0;
		OMRPORT_SIG_FLAG_SIGPOLL = 0;
		OMRPORT_SIG_FLAG_SIGPROF = 0;
		OMRPORT_SIG_FLAG_SIGQUIT = 0;
		OMRPORT_SIG_FLAG_SIGRECONFIG = 0;
		OMRPORT_SIG_FLAG_SIGSEGV = 0;
		OMRPORT_SIG_FLAG_SIGSYS = 0;
		OMRPORT_SIG_FLAG_SIGTERM = 0;
		OMRPORT_SIG_FLAG_SIGTRAP = 0;
		OMRPORT_SIG_FLAG_SIGTSTP = 0;
		OMRPORT_SIG_FLAG_SIGTTIN = 0;
		OMRPORT_SIG_FLAG_SIGTTOU = 0;
		OMRPORT_SIG_FLAG_SIGURG = 0;
		OMRPORT_SIG_FLAG_SIGUSR1 = 0;
		OMRPORT_SIG_FLAG_SIGUSR2 = 0;
		OMRPORT_SIG_FLAG_SIGVTALRM = 0;
		OMRPORT_SIG_FLAG_SIGWINCH = 0;
		OMRPORT_SIG_FLAG_SIGXCPU = 0;
		OMRPORT_SIG_FLAG_SIGXFSZ = 0;
		OMRPORT_SIG_FPR = 0;
		OMRPORT_SIG_GPR = 0;
		OMRPORT_SIG_GPR_AMD64_R10 = 0;
		OMRPORT_SIG_GPR_AMD64_R11 = 0;
		OMRPORT_SIG_GPR_AMD64_R12 = 0;
		OMRPORT_SIG_GPR_AMD64_R13 = 0;
		OMRPORT_SIG_GPR_AMD64_R14 = 0;
		OMRPORT_SIG_GPR_AMD64_R15 = 0;
		OMRPORT_SIG_GPR_AMD64_R8 = 0;
		OMRPORT_SIG_GPR_AMD64_R9 = 0;
		OMRPORT_SIG_GPR_AMD64_RAX = 0;
		OMRPORT_SIG_GPR_AMD64_RBX = 0;
		OMRPORT_SIG_GPR_AMD64_RCX = 0;
		OMRPORT_SIG_GPR_AMD64_RDI = 0;
		OMRPORT_SIG_GPR_AMD64_RDX = 0;
		OMRPORT_SIG_GPR_AMD64_RSI = 0;
		OMRPORT_SIG_GPR_ARM_R0 = 0;
		OMRPORT_SIG_GPR_ARM_R1 = 0;
		OMRPORT_SIG_GPR_ARM_R10 = 0;
		OMRPORT_SIG_GPR_ARM_R2 = 0;
		OMRPORT_SIG_GPR_ARM_R3 = 0;
		OMRPORT_SIG_GPR_ARM_R4 = 0;
		OMRPORT_SIG_GPR_ARM_R5 = 0;
		OMRPORT_SIG_GPR_ARM_R6 = 0;
		OMRPORT_SIG_GPR_ARM_R7 = 0;
		OMRPORT_SIG_GPR_ARM_R8 = 0;
		OMRPORT_SIG_GPR_ARM_R9 = 0;
		OMRPORT_SIG_GPR_X86_EAX = 0;
		OMRPORT_SIG_GPR_X86_EBX = 0;
		OMRPORT_SIG_GPR_X86_ECX = 0;
		OMRPORT_SIG_GPR_X86_EDI = 0;
		OMRPORT_SIG_GPR_X86_EDX = 0;
		OMRPORT_SIG_GPR_X86_ESI = 0;
		OMRPORT_SIG_MODULE = 0;
		OMRPORT_SIG_MODULE_FUNCTION_NAME = 0;
		OMRPORT_SIG_MODULE_NAME = 0;
		OMRPORT_SIG_NO_EXCEPTION = 0;
		OMRPORT_SIG_NUM_CATEGORIES = 0;
		OMRPORT_SIG_OPTIONS_COOPERATIVE_SHUTDOWN = 0;
		OMRPORT_SIG_OPTIONS_OMRSIG_NO_CHAIN = 0;
		OMRPORT_SIG_OPTIONS_REDUCED_SIGNALS_ASYNCHRONOUS = 0;
		OMRPORT_SIG_OPTIONS_REDUCED_SIGNALS_SYNCHRONOUS = 0;
		OMRPORT_SIG_OPTIONS_SIGXFSZ = 0;
		OMRPORT_SIG_OPTIONS_ZOS_USE_CEEHDLR = 0;
		OMRPORT_SIG_OTHER = 0;
		OMRPORT_SIG_SIGNAL = 0;
		OMRPORT_SIG_SIGNAL_ADDRESS = 0;
		OMRPORT_SIG_SIGNAL_CODE = 0;
		OMRPORT_SIG_SIGNAL_ERROR_VALUE = 0;
		OMRPORT_SIG_SIGNAL_HANDLER = 0;
		OMRPORT_SIG_SIGNAL_INACCESSIBLE_ADDRESS = 0;
		OMRPORT_SIG_SIGNAL_PLATFORM_SIGNAL_TYPE = 0;
		OMRPORT_SIG_SIGNAL_TYPE = 0;
		OMRPORT_SIG_SIGNAL_ZOS_CONDITION_FACILITY_ID = 0;
		OMRPORT_SIG_SIGNAL_ZOS_CONDITION_FEEDBACK_TOKEN = 0;
		OMRPORT_SIG_SIGNAL_ZOS_CONDITION_INFORMATION_BLOCK = 0;
		OMRPORT_SIG_SIGNAL_ZOS_CONDITION_MESSAGE_NUMBER = 0;
		OMRPORT_SIG_SIGNAL_ZOS_CONDITION_SEVERITY = 0;
		OMRPORT_SIG_SMALLEST_SIGNAL_FLAG = 0;
		OMRPORT_SIG_VALUE_128 = 0;
		OMRPORT_SIG_VALUE_16 = 0;
		OMRPORT_SIG_VALUE_32 = 0;
		OMRPORT_SIG_VALUE_64 = 0;
		OMRPORT_SIG_VALUE_ADDRESS = 0;
		OMRPORT_SIG_VALUE_FLOAT_64 = 0;
		OMRPORT_SIG_VALUE_STRING = 0;
		OMRPORT_SIG_VALUE_UNDEFINED = 0;
		OMRPORT_SIG_VR = 0;
		OMRPORT_SIG_WINDOWS_DEFER_TRY_EXCEPT_HANDLER = 0;
		OMRPORT_SLOPEN_DECORATE = 0;
		OMRPORT_SLOPEN_LAZY = 0;
		OMRPORT_SLOPEN_NO_LOOKUP_MSG_FOR_NOT_FOUND = 0;
		OMRPORT_SLOPEN_OPEN_EXECUTABLE = 0;
		OMRPORT_SL_FOUND = 0;
		OMRPORT_SL_INVALID = 0;
		OMRPORT_SL_NOT_FOUND = 0;
		OMRPORT_SL_UNKNOWN = 0;
		OMRPORT_SL_UNSUPPORTED = 0;
		OMRPORT_SYSINFO_FEATURES_SIZE = 0;
		OMRPORT_SYSINFO_OS_FEATURES_SIZE = 0;
		OMRPORT_TIME_DELTA_IN_MICROSECONDS = 0;
		OMRPORT_TIME_DELTA_IN_MILLISECONDS = 0;
		OMRPORT_TIME_DELTA_IN_NANOSECONDS = 0;
		OMRPORT_TIME_DELTA_IN_SECONDS = 0;
		OMRPORT_TIME_HIRES_MICROTIME_DIVISOR = 0;
		OMRPORT_TIME_HIRES_MILLITIME_DIVISOR = 0;
		OMRPORT_TIME_HIRES_NANOTIME_DENOMINATOR = 0;
		OMRPORT_TIME_HIRES_NANOTIME_NUMERATOR = 0;
		OMRPORT_TIME_NS_PER_MS = 0;
		OMRPORT_TIME_US_PER_SEC = 0;
		OMRPORT_TTY_ERR = 0;
		OMRPORT_TTY_IN = 0;
		OMRPORT_TTY_OUT = 0;
		OMRPORT_VMEM_ADDRESS_HINT = 0;
		OMRPORT_VMEM_ALLOCATE_PERSIST = 0;
		OMRPORT_VMEM_ALLOCATE_TOP_DOWN = 0;
		OMRPORT_VMEM_ALLOC_DIR_BOTTOM_UP = 0;
		OMRPORT_VMEM_ALLOC_DIR_TOP_DOWN = 0;
		OMRPORT_VMEM_ALLOC_QUICK = 0;
		OMRPORT_VMEM_MEMORY_MODE_COMMIT = 0;
		OMRPORT_VMEM_MEMORY_MODE_DOUBLE_MAP_AVAILABLE = 0;
		OMRPORT_VMEM_MEMORY_MODE_EXECUTE = 0;
		OMRPORT_VMEM_MEMORY_MODE_MMAP_HUGE_PAGES = 0;
		OMRPORT_VMEM_MEMORY_MODE_READ = 0;
		OMRPORT_VMEM_MEMORY_MODE_SHARE_FILE_OPEN = 0;
		OMRPORT_VMEM_MEMORY_MODE_VIRTUAL = 0;
		OMRPORT_VMEM_MEMORY_MODE_WRITE = 0;
		OMRPORT_VMEM_NO_AFFINITY = 0;
		OMRPORT_VMEM_PAGE_FLAG_FIXED = 0;
		OMRPORT_VMEM_PAGE_FLAG_NOT_USED = 0;
		OMRPORT_VMEM_PAGE_FLAG_PAGEABLE = 0;
		OMRPORT_VMEM_PAGE_FLAG_PAGEABLE_PREFERABLE = 0;
		OMRPORT_VMEM_PAGE_FLAG_SUPERPAGE_ANY = 0;
		OMRPORT_VMEM_PAGE_FLAG_TYPE_MASK = 0;
		OMRPORT_VMEM_RESERVE_USED_INVALID = 0;
		OMRPORT_VMEM_RESERVE_USED_J9ALLOCATE_4K_PAGES_ABOVE_BAR = 0;
		OMRPORT_VMEM_RESERVE_USED_J9ALLOCATE_4K_PAGES_BELOW_BAR = 0;
		OMRPORT_VMEM_RESERVE_USED_J9ALLOCATE_4K_PAGES_IN_2TO32G_AREA = 0;
		OMRPORT_VMEM_RESERVE_USED_J9ALLOCATE_LARGE_FIXED_PAGES_ABOVE_BAR = 0;
		OMRPORT_VMEM_RESERVE_USED_J9ALLOCATE_LARGE_PAGEABLE_PAGES_ABOVE_BAR = 0;
		OMRPORT_VMEM_RESERVE_USED_J9ALLOCATE_LARGE_PAGES_BELOW_BAR = 0;
		OMRPORT_VMEM_RESERVE_USED_J9MEM_ALLOCATE_MEMORY = 0;
		OMRPORT_VMEM_RESERVE_USED_MALLOC31 = 0;
		OMRPORT_VMEM_RESERVE_USED_MMAP = 0;
		OMRPORT_VMEM_RESERVE_USED_MMAP_RESTORE_MMAP = 0;
		OMRPORT_VMEM_RESERVE_USED_MMAP_SHM = 0;
		OMRPORT_VMEM_RESERVE_USED_MOSERVICES = 0;
		OMRPORT_VMEM_RESERVE_USED_SHM = 0;
		OMRPORT_VMEM_STRICT_ADDRESS = 0;
		OMRPORT_VMEM_STRICT_PAGE_SIZE = 0;
		OMRPORT_VMEM_ZOS_USE2TO32G_AREA = 0;
		OMRPORT_VMEM_ZTPF_USE_31BIT_MALLOC = 0;
		OMRPORT_ZOS_FEATURE_RMODE64 = 0;
		OMRSHMEM_GETDIR_APPEND_BASEDIR = 0;
		OMRSHMEM_GETDIR_USE_USERHOME = 0;
		OMRSHMEM_NO_FLAGS = 0;
		OMRSHMEM_OPEN_DO_NOT_CREATE = 0;
		OMRSHMEM_OPEN_FOR_DESTROY = 0;
		OMRSHMEM_OPEN_FOR_STATS = 0;
		OMRSHMEM_PRINT_STORAGE_KEY_WARNING = 0;
		OMRSHMEM_STORAGE_KEY_TESTING = 0;
		OMRSHMEM_STORAGE_KEY_TESTING_MASK = 0;
		OMRSHSEM_NO_FLAGS = 0;
		OMRSHSEM_OPEN_DO_NOT_CREATE = 0;
		OMRSHSEM_OPEN_FOR_DESTROY = 0;
		OMRSHSEM_OPEN_FOR_STATS = 0;
		OMRSH_BASEFILEPERM = 0;
		OMRSH_BASEFILEPERM_GROUP_RW_ACCESS = 0;
		OMRSH_DIRPERM = 0;
		OMRSH_DIRPERM_ABSENT = 0;
		OMRSH_DIRPERM_DEFAULT = 0;
		OMRSH_DIRPERM_DEFAULT_WITH_STICKYBIT = 0;
		OMRSH_MAXPATH = 0;
		OMRSH_PARENTDIRPERM = 0;
		OMRSH_SHMEM_PERM_READ = 0;
		OMRSH_SHMEM_PERM_READ_WRITE = 0;
		OMRSH_SYSV_OLDER_CONTROL_FILE = 0;
		OMRSH_SYSV_OLDER_EMPTY_CONTROL_FILE = 0;
		OMRSH_SYSV_REGULAR_CONTROL_FILE = 0;
		OMR_CGROUP_SUBSYSTEM_ALL = 0;
		OMR_CGROUP_SUBSYSTEM_CPU = 0;
		OMR_CGROUP_SUBSYSTEM_CPUSET = 0;
		OMR_CGROUP_SUBSYSTEM_MEMORY = 0;
		OMR_CONFIGURABLE_SUSPEND_SIGNAL = 0;
		OMR_CONFIGURABLE_SUSPEND_SIGNAL_DEFINED = 0;
		OMR_FEATURE_PPC_32 = 0;
		OMR_FEATURE_PPC_601_INSTR = 0;
		OMR_FEATURE_PPC_64 = 0;
		OMR_FEATURE_PPC_ARCH_2_05 = 0;
		OMR_FEATURE_PPC_ARCH_2_06 = 0;
		OMR_FEATURE_PPC_ARCH_2_07 = 0;
		OMR_FEATURE_PPC_BOOKE = 0;
		OMR_FEATURE_PPC_CELL_BE = 0;
		OMR_FEATURE_PPC_DSCR = 0;
		OMR_FEATURE_PPC_EBB = 0;
		OMR_FEATURE_PPC_HAS_4xxMAC = 0;
		OMR_FEATURE_PPC_HAS_ALTIVEC = 0;
		OMR_FEATURE_PPC_HAS_DFP = 0;
		OMR_FEATURE_PPC_HAS_EFP_DOUBLE = 0;
		OMR_FEATURE_PPC_HAS_EFP_SINGLE = 0;
		OMR_FEATURE_PPC_HAS_FPU = 0;
		OMR_FEATURE_PPC_HAS_MMU = 0;
		OMR_FEATURE_PPC_HAS_SPE = 0;
		OMR_FEATURE_PPC_HAS_VSX = 0;
		OMR_FEATURE_PPC_HTM = 0;
		OMR_FEATURE_PPC_ICACHE_SNOOP = 0;
		OMR_FEATURE_PPC_ISEL = 0;
		OMR_FEATURE_PPC_LE = 0;
		OMR_FEATURE_PPC_NO_TB = 0;
		OMR_FEATURE_PPC_PA6T = 0;
		OMR_FEATURE_PPC_POWER4 = 0;
		OMR_FEATURE_PPC_POWER5 = 0;
		OMR_FEATURE_PPC_POWER5_PLUS = 0;
		OMR_FEATURE_PPC_POWER6_EXT = 0;
		OMR_FEATURE_PPC_PSERIES_PERFMON_COMPAT = 0;
		OMR_FEATURE_PPC_SMT = 0;
		OMR_FEATURE_PPC_TAR = 0;
		OMR_FEATURE_PPC_TRUE_LE = 0;
		OMR_FEATURE_PPC_UNIFIED_CACHE = 0;
		OMR_FEATURE_S390_COMPARE_AND_SWAP_AND_STORE = 0;
		OMR_FEATURE_S390_COMPARE_AND_SWAP_AND_STORE2 = 0;
		OMR_FEATURE_S390_DFP = 0;
		OMR_FEATURE_S390_ESAN3 = 0;
		OMR_FEATURE_S390_ETF3_ENHANCEMENT = 0;
		OMR_FEATURE_S390_EXECUTE_EXTENSIONS = 0;
		OMR_FEATURE_S390_EXTENDED_IMMEDIATE = 0;
		OMR_FEATURE_S390_EXTENDED_TRANSLATION_3 = 0;
		OMR_FEATURE_S390_FPE = 0;
		OMR_FEATURE_S390_GENERAL_INSTRUCTIONS_EXTENSIONS = 0;
		OMR_FEATURE_S390_GUARDED_STORAGE = 0;
		OMR_FEATURE_S390_HIGH_WORD = 0;
		OMR_FEATURE_S390_HPAGE = 0;
		OMR_FEATURE_S390_LOAD_AND_ZERO_RIGHTMOST_BYTE = 0;
		OMR_FEATURE_S390_LOAD_STORE_ON_CONDITION_1 = 0;
		OMR_FEATURE_S390_LOAD_STORE_ON_CONDITION_2 = 0;
		OMR_FEATURE_S390_LONG_DISPLACEMENT = 0;
		OMR_FEATURE_S390_MISCELLANEOUS_INSTRUCTION_EXTENSION = 0;
		OMR_FEATURE_S390_MISCELLANEOUS_INSTRUCTION_EXTENSION_2 = 0;
		OMR_FEATURE_S390_MISCELLANEOUS_INSTRUCTION_EXTENSION_3 = 0;
		OMR_FEATURE_S390_MSA = 0;
		OMR_FEATURE_S390_MSA_EXTENSION3 = 0;
		OMR_FEATURE_S390_MSA_EXTENSION4 = 0;
		OMR_FEATURE_S390_MSA_EXTENSION_5 = 0;
		OMR_FEATURE_S390_MSA_EXTENSION_8 = 0;
		OMR_FEATURE_S390_RI = 0;
		OMR_FEATURE_S390_SEMAPHORE_ASSIST = 0;
		OMR_FEATURE_S390_SIDE_EFFECT_ACCESS = 0;
		OMR_FEATURE_S390_STFLE = 0;
		OMR_FEATURE_S390_TE = 0;
		OMR_FEATURE_S390_VECTOR_FACILITY = 0;
		OMR_FEATURE_S390_VECTOR_FACILITY_ENHANCEMENT_1 = 0;
		OMR_FEATURE_S390_VECTOR_FACILITY_ENHANCEMENT_2 = 0;
		OMR_FEATURE_S390_VECTOR_PACKED_DECIMAL = 0;
		OMR_FEATURE_S390_VECTOR_PACKED_DECIMAL_ENHANCEMENT_FACILITY = 0;
		OMR_FEATURE_S390_ZARCH = 0;
		OMR_FEATURE_X86_0_10 = 0;
		OMR_FEATURE_X86_0_20 = 0;
		OMR_FEATURE_X86_0_30 = 0;
		OMR_FEATURE_X86_1_16 = 0;
		OMR_FEATURE_X86_1_31 = 0;
		OMR_FEATURE_X86_3_22 = 0;
		OMR_FEATURE_X86_ACPI = 0;
		OMR_FEATURE_X86_ADX = 0;
		OMR_FEATURE_X86_AESNI = 0;
		OMR_FEATURE_X86_APIC = 0;
		OMR_FEATURE_X86_AVX = 0;
		OMR_FEATURE_X86_AVX2 = 0;
		OMR_FEATURE_X86_AVX512BW = 0;
		OMR_FEATURE_X86_AVX512CD = 0;
		OMR_FEATURE_X86_AVX512DQ = 0;
		OMR_FEATURE_X86_AVX512ER = 0;
		OMR_FEATURE_X86_AVX512F = 0;
		OMR_FEATURE_X86_AVX512PF = 0;
		OMR_FEATURE_X86_AVX512VL = 0;
		OMR_FEATURE_X86_AVX512_IFMA = 0;
		OMR_FEATURE_X86_BMI1 = 0;
		OMR_FEATURE_X86_BMI2 = 0;
		OMR_FEATURE_X86_CLFLUSHOPT = 0;
		OMR_FEATURE_X86_CLFSH = 0;
		OMR_FEATURE_X86_CLWB = 0;
		OMR_FEATURE_X86_CMOV = 0;
		OMR_FEATURE_X86_CMPXCHG16B = 0;
		OMR_FEATURE_X86_CNXT_ID = 0;
		OMR_FEATURE_X86_CX8 = 0;
		OMR_FEATURE_X86_DCA = 0;
		OMR_FEATURE_X86_DE = 0;
		OMR_FEATURE_X86_DEPRECATE_FPUCS = 0;
		OMR_FEATURE_X86_DS = 0;
		OMR_FEATURE_X86_DS_CPL = 0;
		OMR_FEATURE_X86_DTES64 = 0;
		OMR_FEATURE_X86_EIST = 0;
		OMR_FEATURE_X86_ERMSB = 0;
		OMR_FEATURE_X86_F16C = 0;
		OMR_FEATURE_X86_FDP_EXCPTN_ONLY = 0;
		OMR_FEATURE_X86_FMA = 0;
		OMR_FEATURE_X86_FPU = 0;
		OMR_FEATURE_X86_FSGSBASE = 0;
		OMR_FEATURE_X86_FXSR = 0;
		OMR_FEATURE_X86_HLE = 0;
		OMR_FEATURE_X86_HTT = 0;
		OMR_FEATURE_X86_IA32_TSC_ADJUST = 0;
		OMR_FEATURE_X86_INVPCID = 0;
		OMR_FEATURE_X86_IPT = 0;
		OMR_FEATURE_X86_MCA = 0;
		OMR_FEATURE_X86_MCE = 0;
		OMR_FEATURE_X86_MMX = 0;
		OMR_FEATURE_X86_MONITOR = 0;
		OMR_FEATURE_X86_MOVBE = 0;
		OMR_FEATURE_X86_MPX = 0;
		OMR_FEATURE_X86_MSR = 0;
		OMR_FEATURE_X86_MTRR = 0;
		OMR_FEATURE_X86_OSXSAVE = 0;
		OMR_FEATURE_X86_PAE = 0;
		OMR_FEATURE_X86_PAT = 0;
		OMR_FEATURE_X86_PBE = 0;
		OMR_FEATURE_X86_PCID = 0;
		OMR_FEATURE_X86_PCLMULQDQ = 0;
		OMR_FEATURE_X86_PDCM = 0;
		OMR_FEATURE_X86_PGE = 0;
		OMR_FEATURE_X86_POPCNT = 0;
		OMR_FEATURE_X86_PSE = 0;
		OMR_FEATURE_X86_PSE_36 = 0;
		OMR_FEATURE_X86_PSN = 0;
		OMR_FEATURE_X86_RDRAND = 0;
		OMR_FEATURE_X86_RDSEED = 0;
		OMR_FEATURE_X86_RDT_A = 0;
		OMR_FEATURE_X86_RDT_M = 0;
		OMR_FEATURE_X86_RTM = 0;
		OMR_FEATURE_X86_SDBG = 0;
		OMR_FEATURE_X86_SEP = 0;
		OMR_FEATURE_X86_SGX = 0;
		OMR_FEATURE_X86_SHA = 0;
		OMR_FEATURE_X86_SMAP = 0;
		OMR_FEATURE_X86_SMEP = 0;
		OMR_FEATURE_X86_SMX = 0;
		OMR_FEATURE_X86_SS = 0;
		OMR_FEATURE_X86_SSE = 0;
		OMR_FEATURE_X86_SSE2 = 0;
		OMR_FEATURE_X86_SSE3 = 0;
		OMR_FEATURE_X86_SSE4_1 = 0;
		OMR_FEATURE_X86_SSE4_2 = 0;
		OMR_FEATURE_X86_SSSE3 = 0;
		OMR_FEATURE_X86_TM = 0;
		OMR_FEATURE_X86_TM2 = 0;
		OMR_FEATURE_X86_TSC = 0;
		OMR_FEATURE_X86_TSC_DEADLINE = 0;
		OMR_FEATURE_X86_VME = 0;
		OMR_FEATURE_X86_VMX = 0;
		OMR_FEATURE_X86_X2APIC = 0;
		OMR_FEATURE_X86_XSAVE = 0;
		OMR_FEATURE_X86_XTPR = 0;
		OMR_HWCAP_S390_DFP = 0;
		OMR_HWCAP_S390_EIMM = 0;
		OMR_HWCAP_S390_ESAN3 = 0;
		OMR_HWCAP_S390_ETF3EH = 0;
		OMR_HWCAP_S390_GS = 0;
		OMR_HWCAP_S390_HIGH_GPRS = 0;
		OMR_HWCAP_S390_HPAGE = 0;
		OMR_HWCAP_S390_LDISP = 0;
		OMR_HWCAP_S390_MSA = 0;
		OMR_HWCAP_S390_STFLE = 0;
		OMR_HWCAP_S390_TE = 0;
		OMR_HWCAP_S390_VXRS = 0;
		OMR_HWCAP_S390_VXRS_BCD = 0;
		OMR_HWCAP_S390_VXRS_EXT = 0;
		OMR_HWCAP_S390_ZARCH = 0;
		UNICODE_REPLACEMENT_CHARACTER = 0;
		_XOPEN_SOURCE = 0;
		_XOPEN_SOURCE_DEFINED = 0;
		_gp_handler_functionOffset_ = 0;
		_gp_infoOffset_ = 0;
		_gp_info_countOffset_ = 0;
		_gp_protectOffset_ = 0;
		_gp_register_handlerOffset_ = 0;
		_gp_shutdownOffset_ = 0;
		_gp_startupOffset_ = 0;
		_gs_deinitializeOffset_ = 0;
		_gs_disableOffset_ = 0;
		_gs_enableOffset_ = 0;
		_gs_initializeOffset_ = 0;
		_gs_isEnabledOffset_ = 0;
		_gs_params_initOffset_ = 0;
		_hypervisor_get_guest_memory_usageOffset_ = 0;
		_hypervisor_get_guest_processor_usageOffset_ = 0;
		_hypervisor_get_hypervisor_infoOffset_ = 0;
		_hypervisor_hypervisor_presentOffset_ = 0;
		_hypervisor_shutdownOffset_ = 0;
		_hypervisor_startupOffset_ = 0;
		_ipcmutex_acquireOffset_ = 0;
		_ipcmutex_releaseOffset_ = 0;
		_ipcmutex_shutdownOffset_ = 0;
		_ipcmutex_startupOffset_ = 0;
		_omrPortLibraryOffset_ = 0;
		_portGlobalsOffset_ = 0;
		_portVersionOffset_ = 0;
		_port_controlOffset_ = 0;
		_port_create_libraryOffset_ = 0;
		_port_init_libraryOffset_ = 0;
		_port_isFunctionOverriddenOffset_ = 0;
		_port_shutdown_libraryOffset_ = 0;
		_port_startup_libraryOffset_ = 0;
		_process_closeOffset_ = 0;
		_process_createOffset_ = 0;
		_process_getStreamOffset_ = 0;
		_process_get_availableOffset_ = 0;
		_process_get_exitCodeOffset_ = 0;
		_process_isCompleteOffset_ = 0;
		_process_readOffset_ = 0;
		_process_terminateOffset_ = 0;
		_process_waitforOffset_ = 0;
		_process_writeOffset_ = 0;
		_self_handleOffset_ = 0;
		_shmem_attachOffset_ = 0;
		_shmem_closeOffset_ = 0;
		_shmem_createDirOffset_ = 0;
		_shmem_destroyOffset_ = 0;
		_shmem_destroyDeprecatedOffset_ = 0;
		_shmem_detachOffset_ = 0;
		_shmem_findcloseOffset_ = 0;
		_shmem_findfirstOffset_ = 0;
		_shmem_findnextOffset_ = 0;
		_shmem_getDirOffset_ = 0;
		_shmem_getFilepathOffset_ = 0;
		_shmem_get_region_granularityOffset_ = 0;
		_shmem_getidOffset_ = 0;
		_shmem_handle_statOffset_ = 0;
		_shmem_openOffset_ = 0;
		_shmem_openDeprecatedOffset_ = 0;
		_shmem_protectOffset_ = 0;
		_shmem_shutdownOffset_ = 0;
		_shmem_startupOffset_ = 0;
		_shmem_statOffset_ = 0;
		_shmem_statDeprecatedOffset_ = 0;
		_shsem_closeOffset_ = 0;
		_shsem_deprecated_closeOffset_ = 0;
		_shsem_deprecated_destroyOffset_ = 0;
		_shsem_deprecated_destroyDeprecatedOffset_ = 0;
		_shsem_deprecated_getValOffset_ = 0;
		_shsem_deprecated_getidOffset_ = 0;
		_shsem_deprecated_handle_statOffset_ = 0;
		_shsem_deprecated_openOffset_ = 0;
		_shsem_deprecated_openDeprecatedOffset_ = 0;
		_shsem_deprecated_postOffset_ = 0;
		_shsem_deprecated_setValOffset_ = 0;
		_shsem_deprecated_shutdownOffset_ = 0;
		_shsem_deprecated_startupOffset_ = 0;
		_shsem_deprecated_waitOffset_ = 0;
		_shsem_destroyOffset_ = 0;
		_shsem_getValOffset_ = 0;
		_shsem_openOffset_ = 0;
		_shsem_params_initOffset_ = 0;
		_shsem_postOffset_ = 0;
		_shsem_setValOffset_ = 0;
		_shsem_shutdownOffset_ = 0;
		_shsem_startupOffset_ = 0;
		_shsem_waitOffset_ = 0;
		_sock_error_messageOffset_ = 0;
		_sock_freeaddrinfoOffset_ = 0;
		_sock_getaddrinfoOffset_ = 0;
		_sock_getaddrinfo_addressOffset_ = 0;
		_sock_getaddrinfo_create_hintsOffset_ = 0;
		_sock_getaddrinfo_familyOffset_ = 0;
		_sock_getaddrinfo_lengthOffset_ = 0;
		_sock_getaddrinfo_nameOffset_ = 0;
		_sock_gethostbyaddrOffset_ = 0;
		_sock_gethostbynameOffset_ = 0;
		_sock_inetaddrOffset_ = 0;
		_sock_shutdownOffset_ = 0;
		_sock_startupOffset_ = 0;
		_sysinfo_DLPAR_enabledOffset_ = 0;
		_sysinfo_DLPAR_max_CPUsOffset_ = 0;
		_sysinfo_get_cache_infoOffset_ = 0;
		_sysinfo_get_classpathSeparatorOffset_ = 0;
		_sysinfo_get_hw_infoOffset_ = 0;
		_sysinfo_get_processing_capacityOffset_ = 0;
		_sysinfo_get_processor_descriptionOffset_ = 0;
		_sysinfo_processor_has_featureOffset_ = 0;
		_sysinfo_shutdownOffset_ = 0;
		_sysinfo_startupOffset_ = 0;
		_sysinfo_weak_memory_consistencyOffset_ = 0;
	}

}
