/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9MemorySegment
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9MemorySegment {

	// VM Constants

	public static final long SIZEOF;
	public static final long MEMORY_TYPE_ALLOCATED;
	public static final long MEMORY_TYPE_BASETYPE_ROM_CLASS;
	public static final long MEMORY_TYPE_CLASS_FILE_BYTES;
	public static final long MEMORY_TYPE_CODE;
	public static final long MEMORY_TYPE_DEBUG_INFO;
	public static final long MEMORY_TYPE_DEFAULT;
	public static final long MEMORY_TYPE_DISCARDABLE;
	public static final long MEMORY_TYPE_DYNAMIC_LOADED_CLASSES;
	public static final long MEMORY_TYPE_FIXED;
	public static final long MEMORY_TYPE_FIXEDSIZE;
	public static final long MEMORY_TYPE_FIXED_RAM;
	public static final long MEMORY_TYPE_FIXED_RAM_CLASS;
	public static final long MEMORY_TYPE_FROM_JXE;
	public static final long MEMORY_TYPE_IGC_SCAN_QUEUE;
	public static final long MEMORY_TYPE_IMMORTAL;
	public static final long MEMORY_TYPE_JIT_PERSISTENT;
	public static final long MEMORY_TYPE_JIT_SCRATCH_SPACE;
	public static final long MEMORY_TYPE_NEW;
	public static final long MEMORY_TYPE_NEW_RAM;
	public static final long MEMORY_TYPE_NUMA;
	public static final long MEMORY_TYPE_OLD;
	public static final long MEMORY_TYPE_OLD_RAM;
	public static final long MEMORY_TYPE_OLD_ROM;
	public static final long MEMORY_TYPE_RAM;
	public static final long MEMORY_TYPE_RAM_CLASS;
	public static final long MEMORY_TYPE_ROM;
	public static final long MEMORY_TYPE_ROM_CLASS;
	public static final long MEMORY_TYPE_SCOPED;
	public static final long MEMORY_TYPE_SHARED_META;
	public static final long MEMORY_TYPE_UNCOMMITTED;
	public static final long MEMORY_TYPE_UNDEAD_CLASS;
	public static final long MEMORY_TYPE_VIRTUAL;

	// Offsets

	public static final int _baseAddressOffset_;
	public static final int _classLoaderOffset_;
	public static final int _heapAllocOffset_;
	public static final int _heapBaseOffset_;
	public static final int _heapTopOffset_;
	public static final int _memorySegmentListOffset_;
	public static final int _memorySpaceOffset_;
	public static final int _nextSegmentOffset_;
	public static final int _nextSegmentInClassLoaderOffset_;
	public static final int _parentAVLTreeNodeOffset_;
	public static final int _previousSegmentOffset_;
	public static final int _sizeOffset_;
	public static final int _typeOffset_;
	public static final int _unused1Offset_;
	public static final int _vmemIdentifierOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		MEMORY_TYPE_ALLOCATED = 0;
		MEMORY_TYPE_BASETYPE_ROM_CLASS = 0;
		MEMORY_TYPE_CLASS_FILE_BYTES = 0;
		MEMORY_TYPE_CODE = 0;
		MEMORY_TYPE_DEBUG_INFO = 0;
		MEMORY_TYPE_DEFAULT = 0;
		MEMORY_TYPE_DISCARDABLE = 0;
		MEMORY_TYPE_DYNAMIC_LOADED_CLASSES = 0;
		MEMORY_TYPE_FIXED = 0;
		MEMORY_TYPE_FIXEDSIZE = 0;
		MEMORY_TYPE_FIXED_RAM = 0;
		MEMORY_TYPE_FIXED_RAM_CLASS = 0;
		MEMORY_TYPE_FROM_JXE = 0;
		MEMORY_TYPE_IGC_SCAN_QUEUE = 0;
		MEMORY_TYPE_IMMORTAL = 0;
		MEMORY_TYPE_JIT_PERSISTENT = 0;
		MEMORY_TYPE_JIT_SCRATCH_SPACE = 0;
		MEMORY_TYPE_NEW = 0;
		MEMORY_TYPE_NEW_RAM = 0;
		MEMORY_TYPE_NUMA = 0;
		MEMORY_TYPE_OLD = 0;
		MEMORY_TYPE_OLD_RAM = 0;
		MEMORY_TYPE_OLD_ROM = 0;
		MEMORY_TYPE_RAM = 0;
		MEMORY_TYPE_RAM_CLASS = 0;
		MEMORY_TYPE_ROM = 0;
		MEMORY_TYPE_ROM_CLASS = 0;
		MEMORY_TYPE_SCOPED = 0;
		MEMORY_TYPE_SHARED_META = 0;
		MEMORY_TYPE_UNCOMMITTED = 0;
		MEMORY_TYPE_UNDEAD_CLASS = 0;
		MEMORY_TYPE_VIRTUAL = 0;
		_baseAddressOffset_ = 0;
		_classLoaderOffset_ = 0;
		_heapAllocOffset_ = 0;
		_heapBaseOffset_ = 0;
		_heapTopOffset_ = 0;
		_memorySegmentListOffset_ = 0;
		_memorySpaceOffset_ = 0;
		_nextSegmentOffset_ = 0;
		_nextSegmentInClassLoaderOffset_ = 0;
		_parentAVLTreeNodeOffset_ = 0;
		_previousSegmentOffset_ = 0;
		_sizeOffset_ = 0;
		_typeOffset_ = 0;
		_unused1Offset_ = 0;
		_vmemIdentifierOffset_ = 0;
	}

}
