/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9GarbageCollectionInfo
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9GarbageCollectionInfo {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _arraySizeOffset_;
	public static final int _endTimeOffset_;
	public static final int _gcActionOffset_;
	public static final int _gcCauseOffset_;
	public static final int _gcIDOffset_;
	public static final int _indexOffset_;
	public static final int _initialSizeOffset_;
	public static final int _postCommittedOffset_;
	public static final int _postMaxOffset_;
	public static final int _postUsedOffset_;
	public static final int _preCommittedOffset_;
	public static final int _preMaxOffset_;
	public static final int _preUsedOffset_;
	public static final int _startTimeOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_arraySizeOffset_ = 0;
		_endTimeOffset_ = 0;
		_gcActionOffset_ = 0;
		_gcCauseOffset_ = 0;
		_gcIDOffset_ = 0;
		_indexOffset_ = 0;
		_initialSizeOffset_ = 0;
		_postCommittedOffset_ = 0;
		_postMaxOffset_ = 0;
		_postUsedOffset_ = 0;
		_preCommittedOffset_ = 0;
		_preMaxOffset_ = 0;
		_preUsedOffset_ = 0;
		_startTimeOffset_ = 0;
	}

}
