/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9DescriptionBits
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9DescriptionBits {

	// VM Constants

	public static final long SIZEOF;
	public static final long J9DescriptionCpBsmIndexMask;
	public static final long J9DescriptionCpTypeClass;
	public static final long J9DescriptionCpTypeConstantDynamic;
	public static final long J9DescriptionCpTypeMask;
	public static final long J9DescriptionCpTypeMethodHandle;
	public static final long J9DescriptionCpTypeMethodType;
	public static final long J9DescriptionCpTypeObject;
	public static final long J9DescriptionCpTypeScalar;
	public static final long J9DescriptionCpTypeShift;
	public static final long J9DescriptionImmediate;
	public static final long J9DescriptionReturnTypeBoolean;
	public static final long J9DescriptionReturnTypeByte;
	public static final long J9DescriptionReturnTypeChar;
	public static final long J9DescriptionReturnTypeDouble;
	public static final long J9DescriptionReturnTypeFloat;
	public static final long J9DescriptionReturnTypeInt;
	public static final long J9DescriptionReturnTypeLong;
	public static final long J9DescriptionReturnTypeShift;
	public static final long J9DescriptionReturnTypeShort;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		J9DescriptionCpBsmIndexMask = 0;
		J9DescriptionCpTypeClass = 0;
		J9DescriptionCpTypeConstantDynamic = 0;
		J9DescriptionCpTypeMask = 0;
		J9DescriptionCpTypeMethodHandle = 0;
		J9DescriptionCpTypeMethodType = 0;
		J9DescriptionCpTypeObject = 0;
		J9DescriptionCpTypeScalar = 0;
		J9DescriptionCpTypeShift = 0;
		J9DescriptionImmediate = 0;
		J9DescriptionReturnTypeBoolean = 0;
		J9DescriptionReturnTypeByte = 0;
		J9DescriptionReturnTypeChar = 0;
		J9DescriptionReturnTypeDouble = 0;
		J9DescriptionReturnTypeFloat = 0;
		J9DescriptionReturnTypeInt = 0;
		J9DescriptionReturnTypeLong = 0;
		J9DescriptionReturnTypeShift = 0;
		J9DescriptionReturnTypeShort = 0;
	}

}
