/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9ConstantPool
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9ConstantPool {

	// VM Constants

	public static final long SIZEOF;
	public static final long J9CPTYPE_ANNOTATION_UTF8;
	public static final long J9CPTYPE_CLASS;
	public static final long J9CPTYPE_CONSTANT_DYNAMIC;
	public static final long J9CPTYPE_DOUBLE;
	public static final long J9CPTYPE_FIELD;
	public static final long J9CPTYPE_FLOAT;
	public static final long J9CPTYPE_HANDLE_METHOD;
	public static final long J9CPTYPE_INSTANCE_METHOD;
	public static final long J9CPTYPE_INT;
	public static final long J9CPTYPE_INTERFACE_INSTANCE_METHOD;
	public static final long J9CPTYPE_INTERFACE_METHOD;
	public static final long J9CPTYPE_INTERFACE_STATIC_METHOD;
	public static final long J9CPTYPE_LONG;
	public static final long J9CPTYPE_METHODHANDLE;
	public static final long J9CPTYPE_METHOD_TYPE;
	public static final long J9CPTYPE_STATIC_METHOD;
	public static final long J9CPTYPE_STRING;
	public static final long J9CPTYPE_UNUSED;
	public static final long J9CPTYPE_UNUSED8;
	public static final long J9_CP_BITS_PER_DESCRIPTION;
	public static final long J9_CP_DESCRIPTIONS_PER_U32;
	public static final long J9_CP_DESCRIPTION_MASK;

	// Offsets

	public static final int _ramClassOffset_;
	public static final int _romConstantPoolOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		J9CPTYPE_ANNOTATION_UTF8 = 0;
		J9CPTYPE_CLASS = 0;
		J9CPTYPE_CONSTANT_DYNAMIC = 0;
		J9CPTYPE_DOUBLE = 0;
		J9CPTYPE_FIELD = 0;
		J9CPTYPE_FLOAT = 0;
		J9CPTYPE_HANDLE_METHOD = 0;
		J9CPTYPE_INSTANCE_METHOD = 0;
		J9CPTYPE_INT = 0;
		J9CPTYPE_INTERFACE_INSTANCE_METHOD = 0;
		J9CPTYPE_INTERFACE_METHOD = 0;
		J9CPTYPE_INTERFACE_STATIC_METHOD = 0;
		J9CPTYPE_LONG = 0;
		J9CPTYPE_METHODHANDLE = 0;
		J9CPTYPE_METHOD_TYPE = 0;
		J9CPTYPE_STATIC_METHOD = 0;
		J9CPTYPE_STRING = 0;
		J9CPTYPE_UNUSED = 0;
		J9CPTYPE_UNUSED8 = 0;
		J9_CP_BITS_PER_DESCRIPTION = 0;
		J9_CP_DESCRIPTIONS_PER_U32 = 0;
		J9_CP_DESCRIPTION_MASK = 0;
		_ramClassOffset_ = 0;
		_romConstantPoolOffset_ = 0;
	}

}
