/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9CfrAttribute
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9CfrAttribute {

	// VM Constants

	public static final long SIZEOF;
	public static final long CFR_ATTRIBUTE_AnnotationDefault;
	public static final long CFR_ATTRIBUTE_BootstrapMethods;
	public static final long CFR_ATTRIBUTE_Code;
	public static final long CFR_ATTRIBUTE_ConstantValue;
	public static final long CFR_ATTRIBUTE_Deprecated;
	public static final long CFR_ATTRIBUTE_EnclosingMethod;
	public static final long CFR_ATTRIBUTE_Exceptions;
	public static final long CFR_ATTRIBUTE_InnerClasses;
	public static final long CFR_ATTRIBUTE_LineNumberTable;
	public static final long CFR_ATTRIBUTE_LocalVariableTable;
	public static final long CFR_ATTRIBUTE_LocalVariableTypeTable;
	public static final long CFR_ATTRIBUTE_MethodParameters;
	public static final long CFR_ATTRIBUTE_NestHost;
	public static final long CFR_ATTRIBUTE_NestMembers;
	public static final long CFR_ATTRIBUTE_PermittedSubclasses;
	public static final long CFR_ATTRIBUTE_Record;
	public static final long CFR_ATTRIBUTE_RuntimeInvisibleAnnotations;
	public static final long CFR_ATTRIBUTE_RuntimeInvisibleParameterAnnotations;
	public static final long CFR_ATTRIBUTE_RuntimeInvisibleTypeAnnotations;
	public static final long CFR_ATTRIBUTE_RuntimeVisibleAnnotations;
	public static final long CFR_ATTRIBUTE_RuntimeVisibleParameterAnnotations;
	public static final long CFR_ATTRIBUTE_RuntimeVisibleTypeAnnotations;
	public static final long CFR_ATTRIBUTE_Signature;
	public static final long CFR_ATTRIBUTE_SourceDebugExtension;
	public static final long CFR_ATTRIBUTE_SourceFile;
	public static final long CFR_ATTRIBUTE_StackMap;
	public static final long CFR_ATTRIBUTE_StackMapTable;
	public static final long CFR_ATTRIBUTE_StrippedInnerClasses;
	public static final long CFR_ATTRIBUTE_StrippedLineNumberTable;
	public static final long CFR_ATTRIBUTE_StrippedLocalVariableTable;
	public static final long CFR_ATTRIBUTE_StrippedLocalVariableTypeTable;
	public static final long CFR_ATTRIBUTE_StrippedSourceDebugExtension;
	public static final long CFR_ATTRIBUTE_StrippedUnknown;
	public static final long CFR_ATTRIBUTE_Synthetic;
	public static final long CFR_ATTRIBUTE_Unknown;
	public static final long CFR_TARGET_TYPE_ErrorInAttribute;
	public static final long CFR_TARGET_TYPE_ReceiverType;
	public static final long CFR_TARGET_TYPE_ReturnType;
	public static final long CFR_TARGET_TYPE_TypeForGenericConstructorInMethodRef;
	public static final long CFR_TARGET_TYPE_TypeForGenericConstructorInNew;
	public static final long CFR_TARGET_TYPE_TypeForGenericMethodInvocation;
	public static final long CFR_TARGET_TYPE_TypeForGenericMethodInvocationInMethodRef;
	public static final long CFR_TARGET_TYPE_TypeInBoundOfGenericClass;
	public static final long CFR_TARGET_TYPE_TypeInBoundOfGenericMethod;
	public static final long CFR_TARGET_TYPE_TypeInCast;
	public static final long CFR_TARGET_TYPE_TypeInExceptionParam;
	public static final long CFR_TARGET_TYPE_TypeInExtends;
	public static final long CFR_TARGET_TYPE_TypeInFieldDecl;
	public static final long CFR_TARGET_TYPE_TypeInFormalParam;
	public static final long CFR_TARGET_TYPE_TypeInInstanceof;
	public static final long CFR_TARGET_TYPE_TypeInLocalVar;
	public static final long CFR_TARGET_TYPE_TypeInMethodrefIdentifier;
	public static final long CFR_TARGET_TYPE_TypeInMethodrefNew;
	public static final long CFR_TARGET_TYPE_TypeInNew;
	public static final long CFR_TARGET_TYPE_TypeInResourceVar;
	public static final long CFR_TARGET_TYPE_TypeInThrows;
	public static final long CFR_TARGET_TYPE_TypeParameterGenericClass;
	public static final long CFR_TARGET_TYPE_TypeParameterGenericMethod;

	// Offsets

	public static final int _lengthOffset_;
	public static final int _nameIndexOffset_;
	public static final int _romAddressOffset_;
	public static final int _tagOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		CFR_ATTRIBUTE_AnnotationDefault = 0;
		CFR_ATTRIBUTE_BootstrapMethods = 0;
		CFR_ATTRIBUTE_Code = 0;
		CFR_ATTRIBUTE_ConstantValue = 0;
		CFR_ATTRIBUTE_Deprecated = 0;
		CFR_ATTRIBUTE_EnclosingMethod = 0;
		CFR_ATTRIBUTE_Exceptions = 0;
		CFR_ATTRIBUTE_InnerClasses = 0;
		CFR_ATTRIBUTE_LineNumberTable = 0;
		CFR_ATTRIBUTE_LocalVariableTable = 0;
		CFR_ATTRIBUTE_LocalVariableTypeTable = 0;
		CFR_ATTRIBUTE_MethodParameters = 0;
		CFR_ATTRIBUTE_NestHost = 0;
		CFR_ATTRIBUTE_NestMembers = 0;
		CFR_ATTRIBUTE_PermittedSubclasses = 0;
		CFR_ATTRIBUTE_Record = 0;
		CFR_ATTRIBUTE_RuntimeInvisibleAnnotations = 0;
		CFR_ATTRIBUTE_RuntimeInvisibleParameterAnnotations = 0;
		CFR_ATTRIBUTE_RuntimeInvisibleTypeAnnotations = 0;
		CFR_ATTRIBUTE_RuntimeVisibleAnnotations = 0;
		CFR_ATTRIBUTE_RuntimeVisibleParameterAnnotations = 0;
		CFR_ATTRIBUTE_RuntimeVisibleTypeAnnotations = 0;
		CFR_ATTRIBUTE_Signature = 0;
		CFR_ATTRIBUTE_SourceDebugExtension = 0;
		CFR_ATTRIBUTE_SourceFile = 0;
		CFR_ATTRIBUTE_StackMap = 0;
		CFR_ATTRIBUTE_StackMapTable = 0;
		CFR_ATTRIBUTE_StrippedInnerClasses = 0;
		CFR_ATTRIBUTE_StrippedLineNumberTable = 0;
		CFR_ATTRIBUTE_StrippedLocalVariableTable = 0;
		CFR_ATTRIBUTE_StrippedLocalVariableTypeTable = 0;
		CFR_ATTRIBUTE_StrippedSourceDebugExtension = 0;
		CFR_ATTRIBUTE_StrippedUnknown = 0;
		CFR_ATTRIBUTE_Synthetic = 0;
		CFR_ATTRIBUTE_Unknown = 0;
		CFR_TARGET_TYPE_ErrorInAttribute = 0;
		CFR_TARGET_TYPE_ReceiverType = 0;
		CFR_TARGET_TYPE_ReturnType = 0;
		CFR_TARGET_TYPE_TypeForGenericConstructorInMethodRef = 0;
		CFR_TARGET_TYPE_TypeForGenericConstructorInNew = 0;
		CFR_TARGET_TYPE_TypeForGenericMethodInvocation = 0;
		CFR_TARGET_TYPE_TypeForGenericMethodInvocationInMethodRef = 0;
		CFR_TARGET_TYPE_TypeInBoundOfGenericClass = 0;
		CFR_TARGET_TYPE_TypeInBoundOfGenericMethod = 0;
		CFR_TARGET_TYPE_TypeInCast = 0;
		CFR_TARGET_TYPE_TypeInExceptionParam = 0;
		CFR_TARGET_TYPE_TypeInExtends = 0;
		CFR_TARGET_TYPE_TypeInFieldDecl = 0;
		CFR_TARGET_TYPE_TypeInFormalParam = 0;
		CFR_TARGET_TYPE_TypeInInstanceof = 0;
		CFR_TARGET_TYPE_TypeInLocalVar = 0;
		CFR_TARGET_TYPE_TypeInMethodrefIdentifier = 0;
		CFR_TARGET_TYPE_TypeInMethodrefNew = 0;
		CFR_TARGET_TYPE_TypeInNew = 0;
		CFR_TARGET_TYPE_TypeInResourceVar = 0;
		CFR_TARGET_TYPE_TypeInThrows = 0;
		CFR_TARGET_TYPE_TypeParameterGenericClass = 0;
		CFR_TARGET_TYPE_TypeParameterGenericMethod = 0;
		_lengthOffset_ = 0;
		_nameIndexOffset_ = 0;
		_romAddressOffset_ = 0;
		_tagOffset_ = 0;
	}

}
