/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9BaseTypePrimitiveROMClasses
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9BaseTypePrimitiveROMClasses {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _booleanClassName$dataOffset_;
	public static final int _booleanClassName$lengthOffset_;
	public static final int _booleanReflectROMClassOffset_;
	public static final int _byteClassName$dataOffset_;
	public static final int _byteClassName$lengthOffset_;
	public static final int _byteReflectROMClassOffset_;
	public static final int _charClassName$dataOffset_;
	public static final int _charClassName$lengthOffset_;
	public static final int _charReflectROMClassOffset_;
	public static final int _doubleClassName$dataOffset_;
	public static final int _doubleClassName$lengthOffset_;
	public static final int _doubleReflectROMClassOffset_;
	public static final int _floatClassName$dataOffset_;
	public static final int _floatClassName$lengthOffset_;
	public static final int _floatReflectROMClassOffset_;
	public static final int _headerOffset_;
	public static final int _intClassName$dataOffset_;
	public static final int _intClassName$lengthOffset_;
	public static final int _intReflectROMClassOffset_;
	public static final int _longClassName$dataOffset_;
	public static final int _longClassName$lengthOffset_;
	public static final int _longReflectROMClassOffset_;
	public static final int _shortClassName$dataOffset_;
	public static final int _shortClassName$lengthOffset_;
	public static final int _shortReflectROMClassOffset_;
	public static final int _voidClassName$dataOffset_;
	public static final int _voidClassName$lengthOffset_;
	public static final int _voidReflectROMClassOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_booleanClassName$dataOffset_ = 0;
		_booleanClassName$lengthOffset_ = 0;
		_booleanReflectROMClassOffset_ = 0;
		_byteClassName$dataOffset_ = 0;
		_byteClassName$lengthOffset_ = 0;
		_byteReflectROMClassOffset_ = 0;
		_charClassName$dataOffset_ = 0;
		_charClassName$lengthOffset_ = 0;
		_charReflectROMClassOffset_ = 0;
		_doubleClassName$dataOffset_ = 0;
		_doubleClassName$lengthOffset_ = 0;
		_doubleReflectROMClassOffset_ = 0;
		_floatClassName$dataOffset_ = 0;
		_floatClassName$lengthOffset_ = 0;
		_floatReflectROMClassOffset_ = 0;
		_headerOffset_ = 0;
		_intClassName$dataOffset_ = 0;
		_intClassName$lengthOffset_ = 0;
		_intReflectROMClassOffset_ = 0;
		_longClassName$dataOffset_ = 0;
		_longClassName$lengthOffset_ = 0;
		_longReflectROMClassOffset_ = 0;
		_shortClassName$dataOffset_ = 0;
		_shortClassName$lengthOffset_ = 0;
		_shortReflectROMClassOffset_ = 0;
		_voidClassName$dataOffset_ = 0;
		_voidClassName$lengthOffset_ = 0;
		_voidReflectROMClassOffset_ = 0;
	}

}
