/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9AVLConsts
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9AVLConsts {

	// VM Constants

	public static final long SIZEOF;
	public static final long AVL_BALANCED;
	public static final long AVL_BALANCEMASK;
	public static final long AVL_LEFTHEAVY;
	public static final long AVL_RIGHTHEAVY;
	public static final long J9AVLTREE_ACTION_DOUBLE_ROTATE;
	public static final long J9AVLTREE_ACTION_INSERT;
	public static final long J9AVLTREE_ACTION_INSERT_EXISTS;
	public static final long J9AVLTREE_ACTION_REMOVE;
	public static final long J9AVLTREE_ACTION_REMOVE_NOT_IN_TREE;
	public static final long J9AVLTREE_ACTION_REPLACE_REMOVED_PARENT;
	public static final long J9AVLTREE_ACTION_SINGLE_ROTATE;
	public static final long J9AVLTREE_DISABLE_SHARED_TREE_UPDATES;
	public static final long J9AVLTREE_DO_VERIFY_TREE_STRUCT_AND_ACCESS;
	public static final long J9AVLTREE_IS_SHARED_TREE;
	public static final long J9AVLTREE_SHARED_TREE_INITIALIZED;
	public static final long J9AVLTREE_TEST_INTERNAVL;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		AVL_BALANCED = 0;
		AVL_BALANCEMASK = 0;
		AVL_LEFTHEAVY = 0;
		AVL_RIGHTHEAVY = 0;
		J9AVLTREE_ACTION_DOUBLE_ROTATE = 0;
		J9AVLTREE_ACTION_INSERT = 0;
		J9AVLTREE_ACTION_INSERT_EXISTS = 0;
		J9AVLTREE_ACTION_REMOVE = 0;
		J9AVLTREE_ACTION_REMOVE_NOT_IN_TREE = 0;
		J9AVLTREE_ACTION_REPLACE_REMOVED_PARENT = 0;
		J9AVLTREE_ACTION_SINGLE_ROTATE = 0;
		J9AVLTREE_DISABLE_SHARED_TREE_UPDATES = 0;
		J9AVLTREE_DO_VERIFY_TREE_STRUCT_AND_ACCESS = 0;
		J9AVLTREE_IS_SHARED_TREE = 0;
		J9AVLTREE_SHARED_TREE_INITIALIZED = 0;
		J9AVLTREE_TEST_INTERNAVL = 0;
	}

}
