/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: GC_FinalizeListManager
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class GC_FinalizeListManager {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __classLoaderCountOffset_;
	public static final int __classLoadersOffset_;
	public static final int __defaultFinalizableObjectCountOffset_;
	public static final int __defaultFinalizableObjectsOffset_;
	public static final int __extensionsOffset_;
	public static final int __mutexOffset_;
	public static final int __referenceObjectCountOffset_;
	public static final int __referenceObjectsOffset_;
	public static final int __systemFinalizableObjectCountOffset_;
	public static final int __systemFinalizableObjectsOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__classLoaderCountOffset_ = 0;
		__classLoadersOffset_ = 0;
		__defaultFinalizableObjectCountOffset_ = 0;
		__defaultFinalizableObjectsOffset_ = 0;
		__extensionsOffset_ = 0;
		__mutexOffset_ = 0;
		__referenceObjectCountOffset_ = 0;
		__referenceObjectsOffset_ = 0;
		__systemFinalizableObjectCountOffset_ = 0;
		__systemFinalizableObjectsOffset_ = 0;
	}

}
