/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: DgRasInterface
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class DgRasInterface {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _CreateThreadOffset_;
	public static final int _DumpDeregisterOffset_;
	public static final int _DumpRegisterOffset_;
	public static final int _DynamicVerbosegcOffset_;
	public static final int _GenerateHeapdumpOffset_;
	public static final int _GenerateJavacoreOffset_;
	public static final int _GetComponentDataAreaOffset_;
	public static final int _GetRasInfoOffset_;
	public static final int _InitiateSystemDumpOffset_;
	public static final int _InjectOutOfMemoryOffset_;
	public static final int _InjectSigsegvOffset_;
	public static final int _NotifySignalOffset_;
	public static final int _ReleaseRasInfoOffset_;
	public static final int _RunDumpRoutineOffset_;
	public static final int _SetOutOfMemoryHookOffset_;
	public static final int _TraceDeregisterOffset_;
	public static final int _TraceDeregister50Offset_;
	public static final int _TraceRegisterOffset_;
	public static final int _TraceRegister50Offset_;
	public static final int _TraceResumeOffset_;
	public static final int _TraceResumeThisOffset_;
	public static final int _TraceSetOffset_;
	public static final int _TraceSnapOffset_;
	public static final int _TraceSuspendOffset_;
	public static final int _TraceSuspendThisOffset_;
	public static final int _eyecatcherOffset_;
	public static final int _lengthOffset_;
	public static final int _modificationOffset_;
	public static final int _versionOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_CreateThreadOffset_ = 0;
		_DumpDeregisterOffset_ = 0;
		_DumpRegisterOffset_ = 0;
		_DynamicVerbosegcOffset_ = 0;
		_GenerateHeapdumpOffset_ = 0;
		_GenerateJavacoreOffset_ = 0;
		_GetComponentDataAreaOffset_ = 0;
		_GetRasInfoOffset_ = 0;
		_InitiateSystemDumpOffset_ = 0;
		_InjectOutOfMemoryOffset_ = 0;
		_InjectSigsegvOffset_ = 0;
		_NotifySignalOffset_ = 0;
		_ReleaseRasInfoOffset_ = 0;
		_RunDumpRoutineOffset_ = 0;
		_SetOutOfMemoryHookOffset_ = 0;
		_TraceDeregisterOffset_ = 0;
		_TraceDeregister50Offset_ = 0;
		_TraceRegisterOffset_ = 0;
		_TraceRegister50Offset_ = 0;
		_TraceResumeOffset_ = 0;
		_TraceResumeThisOffset_ = 0;
		_TraceSetOffset_ = 0;
		_TraceSnapOffset_ = 0;
		_TraceSuspendOffset_ = 0;
		_TraceSuspendThisOffset_ = 0;
		_eyecatcherOffset_ = 0;
		_lengthOffset_ = 0;
		_modificationOffset_ = 0;
		_versionOffset_ = 0;
	}

}
