/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: DbgConstants
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class DbgConstants {

	// VM Constants

	public static final long SIZEOF;
	public static final long ClassTagArray;
	public static final long ClassTagClass;
	public static final long ClassTagInterface;
	public static final long J9WP_MAJOR_VERSION;
	public static final long J9WP_MINOR_VERSION;
	public static final long J9_LINE_TABLE_CACHE_SIZE;
	public static final long JDWP_BYTECODE_PC_SIZE;
	public static final long JDWP_FIELD_ID_SIZE;
	public static final long JDWP_FRAME_ID_SIZE;
	public static final long JDWP_METHOD_ID_SIZE;
	public static final long JDWP_OBJECT_ID_SIZE;
	public static final long JDWP_REF_TYPE_ID_SIZE;
	public static final long JVMDI_CLASS_STATUS_ERROR;
	public static final long JVMDI_CLASS_STATUS_INITIALIZED;
	public static final long JVMDI_CLASS_STATUS_PREPARED;
	public static final long JVMDI_CLASS_STATUS_VERIFIED;
	public static final long JVMDI_DISABLE;
	public static final long JVMDI_ENABLE;
	public static final long JVMDI_ERROR_ABSENT_INFORMATION;
	public static final long JVMDI_ERROR_ACCESS_DENIED;
	public static final long JVMDI_ERROR_ADD_METHOD_NOT_IMPLEMENTED;
	public static final long JVMDI_ERROR_ALREADY_INVOKING;
	public static final long JVMDI_ERROR_BUFFER_GROW;
	public static final long JVMDI_ERROR_CIRCULAR_CLASS_DEFINITION;
	public static final long JVMDI_ERROR_CLASS_MODIFIERS_CHANGE_NOT_IMPLEMENTED;
	public static final long JVMDI_ERROR_CLASS_NOT_PREPARED;
	public static final long JVMDI_ERROR_DELETE_METHOD_NOT_IMPLEMENTED;
	public static final long JVMDI_ERROR_DUPLICATE;
	public static final long JVMDI_ERROR_FAILS_VERIFICATION;
	public static final long JVMDI_ERROR_HIERARCHY_CHANGE_NOT_IMPLEMENTED;
	public static final long JVMDI_ERROR_HOT_SWAP_OPERATION_IGNORED;
	public static final long JVMDI_ERROR_HOT_SWAP_OPERATION_REFUSED;
	public static final long JVMDI_ERROR_ILLEGAL_ARGUMENT;
	public static final long JVMDI_ERROR_INTERNAL;
	public static final long JVMDI_ERROR_INTERRUPT;
	public static final long JVMDI_ERROR_INVALID_ARRAY;
	public static final long JVMDI_ERROR_INVALID_CLASS;
	public static final long JVMDI_ERROR_INVALID_CLASS_FORMAT;
	public static final long JVMDI_ERROR_INVALID_CLASS_LOADER;
	public static final long JVMDI_ERROR_INVALID_EVENT_TYPE;
	public static final long JVMDI_ERROR_INVALID_FIELDID;
	public static final long JVMDI_ERROR_INVALID_FRAMEID;
	public static final long JVMDI_ERROR_INVALID_INDEX;
	public static final long JVMDI_ERROR_INVALID_LENGTH;
	public static final long JVMDI_ERROR_INVALID_LOCATION;
	public static final long JVMDI_ERROR_INVALID_METHODID;
	public static final long JVMDI_ERROR_INVALID_MONITOR;
	public static final long JVMDI_ERROR_INVALID_OBJECT;
	public static final long JVMDI_ERROR_INVALID_PRIORITY;
	public static final long JVMDI_ERROR_INVALID_SLOT;
	public static final long JVMDI_ERROR_INVALID_STRING;
	public static final long JVMDI_ERROR_INVALID_TAG;
	public static final long JVMDI_ERROR_INVALID_THREAD;
	public static final long JVMDI_ERROR_INVALID_THREAD_GROUP;
	public static final long JVMDI_ERROR_INVALID_TYPESTATE;
	public static final long JVMDI_ERROR_METHOD_MODIFIERS_CHANGE_NOT_IMPLEMENTED;
	public static final long JVMDI_ERROR_NAMES_DONT_MATCH;
	public static final long JVMDI_ERROR_NONE;
	public static final long JVMDI_ERROR_NOT_CURRENT_FRAME;
	public static final long JVMDI_ERROR_NOT_FOUND;
	public static final long JVMDI_ERROR_NOT_IMPLEMENTED;
	public static final long JVMDI_ERROR_NOT_MONITOR_OWNER;
	public static final long JVMDI_ERROR_NO_AVAILABLE_THREAD;
	public static final long JVMDI_ERROR_NO_MORE_FRAMES;
	public static final long JVMDI_ERROR_NULL_POINTER;
	public static final long JVMDI_ERROR_OPAQUE_FRAME;
	public static final long JVMDI_ERROR_OUT_OF_MEMORY;
	public static final long JVMDI_ERROR_SCHEMA_CHANGE_NOT_IMPLEMENTED;
	public static final long JVMDI_ERROR_THREAD_NOT_SUSPENDED;
	public static final long JVMDI_ERROR_THREAD_SUSPENDED;
	public static final long JVMDI_ERROR_TRANSPORT_INIT;
	public static final long JVMDI_ERROR_TRANSPORT_LOAD;
	public static final long JVMDI_ERROR_TYPE_MISMATCH;
	public static final long JVMDI_ERROR_UNATTACHED_THREAD;
	public static final long JVMDI_ERROR_VM_DEAD;
	public static final long JVMDI_ERROR_VM_NOT_INTERRUPTED;
	public static final long JVMDI_EVENT_BREAKPOINT;
	public static final long JVMDI_EVENT_CLASS_LOAD;
	public static final long JVMDI_EVENT_CLASS_PREPARE;
	public static final long JVMDI_EVENT_CLASS_UNLOAD;
	public static final long JVMDI_EVENT_COMMAND_SET;
	public static final long JVMDI_EVENT_DEBUG_ATTRIBUTES;
	public static final long JVMDI_EVENT_EXCEPTION;
	public static final long JVMDI_EVENT_EXCEPTION_CATCH;
	public static final long JVMDI_EVENT_FIELD_ACCESS;
	public static final long JVMDI_EVENT_FIELD_MODIFICATION;
	public static final long JVMDI_EVENT_FRAME_POP;
	public static final long JVMDI_EVENT_METHOD_ENTRY;
	public static final long JVMDI_EVENT_METHOD_EXIT;
	public static final long JVMDI_EVENT_RAM_CLASS_CREATE;
	public static final long JVMDI_EVENT_RAM_CLASS_CREATE_WITH_ID;
	public static final long JVMDI_EVENT_SINGLE_STEP;
	public static final long JVMDI_EVENT_THREAD_END;
	public static final long JVMDI_EVENT_THREAD_START;
	public static final long JVMDI_EVENT_USER_DEFINED;
	public static final long JVMDI_EVENT_VM_DEATH;
	public static final long JVMDI_EVENT_VM_DISCONNECTED;
	public static final long JVMDI_EVENT_VM_INIT;
	public static final long JVMDI_EXTENDED_EVENT_COMMAND_SET;
	public static final long JVMDI_INVOKE_NONVIRTUAL;
	public static final long JVMDI_INVOKE_SINGLE_THREADED;
	public static final long JVMDI_MAX_EVENT_TYPE_VAL;
	public static final long JVMDI_MOD_KIND_CLASS_EXCLUDE;
	public static final long JVMDI_MOD_KIND_CLASS_MATCH;
	public static final long JVMDI_MOD_KIND_CLASS_ONLY;
	public static final long JVMDI_MOD_KIND_CONDITIONAL;
	public static final long JVMDI_MOD_KIND_COUNT;
	public static final long JVMDI_MOD_KIND_EXCEPTION_ONLY;
	public static final long JVMDI_MOD_KIND_FIELD_ONLY;
	public static final long JVMDI_MOD_KIND_INSTANCE_ONLY;
	public static final long JVMDI_MOD_KIND_LOCATION_ONLY;
	public static final long JVMDI_MOD_KIND_LOCATION_RANGE;
	public static final long JVMDI_MOD_KIND_STEP;
	public static final long JVMDI_MOD_KIND_THREAD_ONLY;
	public static final long JVMDI_MONITOR_WAIT_FOREVER;
	public static final long JVMDI_STEP_DEPTH_INTO;
	public static final long JVMDI_STEP_DEPTH_OUT;
	public static final long JVMDI_STEP_DEPTH_OVER;
	public static final long JVMDI_STEP_DEPTH_REENTER;
	public static final long JVMDI_STEP_SIZE_LINE;
	public static final long JVMDI_STEP_SIZE_MIN;
	public static final long JVMDI_SUSPEND_POLICY_ALL;
	public static final long JVMDI_SUSPEND_POLICY_EVENT_THREAD;
	public static final long JVMDI_SUSPEND_POLICY_NONE;
	public static final long JVMDI_SUSPEND_STATUS_BREAK;
	public static final long JVMDI_SUSPEND_STATUS_NOT_SUSPENDED;
	public static final long JVMDI_SUSPEND_STATUS_SUSPENDED;
	public static final long JVMDI_THREAD_MAX_PRIORITY;
	public static final long JVMDI_THREAD_MIN_PRIORITY;
	public static final long JVMDI_THREAD_NORM_PRIORITY;
	public static final long JVMDI_THREAD_STATUS_MONITOR;
	public static final long JVMDI_THREAD_STATUS_RUNNING;
	public static final long JVMDI_THREAD_STATUS_SLEEPING;
	public static final long JVMDI_THREAD_STATUS_UNKNOWN;
	public static final long JVMDI_THREAD_STATUS_WAIT;
	public static final long JVMDI_THREAD_STATUS_ZOMBIE;
	public static final long PacketFlagFlushRemaining;
	public static final long PacketFlagHighPriority;
	public static final long PacketFlagSentByVM;
	public static final long PacketNoFlags;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		ClassTagArray = 0;
		ClassTagClass = 0;
		ClassTagInterface = 0;
		J9WP_MAJOR_VERSION = 0;
		J9WP_MINOR_VERSION = 0;
		J9_LINE_TABLE_CACHE_SIZE = 0;
		JDWP_BYTECODE_PC_SIZE = 0;
		JDWP_FIELD_ID_SIZE = 0;
		JDWP_FRAME_ID_SIZE = 0;
		JDWP_METHOD_ID_SIZE = 0;
		JDWP_OBJECT_ID_SIZE = 0;
		JDWP_REF_TYPE_ID_SIZE = 0;
		JVMDI_CLASS_STATUS_ERROR = 0;
		JVMDI_CLASS_STATUS_INITIALIZED = 0;
		JVMDI_CLASS_STATUS_PREPARED = 0;
		JVMDI_CLASS_STATUS_VERIFIED = 0;
		JVMDI_DISABLE = 0;
		JVMDI_ENABLE = 0;
		JVMDI_ERROR_ABSENT_INFORMATION = 0;
		JVMDI_ERROR_ACCESS_DENIED = 0;
		JVMDI_ERROR_ADD_METHOD_NOT_IMPLEMENTED = 0;
		JVMDI_ERROR_ALREADY_INVOKING = 0;
		JVMDI_ERROR_BUFFER_GROW = 0;
		JVMDI_ERROR_CIRCULAR_CLASS_DEFINITION = 0;
		JVMDI_ERROR_CLASS_MODIFIERS_CHANGE_NOT_IMPLEMENTED = 0;
		JVMDI_ERROR_CLASS_NOT_PREPARED = 0;
		JVMDI_ERROR_DELETE_METHOD_NOT_IMPLEMENTED = 0;
		JVMDI_ERROR_DUPLICATE = 0;
		JVMDI_ERROR_FAILS_VERIFICATION = 0;
		JVMDI_ERROR_HIERARCHY_CHANGE_NOT_IMPLEMENTED = 0;
		JVMDI_ERROR_HOT_SWAP_OPERATION_IGNORED = 0;
		JVMDI_ERROR_HOT_SWAP_OPERATION_REFUSED = 0;
		JVMDI_ERROR_ILLEGAL_ARGUMENT = 0;
		JVMDI_ERROR_INTERNAL = 0;
		JVMDI_ERROR_INTERRUPT = 0;
		JVMDI_ERROR_INVALID_ARRAY = 0;
		JVMDI_ERROR_INVALID_CLASS = 0;
		JVMDI_ERROR_INVALID_CLASS_FORMAT = 0;
		JVMDI_ERROR_INVALID_CLASS_LOADER = 0;
		JVMDI_ERROR_INVALID_EVENT_TYPE = 0;
		JVMDI_ERROR_INVALID_FIELDID = 0;
		JVMDI_ERROR_INVALID_FRAMEID = 0;
		JVMDI_ERROR_INVALID_INDEX = 0;
		JVMDI_ERROR_INVALID_LENGTH = 0;
		JVMDI_ERROR_INVALID_LOCATION = 0;
		JVMDI_ERROR_INVALID_METHODID = 0;
		JVMDI_ERROR_INVALID_MONITOR = 0;
		JVMDI_ERROR_INVALID_OBJECT = 0;
		JVMDI_ERROR_INVALID_PRIORITY = 0;
		JVMDI_ERROR_INVALID_SLOT = 0;
		JVMDI_ERROR_INVALID_STRING = 0;
		JVMDI_ERROR_INVALID_TAG = 0;
		JVMDI_ERROR_INVALID_THREAD = 0;
		JVMDI_ERROR_INVALID_THREAD_GROUP = 0;
		JVMDI_ERROR_INVALID_TYPESTATE = 0;
		JVMDI_ERROR_METHOD_MODIFIERS_CHANGE_NOT_IMPLEMENTED = 0;
		JVMDI_ERROR_NAMES_DONT_MATCH = 0;
		JVMDI_ERROR_NONE = 0;
		JVMDI_ERROR_NOT_CURRENT_FRAME = 0;
		JVMDI_ERROR_NOT_FOUND = 0;
		JVMDI_ERROR_NOT_IMPLEMENTED = 0;
		JVMDI_ERROR_NOT_MONITOR_OWNER = 0;
		JVMDI_ERROR_NO_AVAILABLE_THREAD = 0;
		JVMDI_ERROR_NO_MORE_FRAMES = 0;
		JVMDI_ERROR_NULL_POINTER = 0;
		JVMDI_ERROR_OPAQUE_FRAME = 0;
		JVMDI_ERROR_OUT_OF_MEMORY = 0;
		JVMDI_ERROR_SCHEMA_CHANGE_NOT_IMPLEMENTED = 0;
		JVMDI_ERROR_THREAD_NOT_SUSPENDED = 0;
		JVMDI_ERROR_THREAD_SUSPENDED = 0;
		JVMDI_ERROR_TRANSPORT_INIT = 0;
		JVMDI_ERROR_TRANSPORT_LOAD = 0;
		JVMDI_ERROR_TYPE_MISMATCH = 0;
		JVMDI_ERROR_UNATTACHED_THREAD = 0;
		JVMDI_ERROR_VM_DEAD = 0;
		JVMDI_ERROR_VM_NOT_INTERRUPTED = 0;
		JVMDI_EVENT_BREAKPOINT = 0;
		JVMDI_EVENT_CLASS_LOAD = 0;
		JVMDI_EVENT_CLASS_PREPARE = 0;
		JVMDI_EVENT_CLASS_UNLOAD = 0;
		JVMDI_EVENT_COMMAND_SET = 0;
		JVMDI_EVENT_DEBUG_ATTRIBUTES = 0;
		JVMDI_EVENT_EXCEPTION = 0;
		JVMDI_EVENT_EXCEPTION_CATCH = 0;
		JVMDI_EVENT_FIELD_ACCESS = 0;
		JVMDI_EVENT_FIELD_MODIFICATION = 0;
		JVMDI_EVENT_FRAME_POP = 0;
		JVMDI_EVENT_METHOD_ENTRY = 0;
		JVMDI_EVENT_METHOD_EXIT = 0;
		JVMDI_EVENT_RAM_CLASS_CREATE = 0;
		JVMDI_EVENT_RAM_CLASS_CREATE_WITH_ID = 0;
		JVMDI_EVENT_SINGLE_STEP = 0;
		JVMDI_EVENT_THREAD_END = 0;
		JVMDI_EVENT_THREAD_START = 0;
		JVMDI_EVENT_USER_DEFINED = 0;
		JVMDI_EVENT_VM_DEATH = 0;
		JVMDI_EVENT_VM_DISCONNECTED = 0;
		JVMDI_EVENT_VM_INIT = 0;
		JVMDI_EXTENDED_EVENT_COMMAND_SET = 0;
		JVMDI_INVOKE_NONVIRTUAL = 0;
		JVMDI_INVOKE_SINGLE_THREADED = 0;
		JVMDI_MAX_EVENT_TYPE_VAL = 0;
		JVMDI_MOD_KIND_CLASS_EXCLUDE = 0;
		JVMDI_MOD_KIND_CLASS_MATCH = 0;
		JVMDI_MOD_KIND_CLASS_ONLY = 0;
		JVMDI_MOD_KIND_CONDITIONAL = 0;
		JVMDI_MOD_KIND_COUNT = 0;
		JVMDI_MOD_KIND_EXCEPTION_ONLY = 0;
		JVMDI_MOD_KIND_FIELD_ONLY = 0;
		JVMDI_MOD_KIND_INSTANCE_ONLY = 0;
		JVMDI_MOD_KIND_LOCATION_ONLY = 0;
		JVMDI_MOD_KIND_LOCATION_RANGE = 0;
		JVMDI_MOD_KIND_STEP = 0;
		JVMDI_MOD_KIND_THREAD_ONLY = 0;
		JVMDI_MONITOR_WAIT_FOREVER = 0;
		JVMDI_STEP_DEPTH_INTO = 0;
		JVMDI_STEP_DEPTH_OUT = 0;
		JVMDI_STEP_DEPTH_OVER = 0;
		JVMDI_STEP_DEPTH_REENTER = 0;
		JVMDI_STEP_SIZE_LINE = 0;
		JVMDI_STEP_SIZE_MIN = 0;
		JVMDI_SUSPEND_POLICY_ALL = 0;
		JVMDI_SUSPEND_POLICY_EVENT_THREAD = 0;
		JVMDI_SUSPEND_POLICY_NONE = 0;
		JVMDI_SUSPEND_STATUS_BREAK = 0;
		JVMDI_SUSPEND_STATUS_NOT_SUSPENDED = 0;
		JVMDI_SUSPEND_STATUS_SUSPENDED = 0;
		JVMDI_THREAD_MAX_PRIORITY = 0;
		JVMDI_THREAD_MIN_PRIORITY = 0;
		JVMDI_THREAD_NORM_PRIORITY = 0;
		JVMDI_THREAD_STATUS_MONITOR = 0;
		JVMDI_THREAD_STATUS_RUNNING = 0;
		JVMDI_THREAD_STATUS_SLEEPING = 0;
		JVMDI_THREAD_STATUS_UNKNOWN = 0;
		JVMDI_THREAD_STATUS_WAIT = 0;
		JVMDI_THREAD_STATUS_ZOMBIE = 0;
		PacketFlagFlushRemaining = 0;
		PacketFlagHighPriority = 0;
		PacketFlagSentByVM = 0;
		PacketNoFlags = 0;
	}

}
