/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: DDRAlgorithmVersions
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class DDRAlgorithmVersions {

	// VM Constants

	public static final long SIZEOF;
	public static final long ALG_GC_ARRAYLET_OBJECT_MODEL_VERSION;
	public static final long ALG_GC_OBJECT_HEAP_ITERATOR_ADDRESS_ORDERED_LIST_VERSION;
	public static final long ALG_GC_OBJECT_HEAP_ITERATOR_SEGREGATED_ORDERED_LIST_VERSION;
	public static final long ALG_GC_SCAVENGER_FORWARDED_HEADER_VERSION;
	public static final long ALG_OBJECT_MONITOR_VERSION;
	public static final long ALG_ROM_HELP_VERSION;
	public static final long ALG_VM_BYTECODE_VERSION;
	public static final long ALG_VM_ITABLE_VERSION;
	public static final long ALG_VM_J9CLASS_VERSION;
	public static final long ALG_VM_VTABLE_VERSION;
	public static final long FOUR_BYTE_OFFSETS_VERSION;
	public static final long J9DDR_GENERATE_VERSION;
	public static final long J9_OBJECT_FIELD_OFFSET_ITERATOR_VERSION;
	public static final long MIXED_REFERENCE_MODE;
	public static final long VM_CAN_ACCESS_LOCALS_VERSION;
	public static final long VM_HASHTABLE_VERSION;
	public static final long VM_LINE_NUMBER_TABLE_VERSION;
	public static final long VM_LOCAL_VARIABLE_TABLE_VERSION;
	public static final long VM_MAJOR_VERSION;
	public static final long VM_MINOR_VERSION;
	public static final long VM_STACK_GROW_VERSION;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		ALG_GC_ARRAYLET_OBJECT_MODEL_VERSION = 0;
		ALG_GC_OBJECT_HEAP_ITERATOR_ADDRESS_ORDERED_LIST_VERSION = 0;
		ALG_GC_OBJECT_HEAP_ITERATOR_SEGREGATED_ORDERED_LIST_VERSION = 0;
		ALG_GC_SCAVENGER_FORWARDED_HEADER_VERSION = 0;
		ALG_OBJECT_MONITOR_VERSION = 0;
		ALG_ROM_HELP_VERSION = 0;
		ALG_VM_BYTECODE_VERSION = 0;
		ALG_VM_ITABLE_VERSION = 0;
		ALG_VM_J9CLASS_VERSION = 0;
		ALG_VM_VTABLE_VERSION = 0;
		FOUR_BYTE_OFFSETS_VERSION = 0;
		J9DDR_GENERATE_VERSION = 0;
		J9_OBJECT_FIELD_OFFSET_ITERATOR_VERSION = 0;
		MIXED_REFERENCE_MODE = 0;
		VM_CAN_ACCESS_LOCALS_VERSION = 0;
		VM_HASHTABLE_VERSION = 0;
		VM_LINE_NUMBER_TABLE_VERSION = 0;
		VM_LOCAL_VARIABLE_TABLE_VERSION = 0;
		VM_MAJOR_VERSION = 0;
		VM_MINOR_VERSION = 0;
		VM_STACK_GROW_VERSION = 0;
	}

}
