/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: CollectionCounts
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class CollectionCounts {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _concurrentGCOffset_;
	public static final int _metronomeCycleOffset_;
	public static final int _metronomeHeartbeatOffset_;
	public static final int _metronomeSynchGCOffset_;
	public static final int _metronomeThreadPriorityChangeOffset_;
	public static final int _metronomeTriggerOffset_;
	public static final int _nurseryAFOffset_;
	public static final int _systemGCOffset_;
	public static final int _tenureAFOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_concurrentGCOffset_ = 0;
		_metronomeCycleOffset_ = 0;
		_metronomeHeartbeatOffset_ = 0;
		_metronomeSynchGCOffset_ = 0;
		_metronomeThreadPriorityChangeOffset_ = 0;
		_metronomeTriggerOffset_ = 0;
		_nurseryAFOffset_ = 0;
		_systemGCOffset_ = 0;
		_tenureAFOffset_ = 0;
	}

}
