/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: BuildResult
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class BuildResult {

	// VM Constants

	public static final long SIZEOF;
	public static final long BytecodeTranslationFailed;
	public static final long ClassNameMismatch;
	public static final long ClassRead;
	public static final long GenericError;
	public static final long GenericErrorCustomMsg;
	public static final long IllegalPackageName;
	public static final long InvalidAnnotation;
	public static final long InvalidBytecode;
	public static final long InvalidBytecodeSize;
	public static final long InvalidClassType;
	public static final long LineNumberTableDecompressFailed;
	public static final long NeedWideBranches;
	public static final long OK;
	public static final long OutOfMemory;
	public static final long OutOfROM;
	public static final long StackMapFailed;
	public static final long UnknownAnnotation;
	public static final long VerifyErrorInlining;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		BytecodeTranslationFailed = 0;
		ClassNameMismatch = 0;
		ClassRead = 0;
		GenericError = 0;
		GenericErrorCustomMsg = 0;
		IllegalPackageName = 0;
		InvalidAnnotation = 0;
		InvalidBytecode = 0;
		InvalidBytecodeSize = 0;
		InvalidClassType = 0;
		LineNumberTableDecompressFailed = 0;
		NeedWideBranches = 0;
		OK = 0;
		OutOfMemory = 0;
		OutOfROM = 0;
		StackMapFailed = 0;
		UnknownAnnotation = 0;
		VerifyErrorInlining = 0;
	}

}
