/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 *  SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/

/**
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: workerThreadInfoPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the workerThreadInfoPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=workerThreadInfo.class)
public class workerThreadInfoPointer extends StructurePointer {

	// NULL
	public static final workerThreadInfoPointer NULL = new workerThreadInfoPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected workerThreadInfoPointer(long address) {
		super(address);
	}

	public static workerThreadInfoPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static workerThreadInfoPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static workerThreadInfoPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}

		return new workerThreadInfoPointer(address);
	}

	public workerThreadInfoPointer add(long count) {
		return workerThreadInfoPointer.cast(address + (workerThreadInfo.SIZEOF * count));
	}

	public workerThreadInfoPointer add(Scalar count) {
		return add(count.longValue());
	}

	public workerThreadInfoPointer addOffset(long offset) {
		return workerThreadInfoPointer.cast(address + offset);
	}

	public workerThreadInfoPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public workerThreadInfoPointer sub(long count) {
		return workerThreadInfoPointer.cast(address - (workerThreadInfo.SIZEOF * count));
	}

	public workerThreadInfoPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public workerThreadInfoPointer subOffset(long offset) {
		return workerThreadInfoPointer.cast(address - offset);
	}

	public workerThreadInfoPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public workerThreadInfoPointer untag(long mask) {
		return workerThreadInfoPointer.cast(address & ~mask);
	}

	public workerThreadInfoPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return workerThreadInfo.SIZEOF;
	}

	// Implementation methods

	// MM_ParallelDispatcher* dispatcher
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dispatcherOffset_", declaredType="MM_ParallelDispatcher*")
	public MM_ParallelDispatcherPointer dispatcher() throws CorruptDataException {
		long pointer = getPointerAtOffset(workerThreadInfo._dispatcherOffset_);
		return MM_ParallelDispatcherPointer.cast(pointer);
	}

	// MM_ParallelDispatcher* dispatcher
	public PointerPointer dispatcherEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + workerThreadInfo._dispatcherOffset_);
	}

	// OMR_VM* omrVM
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_omrVMOffset_", declaredType="OMR_VM*")
	public OMR_VMPointer omrVM() throws CorruptDataException {
		long pointer = getPointerAtOffset(workerThreadInfo._omrVMOffset_);
		return OMR_VMPointer.cast(pointer);
	}

	// OMR_VM* omrVM
	public PointerPointer omrVMEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + workerThreadInfo._omrVMOffset_);
	}

	// U64 workerFlags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_workerFlagsOffset_", declaredType="U64")
	public UDATA workerFlags() throws CorruptDataException {
		return new U64(getLongAtOffset(workerThreadInfo._workerFlagsOffset_));
	}

	// U64 workerFlags
	public UDATAPointer workerFlagsEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + workerThreadInfo._workerFlagsOffset_);
	}

	// U64 workerID
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_workerIDOffset_", declaredType="U64")
	public UDATA workerID() throws CorruptDataException {
		return new U64(getLongAtOffset(workerThreadInfo._workerIDOffset_));
	}

	// U64 workerID
	public UDATAPointer workerIDEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UDATAPointer.cast(address + workerThreadInfo._workerIDOffset_);
	}

}
