/*******************************************************************************
 * Copyright (c) 1991, 2021 IBM Corp. and others
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] http://openjdk.java.net/legal/assembly-exception.html
 *
 *  SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0 WITH Classpath-exception-2.0 OR LicenseRef-GPL-2.0 WITH Assembly-exception
 *******************************************************************************/

/**
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: UtComponentListPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the UtComponentListPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=UtComponentList.class)
public class UtComponentListPointer extends StructurePointer {

	// NULL
	public static final UtComponentListPointer NULL = new UtComponentListPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected UtComponentListPointer(long address) {
		super(address);
	}

	public static UtComponentListPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static UtComponentListPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static UtComponentListPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}

		return new UtComponentListPointer(address);
	}

	public UtComponentListPointer add(long count) {
		return UtComponentListPointer.cast(address + (UtComponentList.SIZEOF * count));
	}

	public UtComponentListPointer add(Scalar count) {
		return add(count.longValue());
	}

	public UtComponentListPointer addOffset(long offset) {
		return UtComponentListPointer.cast(address + offset);
	}

	public UtComponentListPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public UtComponentListPointer sub(long count) {
		return UtComponentListPointer.cast(address - (UtComponentList.SIZEOF * count));
	}

	public UtComponentListPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public UtComponentListPointer subOffset(long offset) {
		return UtComponentListPointer.cast(address - offset);
	}

	public UtComponentListPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public UtComponentListPointer untag(long mask) {
		return UtComponentListPointer.cast(address & ~mask);
	}

	public UtComponentListPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return UtComponentList.SIZEOF;
	}

	// Implementation methods

	// UtDeferredConfigInfo* deferredConfigInfoHead
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_deferredConfigInfoHeadOffset_", declaredType="UtDeferredConfigInfo*")
	public UtDeferredConfigInfoPointer deferredConfigInfoHead() throws CorruptDataException {
		long pointer = getPointerAtOffset(UtComponentList._deferredConfigInfoHeadOffset_);
		return UtDeferredConfigInfoPointer.cast(pointer);
	}

	// UtDeferredConfigInfo* deferredConfigInfoHead
	public PointerPointer deferredConfigInfoHeadEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + UtComponentList._deferredConfigInfoHeadOffset_);
	}

	// UtComponentData* head
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_headOffset_", declaredType="UtComponentData*")
	public UtComponentDataPointer head() throws CorruptDataException {
		long pointer = getPointerAtOffset(UtComponentList._headOffset_);
		return UtComponentDataPointer.cast(pointer);
	}

	// UtComponentData* head
	public PointerPointer headEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + UtComponentList._headOffset_);
	}

	// UtDataHeader header
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_headerOffset_", declaredType="UtDataHeader")
	public UtDataHeaderPointer header() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return UtDataHeaderPointer.cast(address + UtComponentList._headerOffset_);
	}

	// UtDataHeader header
	public PointerPointer headerEA() throws CorruptDataException {
		if (address == 0) {
			throw new NullPointerDereference();
		}

		return PointerPointer.cast(address + UtComponentList._headerOffset_);
	}

}
